/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram;

import amida.calltree.LoopNode;
import amida.calltree.MethodMissingLoopNode;
import amida.calltree.ObjectDifferenceLoopNode;
import amida.calltree.SimpleLoopNode;
import amida.diagram.sequencediagram.Called;
import amida.diagram.sequencediagram.Sequence;
import amida.diagram.sequencediagram.SequenceDiagramAdjuster;
import amida.diagram.sequencediagram.SequenceDiagramModel;
import amida.diagram.sequencediagram.SequenceLoop;
import amida.diagram.sequencediagram.SequenceObject;
import amida.diagram.sequencediagram.gui.SelectableElement;
import amida.utility.StringMaker;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class SequenceDiagramDrawer {
    private static final String BRANCH_MARK = "? ";
    private static Color selectionColor = new Color(204, 204, 255);

    public static void drawTopObject(SequenceDiagramModel model, SequenceDiagramAdjuster adjuster, Graphics g, Rectangle viewRange) {
        if (model == null || adjuster == null || g == null || viewRange == null) {
            return;
        }
        g.setFont(g.getFont().deriveFont(adjuster.getFontSize()));
        int objectsSpace = adjuster.getObjectSpace();
        int objectWidth = adjuster.getObjectWidth();
        int startObjectIndex = (int)((viewRange.getX() - (double)adjuster.getMargin().left) / (double)(objectWidth + objectsSpace)) - 1;
        int endObjectIndex = (int)((viewRange.getMaxX() - (double)adjuster.getMargin().left) / (double)(objectWidth + objectsSpace)) + 1;
        if (startObjectIndex < 0) {
            startObjectIndex = 0;
        }
        if (endObjectIndex >= model.getObjectList().size()) {
            endObjectIndex = model.getObjectNum() - 1;
        }
        int x = (objectWidth + objectsSpace) * startObjectIndex + adjuster.getMargin().left - (int)viewRange.getX() + 1;
        int fontHeight = g.getFontMetrics().getHeight();
        Set<Integer> selectedSet = model.getSelectionModel().getSelectedObjectIndex();
        int top = (int)viewRange.getY() / adjuster.getSequenceSpace() - 1;
        int i = startObjectIndex;
        while (i <= endObjectIndex) {
            SequenceObject object = model.getObject(i);
            x += objectWidth + objectsSpace;
            if (object.isVisible(top)) {
                if (selectedSet.contains(new Integer(i))) {
                    Color bColor = g.getColor();
                    g.setColor(selectionColor);
                    g.fillRect(x, adjuster.getMargin().top, adjuster.getObjectWidth(), adjuster.getObjectHeight());
                    g.setColor(bColor);
                }
                g.drawRect(x, adjuster.getMargin().top, adjuster.getObjectWidth(), adjuster.getObjectHeight());
                String packageName = object.getNameSpace();
                int line = SequenceDiagramDrawer.drawPackageName(g, String.valueOf(packageName) + ":", x + 3, adjuster.getMargin().top + fontHeight, adjuster.getObjectWidth() - 3);
                String className = object.getClassName();
                line += SequenceDiagramDrawer.drawClassName(g, className, x + 3, adjuster.getMargin().top + fontHeight * (line + 1), adjuster.getObjectWidth() - 3);
                int space = adjuster.getObjectHeight() / fontHeight - line;
                SequenceDiagramDrawer.drawObjectIdString(g, object.getIds(), x + 3, adjuster.getMargin().top + fontHeight * (line + 1), adjuster.getObjectWidth() - 3, space);
            }
            ++i;
        }
    }

    private static int drawPackageName(Graphics g, String text, int x, int y, int spaceWidth) {
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        if (textWidth <= spaceWidth) {
            g.drawString(text, x, y);
            return 1;
        }
        ArrayList<Integer> cutIndex = new ArrayList<Integer>();
        int i = 1;
        while (i < text.length()) {
            if (text.charAt(i) == '.') {
                cutIndex.add(new Integer(i));
            }
            ++i;
        }
        cutIndex.add(new Integer(text.length()));
        int start = 0;
        int y2 = y;
        int line = 0;
        int i2 = cutIndex.size() - 1;
        while (start < text.length()) {
            String subText;
            int index = (Integer)cutIndex.get(i2);
            if (index == start && cutIndex.size() > i2 + 1) {
                index = (Integer)cutIndex.get(i2 + 1);
                subText = text.substring(start, index);
                g.drawString(subText, x, y2);
                start = index;
                y2 += fm.getHeight();
                i2 = cutIndex.size() - 1;
                ++line;
                continue;
            }
            subText = text.substring(start, index);
            if (fm.stringWidth(subText) <= spaceWidth || i2 == 0) {
                if (subText.equals("")) {
                    subText = text.substring(start, text.length());
                    index = text.length();
                }
                g.drawString(subText, x, y2);
                start = index;
                y2 += fm.getHeight();
                i2 = cutIndex.size() - 1;
                ++line;
                continue;
            }
            --i2;
        }
        return line;
    }

    private static int drawClassName(Graphics g, String text, int x, int y, int spaceWidth) {
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        if (textWidth <= spaceWidth) {
            g.drawString(text, x, y);
            return 1;
        }
        ArrayList<Integer> cutIndex = new ArrayList<Integer>();
        int i = 1;
        while (i < text.length()) {
            if (Character.isUpperCase(text.charAt(i)) || text.charAt(i) == '.') {
                cutIndex.add(i);
            }
            ++i;
        }
        cutIndex.add(new Integer(text.length()));
        if (cutIndex.isEmpty()) {
            return 0;
        }
        int start = 0;
        int y2 = y;
        int line = 0;
        int i2 = cutIndex.size() - 1;
        while (start < text.length()) {
            String subText;
            int index = (Integer)cutIndex.get(i2);
            if (index == start && cutIndex.size() > i2 + 1) {
                index = (Integer)cutIndex.get(i2 + 1);
                subText = text.substring(start, index);
                g.drawString(subText, x, y2);
                start = index;
                y2 += fm.getHeight();
                i2 = cutIndex.size() - 1;
                ++line;
                continue;
            }
            subText = text.substring(start, index);
            if (fm.stringWidth(subText) <= spaceWidth || i2 == 0) {
                g.drawString(subText, x, y2);
                start = index;
                y2 += fm.getHeight();
                i2 = cutIndex.size() - 1;
                ++line;
                continue;
            }
            --i2;
        }
        return line;
    }

    private static void drawObjectIdString(Graphics g, Set<Integer> ids, int x, int y, int spaceWidth, int maxLine) {
        FontMetrics fm = g.getFontMetrics();
        int charHeight = fm.getHeight();
        int y2 = y;
        int x2 = 0;
        int lineCount = 0;
        StringTokenizer st = new StringTokenizer(StringMaker.IntSetToString(ids), ",");
        String backup = null;
        while (st.hasMoreTokens() || backup != null) {
            StringBuffer buffer = new StringBuffer();
            while (st.hasMoreTokens() || backup != null) {
                String sid;
                if (backup != null) {
                    sid = backup;
                    backup = null;
                } else {
                    sid = st.nextToken();
                }
                if (fm.stringWidth(String.valueOf(buffer.toString()) + sid) < spaceWidth) {
                    buffer.append(String.valueOf(sid) + ",");
                    continue;
                }
                backup = sid;
                break;
            }
            if (buffer.length() == 0) continue;
            if (lineCount + 1 >= maxLine && st.hasMoreTokens()) {
                buffer.delete(buffer.length() - 3, buffer.length());
                buffer.append("...");
                g.drawString(buffer.toString(), x + x2, y2);
                return;
            }
            buffer.deleteCharAt(buffer.length() - 1);
            g.drawString(buffer.toString(), x + x2, y2);
            ++lineCount;
            y2 += charHeight;
        }
    }

    public static List<SelectableElement> drawDiagram(SequenceDiagramModel model, SequenceDiagramAdjuster adjuster, Graphics g, Rectangle viewRange, Rectangle drawRange) {
        int yStartIndex;
        LinkedList<SelectableElement> selectables = new LinkedList<SelectableElement>();
        if (adjuster == null || model == null || viewRange == null || drawRange == null || g == null) {
            return selectables;
        }
        g.setFont(g.getFont().deriveFont(adjuster.getFontSize()));
        int objectSpace = adjuster.getObjectSpace();
        int objectWidth = adjuster.getObjectWidth();
        int sequenceSpace = adjuster.getSequenceSpace();
        int xStartIndex = ((int)viewRange.getX() - adjuster.getMargin().left - objectSpace) / (objectWidth + objectSpace);
        if (xStartIndex < 0) {
            xStartIndex = 0;
        } else if (xStartIndex >= model.getObjectNum()) {
            xStartIndex = model.getObjectNum();
        }
        int xEndIndex = ((int)viewRange.getX() + (int)viewRange.getWidth() - adjuster.getMargin().left) / (objectWidth + objectSpace) - 1;
        if (xEndIndex >= model.getObjectNum()) {
            xEndIndex = model.getObjectNum() - 1;
        }
        if ((yStartIndex = (int)(viewRange.getY() - (double)adjuster.getMargin().top) / sequenceSpace - 1) < 0) {
            yStartIndex = 0;
        } else if (yStartIndex >= model.getSequenceNum()) {
            yStartIndex = model.getSequenceNum();
        }
        int yEndIndex = (int)(viewRange.getY() + viewRange.getHeight() - (double)adjuster.getMargin().top) / sequenceSpace + yStartIndex;
        if (yEndIndex >= model.getSequenceNum()) {
            yEndIndex = model.getSequenceNum() - 1;
        }
        int xGap = (int)(drawRange.getX() - viewRange.getX());
        int yGap = (int)(drawRange.getY() - viewRange.getY());
        selectables.addAll(SequenceDiagramDrawer.drawObjectLine(model, adjuster, g, xStartIndex, xEndIndex, yStartIndex, yEndIndex, xGap, yGap));
        selectables.addAll(SequenceDiagramDrawer.drawLoop(model, adjuster, g, xStartIndex, xEndIndex, yStartIndex, yEndIndex, xGap, yGap));
        selectables.addAll(SequenceDiagramDrawer.drawSequence(model, adjuster, g, xStartIndex, xEndIndex, yStartIndex, yEndIndex, xGap, yGap));
        return selectables;
    }

    private static List<SelectableElement> drawObjectLine(SequenceDiagramModel model, SequenceDiagramAdjuster adjuster, Graphics g, int startObjectIndex, int endObjectIndex, int startSequenceIndex, int endSequenceIndex, int xGap, int yGap) {
        endSequenceIndex += 2;
        int objectSpace = adjuster.getObjectSpace();
        int objectWidth = adjuster.getObjectWidth();
        int sequenceSpace = adjuster.getSequenceSpace();
        int calledWidth = adjuster.getCalledWidth();
        int leftX = adjuster.getMargin().left + startObjectIndex * (objectWidth + objectSpace) + xGap;
        int baseY = yGap + adjuster.getMargin().top;
        LinkedList<SelectableElement> selectableObjects = new LinkedList<SelectableElement>();
        int i = startObjectIndex;
        while (i <= endObjectIndex) {
            SequenceObject object = model.getObject(i);
            leftX += objectWidth + objectSpace;
            int madeIndex = object.getMadeIndex();
            int lastUsedIndex = object.getLastUsedIndex();
            if (startSequenceIndex < madeIndex) {
                if (endSequenceIndex < madeIndex) {
                    SequenceDiagramDrawer.drawDottedLine(g, leftX + objectWidth / 2, sequenceSpace * startSequenceIndex + baseY, leftX + objectWidth / 2, sequenceSpace * endSequenceIndex + baseY, adjuster.getDottedLineSize() / 2, adjuster.getDottedLineSize());
                } else {
                    SequenceDiagramDrawer.drawDottedLine(g, leftX + objectWidth / 2, sequenceSpace * startSequenceIndex + baseY, leftX + objectWidth / 2, sequenceSpace * madeIndex + baseY, adjuster.getDottedLineSize() / 2, adjuster.getDottedLineSize());
                }
            }
            if (startSequenceIndex < lastUsedIndex && endSequenceIndex > madeIndex) {
                if (startSequenceIndex < madeIndex && endSequenceIndex < lastUsedIndex) {
                    g.drawLine(leftX + objectWidth / 2, sequenceSpace * madeIndex + baseY, leftX + objectWidth / 2, sequenceSpace * endSequenceIndex + baseY);
                } else if (startSequenceIndex < madeIndex && endSequenceIndex >= lastUsedIndex) {
                    g.drawLine(leftX + objectWidth / 2, sequenceSpace * madeIndex + baseY, leftX + objectWidth / 2, sequenceSpace * lastUsedIndex + baseY);
                } else if (startSequenceIndex >= madeIndex && endSequenceIndex < lastUsedIndex) {
                    g.drawLine(leftX + objectWidth / 2, sequenceSpace * startSequenceIndex + baseY, leftX + objectWidth / 2, sequenceSpace * endSequenceIndex + baseY);
                } else {
                    g.drawLine(leftX + objectWidth / 2, sequenceSpace * startSequenceIndex + baseY, leftX + objectWidth / 2, sequenceSpace * lastUsedIndex + baseY);
                }
            }
            int centerX = leftX + objectWidth / 2;
            int calledStartX = centerX - calledWidth / 2;
            int j = object.getCalledNum() - 1;
            while (j >= 0) {
                Called called = object.getCalled(j);
                if (called.getStart() <= endSequenceIndex && called.getEnd() >= startSequenceIndex) {
                    int x = calledStartX + calledWidth * called.getLevel() / 2;
                    int y = called.getStart() * sequenceSpace + baseY;
                    int height = (called.getEnd() - called.getStart() + 1) * sequenceSpace;
                    Color backupColor = g.getColor();
                    if (SequenceDiagramDrawer.calledIsSelected(model, called)) {
                        g.setColor(Color.BLUE);
                    }
                    if (called.getCallSequence().getNode().isBehind()) {
                        g.fillRect(x, y, calledWidth, height);
                    } else {
                        Color lineColor = g.getColor();
                        g.setColor(Color.WHITE);
                        g.fillRect(x, y, calledWidth, height);
                        g.setColor(lineColor);
                        g.drawRect(x, y, calledWidth, height);
                    }
                    if (SequenceDiagramDrawer.calledIsSelected(model, called)) {
                        g.setColor(backupColor);
                    }
                    SelectableElement sElement = new SelectableElement(new Rectangle(x, y, calledWidth, height), called, 2);
                    selectableObjects.add(sElement);
                }
                --j;
            }
            ++i;
        }
        return selectableObjects;
    }

    private static boolean calledIsSelected(SequenceDiagramModel model, Called called) {
        if (model.getSelectionModel().getSelectedCalled().contains(called)) {
            return true;
        }
        if (model.getSelectionModel().getSelectedObjectIndex().contains(new Integer(called.getObject().getIndex() - 1))) {
            return true;
        }
        return SequenceDiagramDrawer.sequenceIsSelected(model, called.getCallSequence().getIndex());
    }

    private static boolean sequenceIsSelected(SequenceDiagramModel model, int index) {
        Set<Integer> selectedIndexes = model.getSelectionModel().getSelectedSequenceIndex();
        for (int selectedIndex : selectedIndexes) {
            int pareIndex = model.getSequence(selectedIndex).getPareSequence().getIndex();
            if (index < selectedIndex || index > pareIndex) continue;
            return true;
        }
        Set<Called> calles = model.getSelectionModel().getSelectedCalled();
        for (Called called : calles) {
            if (called.getStart() > index || called.getEnd() < index) continue;
            return true;
        }
        Set<Integer> objects = model.getSelectionModel().getSelectedObjectIndex();
        Iterator<Integer> it = objects.iterator();
        while (it.hasNext()) {
            SequenceObject object = model.getObject(it.next());
            Sequence sequence = model.getSequence(index);
            if (sequence.getStart() != object && sequence.getEnd() != object) continue;
            return true;
        }
        Set<SequenceLoop> loops = model.getSelectionModel().getSelectedLoops();
        for (SequenceLoop loop : loops) {
            if (loop.getStart() > index || loop.getEnd() < index) continue;
            return true;
        }
        return false;
    }

    private static List<SelectableElement> drawSequence(SequenceDiagramModel model, SequenceDiagramAdjuster adjuster, Graphics g, int startObjectIndex, int endObjectIndex, int startSequenceIndex, int endSequenceIndex, int xGap, int yGap) {
        int objectWidth = adjuster.getObjectWidth();
        int objectSpace = adjuster.getObjectSpace();
        int sequenceSpace = adjuster.getSequenceSpace();
        int calledWidth = adjuster.getCalledWidth();
        int fineAdjustment = adjuster.getArrowPointSize();
        int y = sequenceSpace * startSequenceIndex + yGap + adjuster.getMargin().top;
        int half = objectWidth / 2;
        int charHeight = g.getFontMetrics().getHeight();
        LinkedList<SelectableElement> selectables = new LinkedList<SelectableElement>();
        int i = startSequenceIndex;
        while (i <= endSequenceIndex) {
            boolean isSelectedPare;
            Sequence sequence = model.getSequence(i);
            y += sequenceSpace;
            if (sequence.getType() == 0) {
                boolean isSelected = SequenceDiagramDrawer.sequenceIsSelected(model, i);
                SelectableElement lineElement = null;
                SelectableElement sElement = null;
                Color backupColor = g.getColor();
                if (isSelected) {
                    g.setColor(Color.BLUE);
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(String.valueOf(sequence.getNode().getCallIndex()) + ": " + sequence.getNode().getMethodName() + "(");
                String[] args = sequence.getNode().getSimpleArgmentTypeNames();
                if (args != null) {
                    int j = 0;
                    while (j < args.length) {
                        buffer.append(String.valueOf(args[j]) + ",");
                        ++j;
                    }
                    if (j > 0) {
                        buffer.deleteCharAt(buffer.length() - 1);
                    }
                }
                buffer.append(")");
                if (sequence.isBranch()) {
                    buffer.insert(0, BRANCH_MARK);
                }
                String text = buffer.toString();
                int textWidth = g.getFontMetrics().stringWidth(text);
                if (sequence.getStart() != sequence.getEnd()) {
                    int x2;
                    int x1 = adjuster.getMargin().left + sequence.getStartIndex() * (objectWidth + objectSpace) + half + xGap;
                    if (x1 > (x2 = adjuster.getMargin().left + sequence.getEndIndex() * (objectWidth + objectSpace) + half + xGap)) {
                        g.drawLine(x1 += sequence.getStartLevel() * adjuster.getCalledWidth() / 2, y, x2 += (sequence.getEndLevel() + 1) * adjuster.getCalledWidth() / 2, y);
                        g.fillPolygon(new int[]{x2, x2 + fineAdjustment, x2 + fineAdjustment, x2}, new int[]{y, y - fineAdjustment, y + fineAdjustment, y}, 3);
                        g.drawString(text, x2 + fineAdjustment, y - fineAdjustment);
                        lineElement = new SelectableElement(new Rectangle(x1, y - fineAdjustment, x2 - x1, fineAdjustment * 2), sequence, 1);
                        sElement = new SelectableElement(new Rectangle(x2 + fineAdjustment, y - fineAdjustment - charHeight, textWidth, charHeight), sequence, 1);
                    } else {
                        g.drawLine(x1 += sequence.getStartLevel() * calledWidth / 2, y, x2 += sequence.getEndLevel() * calledWidth / 2, y);
                        g.fillPolygon(new int[]{x2, x2 - fineAdjustment, x2 - fineAdjustment, x2}, new int[]{y, y + fineAdjustment, y - fineAdjustment, y}, 3);
                        int stringX = x2 - fineAdjustment - textWidth;
                        if (stringX < 0 && x2 > 0) {
                            stringX = adjuster.getMargin().left;
                        }
                        g.drawString(text, stringX, y - fineAdjustment);
                        lineElement = new SelectableElement(new Rectangle(x1, y - fineAdjustment, x2 - x1, fineAdjustment * 2), sequence, 1);
                        sElement = new SelectableElement(new Rectangle(x2 - fineAdjustment - textWidth, y - fineAdjustment - charHeight, textWidth, charHeight), sequence, 1);
                    }
                    if (sequence.isBranch()) {
                        int pareIndex = sequence.getPareSequence().getIndex();
                        int branchSpace = (pareIndex - i) * adjuster.getSequenceSpace();
                        int threeDivisionSpace = branchSpace / 3;
                        int rightSpace = (objectWidth + objectSpace) / 3;
                        g.drawLine(x1, y, x1 + rightSpace, y + threeDivisionSpace);
                        g.drawLine(x1 + rightSpace, y + threeDivisionSpace, x1 + rightSpace, y + threeDivisionSpace * 2);
                        g.drawLine(x1 + rightSpace, y + threeDivisionSpace * 2, x1, y + branchSpace);
                    }
                } else {
                    int x = adjuster.getMargin().left + sequence.getStartIndex() * (objectWidth + objectSpace) + half + xGap;
                    g.drawLine(x += sequence.getStartLevel() * calledWidth / 2, y - sequenceSpace / 3, x + fineAdjustment * calledWidth / 2, y - sequenceSpace / 3);
                    g.drawLine(x + fineAdjustment * calledWidth / 2, y - sequenceSpace / 3, x + fineAdjustment * calledWidth / 2, y + fineAdjustment);
                    g.drawLine(x + fineAdjustment * calledWidth / 2, y + fineAdjustment, x + calledWidth / 2, y + fineAdjustment);
                    g.drawLine(x + calledWidth / 2 + fineAdjustment, y + fineAdjustment * 2, x + calledWidth / 2, y + fineAdjustment);
                    g.drawLine(x + calledWidth / 2 + fineAdjustment, y, x + calledWidth / 2, y + fineAdjustment);
                    g.drawString(text, x + fineAdjustment * 2, y - sequenceSpace / 3 - fineAdjustment);
                    lineElement = new SelectableElement(new Rectangle(x, y - sequenceSpace / 3, 3 * calledWidth / 2, sequenceSpace / 3 + fineAdjustment), sequence, 1);
                    sElement = new SelectableElement(new Rectangle(x + fineAdjustment * 2, y - sequenceSpace / 3 - fineAdjustment - charHeight, textWidth, charHeight), sequence, 1);
                }
                if (lineElement != null && sElement != null) {
                    selectables.add(lineElement);
                    selectables.add(sElement);
                }
                if (isSelected) {
                    g.setColor(backupColor);
                }
            } else if (sequence.getType() == 1) {
                isSelectedPare = SequenceDiagramDrawer.sequenceIsSelected(model, sequence.getPareSequence().getIndex());
                if (sequence.getStart() != sequence.getEnd()) {
                    int x2;
                    int x1;
                    Color backupColor = g.getColor();
                    if (isSelectedPare) {
                        g.setColor(Color.BLUE);
                    }
                    if ((x1 = adjuster.getMargin().left + sequence.getStartIndex() * (objectWidth + objectSpace) + half + xGap) > (x2 = adjuster.getMargin().left + sequence.getEndIndex() * (objectWidth + objectSpace) + half + xGap)) {
                        SequenceDiagramDrawer.drawDottedLine(g, x1 += (sequence.getStartLevel() - 1) * calledWidth / 2, y, x2 += sequence.getEndLevel() * calledWidth / 2, y, adjuster.getDottedLineSize() / 2, adjuster.getDottedLineSize());
                        g.drawLine(x2 + fineAdjustment, y + fineAdjustment, x2, y);
                        g.drawLine(x2 + fineAdjustment, y - fineAdjustment, x2, y);
                        g.drawString(sequence.getNode().getReturnTypeName(), x2 + 10, y - 5);
                    } else {
                        SequenceDiagramDrawer.drawDottedLine(g, x1 += sequence.getStartLevel() * calledWidth / 2, y, x2 += sequence.getEndLevel() * calledWidth / 2, y, adjuster.getDottedLineSize() / 2, adjuster.getDottedLineSize());
                        g.drawLine(x2 - fineAdjustment, y + fineAdjustment, x2, y);
                        g.drawLine(x2 - fineAdjustment, y - fineAdjustment, x2, y);
                        g.drawString(sequence.getNode().getReturnTypeName(), x2 - fineAdjustment * 2 - g.getFontMetrics().stringWidth(sequence.getNode().getReturnTypeName()), y - fineAdjustment);
                    }
                    if (isSelectedPare) {
                        g.setColor(backupColor);
                    }
                }
            } else if (sequence.getType() == 5) {
                isSelectedPare = SequenceDiagramDrawer.sequenceIsSelected(model, sequence.getPareSequence().getIndex());
                if (sequence.getStart() != sequence.getEnd()) {
                    int x2;
                    int x1;
                    Color backupColor = g.getColor();
                    if (isSelectedPare) {
                        g.setColor(Color.BLUE);
                    }
                    if ((x1 = adjuster.getMargin().left + sequence.getStartIndex() * (objectWidth + objectSpace) + half + xGap) > (x2 = adjuster.getMargin().left + sequence.getEndIndex() * (objectWidth + objectSpace) + half + xGap)) {
                        SequenceDiagramDrawer.drawDottedLine(g, x1 += (sequence.getStartLevel() - 1) * calledWidth / 2, y, x2 += sequence.getEndLevel() * calledWidth / 2, y, adjuster.getDottedLineSize() / 2, adjuster.getDottedLineSize());
                        g.drawLine(x2 + fineAdjustment, y + fineAdjustment, x2, y);
                        g.drawLine(x2 + fineAdjustment, y - fineAdjustment, x2, y);
                        g.drawString(sequence.getNode().getExceptionName(), x2 + 10, y - 5);
                    } else {
                        SequenceDiagramDrawer.drawDottedLine(g, x1 += sequence.getStartLevel() * calledWidth / 2, y, x2 += sequence.getEndLevel() * calledWidth / 2, y, adjuster.getDottedLineSize() / 2, adjuster.getDottedLineSize());
                        g.drawLine(x2 - fineAdjustment, y + fineAdjustment, x2, y);
                        g.drawLine(x2 - fineAdjustment, y - fineAdjustment, x2, y);
                        g.drawString(sequence.getNode().getExceptionName(), x2 - fineAdjustment * 2 - g.getFontMetrics().stringWidth(sequence.getNode().getReturnTypeName()), y - fineAdjustment);
                    }
                    if (isSelectedPare) {
                        g.setColor(backupColor);
                    }
                }
            } else if (sequence.getType() == 3) {
                int x = adjuster.getMargin().left + sequence.getStartIndex() * (objectWidth + objectSpace) + half + sequence.getStartLevel() * calledWidth / 2 + xGap;
                int interval = objectWidth + objectSpace;
                g.drawLine(x, y, x + interval / 4, y);
                g.fillPolygon(new int[]{x + interval / 4, x + interval / 4 - fineAdjustment, x + interval / 4 - fineAdjustment, x}, new int[]{y, y + fineAdjustment, y - fineAdjustment, y}, 3);
                g.drawRect(x + interval / 4, y - sequenceSpace / 10, interval / 2, (int)((double)sequenceSpace * 1.2));
                String text = sequence.getNode().getMethodName();
                int stringWidth = g.getFontMetrics().stringWidth(text);
                g.drawString(text, x + interval / 4 + interval / 4 - stringWidth / 2, y + sequenceSpace / 2 + g.getFontMetrics().getHeight() / 2);
            } else if (sequence.getType() == 4) {
                int interval = objectWidth + objectSpace;
                int x = adjuster.getMargin().left + sequence.getStartIndex() * (objectWidth + objectSpace) + half + sequence.getEndLevel() * calledWidth / 2;
                g.drawLine(x, y, x + interval / 4, y);
                g.drawLine(x, y, x + fineAdjustment, y - fineAdjustment);
                g.drawLine(x, y, x + fineAdjustment, y + fineAdjustment);
            }
            ++i;
        }
        return selectables;
    }

    private static void drawDottedLine(Graphics g, int x1, int y1, int x2, int y2, int length, int space) {
        int spaceYStep;
        int spaceXStep;
        int drawYStep;
        int drawXStep;
        int moveX = 0;
        int moveY = 0;
        int lengthX = Math.abs(x2 - x1);
        int lengthY = Math.abs(y2 - y1);
        if (lengthX != 0) {
            double rate = (double)lengthY / (double)lengthX;
            drawXStep = (int)((double)length / Math.sqrt(1.0 + rate * rate));
            drawYStep = (int)(rate * (double)drawXStep);
            spaceXStep = (int)((double)space / Math.sqrt(1.0 + rate * rate));
            spaceYStep = (int)(rate * (double)spaceXStep);
        } else {
            drawXStep = 0;
            drawYStep = length;
            spaceXStep = 0;
            spaceYStep = space;
        }
        if (x2 < x1) {
            drawXStep = -drawXStep;
            spaceXStep = -spaceXStep;
        }
        if (y2 < y1) {
            drawYStep = -drawYStep;
            spaceYStep = -spaceYStep;
        }
        int xOneStep = Math.abs(drawXStep + spaceXStep);
        int yOneStep = Math.abs(drawYStep + spaceYStep);
        int positionX = x1;
        int positionY = y1;
        while (moveX < lengthX || moveY < lengthY) {
            int nextXEnd = moveX + xOneStep > lengthX ? x2 : positionX + drawXStep;
            int nextYEnd = moveY + yOneStep > lengthY ? y2 : positionY + drawYStep;
            g.drawLine(positionX, positionY, nextXEnd, nextYEnd);
            positionX += drawXStep + spaceXStep;
            positionY += drawYStep + spaceYStep;
            moveX += Math.abs(drawXStep + spaceXStep);
            moveY += Math.abs(drawYStep + spaceYStep);
        }
    }

    private static List<SelectableElement> drawLoop(SequenceDiagramModel model, SequenceDiagramAdjuster adjuster, Graphics g, int startObjectIndex, int endObjectIndex, int startSequenceIndex, int endSequenceIndex, int xGap, int yGap) {
        int fineAdjustment;
        LinkedList<SelectableElement> selectables = new LinkedList<SelectableElement>();
        int gap = fineAdjustment = adjuster.getArrowPointSize();
        int fontHeight = g.getFontMetrics().getHeight();
        int maxLoopDepth = model.getMaxLoopDepth();
        int objectSpace = adjuster.getObjectSpace();
        int i = model.getLoopNum() - 1;
        while (i >= 0) {
            SequenceObject object;
            int oIndex;
            SequenceLoop loop = model.getLoop(i);
            if (loop.getStart() <= endSequenceIndex && loop.getEnd() >= startSequenceIndex && (oIndex = (object = loop.getParentObject()) == null ? 0 : object.getIndex()) >= startObjectIndex && oIndex <= endObjectIndex) {
                int x1 = adjuster.getMargin().left + oIndex * (adjuster.getObjectWidth() + objectSpace) - objectSpace / 2 + xGap;
                int x2 = adjuster.getMargin().left + oIndex * (adjuster.getObjectWidth() + objectSpace) + adjuster.getObjectWidth() / 2 - adjuster.getCalledWidth() / 2 + xGap;
                x1 += loop.getDepth() * (x2 - x1) / (maxLoopDepth + 1);
                int y1 = (loop.getStart() + 1) * adjuster.getSequenceSpace() + yGap + adjuster.getMargin().top;
                int y2 = (loop.getEnd() + 1) * adjuster.getSequenceSpace() + yGap + adjuster.getMargin().top;
                LoopNode loopNode = loop.getNode();
                Color backupColor = g.getColor();
                if (model.getSelectionModel().getSelectedLoops().contains(loop)) {
                    g.setColor(selectionColor);
                    g.fillRect(x1, y1 - gap, x2 - x1, y2 - y1 + gap * 2);
                }
                if (loopNode instanceof SimpleLoopNode) {
                    g.setColor(Color.BLACK);
                } else if (loopNode instanceof ObjectDifferenceLoopNode) {
                    g.setColor(Color.BLUE);
                } else if (loopNode instanceof MethodMissingLoopNode) {
                    g.setColor(Color.RED);
                }
                g.drawLine(x1, y1 - gap, x2, y1 - gap);
                g.drawLine(x1, y1 - gap, x1, y2 + gap);
                g.drawLine(x1, y2 + gap, x2, y2 + gap);
                int stringX = x1 + fineAdjustment / 2;
                int stringY = (y2 + y1 + fontHeight) / 2;
                if (!loopNode.isFold()) {
                    g.drawString("1", stringX, stringY);
                } else if (loopNode.getLoopNums().size() > 1) {
                    g.drawString(loopNode.getLoopNum(0) + "-" + loopNode.getLoopNum(loopNode.getLoopNums().size() - 1), stringX, stringY);
                } else {
                    g.drawString("" + loopNode.getLoopNum(0), stringX, stringY);
                }
                SelectableElement element = new SelectableElement(new Rectangle(x1, y1 - gap, x2 - x1, y2 - y1 + gap * 2), loop, 3);
                selectables.add(element);
                g.setColor(backupColor);
            }
            --i;
        }
        return selectables;
    }
}

