/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram;

import amida.calltree.BlockNode;
import amida.calltree.CallNode;
import amida.calltree.CallTree;
import amida.calltree.CallTreeGroup;
import amida.calltree.CallTreeIterator;
import amida.calltree.LoopNode;
import amida.calltree.Node;
import amida.calltree.NodeList;
import amida.diagram.sequencediagram.ObjectMap;
import amida.diagram.sequencediagram.RecursiveCallBlock;
import amida.diagram.sequencediagram.SeparateBlock;
import amida.diagram.sequencediagram.Sequence;
import amida.diagram.sequencediagram.SequenceBlock;
import amida.diagram.sequencediagram.SequenceLoop;
import amida.diagram.sequencediagram.SequenceObject;
import amida.diagram.sequencediagram.SequenceSelectionModel;
import amida.diagram.sequencediagram.filter.IMethodFilter;
import amida.diagram.sequencediagram.filter.IPreObjectFilter;
import amida.utility.DataChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public class SequenceDiagramModel
implements DataChangeListener {
    private List<DataChangeListener> dataChangeListeners = new LinkedList<DataChangeListener>();
    private CallTree callTree;
    private Node targetNode;
    private NodeList targetNodeList;
    private SequenceSelectionModel selectionModel = new SequenceSelectionModel();
    private List<IPreObjectFilter> preObjectFilterList = new LinkedList<IPreObjectFilter>();
    private List<IMethodFilter> preMethodFilterList = new LinkedList<IMethodFilter>();
    private List<SequenceObject> objectList;
    private List<Sequence> sequenceList;
    private List<SequenceLoop> loopList;
    private List<SequenceBlock> blockList;
    private List<SequenceObject> tmpObjectList;
    private List<Sequence> tmpSequenceList;
    private List<SequenceLoop> tmpLoopList;
    private List<SequenceBlock> tmpBlockList;
    private int tmpMaxLoopDepth;
    private int tmpMaxCallStackLevel;
    private int tmpMaxBlockDepth;
    private int maxLoopDepth = 0;
    private int maxBlockDepth = 0;
    private int maxCallStackLevel = 0;
    private ObjectMap objectMap = new ObjectMap();
    private Stack<SequenceObject> loopStack = new Stack();
    private int sequenceCount = 0;

    public SequenceDiagramModel(CallTree tree) {
        this.callTree = tree;
        tree.addDataChangeListener(this);
        this.renew();
    }

    public SequenceDiagramModel(Node node) {
        this.targetNode = node;
        this.callTree = node.getCallTree();
        this.callTree.addDataChangeListener(this);
        this.renew();
    }

    public SequenceDiagramModel(NodeList list) {
        this.targetNodeList = list;
        this.callTree = list.getCallTree();
        this.callTree.addDataChangeListener(this);
        this.renew();
    }

    public SequenceDiagramModel(CallTreeGroup group) {
        this.renew();
    }

    public void renew() {
        if (this.targetNodeList == null && this.targetNode == null && (this.callTree == null || this.callTree.getTopNodeList() == null)) {
            return;
        }
        this.getSelectionModel().clearAllSelection();
        this.tmpLoopList = new ArrayList<SequenceLoop>();
        this.tmpObjectList = new ArrayList<SequenceObject>();
        this.tmpSequenceList = new ArrayList<Sequence>();
        this.tmpBlockList = new ArrayList<SequenceBlock>();
        this.tmpMaxLoopDepth = 0;
        this.tmpMaxBlockDepth = 0;
        this.tmpMaxCallStackLevel = 0;
        this.loopStack.clear();
        this.objectMap.clear();
        this.sequenceCount = 0;
        NodeList nodes = null;
        Node node = null;
        if (this.targetNode != null) {
            node = this.targetNode;
            this.objectMap.makeObjectGroupes(node, this.preObjectFilterList);
            this.makeSequenceModel(node, null, this.loopStack, 0);
        } else if (this.targetNodeList != null || this.callTree != null) {
            nodes = this.targetNodeList != null ? this.targetNodeList : this.callTree.getTopNodeList();
            this.objectMap.makeObjectGroupes(nodes, this.preObjectFilterList);
            this.makeSequenceModel(nodes, null, this.loopStack, 0);
        }
        this.reflectNewData();
        this.fireDataChange();
    }

    private void makeSequenceModel(NodeList list, SequenceObject callParent, Stack<SequenceObject> loopStack, int blockDepth) {
        CallTreeIterator it = list.nodeIterator();
        while (it.hasNext()) {
            Node node = it.next();
            this.makeSequenceModel(node, callParent, loopStack, blockDepth);
        }
    }

    private void makeSequenceModel(Node node, SequenceObject callParent, Stack<SequenceObject> loopStack, int blockDepth) {
        if (node instanceof CallNode) {
            CallNode call = (CallNode)node;
            SequenceObject object = this.objectMap.get(call);
            if (object == null) {
                return;
            }
            if (call.isConstructor() && object.getMadeIndex() == 0) {
                object.renewClassName(call);
            }
            Sequence newSequence = call.isRecursive() && !call.hasChildren() ? new Sequence(call, callParent, object, 3, this.sequenceCount) : new Sequence(call, callParent, object, 0, this.sequenceCount);
            int filtered = 0;
            for (IMethodFilter filter : this.preMethodFilterList) {
                int tmp = filter.filter(newSequence);
                if (tmp > filtered) {
                    filtered = tmp;
                }
                if (filtered == 1) break;
            }
            if (filtered == 2) {
                this.makeSequenceModel(node.getChildren(), callParent, loopStack, blockDepth);
            } else if (filtered == 0) {
                boolean isNewObject = false;
                if (object.getIndex() <= 0) {
                    object.setAppearanceIndex(this.tmpObjectList.size() + 1);
                    isNewObject = true;
                }
                ++this.sequenceCount;
                if (isNewObject) {
                    this.tmpObjectList.add(object);
                }
                this.tmpSequenceList.add(newSequence);
                if (callParent != null) {
                    callParent.addCallSequence(newSequence);
                }
                if (!call.isRecursive() || call.hasChildren()) {
                    object.call(newSequence, this.tmpSequenceList.size());
                }
                if (call.isBranch()) {
                    newSequence.setBranch(true);
                }
                if (object.getLevel() > this.tmpMaxCallStackLevel) {
                    this.tmpMaxCallStackLevel = object.getLevel();
                }
                if (!object.getIds().contains(new Integer(0)) && object.getMadeIndex() == 0) {
                    object.make(this.tmpSequenceList.size());
                }
                int tmpBlockDepth = 0;
                if (call.isRecursive() && call.hasChildren()) {
                    tmpBlockDepth = blockDepth++;
                }
                this.makeSequenceModel(node.getChildren(), object, loopStack, blockDepth);
                object.used(this.sequenceCount);
                Sequence newSequence2 = null;
                newSequence2 = call.getExitMode() == 2 ? (!call.isRecursive() || call.hasChildren() ? new Sequence(call, object, callParent, 5, this.sequenceCount++) : new Sequence(call, object, callParent, 6, this.sequenceCount++)) : (call.getReturnTypeName().equals("void") || !call.isEnded() ? new Sequence(call, object, callParent, 2, this.sequenceCount++) : (call.isRecursive() && !call.hasChildren() ? new Sequence(call, object, callParent, 4, this.sequenceCount++) : new Sequence(call, object, callParent, 1, this.sequenceCount++)));
                this.tmpSequenceList.add(newSequence2);
                if (callParent != null) {
                    callParent.addCallSequence(newSequence2);
                }
                newSequence.setPareSequence(newSequence2);
                if (!call.isRecursive() || call.hasChildren()) {
                    object.ret(newSequence2, this.tmpSequenceList.size() - 1);
                }
                if (call.isRecursive() && call.hasChildren()) {
                    RecursiveCallBlock recursiveBlock = new RecursiveCallBlock(tmpBlockDepth, callParent);
                    recursiveBlock.setStartIndex(newSequence.getIndex());
                    recursiveBlock.setEndIndex(newSequence2.getIndex());
                    recursiveBlock.setSequenceList(new ArrayList<Sequence>((Collection)this.tmpSequenceList.subList(newSequence.getIndex(), newSequence2.getIndex() + 1)));
                    this.tmpBlockList.add(recursiveBlock);
                }
            }
        } else if (node instanceof LoopNode) {
            int loopStart = this.tmpSequenceList.size();
            loopStack.push(callParent);
            this.makeSequenceModel(node.getChildren(), callParent, loopStack, blockDepth);
            loopStack.pop();
            int loopEnd = this.tmpSequenceList.size();
            if (loopStart != loopEnd) {
                Iterator stackEntry = loopStack.iterator();
                int count = 1;
                while (stackEntry.hasNext()) {
                    if (callParent != stackEntry.next()) continue;
                    ++count;
                }
                if (count > this.tmpMaxLoopDepth) {
                    this.tmpMaxLoopDepth = count;
                }
                this.tmpLoopList.add(new SequenceLoop((LoopNode)node, loopStart, loopEnd - 1, callParent, count));
            }
        } else if (node instanceof BlockNode) {
            BlockNode block = (BlockNode)node;
            if (block.hasChildren()) {
                int start = this.sequenceCount;
                if (this.tmpMaxBlockDepth < ++blockDepth) {
                    this.tmpMaxBlockDepth = blockDepth;
                }
                this.makeSequenceModel(node.getChildren(), callParent, loopStack, blockDepth);
                int end = this.sequenceCount - 1;
                if (end - start > 0) {
                    SeparateBlock separateBlock = new SeparateBlock(block, blockDepth, callParent);
                    separateBlock.setStartIndex(start);
                    separateBlock.setEndIndex(end);
                    separateBlock.setSequenceList(new ArrayList<Sequence>((Collection)this.tmpSequenceList.subList(start, end)));
                    this.tmpBlockList.add(separateBlock);
                }
            } else {
                SeparateBlock separateBlock = new SeparateBlock(block, blockDepth, callParent);
                separateBlock.setStartIndex(this.sequenceCount);
                separateBlock.setEndIndex(this.sequenceCount);
                separateBlock.setSequenceList(new ArrayList<Sequence>());
                this.tmpBlockList.add(separateBlock);
                Sequence one = new Sequence(null, callParent, callParent, 2, this.sequenceCount++);
                Sequence two = new Sequence(null, callParent, callParent, 2, this.sequenceCount++);
                one.setPareSequence(two);
                this.tmpSequenceList.add(one);
                this.tmpSequenceList.add(two);
            }
        } else {
            this.makeSequenceModel(node.getChildren(), callParent, loopStack, blockDepth);
        }
    }

    private synchronized void reflectNewData() {
        this.loopList = this.tmpLoopList;
        this.objectList = this.tmpObjectList;
        this.sequenceList = this.tmpSequenceList;
        this.blockList = this.tmpBlockList;
        this.maxLoopDepth = this.tmpMaxLoopDepth;
        this.maxBlockDepth = this.tmpMaxBlockDepth;
        this.maxCallStackLevel = this.tmpMaxCallStackLevel;
    }

    public synchronized List<Sequence> getSequenceList() {
        return Collections.unmodifiableList(this.sequenceList);
    }

    public synchronized Sequence getSequence(int i) {
        return this.sequenceList.get(i);
    }

    public synchronized int getSequenceNum() {
        return this.sequenceList.size();
    }

    public synchronized List<SequenceObject> getObjectList() {
        return Collections.unmodifiableList(this.objectList);
    }

    public synchronized SequenceObject getObject(int i) {
        return this.objectList.get(i);
    }

    public synchronized int getObjectNum() {
        return this.objectList.size();
    }

    public synchronized List<SequenceLoop> getLoopList() {
        return Collections.unmodifiableList(this.loopList);
    }

    public synchronized SequenceLoop getLoop(int i) {
        return this.loopList.get(i);
    }

    public synchronized int getLoopNum() {
        return this.loopList.size();
    }

    public synchronized List<SequenceBlock> getBlockList() {
        return Collections.unmodifiableList(this.blockList);
    }

    public synchronized SequenceBlock getBlock(int i) {
        return this.blockList.get(i);
    }

    public synchronized int getBlockNum() {
        return this.blockList.size();
    }

    public synchronized void sortObject(Comparator<SequenceObject> comp) {
        Collections.sort(this.objectList, comp);
        ListIterator<SequenceObject> it = this.objectList.listIterator();
        while (it.hasNext()) {
            it.next().setIndex(it.nextIndex());
        }
        this.fireDataChange();
    }

    public synchronized int getMaxCallDepth() {
        return this.maxCallStackLevel;
    }

    public synchronized int getMaxLoopDepth() {
        return this.maxLoopDepth;
    }

    @Override
    public void dataChanged() {
        this.renew();
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.add(listener);
    }

    public void removeDataChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.remove(listener);
    }

    public void fireDataChange() {
        for (DataChangeListener listener : this.dataChangeListeners) {
            listener.dataChanged();
        }
    }

    public SequenceSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SequenceSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public void selectionChanged() {
        this.renew();
    }

    public CallTree getCallTree() {
        return this.callTree;
    }

    public int getMaxBlockDepth() {
        return this.maxBlockDepth;
    }

    public Node getTargetNode() {
        return this.targetNode;
    }

    public NodeList getTargetNodeList() {
        return this.targetNodeList;
    }

    public void addPreObjectFilter(IPreObjectFilter filter) {
        this.preObjectFilterList.add(filter);
    }

    public void remvoePreObjectFilter(IPreObjectFilter filter) {
        this.preObjectFilterList.remove(filter);
    }

    public void addPreMethodFilter(IMethodFilter filter) {
        this.preMethodFilterList.add(filter);
    }

    public void removePreMethodFilter(IMethodFilter filter) {
        this.preMethodFilterList.add(filter);
    }

    public void clearAllFilters() {
        this.preObjectFilterList.clear();
        this.preMethodFilterList.clear();
    }
}

