/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram;

import amida.calltree.CallNode;
import amida.diagram.sequencediagram.Called;
import amida.diagram.sequencediagram.ISequenceElement;
import amida.diagram.sequencediagram.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class SequenceObject
implements ISequenceElement {
    public static final int STATE_VISIBLE = 0;
    public static final int STATE_HIDDEN = 1;
    public static final int STATE_DELETED = 2;
    private int state = 0;
    private int index;
    private int madeIndex;
    private int lastUsedIndex;
    private int appearanceNum;
    private String className = null;
    private String nameSpace = null;
    private Set<Integer> ids = new TreeSet<Integer>();
    private List<Called> calledList = new ArrayList<Called>();
    private final Stack<Integer> callStack = new Stack();
    private final List<Sequence> calledSequences = new LinkedList<Sequence>();
    private final List<Sequence> callSequences = new LinkedList<Sequence>();
    private boolean renewable = true;
    private List<SequenceObject> children = null;
    private static final Integer ZERO = new Integer(0);
    public static final String CLASS_OBJECT_LABEL = "<CLASS>";
    List<String> label = null;

    public SequenceObject() {
    }

    public void addClassName(String signature) {
        if (this.renewable) {
            String[] args = signature.split(" ");
            this.nameSpace = args[0];
            this.className = args[1];
        }
    }

    public SequenceObject(CallNode call) {
        this();
        this.renewClassName(call);
        this.ids.addAll(call.getId());
    }

    public void renewClassName(CallNode call) {
        if (this.renewable) {
            this.className = call.getClassName();
            this.nameSpace = call.getPackageName();
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void addId(int i) {
        this.ids.add(new Integer(i));
    }

    public void addId(Integer i) {
        this.ids.add(i);
    }

    public void addIds(Set<Integer> ids) {
        Iterator<Integer> it = ids.iterator();
        while (it.hasNext()) {
            this.ids.add(it.next());
        }
    }

    public boolean isStaticObject() {
        return this.getIds().size() == 1 && this.getIds().contains(ZERO);
    }

    public Set<Integer> getIds() {
        return this.ids;
    }

    public String getClassName() {
        return this.className;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void call(Sequence seq, int start) {
        this.callStack.push(new Integer(start));
        this.calledSequences.add(seq);
    }

    public void ret(Sequence seq, int end) {
        Integer start = this.callStack.pop();
        this.calledList.add(new Called(this, seq.getPareSequence(), seq, start, end, this.callStack.size()));
        this.calledSequences.add(seq);
    }

    public void addCallSequence(Sequence seq) {
        this.callSequences.add(seq);
    }

    public int getCalledNum() {
        return this.calledList.size();
    }

    public Called getCalled(int index) {
        return this.calledList.get(index);
    }

    public int getLevel() {
        return this.callStack.size();
    }

    public void make(int index) {
        this.madeIndex = index;
    }

    public int getMadeIndex() {
        return this.madeIndex;
    }

    public void used(int index) {
        this.lastUsedIndex = index;
    }

    public int getLastUsedIndex() {
        return this.lastUsedIndex;
    }

    public int getAppearanceNum() {
        return this.appearanceNum;
    }

    public boolean isVisible(int index) {
        return index <= this.lastUsedIndex;
    }

    public boolean isActive(int start, int end) {
        return start <= this.madeIndex && this.madeIndex <= end || start <= this.lastUsedIndex && this.lastUsedIndex <= end || this.madeIndex < start && end < this.lastUsedIndex;
    }

    public void setAppearanceIndex(int i) {
        this.appearanceNum = i;
        this.index = i;
    }

    public void setNameSpace(String packageName) {
        if (this.renewable) {
            this.nameSpace = packageName;
        }
    }

    public void setClassName(String className) {
        if (this.renewable) {
            this.className = className;
        }
    }

    public void setRenewable(boolean b) {
        this.renewable = b;
    }

    public void setVisibleState(int state) {
        this.state = state;
    }

    public boolean isHidden() {
        return this.state == 1;
    }

    public boolean isDeleted() {
        return this.state == 2;
    }

    public void merge(SequenceObject another) {
        if (this.children == null) {
            this.children = new ArrayList<SequenceObject>();
        }
        this.children.add(another);
        this.addIds(another.getIds());
        if (this.className == null) {
            this.className = another.className;
        } else if (!this.className.equals(another.className)) {
            this.className = String.valueOf(this.className) + "/" + another.className;
        }
        if (this.nameSpace == null) {
            this.nameSpace = another.nameSpace;
        } else if (!this.nameSpace.equals(another.nameSpace)) {
            this.nameSpace = "*";
        }
        if (this.state > another.state) {
            this.state = another.state;
        }
    }

    public boolean isUnified() {
        return this.children != null && this.children.size() > 1;
    }

    public List<SequenceObject> getUnifiedObjects() {
        return this.children;
    }

    public String getObjectCountString() {
        return "(" + Integer.toString(this.ids.size()) + " objects)";
    }

    public List<String> getObjectIDLabels() {
        if (this.label == null) {
            this.label = new ArrayList<String>();
            int[] idlist = new int[this.ids.size()];
            int idx = 0;
            for (Integer id : this.ids) {
                idlist[idx] = id;
                ++idx;
            }
            if (this.ids.size() == 1) {
                if (idlist[0] == 0) {
                    this.label.add(CLASS_OBJECT_LABEL);
                } else {
                    this.label.add(Integer.toString(idlist[0]));
                }
            } else {
                int start;
                Arrays.sort(idlist);
                int last = start = idlist[0];
                int i = 1;
                while (i < idlist.length) {
                    if (last + 1 == idlist[i]) {
                        last = idlist[i];
                    } else {
                        this.label.add(this.createLabel(start, last));
                        start = idlist[i];
                        last = idlist[i];
                    }
                    ++i;
                }
                this.label.add(this.createLabel(start, last));
            }
        }
        return this.label;
    }

    private String createLabel(int start, int last) {
        if (start == last) {
            return Integer.toString(start);
        }
        return String.valueOf(Integer.toString(start)) + "-" + Integer.toString(last);
    }
}

