/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram.filter;

import amida.calltree.CallNode;
import amida.diagram.sequencediagram.ObjectGroup;
import amida.diagram.sequencediagram.filter.IPreObjectFilter;
import amida.utility.StringPatternComparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class ObjectFilter
implements IPreObjectFilter {
    private final String packageName;
    private final String className;
    private final Set<Integer> ids;
    private final boolean canIncludeOtherId;

    public ObjectFilter(String packageName, String className, Set<Integer> ids, boolean otherId) {
        this.packageName = packageName;
        this.className = className;
        if (ids != null) {
            this.ids = new TreeSet<Integer>();
            this.ids.addAll(ids);
        } else {
            this.ids = null;
        }
        this.canIncludeOtherId = otherId;
    }

    @Override
    public boolean filter(CallNode node) {
        if (this.packageName != null && !StringPatternComparator.compareStringPattern(this.packageName, node.getPackageName())) {
            return false;
        }
        if (this.className != null && !StringPatternComparator.compareStringPattern(this.className, node.getClassName())) {
            return false;
        }
        return !(this.canIncludeOtherId ? this.ids != null && !this.ids.isEmpty() && !this.ids.containsAll(node.getId()) : this.ids == null || this.ids.isEmpty() || !this.ids.equals(node.getId()));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.getPackageName()) + "." + this.getClassName() + "(");
        if (this.getIds() == null || this.getIds().isEmpty()) {
            buffer.append("*");
        } else {
            Iterator<Integer> it = this.getIds().iterator();
            while (it.hasNext()) {
                buffer.append(it.next());
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public abstract void makeSuitableGroupe(CallNode var1, Map<CallNode, ObjectGroup> var2);

    public boolean isCanIncludeOtherId() {
        return this.canIncludeOtherId;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<Integer> getIds() {
        return this.ids;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

