/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram.filter;

import amida.calltree.CallNode;
import amida.diagram.sequencediagram.ObjectGroup;
import amida.diagram.sequencediagram.filter.ObjectFilter;
import amida.utility.StringPatternComparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObjectUnifyFilter
extends ObjectFilter {
    public ObjectUnifyFilter(String packageName, String className, Set<Integer> ids, boolean otherId) {
        super(packageName, className, ids, otherId);
    }

    @Override
    public void makeSuitableGroupe(CallNode node, Map<CallNode, ObjectGroup> map) {
        Iterator<Map.Entry<CallNode, ObjectGroup>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            ObjectGroup groupe = it.next().getValue();
            if (!this.isSuitableGroupe(groupe)) continue;
            map.put(node, groupe);
            groupe.addIds(node.getId());
            groupe.getSequenceObject().setNameSpace(this.getPackageName());
            groupe.getSequenceObject().setClassName(this.getClassName());
            groupe.getSequenceObject().setRenewable(false);
            return;
        }
        map.put(node, new ObjectGroup(node));
    }

    private boolean isSuitableGroupe(ObjectGroup groupe) {
        String groupePackage = groupe.getSequenceObject().getNameSpace();
        String groupeClass = groupe.getSequenceObject().getClassName();
        Set<Integer> groupeId = groupe.getSequenceObject().getIds();
        if (this.getPackageName() != null && !StringPatternComparator.compareStringPattern(this.getPackageName(), groupePackage)) {
            return false;
        }
        if (this.getClassName() != null && !StringPatternComparator.compareStringPattern(this.getClassName(), groupeClass)) {
            return false;
        }
        return this.getIds() == null || this.getIds().isEmpty() || this.getIds().containsAll(groupeId);
    }
}

