/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram.filter.gui;

import amida.diagram.sequencediagram.filter.ISequenceFilter;
import amida.diagram.sequencediagram.filter.gui.SequenceFilter;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class MethodFilter
extends SequenceFilter {
    public static final int DELETE_ALL = 0;
    public static final int DELETE_ONLY = 1;
    public static final String DELETE_ALL_NAME = "Delete all.";
    public static final String DELETE_ONLY_NAME = "Delete only.";
    private int type = 0;
    private String methodName;
    private String callerPackage;
    private String callerClass;
    private Set<Integer> callerId = new TreeSet<Integer>();
    private boolean callerCanIncludeOtherId = false;
    private String calleePackage = null;
    private String calleeClass = null;
    private Set<Integer> calleeId = new TreeSet<Integer>();
    private boolean calleeCanIncludeOtherId = false;
    private boolean samePackage = false;
    private boolean sameClass = false;
    private boolean sameId = false;
    private ISequenceFilter filter;

    public MethodFilter(String DiagramName, int type, String methodName, String callerPackage, String callerClass, String callerId, String calleePackage, String calleeClass, String calleeId, boolean samePackage, boolean sameClass, boolean sameId) {
        super(DiagramName);
        this.type = type;
        this.methodName = methodName;
        this.callerPackage = callerPackage;
        this.callerClass = callerClass;
        this.callerCanIncludeOtherId = this.makeIdSet(callerId, this.callerId);
        this.samePackage = samePackage;
        this.calleePackage = calleePackage;
        this.sameClass = sameClass;
        this.calleeClass = calleeClass;
        this.sameId = sameId;
        this.calleeCanIncludeOtherId = this.makeIdSet(calleeId, this.calleeId);
        this.filter = new amida.diagram.sequencediagram.filter.MethodFilter(this.type, this.methodName, this.callerPackage, this.callerClass, this.callerId, this.callerCanIncludeOtherId, this.calleePackage, this.calleeClass, this.calleeId, this.calleeCanIncludeOtherId, this.samePackage, this.sameClass, this.sameId);
    }

    private boolean makeIdSet(String id, Set<Integer> idSet) {
        boolean containsAsterisk = false;
        StringTokenizer st = new StringTokenizer(id, " ,;.()[]{}\t");
        while (st.hasMoreTokens()) {
            try {
                String token = st.nextToken();
                if (token.equals("*")) {
                    containsAsterisk = true;
                    continue;
                }
                idSet.add(Integer.valueOf(token));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return containsAsterisk;
    }

    @Override
    public ISequenceFilter getFilter() {
        return this.filter;
    }

    public String getTypeName() {
        if (this.type == 0) {
            return DELETE_ALL_NAME;
        }
        if (this.type == 1) {
            return DELETE_ONLY_NAME;
        }
        return "";
    }

    public String getCaller() {
        return String.valueOf(this.callerPackage) + "." + this.callerClass + "(" + this.idToString(this.callerId, this.callerCanIncludeOtherId) + ")";
    }

    public String getCallee() {
        boolean containsOther;
        Set<Integer> ids;
        String packageName = this.samePackage ? this.callerPackage : this.calleePackage;
        String className = this.sameClass ? this.callerClass : this.calleeClass;
        if (this.sameId) {
            ids = this.callerId;
            containsOther = this.callerCanIncludeOtherId;
        } else {
            ids = this.calleeId;
            containsOther = this.calleeCanIncludeOtherId;
        }
        return String.valueOf(packageName) + "." + className + "(" + this.idToString(ids, containsOther) + ")";
    }

    private String idToString(Set<Integer> ids, boolean containsOther) {
        StringBuffer buffer = new StringBuffer();
        if (ids != null && !ids.isEmpty()) {
            Iterator<Integer> it = ids.iterator();
            while (it.hasNext()) {
                buffer.append(it.next() + ",");
            }
            if (containsOther) {
                buffer.append("*");
            } else {
                buffer.deleteCharAt(buffer.length() - 1);
            }
        } else if (containsOther) {
            buffer.append("*");
        }
        return buffer.toString();
    }

    public String getCalleeClass() {
        return this.calleeClass;
    }

    public Set<Integer> getCalleeId() {
        return this.calleeId;
    }

    public String getCalleePackage() {
        return this.calleePackage;
    }

    public String getCallerClass() {
        return this.callerClass;
    }

    public Set<Integer> getCallerId() {
        return this.callerId;
    }

    public String getCallerPackage() {
        return this.callerPackage;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isSameClass() {
        return this.sameClass;
    }

    public boolean isSameId() {
        return this.sameId;
    }

    public boolean isSamePackage() {
        return this.samePackage;
    }

    public int getType() {
        return this.type;
    }
}

