/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram.gui;

import amida.diagram.sequencediagram.SequenceDiagramAdjuster;
import amida.diagram.sequencediagram.SequenceDiagramModel;
import amida.diagram.sequencediagram.gui.SequenceDiagramCanvas;
import amida.diagram.sequencediagram.gui.SequenceMapCanvas;
import amida.diagram.sequencediagram.gui.SequenceObjectCanvas;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JScrollPane;

public class DiagramsCanvasAdjuster
extends SequenceDiagramAdjuster {
    private SequenceDiagramCanvas sdc;
    private SequenceObjectCanvas soc;
    private SequenceMapCanvas smc;
    private SequenceDiagramModel model;
    private MouseListener smcMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (DiagramsCanvasAdjuster.this.smc != null) {
                Point p = e.getPoint();
                Insets margin = SequenceMapCanvas.MARGIN;
                DiagramsCanvasAdjuster.this.moveSdc((p.getX() - (double)margin.left) / (double)DiagramsCanvasAdjuster.this.smc.getXRate(), (p.getY() - (double)margin.top) / (double)DiagramsCanvasAdjuster.this.smc.getYRate() + 1.0);
            }
        }
    };
    private MouseMotionListener smcMouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent e) {
            if (DiagramsCanvasAdjuster.this.smc != null) {
                Point p = e.getPoint();
                Insets margin = SequenceMapCanvas.MARGIN;
                DiagramsCanvasAdjuster.this.moveSdc((p.getX() - (double)margin.left) / (double)DiagramsCanvasAdjuster.this.smc.getXRate(), (p.getY() - (double)margin.top) / (double)DiagramsCanvasAdjuster.this.smc.getYRate() + 1.0);
            }
        }
    };
    private AdjustmentListener sdcScrollListener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (DiagramsCanvasAdjuster.this.smc != null) {
                DiagramsCanvasAdjuster.this.smc.repaint();
            }
            if (DiagramsCanvasAdjuster.this.soc != null) {
                DiagramsCanvasAdjuster.this.soc.repaint();
            }
        }
    };

    @Override
    public int getObjectSpace() {
        if (this.model == null) {
            return 8;
        }
        int space = this.model.getMaxCallDepth() * this.getCalledWidth() / 2;
        if (space > 8) {
            return space;
        }
        return 8;
    }

    protected void setDiagramCanvas(SequenceDiagramCanvas _sdc) {
        this.sdc = _sdc;
        if (_sdc == null) {
            return;
        }
        JScrollPane diagramScroll = this.getParentJScrollPane(this.sdc);
        if (diagramScroll != null) {
            diagramScroll.getHorizontalScrollBar().addAdjustmentListener(this.sdcScrollListener);
            diagramScroll.getVerticalScrollBar().addAdjustmentListener(this.sdcScrollListener);
        }
        this.sdc.setSequenceDiagramsAdjuster(this);
    }

    protected void setObjectCanvas(SequenceObjectCanvas soc) {
        this.soc = soc;
        soc.setSequenceDiagramsAdjuster(this);
    }

    protected void setMapCanvas(SequenceMapCanvas _smc) {
        this.smc = _smc;
        if (this.smc != null) {
            this.smc.setModel(this.getModel());
            this.smc.addMouseListener(this.smcMouseListener);
            this.smc.addMouseMotionListener(this.smcMouseMotionListener);
            this.smc.setSequenceDiagramsAdjuster(this);
        }
    }

    protected void removeMapCanvas() {
        if (this.smc != null) {
            this.smc.removeMouseListener(this.smcMouseListener);
            this.smc.removeMouseMotionListener(this.smcMouseMotionListener);
            this.smc.setSequenceDiagramsAdjuster(null);
            this.smc = null;
        }
    }

    protected Rectangle getDiagramCanvasViewRange() {
        return this.sdc.getViewRange();
    }

    public void moveSdc(double objectNum, double sequenceNum) {
        if (this.sdc == null) {
            return;
        }
        this.sdc.scroll((int)objectNum, (int)sequenceNum);
    }

    public Rectangle translateDiagramCoordinatesToMap(Rectangle sdcCoordinates) {
        double xrate = (double)this.smc.getXRate() / (double)(this.getObjectSpace() + this.getObjectWidth());
        double yrate = (double)this.smc.getYRate() / (double)this.getSequenceSpace();
        int x = (int)((double)sdcCoordinates.x * xrate);
        int y = (int)((double)sdcCoordinates.y * yrate);
        int width = (int)((double)sdcCoordinates.width * xrate);
        int height = (int)((double)sdcCoordinates.height * yrate);
        return new Rectangle(x, y, width, height);
    }

    private JScrollPane getParentJScrollPane(Component comp) {
        while ((comp = comp.getParent()) != null && !(comp instanceof JScrollPane)) {
        }
        if (comp != null) {
            return (JScrollPane)comp;
        }
        return null;
    }

    public SequenceDiagramModel getModel() {
        return this.model;
    }

    public void setModel(SequenceDiagramModel model) {
        this.model = model;
        if (this.sdc != null) {
            this.sdc.setModel(model);
        }
        if (this.smc != null) {
            this.smc.setModel(model);
        }
        if (this.soc != null) {
            this.soc.setModel(model);
        }
    }
}

