/*
 * Decompiled with CFR 0.152.
 */
package amida.gui;

import amida.gui.MouseHandler;
import amida.gui.TableModel;
import amida.gui.TableModelListener;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableManager {
    private static final int COL_MIN_WIDTH = 60;
    private static final int BAR_COL_WIDTH = 300;

    public static void associate(Table table, TableModel model) {
        table.setHeaderVisible(true);
        int i = 0;
        while (i < model.getColumnCount()) {
            TableColumn col = new TableColumn(table, 16384);
            col.setText(model.getColumnName(i));
            if (i < model.getColumnCount() - 1) {
                col.pack();
                if (col.getWidth() < 60) {
                    col.setWidth(60);
                }
            } else {
                col.setWidth(300);
            }
            ++i;
        }
        TableSorter sorter = new TableSorter(table, model);
        int i2 = 0;
        while (i2 < model.getColumnCount()) {
            table.getColumn(i2).addSelectionListener((SelectionListener)sorter);
            ++i2;
        }
        model.addListener(new UpdateListener(table, model));
        table.addListener(8, (Listener)new DblClickHandler(table, model));
        table.addListener(42, (Listener)new BarPainter(table, model));
        table.addListener(5, (Listener)new MouseMoveHandler(table, model));
        table.addListener(3, (Listener)new SingleClickHandler(table, model));
    }

    private static class BarPainter
    implements Listener {
        private Table table;
        private TableModel model;

        public BarPainter(Table table, TableModel model) {
            this.table = table;
            this.model = model;
        }

        public void handleEvent(Event event) {
            if (event.index == this.table.getColumnCount() - 1) {
                GC gc = event.gc;
                Table table = (Table)event.widget;
                TableColumn column = table.getColumn(event.index);
                TableItem item = (TableItem)event.item;
                String text = item.getText(table.getColumnCount() - 1);
                int idx = Integer.parseInt(text);
                this.model.getContent(idx).draw(table.getDisplay(), gc, event.x, event.y, column.getWidth(), event.height);
            }
        }
    }

    private static class DblClickHandler
    extends MouseHandler {
        public DblClickHandler(Table table, TableModel model) {
            super(table, model);
        }

        @Override
        protected void triggerEvent(Event event, int index, int x, int y, int w, int h, int cursorX, int cursorY) {
            if (event.button == 1) {
                this.getModel().getContent(index).onDoubleClicked((Control)this.getTable(), x, y, w, h, cursorX, cursorY);
            }
        }

        @Override
        protected void triggerNoHit(Event e) {
        }
    }

    private static class MouseMoveHandler
    extends MouseHandler {
        public MouseMoveHandler(Table table, TableModel model) {
            super(table, model);
        }

        @Override
        protected void triggerEvent(Event event, int index, int x, int y, int w, int h, int cursorX, int cursorY) {
            this.getModel().getContent(index).onMouseMove((Control)this.getTable(), x, y, w, h, cursorX, cursorY);
        }

        @Override
        protected void triggerNoHit(Event e) {
            this.getModel().onMouseLeave();
        }
    }

    private static class SingleClickHandler
    extends MouseHandler {
        public SingleClickHandler(Table table, TableModel model) {
            super(table, model);
        }

        @Override
        protected void triggerEvent(Event event, int index, int x, int y, int w, int h, int cursorX, int cursorY) {
            if (event.count == 1 && event.button != 1) {
                this.getModel().getContent(index).onClicked((Control)this.getTable(), x, y, w, h, cursorX, cursorY);
            }
        }

        @Override
        protected void triggerNoHit(Event e) {
        }
    }

    private static class TableSorter
    implements SelectionListener {
        private Table table;
        private TableModel model;
        private int[] sortKeys;

        public TableSorter(Table table, TableModel model) {
            this.table = table;
            this.model = model;
            this.sortKeys = new int[table.getColumnCount() - 1];
            int i = 0;
            while (i < this.sortKeys.length) {
                this.sortKeys[i] = i;
                ++i;
            }
        }

        private int getColumnIndex(SelectionEvent e) {
            int i = 0;
            while (i < this.table.getColumnCount()) {
                if (this.table.getColumn(i) == e.getSource()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void updateSortKeys(int index) {
            if (index == this.sortKeys[0]) {
                this.sortKeys[0] = this.reverseKey(this.sortKeys[0]);
            } else {
                int newKey = index;
                int i = 0;
                while (i < this.sortKeys.length) {
                    int tempKey = this.sortKeys[i];
                    this.sortKeys[i] = newKey;
                    newKey = tempKey;
                    if (newKey == index || newKey == this.reverseKey(index)) break;
                    ++i;
                }
            }
        }

        private int reverseKey(int index) {
            if (index < this.sortKeys.length) {
                return index + this.sortKeys.length;
            }
            return index - this.sortKeys.length;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.getColumnIndex(e);
            if (index < 0 || index >= this.sortKeys.length) {
                return;
            }
            this.updateSortKeys(index);
            TableItem[] items = this.table.getItems();
            Arrays.sort(items, new ItemComparator());
            this.table.setRedraw(false);
            String[][] copy = new String[this.table.getItemCount()][this.table.getColumnCount()];
            int i = 0;
            while (i < items.length) {
                int col = 0;
                while (col < this.table.getColumnCount()) {
                    copy[i][col] = items[i].getText(col);
                    ++col;
                }
                ++i;
            }
            i = 0;
            while (i < items.length) {
                this.table.getItem(i).setText(copy[i]);
                ++i;
            }
            this.table.setRedraw(true);
            this.table.redraw();
        }

        private class ItemComparator
        implements Comparator<TableItem> {
            private ItemComparator() {
            }

            @Override
            public int compare(TableItem item1, TableItem item2) {
                int i = 0;
                while (i < TableSorter.this.sortKeys.length) {
                    int result;
                    int sortColumn = TableSorter.this.sortKeys[i];
                    int direction = 1;
                    if (TableSorter.this.sortKeys[i] >= TableSorter.this.sortKeys.length) {
                        sortColumn -= TableSorter.this.sortKeys.length;
                        direction = -1;
                    }
                    if ((result = this.compareContent(item1.getText(sortColumn), item2.getText(sortColumn), TableSorter.this.model.getColumnType(sortColumn), direction)) != 0) {
                        return result;
                    }
                    ++i;
                }
                return 0;
            }

            private int compareContent(String item1, String item2, int col, int direction) {
                if (col == 0) {
                    return direction * (Integer.parseInt(item1) - Integer.parseInt(item2));
                }
                if (col == 1) {
                    return direction * (int)Math.signum(Double.parseDouble(item1) - Double.parseDouble(item2));
                }
                return direction * item1.compareTo(item2);
            }
        }
    }

    private static class UpdateListener
    implements TableModelListener {
        private Table table;
        private TableModel model;

        public UpdateListener(Table table, TableModel model) {
            this.table = table;
            this.model = model;
        }

        @Override
        public void update() {
            this.table.removeAll();
            int row = 0;
            while (row < this.model.getRowCount()) {
                TableItem item = new TableItem(this.table, 0);
                int col = 0;
                while (col < this.model.getColumnCount()) {
                    item.setText(col, this.model.getCell(col, row));
                    ++col;
                }
                ++row;
            }
        }

        @Override
        public void hideHint() {
            this.table.setToolTipText(null);
        }
    }
}

