/*
 * Decompiled with CFR 0.152.
 */
package amida.gui;

import amida.gui.MainFrame;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.IOException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class VersionDialog
extends JDialog {
    private static final long serialVersionUID = 8661859849641870444L;
    private static final String toolName = "Amida";
    private static final String version = "1.0 (ICSE2008)";
    private static final String copyRight = "Copyright (C) 2003-2007, Koji Taniguchi. All Right Reserved.";
    private static final String contact = "http://sel.ist.osaka-u.ac.jp/~ishio/amida/";
    private static String bgColor = "eeeeee";
    private static String textColor = null;
    private static String linkColor = null;
    private final JEditorPane editorPane = new JEditorPane("text/html", null);

    public VersionDialog() {
        super(MainFrame.getInstance(), "About", true);
        this.editorPane.setPreferredSize(new Dimension(360, 80));
        this.editorPane.setEditable(false);
        this.editorPane.setMargin(new Insets(0, 0, 0, 0));
        this.editorPane.setText(this.buildHtmlString());
        this.add(this.editorPane);
        this.pack();
        this.setResizable(false);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){
            private final Cursor handCursor = new Cursor(12);

            @Override
            public void hyperlinkUpdate(HyperlinkEvent arg0) {
                if (arg0.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = arg0.getURL();
                    String os = System.getProperty("os.name");
                    if (os.startsWith("Windows")) {
                        try {
                            Runtime.getRuntime().exec("cmd /c start " + url.toString());
                        }
                        catch (IOException iOException) {}
                    }
                } else if (arg0.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    VersionDialog.this.setCursor(this.handCursor);
                } else {
                    VersionDialog.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    private String buildHtmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<body");
        if (bgColor != null) {
            sb.append(" bgcolor = \"");
            sb.append(bgColor);
            sb.append("\"");
        }
        if (textColor != null) {
            sb.append(" text = \"");
            sb.append(textColor);
            sb.append("\"");
        }
        if (linkColor != null) {
            sb.append(" link = \"");
            sb.append(linkColor);
            sb.append("\"");
        }
        sb.append(">");
        sb.append(toolName);
        sb.append(" ");
        sb.append(version);
        sb.append("<br>");
        sb.append(copyRight);
        sb.append("<br>");
        sb.append(this.buildHyperLinkString(contact));
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    private String buildHyperLinkString(String url) {
        boolean isMailAddr = url.contains("@");
        StringBuilder sb = new StringBuilder();
        sb.append("<a href = \"");
        if (isMailAddr) {
            sb.append("mailto:");
        }
        sb.append(url);
        sb.append("\">");
        sb.append(url);
        sb.append("</a>");
        return sb.toString();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(MainFrame.getInstance());
        }
        super.setVisible(b);
    }
}

