/*
 * Decompiled with CFR 0.152.
 */
package amida.logdecoder;

import amida.logdecoder.Dictionary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class DictionaryLoader {
    private static final String METHOD = "Method";
    private static final String THREAD = "Thread";
    public static final String KEY_VALUE_SEPARATOR = "=";

    public static Dictionary loadDictionary(String filename) {
        try {
            Dictionary dict = new Dictionary();
            File f = new File(filename);
            BufferedReader reader = new BufferedReader(new FileReader(f));
            int l = 0;
            while (reader.ready()) {
                String[] s;
                ++l;
                String line = reader.readLine();
                if (line.startsWith(METHOD)) {
                    s = line.substring(METHOD.length() + 1).split(KEY_VALUE_SEPARATOR);
                    if (s.length == 2) {
                        dict.put(Integer.valueOf(s[0]), s[1]);
                        continue;
                    }
                    System.err.println("Invalid key-value pair found at line " + Integer.toString(l));
                    return dict;
                }
                if (line.startsWith(THREAD)) {
                    s = line.substring(THREAD.length() + 1).split(KEY_VALUE_SEPARATOR);
                    if (s.length == 2) {
                        dict.putThread(Integer.valueOf(s[0]), s[1].substring(1, s[1].length() - 1));
                        continue;
                    }
                    System.err.println("Invalid key-value pair found at line " + Integer.toString(l));
                    return dict;
                }
                System.err.println("Invalid key-value pair found at line " + Integer.toString(l));
                return dict;
            }
            return dict;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

