/*
 * Decompiled with CFR 0.152.
 */
package amida.logloader;

import amida.LanguageType;
import amida.logloader.LogEntry;
import amida.logloader.LogParser;
import amida.logloader.MethodCallEntry;
import amida.logloader.MethodExitByThrowExceptionEntry;
import amida.logloader.MethodExitEntry;
import amida.logloader.ThreadStartEntry;
import amida.logloader.UnknownEntry;
import amida.staticdata.StaticDataAccessor;
import amida.staticdata.Type;
import amida.staticdata.java.JavaStaticDataAccessor;
import amida.staticdata.java.data.JavaAccessModifier;
import amida.staticdata.java.data.JavaType;
import amida.staticdata.java.data.JavaTypeManager;
import java.util.LinkedList;
import java.util.Queue;
import java.util.StringTokenizer;

public class DefaultLogParser
implements LogParser {
    private final int DEFAULT_THREAD_INDEX = 0;
    private final String THREAD_START = "@thread";
    private final Queue<LogEntry> queue = new LinkedList<LogEntry>();
    private int globalMethodCallCount = 0;

    public DefaultLogParser(LanguageType type) {
    }

    @Override
    public Queue<LogEntry> parse(Object o) {
        if (!(o instanceof String)) {
            this.queue.offer(UnknownEntry.getInstance());
            return this.queue;
        }
        String line = (String)o;
        if (line.length() == 0) {
            this.queue.offer(UnknownEntry.getInstance());
            return this.queue;
        }
        if (line.startsWith("//")) {
            this.queue.offer(UnknownEntry.getInstance());
            return this.queue;
        }
        if (line.trim().startsWith("@thread")) {
            String s = line.trim().substring("@thread".length());
            int idx = s.indexOf("=");
            if (idx == -1) {
                this.queue.offer(UnknownEntry.getInstance());
                return this.queue;
            }
            String key = s.substring(0, idx).trim();
            String value = s.substring(idx + 1, s.length()).trim();
            try {
                int threadId = Integer.parseInt(key);
                String threadName = value;
                if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                    threadName = value.substring(1, value.length() - 1);
                }
                this.queue.offer(new ThreadStartEntry(threadName, threadId));
                return this.queue;
            }
            catch (NumberFormatException e) {
                this.queue.offer(UnknownEntry.getInstance());
                return this.queue;
            }
        }
        StringTokenizer st = new StringTokenizer(line, " (){\t\r\n");
        if (!st.hasMoreTokens()) {
            this.queue.offer(UnknownEntry.getInstance());
            return this.queue;
        }
        String token = st.nextToken();
        int threadId = 0;
        if (token.startsWith("@") && token.length() > 1) {
            try {
                String tmp = token;
                token = st.nextToken();
                threadId = Integer.parseInt(tmp.substring(1));
            }
            catch (NumberFormatException tmp) {
                // empty catch block
            }
        }
        if (token.equals("}")) {
            if (st.hasMoreTokens()) {
                token = st.nextToken();
                if (token.equals("returnTo:")) {
                    MethodExitEntry exit = new MethodExitEntry(threadId);
                    exit.setCallerInfo(this.parseCallerInfo(token, st, threadId));
                    this.queue.offer(exit);
                } else {
                    String exception = token;
                    MethodExitByThrowExceptionEntry entry = new MethodExitByThrowExceptionEntry(threadId, exception);
                    if (st.hasMoreTokens() && (token = st.nextToken()).equals("returnTo:")) {
                        entry.setCallerInfo(this.parseCallerInfo(token, st, threadId));
                    }
                    this.queue.offer(entry);
                }
                return this.queue;
            }
            this.queue.offer(new MethodExitEntry(threadId));
            return this.queue;
        }
        LogEntry call = this.parseEntry(token, st, threadId);
        this.queue.offer(call);
        return this.queue;
    }

    private MethodCallEntry parseCallerInfo(String token, StringTokenizer st, int threadId) {
        assert (token.equals("returnTo:"));
        token = st.nextToken();
        if (token.equals("-1")) {
            return null;
        }
        assert (token.startsWith("@"));
        token = st.nextToken();
        LogEntry callerInfo = this.parseEntry(token, st, threadId);
        if (callerInfo instanceof MethodCallEntry) {
            return (MethodCallEntry)callerInfo;
        }
        return null;
    }

    private LogEntry parseEntry(String token, StringTokenizer st, int threadIndex) {
        String[] args;
        int methodCallCount = -1;
        try {
            methodCallCount = Integer.parseInt(token);
            token = st.nextToken();
        }
        catch (NumberFormatException e) {
            methodCallCount = ++this.globalMethodCallCount;
        }
        long callerLocation = -1L;
        if (token.startsWith("From:")) {
            try {
                String tmp = token;
                token = st.nextToken();
                callerLocation = Long.parseLong(tmp.substring(5));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        String returnType = token;
        if (!st.hasMoreTokens()) {
            return UnknownEntry.getInstance();
        }
        String fullClassName = st.nextToken();
        if (!st.hasMoreTokens()) {
            return UnknownEntry.getInstance();
        }
        int id = 0;
        try {
            id = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            return UnknownEntry.getInstance();
        }
        if (!st.hasMoreTokens()) {
            return UnknownEntry.getInstance();
        }
        String methodName = st.nextToken();
        if (methodName.length() > 0 && methodName.charAt(0) == '.') {
            methodName = methodName.substring(1, methodName.length());
        }
        if (st.hasMoreTokens()) {
            String argsString = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(argsString, ",");
            args = new String[st2.countTokens()];
            int i = 0;
            while (st2.hasMoreTokens()) {
                args[i] = st2.nextToken().intern();
                ++i;
            }
        } else {
            args = new String[]{};
        }
        JavaStaticDataAccessor accessor = JavaStaticDataAccessor.getInstance();
        JavaType retType = JavaTypeManager.getType(returnType);
        Type[] argsType = new JavaType[args.length];
        int i = 0;
        while (i < args.length) {
            argsType[i] = JavaTypeManager.getType(args[i]);
            ++i;
        }
        MethodCallEntry call = new MethodCallEntry(threadIndex, methodCallCount, ((StaticDataAccessor)accessor).makeMethodData(((StaticDataAccessor)accessor).makeClassData(fullClassName), methodName, retType, argsType, id == 0, JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.UNDECIDED)), id, callerLocation);
        return call;
    }
}

