/*
 * Decompiled with CFR 0.152.
 */
package amida.logloader;

import amida.calltree.CallTree;
import amida.calltree.CallTreeGroup;
import amida.calltree.CallTreeManager;
import amida.logloader.EntryType;
import amida.logloader.LogEntry;
import amida.logloader.LogIterator;
import amida.logloader.MethodCallEntry;
import amida.logloader.MethodExitByThrowExceptionEntry;
import amida.logloader.MethodExitEntry;
import amida.logloader.ThreadStartEntry;
import amida.staticdata.ClassData;
import amida.staticdata.MethodData;
import amida.staticdata.StaticDataAccessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LogLoader {
    private static final String CLINIT_STRING = "<clinit>";
    public static boolean LOAD_CLINIT = true;
    private static Map<Integer, Integer> inClinitMap = new HashMap<Integer, Integer>();

    public static CallTreeGroup load(LogIterator it) {
        return LogLoader.load(CallTreeManager.getInstance().makeCallTreeGroup(it), it);
    }

    private static CallTreeGroup load(CallTreeGroup group, LogIterator it) {
        HashSet<ThreadStartEntry> threadNames = new HashSet<ThreadStartEntry>();
        while (it.hasNext()) {
            int threadIndex;
            LogEntry entry = it.next();
            if (entry == null) continue;
            EntryType type = entry.getEntryType();
            if (type == EntryType.METHOD_CALL) {
                MethodCallEntry call = (MethodCallEntry)entry;
                threadIndex = call.getThreadIndex();
                MethodData method = call.getMethod();
                if (!LOAD_CLINIT) {
                    if (inClinitMap.containsKey(threadIndex) && (inClinitMap.get(threadIndex) > 0 || call.getMethodName().equals(CLINIT_STRING))) {
                        inClinitMap.put(threadIndex, inClinitMap.get(threadIndex) + 1);
                        continue;
                    }
                    if (call.getMethodName().equals(CLINIT_STRING)) {
                        inClinitMap.put(threadIndex, 1);
                        continue;
                    }
                }
                CallTree tree = LogLoader.getCallTree(group, threadIndex);
                if (call.getMethodCallCount() == -1) {
                    tree.methodCall(method, call.getObjectId());
                    continue;
                }
                tree.methodCall(method, call.getObjectId(), call.getMethodCallCount());
                continue;
            }
            if (type == EntryType.METHOD_EXIT) {
                MethodExitEntry exit = (MethodExitEntry)entry;
                threadIndex = exit.getThreadIndex();
                if (!LOAD_CLINIT && inClinitMap.containsKey(threadIndex) && inClinitMap.get(threadIndex) > 0) {
                    inClinitMap.put(threadIndex, inClinitMap.get(threadIndex) - 1);
                    continue;
                }
                CallTree tree = LogLoader.getCallTree(group, threadIndex);
                tree.methodExit(exit.getCaller());
                continue;
            }
            if (type == EntryType.METHOD_EXIT_BY_EXCEPTION) {
                MethodExitByThrowExceptionEntry exception = (MethodExitByThrowExceptionEntry)entry;
                threadIndex = exception.getThreadIndex();
                StaticDataAccessor accessor = StaticDataAccessor.getLanguageAccessor(it.getLanguageType());
                ClassData exceptionClass = accessor.makeClassData(exception.getExceptionName());
                CallTree tree = LogLoader.getCallTree(group, threadIndex);
                tree.methodExitWithException(exception.getCaller(), exceptionClass);
                continue;
            }
            if (type != EntryType.THREAD_START) continue;
            ThreadStartEntry start = (ThreadStartEntry)entry;
            threadNames.add(start);
        }
        for (ThreadStartEntry th : threadNames) {
            CallTree tree = CallTreeManager.getInstance().getCallTree(group, new Integer(th.getIndex()));
            if (tree == null) continue;
            tree.setName(th.getName());
        }
        return group;
    }

    private static CallTree getCallTree(CallTreeGroup group, int threadIndex) {
        CallTree tree = CallTreeManager.getInstance().getCallTree(group, new Integer(threadIndex));
        if (tree == null) {
            tree = CallTreeManager.getInstance().makeCallTree(group, new Integer(threadIndex));
        }
        return tree;
    }
}

