/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import amida.logmanager.AmidaProperty;
import amida.logmanager.CommandBuilder;
import amida.logmanager.LogFileName;
import amida.logmanager.Logger;
import amida.viewer.ViewerWindow;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.widgets.Shell;

public class AmidaLauncher {
    public static boolean open(Shell shell, LogFileName filename) {
        if (AmidaProperty.getInstance().useExternalViewer()) {
            return AmidaLauncher.openExternalProcess(filename);
        }
        return AmidaLauncher.openInternalViewer(shell, filename);
    }

    public static boolean openInternalViewer(Shell shell, LogFileName filename) {
        ViewerWindow.open(shell, filename);
        return true;
    }

    public static boolean openInternalViewerUsingReflection(LogFileName filename) {
        File f = new File(filename.getLogfile());
        if (f.canRead()) {
            boolean success = false;
            try {
                Class<?> klass = Class.forName(AmidaProperty.getInstance().getAmidaClassname());
                Method m = klass.getMethod("main", String[].class);
                m.invoke(null, new Object[]{new String[]{"-inprocess", filename.toAmidaViewerString()}});
                success = true;
            }
            catch (SecurityException securityException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (!success) {
                Logger.getInstance().println("Failed to open Amida: cannot access to " + AmidaProperty.getInstance().getAmidaClassname());
            }
            return success;
        }
        Logger.getInstance().println("Failed to open Amida: " + filename);
        return false;
    }

    public static boolean openExternalProcess(LogFileName filename) {
        block3: {
            try {
                File f = new File(filename.getLogfile());
                if (!f.canRead()) break block3;
                CommandBuilder cmd = new CommandBuilder();
                cmd.append(AmidaProperty.getInstance().getJavaCommand());
                cmd.append(AmidaProperty.getInstance().getExternalViewerJVMArgs());
                cmd.append("-classpath");
                cmd.append(AmidaProperty.getInstance().getAmidaViewerPath());
                cmd.append(AmidaProperty.getInstance().getAmidaClassname());
                cmd.append(filename.toAmidaViewerString());
                String command = cmd.toString();
                Runtime.getRuntime().exec(command);
                Logger.getInstance().println("Launching Sequence Diagram View: " + command);
                return true;
            }
            catch (IOException ex) {
                StringBuilder errmsg = new StringBuilder();
                errmsg.append("Failed to open Amida: " + filename);
                Logger.getInstance().println(errmsg.toString());
                return false;
            }
        }
        Logger.getInstance().println("Log File Not Found: " + filename);
        return false;
    }
}

