/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import amida.logmanager.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class AmidaProperty {
    private static final String KEY_AMIDA_EXTERNAL_VIEWER = "amida.viewer.external";
    private static final String DEFAULT_AMIDA_EXTERNAL_VIEWER = "false";
    private static final String KEY_AMIDA_PATH = "amida.viewer.path";
    private static final String DEFAULT_AMIDA_PATH = new File("..\\amida-viewer\\bin").getAbsolutePath();
    private static final String KEY_AMIDA_CLASSNAME = "amida.viewer.main";
    private static final String DEFAULT_AMIDA_CLASSNAME = "amida.Main";
    private static final String KEY_JAVA_COMMAND = "jvm";
    private static final String DEFAULT_JAVA_COMMAND = "java";
    private static final String KEY_EXTERNAL_VIEWER_JVM_ARGS = "amida.viewer.vmargs";
    private static final String DEFAULT_EXTERNAL_VIEWER_JVM_ARGS = "-Xmx500M";
    private static final String KEY_SCRIPT_DIR = "amida.script.dir";
    private static final String DEFAULT_SCRIPT_DIR = new File(".").getAbsoluteFile().getParent();
    private static final String KEY_SCRIPT_PHASEDETECTION = "amida.script.phasedetection";
    private static final String DEFAULT_SCRIPT_PHASEDETECTION = "log2phasecvs.pl";
    private static final String KEY_SCRIPT_COMMAND = "amida.script.command";
    private static final String DEFAULT_SCRIPT_COMMAND = "perl";
    private static final String KEY_LOGFILE_DIRECTORY = "amida.log.dir";
    private static final String DEFAULT_LOGFILE_DIRECTORY = new File(".").getAbsoluteFile().getParent();
    private static final String KEY_LOGFILE_DEFAULTNAME = "amida.log.default";
    private static final String DEFAULT_LOGFILE_DEFAULTNAME = "test.log";
    private static final String KEY_PHASE_METHOD_COUNT_SUMMARY = "amida.phase.count.summary";
    private static final int DEFAULT_PHASE_METHOD_COUNT_SUMMARY = 5;
    private static final String KEY_PHASE_METHOD_COUNT_TOOLTIP = "amida.phase.count.tooltip";
    private static final int DEFAULT_PHASE_METHOD_COUNT_TOOLTIP = 3;
    private static final String KEY_PHASE_DETECTION_OPTION_PREFIX = "amida.phase.param.";
    private static final String[] KEY_PHASE_DETECTION_OPTION_PARAMS = new String[]{"cache", "window", "threshold", "scope"};
    private static final String[] KEY_PHASE_DETECTION_OPTION_SUFFIX = new String[]{".caption", ".from", ".to", ".step"};
    private static final String[][] DEFAULT_PAHSE_DETECTION_OPTION = new String[][]{{"Cache Size", "50", "200", "50"}, {"Window Size", "50", "300", "50"}, {"Threshold", "0.1", "0.1", "0.1"}, {"Scope Size", "700", "700", "100"}};
    private static AmidaProperty theInstance;
    private Properties prop = null;

    public static AmidaProperty getInstance() {
        if (theInstance == null) {
            theInstance = new AmidaProperty();
        }
        return theInstance;
    }

    private AmidaProperty() {
        File f = new File("amida.properties");
        try {
            this.prop = new Properties();
            FileInputStream stream = new FileInputStream(f);
            this.prop.load(stream);
            stream.close();
        }
        catch (IOException e) {
            Logger.getInstance().println(String.valueOf(f.getAbsolutePath()) + " not found.  Use default values.");
            this.prop = null;
        }
    }

    private String getValue(String key, String defaultValue) {
        String value = null;
        if (this.prop != null) {
            value = this.prop.getProperty(key);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public boolean useExternalViewer() {
        return Boolean.parseBoolean(this.getValue(KEY_AMIDA_EXTERNAL_VIEWER, DEFAULT_AMIDA_EXTERNAL_VIEWER));
    }

    public String getAmidaViewerPath() {
        return this.getValue(KEY_AMIDA_PATH, DEFAULT_AMIDA_PATH);
    }

    public String getJavaCommand() {
        return this.getValue(KEY_JAVA_COMMAND, DEFAULT_JAVA_COMMAND);
    }

    public String getExternalViewerJVMArgs() {
        return this.getValue(KEY_EXTERNAL_VIEWER_JVM_ARGS, DEFAULT_EXTERNAL_VIEWER_JVM_ARGS);
    }

    public String getAmidaClassname() {
        return this.getValue(KEY_AMIDA_CLASSNAME, DEFAULT_AMIDA_CLASSNAME);
    }

    public String getScriptCommand() {
        return this.getValue(KEY_SCRIPT_COMMAND, DEFAULT_SCRIPT_COMMAND);
    }

    public String getPhaseDetectionScriptName() {
        return this.getValue(KEY_SCRIPT_PHASEDETECTION, DEFAULT_SCRIPT_PHASEDETECTION);
    }

    public String getScriptDir() {
        return this.getValue(KEY_SCRIPT_DIR, DEFAULT_SCRIPT_DIR);
    }

    public String getLogDir() {
        return this.getValue(KEY_LOGFILE_DIRECTORY, DEFAULT_LOGFILE_DIRECTORY);
    }

    public String getDefaultLogFilename() {
        return this.getValue(KEY_LOGFILE_DEFAULTNAME, DEFAULT_LOGFILE_DEFAULTNAME);
    }

    public int getPhaseMethodCountForSummaryWindow() {
        String s = this.getValue(KEY_PHASE_METHOD_COUNT_SUMMARY, new Integer(5).toString());
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }

    public int getPhaseMethodCountForTooltip() {
        String s = this.getValue(KEY_PHASE_METHOD_COUNT_TOOLTIP, new Integer(3).toString());
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 3;
        }
    }

    public String[] getPhaseDetectionParam(int param) {
        if (param >= 0 && param < KEY_PHASE_DETECTION_OPTION_PARAMS.length) {
            String[] defaultValue = DEFAULT_PAHSE_DETECTION_OPTION[param];
            String[] ret = new String[defaultValue.length];
            int i = 0;
            while (i < defaultValue.length) {
                String key = KEY_PHASE_DETECTION_OPTION_PREFIX + KEY_PHASE_DETECTION_OPTION_PARAMS[param] + KEY_PHASE_DETECTION_OPTION_SUFFIX[i];
                ret[i] = this.getValue(key, defaultValue[i]);
                ++i;
            }
            return ret;
        }
        throw new IllegalArgumentException("Invalid parameter for getPhaseDetectionParam: " + Integer.toString(param));
    }
}

