/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler;

import amida.profiler.ProfilerConfig;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AgentConfig
extends ProfilerConfig {
    public AgentConfig() {
        this.setProfilerPath("amida-agent.jar");
    }

    public AgentConfig(File configFile) throws IOException {
        super(configFile);
    }

    @Override
    public boolean saveAs(File configFile) {
        boolean b = super.saveAs(configFile);
        if (b) {
            return this.saveAsXML();
        }
        return false;
    }

    public boolean saveAsXML() {
        if (this.getConfigFile() == null) {
            return false;
        }
        File xmlConfig = new File(String.valueOf(this.getConfigFile().getAbsolutePath()) + ".xml");
        return this.saveAsXML(xmlConfig);
    }

    private boolean saveAsXML(File xmlConfigFile) {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document xml = builder.newDocument();
            Element rootNode = xml.createElement("DamidaSetting");
            xml.appendChild(rootNode);
            Element outputNode = xml.createElement("Output");
            Element outputStyleNode = xml.createElement("OutputStyle");
            outputStyleNode.setAttribute("type", "txt");
            outputStyleNode.setAttribute("serialize", "on");
            outputNode.appendChild(outputStyleNode);
            rootNode.appendChild(outputNode);
            Element permissionNode = xml.createElement("Permission");
            Element permissionPatternNode = xml.createElement("PermissionPattern");
            permissionPatternNode.setAttribute("log", "not");
            permissionNode.appendChild(permissionPatternNode);
            int i = 0;
            while (i < this.getPackageFilters().length) {
                Element packageNameNode = xml.createElement("Class");
                packageNameNode.setAttribute("name", this.getPackageFilters()[i]);
                permissionPatternNode.appendChild(packageNameNode);
                ++i;
            }
            Element constructors = xml.createElement("ConstructorCallee");
            constructors.setAttribute("log", "cancel");
            constructors.setAttribute("name", "*");
            permissionPatternNode.appendChild(constructors);
            Element methods = xml.createElement("MethodCallee");
            methods.setAttribute("log", "cancel");
            methods.setAttribute("name", "*");
            permissionPatternNode.appendChild(methods);
            Element fieldReads = xml.createElement("FieldReader");
            fieldReads.setAttribute("log", "cancel");
            fieldReads.setAttribute("name", "*");
            permissionPatternNode.appendChild(fieldReads);
            Element fieldWrites = xml.createElement("FieldWriter");
            fieldWrites.setAttribute("log", "cancel");
            fieldWrites.setAttribute("name", "*");
            permissionPatternNode.appendChild(fieldWrites);
            rootNode.appendChild(permissionNode);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            tfactory.setAttribute("indent-number", 4);
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            FileOutputStream outfile = new FileOutputStream(xmlConfigFile);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outfile, System.getProperty("file.encoding")));
            transformer.transform(new DOMSource(xml), new StreamResult(writer));
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String toCommandLine() {
        if (this.getConfigFile() == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getJavaCommand());
        builder.append(" ");
        if (this.getClassPath().length > 0) {
            builder.append("-classpath ");
            int i = 0;
            while (i < this.getClassPath().length) {
                if (i > 0) {
                    builder.append(File.pathSeparator);
                }
                builder.append(this.quote(this.getClassPath()[i]));
                ++i;
            }
            builder.append(" ");
        }
        builder.append(this.getJvmArgs());
        builder.append(" ");
        builder.append("-Xbootclasspath/a:");
        builder.append(this.getBytecodeLibraryPath());
        builder.append(" ");
        builder.append("-javaagent:");
        builder.append(this.getProfilerPath());
        builder.append("=");
        builder.append(String.valueOf(this.getConfigFile().getAbsolutePath()) + ".xml");
        builder.append(",");
        builder.append(String.valueOf(this.getLogfileDirectory()) + File.separator);
        builder.append(",");
        builder.append("amida");
        builder.append(" ");
        builder.append("-Xdebug -Djava.compiler=NONE");
        builder.append(" ");
        builder.append(this.getMainClass());
        builder.append(" ");
        builder.append(this.getProgramArgs());
        return builder.toString();
    }

    public String getBytecodeLibraryPath() {
        File f = new File(new File(this.getProfilerPath()).getParent(), "javassist.jar");
        return f.getAbsolutePath();
    }
}

