/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler.gui;

import amida.profiler.gui.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class MethodTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6164616682203534666L;
    private List<Method> methods = new ArrayList<Method>();

    protected MethodTableModel() {
    }

    protected MethodTableModel(List<Method> methods) {
        this.methods.addAll(methods);
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    @Override
    public int getRowCount() {
        return this.methods.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Package";
        }
        if (column == 1) {
            return "Class";
        }
        if (column == 2) {
            return "Method";
        }
        return null;
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        if (arg0 < 0 || arg0 >= this.methods.size() || arg1 < 0 || arg1 > 2) {
            return null;
        }
        if (arg1 == 0) {
            return this.methods.get(arg0).getPackageName();
        }
        if (arg1 == 1) {
            return this.methods.get(arg0).getClassName();
        }
        if (arg1 == 2) {
            return this.methods.get(arg0).getMethodName();
        }
        return null;
    }

    public void add(Method method) {
        this.methods.add(method);
        this.fireTableDataChanged();
    }

    public void delete(int index) {
        if (index >= 0 && index < this.methods.size()) {
            this.methods.remove(index);
            this.fireTableDataChanged();
        }
    }

    public void set(int index, Method method) {
        if (index >= 0 && index < this.methods.size()) {
            this.methods.set(index, method);
            this.fireTableDataChanged();
        }
    }

    public int size() {
        return this.methods.size();
    }

    public List<Method> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public Method getMethod(int index) {
        return this.methods.get(index);
    }
}

