/*
 * Decompiled with CFR 0.152.
 */
package amida.staticdata.java.data;

import amida.staticdata.AccessModifier;
import amida.staticdata.ClassData;
import amida.staticdata.MethodData;
import amida.staticdata.Type;
import amida.staticdata.java.data.JavaAccessModifier;
import amida.staticdata.java.data.JavaClassOrInterface;
import amida.staticdata.java.data.JavaPackage;
import amida.staticdata.java.data.JavaType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaMethod
implements MethodData {
    public static final String CLASS_INIT_NAME = "<clinit>";
    public static final String CONSTRUCTOR_NAME = "<init>";
    private static final Map<JavaClassOrInterface, Map<String, List<JavaMethod>>> cois = new HashMap<JavaClassOrInterface, Map<String, List<JavaMethod>>>();
    private final String name;
    private final JavaClassOrInterface coi;
    private final JavaType[] args;
    private final JavaType returnType;
    private final String signatureString;
    private final String simpleSignatureString;
    private final boolean isConstructor;
    private final boolean isClassInit;
    private boolean isAbstruct = false;
    private AccessModifier accssModifier = JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.UNDECIDED);
    private final Set<MethodData> overWrideMethods = new HashSet<MethodData>();
    private final Set<MethodData> overWriders = new HashSet<MethodData>();

    private JavaMethod(JavaClassOrInterface coi, JavaType returnType, String name, JavaType[] args, boolean isStatic, JavaAccessModifier modifier) {
        this.name = name.intern();
        this.coi = coi;
        this.returnType = returnType;
        this.args = args;
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(returnType.getTypeName());
        buffer.append(' ');
        buffer.append(coi.getTypeName());
        buffer.append('.');
        buffer.append(name);
        buffer.append('(');
        int i = 0;
        while (i < args.length) {
            buffer.append(this.args[i].getTypeName());
            buffer.append(',');
            ++i;
        }
        if (args.length > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append(')');
        this.signatureString = buffer.toString().intern();
        this.isConstructor = coi.getName().equals(name) || name.equals(CONSTRUCTOR_NAME);
        this.isClassInit = name.equals(CLASS_INIT_NAME);
        this.simpleSignatureString = this.makeSimpleSignature(this.returnType, this.args);
        coi.addMethod(this);
    }

    private String makeSimpleSignature(JavaType returnType, JavaType[] args) {
        StringBuffer buffer = new StringBuffer("(");
        JavaType[] javaTypeArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            JavaType type = javaTypeArray[n2];
            buffer.append(type.getSimpleJavaTypeName());
            ++n2;
        }
        buffer.append(")");
        buffer.append(returnType.getSimpleJavaTypeName());
        return buffer.toString().intern();
    }

    protected void resolveOverWride(Collection<JavaClassOrInterface> superClasses, Set<JavaClassOrInterface> checked) {
        if (this.isConstructor || this.isClassInit) {
            return;
        }
        for (JavaClassOrInterface tmp : superClasses) {
            this.resolveOverWride(tmp, checked);
        }
    }

    protected void resolveOverWride(ClassData superClass, Set<JavaClassOrInterface> checked) {
        if (this.isConstructor || this.isClassInit) {
            return;
        }
        if (checked.contains(superClass)) {
            return;
        }
        JavaClassOrInterface coi = (JavaClassOrInterface)superClass;
        checked.add(coi);
        String name = this.getName();
        String signature = this.getSignature();
        Collection<JavaMethod> superMethods = superClass.getMethods();
        boolean finded = false;
        for (MethodData methodData : superMethods) {
            if (!name.equals(methodData.getName()) || !signature.equals(methodData.getSignature())) continue;
            this.addOverWrideMethod(methodData);
            finded = true;
            break;
        }
        if (!finded) {
            if (coi.hasSuperClasses()) {
                this.resolveOverWride(coi.getSuperClasses(), checked);
            }
            if (coi.hasImplementInterfaces()) {
                this.resolveOverWride(coi.getImplementInterfaces(), checked);
            }
            if (coi.hasSuperInterfaces()) {
                this.resolveOverWride(coi.getSuperInterfaces(), checked);
            }
        }
    }

    public void resolveOverWride() {
        if (this.isConstructor || this.isClassInit) {
            return;
        }
        HashSet<JavaClassOrInterface> checked = new HashSet<JavaClassOrInterface>();
        if (this.coi.hasSuperClasses()) {
            this.resolveOverWride(this.coi.getSuperClasses(), checked);
        }
        if (this.coi.hasImplementInterfaces()) {
            this.resolveOverWride(this.coi.getImplementInterfaces(), checked);
        }
        if (this.coi.hasSuperInterfaces()) {
            this.resolveOverWride(this.coi.getSuperInterfaces(), checked);
        }
    }

    public static JavaMethod getMethod(JavaClassOrInterface coi, String methodName, JavaType[] args) {
        Map<String, List<JavaMethod>> methods;
        if (cois.containsKey(coi) && (methods = cois.get(coi)).containsKey(methodName)) {
            List<JavaMethod> methodList = methods.get(methodName);
            for (JavaMethod method : methodList) {
                Type[] args2 = method.getArgmentTypes();
                if (args.length != args2.length) continue;
                boolean match = true;
                int i = 0;
                while (i < args.length) {
                    if (args[i] != args2[i]) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (!match) continue;
                return method;
            }
        }
        return null;
    }

    public static boolean hasMethod(JavaClassOrInterface coi, String methodName, JavaType[] args) {
        Map<String, List<JavaMethod>> methods;
        if (cois.containsKey(coi) && (methods = cois.get(coi)).containsKey(methodName)) {
            List<JavaMethod> methodList = methods.get(methodName);
            for (JavaMethod method : methodList) {
                Type[] args2 = method.getArgmentTypes();
                if (args.length != args2.length) continue;
                boolean match = true;
                int i = 0;
                while (i < args.length) {
                    if (args[i] != args2[i]) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    public static JavaMethod makeMethod(JavaClassOrInterface coi, JavaType returnType, String methodName, JavaType[] args, boolean isStatic, JavaAccessModifier modifier) {
        if (cois.containsKey(coi)) {
            Map<String, List<JavaMethod>> methods = cois.get(coi);
            if (methods.containsKey(methodName)) {
                JavaMethod method2;
                List<JavaMethod> methodList = methods.get(methodName);
                for (JavaMethod method2 : methodList) {
                    Type[] args2 = method2.getArgmentTypes();
                    if (args.length != args2.length) continue;
                    boolean match = true;
                    int i = 0;
                    while (i < args.length) {
                        if (args[i] != args2[i]) {
                            match = false;
                            break;
                        }
                        ++i;
                    }
                    if (!match) continue;
                    return method2;
                }
                method2 = new JavaMethod(coi, returnType, methodName, args, isStatic, modifier);
                methodList.add(method2);
                return method2;
            }
            LinkedList<JavaMethod> newList = new LinkedList<JavaMethod>();
            methods.put(methodName, newList);
            JavaMethod method = new JavaMethod(coi, returnType, methodName, args, isStatic, modifier);
            newList.add(method);
            return method;
        }
        HashMap methods = new HashMap();
        cois.put(coi, methods);
        LinkedList<JavaMethod> newList = new LinkedList<JavaMethod>();
        methods.put(methodName, newList);
        JavaMethod method = new JavaMethod(coi, returnType, methodName, args, isStatic, modifier);
        newList.add(method);
        return method;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.signatureString;
    }

    @Override
    public String getSignature() {
        return this.simpleSignatureString;
    }

    public JavaClassOrInterface getDefinedPlace() {
        return this.coi;
    }

    @Override
    public ClassData getBelongClass() {
        return this.coi;
    }

    @Override
    public Collection<MethodData> getOverWrideMethods() {
        return this.overWrideMethods;
    }

    public String getClassName() {
        return this.getDefinedPlace().getTypeName();
    }

    public JavaPackage getPackage() {
        return this.getDefinedPlace().getPackage();
    }

    public String getPackageName() {
        return this.getPackage().getName();
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Type[] getArgmentTypes() {
        return this.args;
    }

    @Override
    public int getArgmentNum() {
        return this.args.length;
    }

    @Override
    public boolean isConstructor() {
        return this.isConstructor;
    }

    public static int getMethodNum(JavaClassOrInterface coi) {
        int sum = 0;
        if (cois.containsKey(coi)) {
            Map<String, List<JavaMethod>> map = cois.get(coi);
            for (List<JavaMethod> list : map.values()) {
                sum += list.size();
            }
        }
        return sum;
    }

    public static int getAllMethodNum() {
        int sum = 0;
        for (JavaClassOrInterface jcoi : cois.keySet()) {
            sum += JavaMethod.getMethodNum(jcoi);
        }
        return sum;
    }

    public boolean equals(Object o) {
        if (o instanceof JavaMethod) {
            JavaMethod method = (JavaMethod)o;
            return method == this;
        }
        return super.equals(o);
    }

    @Override
    public void addOverWrideMethod(MethodData method) {
        if (!this.overWrideMethods.contains(method)) {
            this.overWrideMethods.add(method);
            method.addOverWrider(this);
        }
    }

    @Override
    public void addOverWrider(MethodData method) {
        if (!this.overWriders.contains(method)) {
            this.overWriders.add(method);
            method.addOverWrideMethod(this);
        }
    }

    @Override
    public boolean isAbstractMethod() {
        return this.isAbstruct;
    }

    public boolean isConcreatMethod() {
        return !this.isAbstruct;
    }

    public void setAbstractMethod(boolean isAbstruct) {
        this.isAbstruct = isAbstruct;
    }

    @Override
    public AccessModifier getAccessModifier() {
        return this.accssModifier;
    }

    public void setAccessModifier(JavaAccessModifier modifier) {
        this.accssModifier = modifier;
    }
}

