/*
 * Decompiled with CFR 0.152.
 */
package amida.staticdata.java.data;

import amida.staticdata.java.data.JavaType;

public class PrimitiveType
implements JavaType {
    public static final int INT = 0;
    public static final int LONG = 1;
    public static final int BOOLEAN = 2;
    public static final int SHORT = 3;
    public static final int BYTE = 4;
    public static final int DOUBLE = 5;
    public static final int CHAR = 6;
    public static final int FLOAT = 7;
    private static final String[] NAME = new String[]{"int", "long", "boolean", "short", "byte", "double", "char", "float"};
    private static final String[] SIMPLE_NAME = new String[]{"I", "J", "Z", "S", "B", "D", "C", "F"};
    private static final PrimitiveType[] INSTANCES = new PrimitiveType[]{new PrimitiveType(0), new PrimitiveType(1), new PrimitiveType(2), new PrimitiveType(3), new PrimitiveType(4), new PrimitiveType(5), new PrimitiveType(6), new PrimitiveType(7)};
    private final int type;

    private PrimitiveType(int id) {
        this.type = id;
    }

    @Override
    public String getTypeName() {
        return NAME[this.type];
    }

    public String toString() {
        return this.getTypeName();
    }

    @Override
    public String getSimpleJavaTypeName() {
        return SIMPLE_NAME[this.type];
    }

    @Override
    public String getSimpleTypeName() {
        return NAME[this.type];
    }

    public int getType() {
        return this.type;
    }

    public static PrimitiveType getInstance(String name) {
        int i = 0;
        while (!NAME[i].equals(name) && ++i < NAME.length) {
        }
        if (i < NAME.length) {
            return INSTANCES[i];
        }
        return null;
    }

    public static PrimitiveType getInstance(int index) {
        if (index >= 0 && index < 8) {
            return INSTANCES[index];
        }
        return null;
    }
}

