/*
 * Decompiled with CFR 0.152.
 */
package amida.utility;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class ClickableTextField
extends JTextField {
    private static final long serialVersionUID = -4190812747653411979L;

    public ClickableTextField() {
        this.construct();
    }

    public ClickableTextField(int size) {
        super(size);
        this.construct();
    }

    public ClickableTextField(String text) {
        super(text);
        this.construct();
    }

    public ClickableTextField(String text, int size) {
        super(text, size);
        this.construct();
    }

    private void construct() {
        final JPopupMenu menu = new JPopupMenu();
        final JMenuItem copy = new JMenuItem("copy");
        final JMenuItem cut = new JMenuItem("cut");
        JMenuItem paste = new JMenuItem("paste");
        menu.add(copy);
        menu.add(cut);
        menu.add(paste);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getButton() == 3) {
                    String text = ClickableTextField.this.getSelectedText();
                    if (text != null) {
                        copy.setEnabled(true);
                        cut.setEnabled(true);
                    } else {
                        copy.setEnabled(false);
                        cut.setEnabled(false);
                    }
                    menu.show(ClickableTextField.this, arg0.getX(), arg0.getY());
                }
            }
        });
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ClickableTextField.this.copy();
            }
        });
        cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ClickableTextField.this.cut();
            }
        });
        paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ClickableTextField.this.paste();
            }
        });
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            this.setBackground(Color.WHITE);
        } else {
            this.setBackground(Color.GRAY);
        }
    }
}

