/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer;

import amida.viewer.SearchListener;
import java.util.LinkedList;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SearchDialog {
    private Shell parent;
    private Shell shell;
    private static final int SEARCH_OBJECT = 0;
    private static final int SEARCH_METHOD = 1;
    private static final int SEARCH_RETURN = 2;
    private SearchListener listener;
    private String searchString;
    private LinkedList<String> searchList;
    private Combo searchCombo;
    private int searchTarget;
    private boolean useRegex;

    public SearchDialog(Shell parent) {
        this.parent = parent;
        this.searchString = "";
        this.searchList = new LinkedList();
        this.searchTarget = 0;
        this.useRegex = false;
    }

    public void open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = new Shell(this.parent, 16480);
            this.constructWindow();
        }
        this.shell.open();
    }

    public void setSearchListener(SearchListener listener) {
        this.listener = listener;
    }

    private void constructWindow() {
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setText("Search");
        Composite searchDialogComposite = new Composite((Composite)this.shell, 0);
        searchDialogComposite.setLayout((Layout)new GridLayout(1, false));
        Composite searchStringComposite = new Composite(searchDialogComposite, 0);
        Composite searchForComposite = new Composite(searchDialogComposite, 0);
        Composite searchButtonComposite = new Composite(searchDialogComposite, 0);
        searchStringComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        searchForComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        searchButtonComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.constructSearchString(searchStringComposite);
        this.constructSearchFor(searchForComposite);
        this.constructSearchButton(searchButtonComposite);
        this.shell.pack();
    }

    private void constructSearchString(Composite searchStringComposite) {
        searchStringComposite.setLayout((Layout)new GridLayout(2, false));
        Label searchStringLabel = new Label(searchStringComposite, 0);
        searchStringLabel.setText("Search String");
        searchStringLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        Label dummy = new Label(searchStringComposite, 0);
        dummy.setLayoutData((Object)new GridData(4, 4, false, true));
        this.searchCombo = new Combo(searchStringComposite, 4);
        this.searchCombo.setText(this.searchString);
        this.searchCombo.setItems(this.searchList.toArray(new String[0]));
        this.searchCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.searchCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchDialog.this.searchString = SearchDialog.this.searchCombo.getText();
            }
        });
        this.searchCombo.addKeyListener((KeyListener)new ButtonShortcutKey());
        final Button buttonUseRegex = new Button(searchStringComposite, 32);
        buttonUseRegex.setText("Use Regex");
        buttonUseRegex.setLayoutData((Object)new GridData(4, 4, false, true));
        buttonUseRegex.setSelection(this.useRegex);
        buttonUseRegex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.useRegex = buttonUseRegex.getSelection();
            }
        });
        buttonUseRegex.addKeyListener((KeyListener)new ButtonShortcutKey());
    }

    private void constructSearchFor(Composite searchForComposite) {
        searchForComposite.setLayout((Layout)new FillLayout());
        Group searchForGroup = new Group(searchForComposite, 0);
        searchForGroup.setText("Search For");
        searchForGroup.setLayout((Layout)new GridLayout(1, false));
        Button searchObject = new Button((Composite)searchForGroup, 16);
        searchObject.setText("Objects");
        searchObject.setLayoutData((Object)new GridData());
        searchObject.addSelectionListener((SelectionListener)new SearchTargetSelectionListener(0));
        Button searchCall = new Button((Composite)searchForGroup, 16);
        searchCall.setText("Method Calls");
        searchCall.setLayoutData((Object)new GridData());
        searchCall.addSelectionListener((SelectionListener)new SearchTargetSelectionListener(1));
        Button searchReturn = new Button((Composite)searchForGroup, 16);
        searchReturn.setText("Return Type/Exception");
        searchReturn.setLayoutData((Object)new GridData());
        searchReturn.addSelectionListener((SelectionListener)new SearchTargetSelectionListener(2));
        switch (this.searchTarget) {
            case 1: {
                searchCall.setSelection(true);
                break;
            }
            case 2: {
                searchReturn.setSelection(true);
                break;
            }
            default: {
                searchObject.setSelection(true);
            }
        }
        searchCall.addKeyListener((KeyListener)new ButtonShortcutKey());
        searchReturn.addKeyListener((KeyListener)new ButtonShortcutKey());
        searchObject.addKeyListener((KeyListener)new ButtonShortcutKey());
    }

    private void constructSearchButton(Composite searchButtonComposite) {
        searchButtonComposite.setLayout((Layout)new GridLayout(2, true));
        Button buttonSearchForward = new Button(searchButtonComposite, 8);
        buttonSearchForward.setText("Search Forward (F3)");
        buttonSearchForward.setLayoutData((Object)new GridData(4, 4, true, true));
        buttonSearchForward.addSelectionListener((SelectionListener)new SearchButtonSelectionListener(true));
        buttonSearchForward.addKeyListener((KeyListener)new ButtonShortcutKey());
        this.shell.setDefaultButton(buttonSearchForward);
        Button buttonSearchBackward = new Button(searchButtonComposite, 8);
        buttonSearchBackward.setText("Search Backward (SHIFT+F3)");
        buttonSearchBackward.setLayoutData((Object)new GridData(4, 4, true, true));
        buttonSearchBackward.addSelectionListener((SelectionListener)new SearchButtonSelectionListener(false));
        buttonSearchBackward.addKeyListener((KeyListener)new ButtonShortcutKey());
    }

    public void search(boolean forward) {
        if (this.shell == null || this.shell.isDisposed()) {
            return;
        }
        if (this.searchString.length() == 0) {
            return;
        }
        switch (this.searchTarget) {
            case 1: {
                this.listener.searchCall(this.searchString, this.useRegex, forward);
                break;
            }
            case 2: {
                this.listener.searchReturn(this.searchString, this.useRegex, forward);
                break;
            }
            default: {
                this.listener.searchObject(this.searchString, this.useRegex, forward);
            }
        }
    }

    private void searchFromButton(boolean forward) {
        if (this.searchString.length() == 0) {
            return;
        }
        this.searchList.remove(this.searchString);
        this.searchList.addFirst(this.searchString);
        this.searchCombo.add(this.searchString, 0);
        this.search(forward);
    }

    private class ButtonShortcutKey
    implements KeyListener {
        private ButtonShortcutKey() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x100000C) {
                SearchDialog.this.searchFromButton((e.stateMask & 0x20000) == 0);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class SearchButtonSelectionListener
    implements SelectionListener {
        private boolean forward;

        public SearchButtonSelectionListener(boolean forward) {
            this.forward = forward;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            SearchDialog.this.searchFromButton(this.forward);
        }
    }

    private class SearchTargetSelectionListener
    implements SelectionListener {
        private int target;

        public SearchTargetSelectionListener(int target) {
            this.target = target;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            SearchDialog.this.searchTarget = this.target;
        }
    }
}

