/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer.filter;

import amida.viewer.filter.FilterChangeListener;
import amida.viewer.filter.FilterManager;
import amida.viewer.filter.FilterSet;
import amida.viewer.filter.FilterTableEditHandler;
import amida.viewer.filter.MethodFilterTableEditHandler;
import amida.viewer.filter.ObjectFilterTableEditHandler;
import amida.viewer.filter.ObjectUnificationFilterTableEditHandler;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FilterDialog {
    private Shell shell;
    private FilterManager filterManager;
    private FilterChangeListener filterChangeListener;
    private ObjectFilterTableEditHandler objectFilterHandler;
    private ObjectUnificationFilterTableEditHandler unificationFilterHandler;
    private MethodFilterTableEditHandler methodFilterHandler;
    boolean filterChanged = false;
    int selectedIndex = 0;
    private static final String CAPTION_OBJECT_FILTER = "Filters to Hide/Delete Objects from a diagram";
    private static final String CAPTION_UNIFICATION_FILTER = "Filters to Replace Objects with an Representative Object";
    private static final String CAPTION_METHOD_FILTER = "Filters to Fold/Hide/Delete method calls in a diagram";

    public static void open(Shell parent, FilterManager filterManager, FilterChangeListener listener) {
        FilterDialog window = new FilterDialog(parent, filterManager, listener);
        window.shell.open();
    }

    private FilterDialog(Shell parent, FilterManager filterManager, FilterChangeListener listener) {
        this.shell = new Shell(parent, 66672);
        this.filterManager = filterManager;
        this.filterChangeListener = listener;
        this.constructWindow();
    }

    public void constructWindow() {
        this.shell.setText("Filter Configuration");
        this.shell.setLayout((Layout)new FillLayout());
        SashForm filtersListSplitter = new SashForm((Composite)this.shell, 256);
        Composite filterslistComposite = new Composite((Composite)filtersListSplitter, 0);
        filterslistComposite.setLayout((Layout)new GridLayout(1, false));
        Label labelList = new Label(filterslistComposite, 0);
        labelList.setText("Filters");
        labelList.setLayoutData((Object)new GridData(4, 4, true, false));
        List filtersList = new List(filterslistComposite, 2820);
        filtersList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.constructFiltersList(filtersList);
        TabFolder filtersTab = new TabFolder((Composite)filtersListSplitter, 0);
        TabItem objectFilterTab = new TabItem(filtersTab, 0);
        objectFilterTab.setText("Object Filters");
        Composite filterEditComposite = new Composite((Composite)filtersTab, 0);
        filterEditComposite.setLayout((Layout)new GridLayout(1, false));
        objectFilterTab.setControl((Control)filterEditComposite);
        TabItem methodFilterTab = new TabItem(filtersTab, 0);
        methodFilterTab.setText("Method Filters");
        Composite methodFilterComposite = new Composite((Composite)filtersTab, 0);
        methodFilterTab.setControl((Control)methodFilterComposite);
        SashForm filterTypeSplitter = new SashForm(filterEditComposite, 512);
        filterTypeSplitter.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite filterButtonComposite = new Composite(filterEditComposite, 0);
        filterButtonComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite objectFilterComposite = new Composite((Composite)filterTypeSplitter, 0);
        Composite unificationFilterComposite = new Composite((Composite)filterTypeSplitter, 0);
        this.objectFilterHandler = new ObjectFilterTableEditHandler(new RecordChange());
        this.createFilterEditTable(objectFilterComposite, CAPTION_OBJECT_FILTER, true, this.objectFilterHandler);
        this.unificationFilterHandler = new ObjectUnificationFilterTableEditHandler(new RecordChange());
        this.createFilterEditTable(unificationFilterComposite, CAPTION_UNIFICATION_FILTER, false, this.unificationFilterHandler);
        this.methodFilterHandler = new MethodFilterTableEditHandler(new RecordChange());
        this.createFilterEditTable(methodFilterComposite, CAPTION_METHOD_FILTER, true, this.methodFilterHandler);
        filterButtonComposite.setLayout((Layout)new GridLayout(3, true));
        Button buttonApply = new Button(filterButtonComposite, 8);
        buttonApply.setText("Apply");
        buttonApply.setLayoutData((Object)new GridData(4, 4, true, false));
        buttonApply.addSelectionListener((SelectionListener)new ApplyButtonHandler());
        Button buttonRevert = new Button(filterButtonComposite, 8);
        buttonRevert.setText("Revert");
        buttonRevert.setLayoutData((Object)new GridData(4, 4, true, false));
        buttonRevert.addSelectionListener((SelectionListener)new RevertButtonHandler());
        this.addDummy(filterButtonComposite);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ((Shell)e.getSource()).setFocus();
                if (FilterDialog.this.filterChanged && !FilterDialog.this.checkSave()) {
                    e.doit = false;
                }
            }
        });
        filtersListSplitter.setWeights(new int[]{1, 5});
        filterTypeSplitter.setWeights(new int[]{1, 1});
        this.shell.pack();
        filtersList.setSelection(0);
        this.loadFilterToTable(0);
    }

    private void constructFiltersList(final List list) {
        int i;
        if (this.filterManager.getLocalFilterCount() > 0) {
            i = 0;
            while (i < this.filterManager.getLocalFilterCount()) {
                list.add(this.filterManager.getLocalFilterName(i));
                ++i;
            }
            list.add("");
        }
        i = 0;
        while (i < this.filterManager.getGlobalFilterCount()) {
            list.add(this.filterManager.getGlobalFilterName(i));
            ++i;
        }
        list.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int itemIndex;
                int topIndex;
                if (FilterDialog.this.hasFilterSeparator() && (topIndex = list.getTopIndex()) <= (itemIndex = FilterDialog.this.filterManager.getLocalFilterCount())) {
                    int y = (itemIndex - topIndex) * list.getItemHeight() + list.getItemHeight() / 2;
                    e.gc.drawLine(0, y, list.getClientArea().width, y);
                }
            }
        });
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = list.getSelectionIndex();
                if (FilterDialog.this.selectedIndex != idx && FilterDialog.this.filterChanged && !FilterDialog.this.checkSave()) {
                    list.select(FilterDialog.this.selectedIndex);
                    return;
                }
                if (FilterDialog.this.isFilterSeparatorIndex(idx)) {
                    if (FilterDialog.this.selectedIndex < idx) {
                        list.select(idx + 1);
                        FilterDialog.this.selectedIndex = idx + 1;
                    } else {
                        list.select(idx - 1);
                        FilterDialog.this.selectedIndex = idx - 1;
                    }
                } else {
                    FilterDialog.this.selectedIndex = idx;
                }
                FilterDialog.this.loadFilterToTable(FilterDialog.this.selectedIndex);
                list.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                list.redraw();
            }
        });
        SelectionAdapter redrawer = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                list.redraw();
            }
        };
        list.getHorizontalBar().addSelectionListener((SelectionListener)redrawer);
        list.getVerticalBar().addSelectionListener((SelectionListener)redrawer);
        assert (list.getItemCount() > 0);
    }

    private FilterSet itemIndexToFilter(int itemIndex) {
        int localCount = this.filterManager.getLocalFilterCount();
        if (localCount == 0) {
            return this.filterManager.getGlobalFilterSet(itemIndex);
        }
        if (localCount > itemIndex) {
            return this.filterManager.getLocalFilter(itemIndex);
        }
        return this.filterManager.getGlobalFilterSet(itemIndex - localCount - 1);
    }

    private boolean hasFilterSeparator() {
        return this.filterManager.getLocalFilterCount() != 0;
    }

    private boolean isFilterSeparatorIndex(int itemIndex) {
        return this.hasFilterSeparator() && this.filterManager.getLocalFilterCount() == itemIndex;
    }

    private void createFilterEditTable(Composite parent, String caption, boolean createUpDown, final FilterTableEditHandler handler) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label captionLabel = new Label(parent, 0);
        captionLabel.setText(caption);
        captionLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addDummy(parent);
        final Table filterTable = new Table(parent, 34816);
        handler.setTable(filterTable);
        int i = 0;
        while (i < handler.getColumnCount()) {
            TableColumn col = new TableColumn(filterTable, 16384);
            col.setText(handler.getColumnHead(i));
            col.pack();
            ++i;
        }
        filterTable.setHeaderVisible(true);
        filterTable.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonForObjectFilter = new Composite(parent, 0);
        buttonForObjectFilter.setLayoutData((Object)new GridData(4, 4, false, true));
        RowLayout layout = new RowLayout(512);
        layout.fill = true;
        buttonForObjectFilter.setLayout((Layout)layout);
        Button buttonAdd = new Button(buttonForObjectFilter, 8);
        buttonAdd.setText("Add");
        buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                handler.add();
            }
        });
        Button buttonRemove = new Button(buttonForObjectFilter, 8);
        buttonRemove.setText("Remove");
        buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                handler.remove();
            }
        });
        if (createUpDown) {
            Button buttonUp = new Button(buttonForObjectFilter, 8);
            buttonUp.setText("Up");
            buttonUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    handler.up();
                }
            });
            Button buttonDown = new Button(buttonForObjectFilter, 8);
            buttonDown.setText("Down");
            buttonDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    handler.down();
                }
            });
        }
        final TableCursor cursor = new TableCursor(filterTable, 0);
        handler.setCursor(cursor);
        final ControlEditor editor = new ControlEditor((Composite)cursor);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                handler.edit(editor, cursor);
            }
        });
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                filterTable.setSelection(new TableItem[]{cursor.getRow()});
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                handler.edit(editor, cursor);
            }
        });
        filterTable.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = event.gc.getFontMetrics().getHeight() * 3 / 2;
            }
        });
    }

    private void addDummy(Composite parent) {
        Label dummy = new Label(parent, 0);
        dummy.setLayoutData((Object)new GridData());
    }

    public boolean checkSave() {
        MessageBox msg = new MessageBox(this.shell, 448);
        msg.setMessage("Filters have been changed.  Do you save the change?");
        msg.setText("Save Filters");
        int ret = msg.open();
        if (ret == 64) {
            this.saveTableToFilter(this.selectedIndex);
        } else if (ret == 256) {
            return false;
        }
        return true;
    }

    public void loadFilterToTable(int index) {
        FilterSet filter = this.itemIndexToFilter(index);
        this.objectFilterHandler.setFilters(filter.objectFilters());
        this.unificationFilterHandler.setFilters(filter.objectUnificationFilters());
        this.methodFilterHandler.setFilters(filter.methodFilters());
        this.filterChanged = false;
    }

    public void saveTableToFilter(int index) {
        FilterSet filter = this.itemIndexToFilter(index);
        filter.clear();
        this.objectFilterHandler.saveFilters(filter);
        this.unificationFilterHandler.saveFilters(filter);
        this.methodFilterHandler.saveFilters(filter);
        this.filterChanged = false;
        if (this.filterChangeListener != null) {
            this.filterChangeListener.changed();
        }
    }

    private class ApplyButtonHandler
    implements SelectionListener {
        private ApplyButtonHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            FilterDialog.this.saveTableToFilter(FilterDialog.this.selectedIndex);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            FilterDialog.this.saveTableToFilter(FilterDialog.this.selectedIndex);
        }
    }

    private class RecordChange
    implements FilterChangeListener {
        private RecordChange() {
        }

        @Override
        public void changed() {
            FilterDialog.this.filterChanged = true;
        }
    }

    private class RevertButtonHandler
    implements SelectionListener {
        private RevertButtonHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.revert();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.revert();
        }

        private void revert() {
            if (FilterDialog.this.filterChanged) {
                MessageBox msg = new MessageBox(FilterDialog.this.shell, 192);
                msg.setMessage("Filters have been changed.  Are you sure to discard changes?");
                msg.setText("Revert");
                int ret = msg.open();
                if (ret == 128) {
                    return;
                }
            }
            FilterDialog.this.loadFilterToTable(FilterDialog.this.selectedIndex);
        }
    }
}

