/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.DefaultContent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.MovementListener;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextDropTargetEffect;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextListener;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class StyledText
extends Canvas {
    static final char TAB = '\t';
    static final String PlatformLineDelimiter = System.getProperty("line.separator");
    static final int BIDI_CARET_WIDTH = 3;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int V_SCROLL_RATE = 50;
    static final int H_SCROLL_RATE = 10;
    static final int ExtendedModify = 3000;
    static final int LineGetBackground = 3001;
    static final int LineGetStyle = 3002;
    static final int TextChanging = 3003;
    static final int TextSet = 3004;
    static final int VerifyKey = 3005;
    static final int TextChanged = 3006;
    static final int LineGetSegments = 3007;
    static final int PaintObject = 3008;
    static final int WordNext = 3009;
    static final int WordPrevious = 3010;
    static final int PREVIOUS_OFFSET_TRAILING = 0;
    static final int OFFSET_LEADING = 1;
    Color selectionBackground;
    Color selectionForeground;
    StyledTextContent content;
    StyledTextRenderer renderer;
    Listener listener;
    TextChangeListener textChangeListener;
    int verticalScrollOffset = 0;
    int horizontalScrollOffset = 0;
    int topIndex = 0;
    int topIndexY;
    int clientAreaHeight = 0;
    int clientAreaWidth = 0;
    int tabLength = 4;
    int leftMargin;
    int topMargin;
    int rightMargin;
    int bottomMargin;
    int columnX;
    int caretOffset = 0;
    int caretAlignment;
    Point selection = new Point(0, 0);
    Point clipboardSelection;
    int selectionAnchor;
    Point doubleClickSelection;
    boolean editable = true;
    boolean wordWrap = false;
    boolean doubleClickEnabled = true;
    boolean overwrite = false;
    int textLimit = -1;
    Hashtable keyActionMap = new Hashtable();
    Color background = null;
    Color foreground = null;
    Clipboard clipboard;
    int clickCount;
    int autoScrollDirection = 0;
    int autoScrollDistance = 0;
    int lastTextChangeStart;
    int lastTextChangeNewLineCount;
    int lastTextChangeNewCharCount;
    int lastTextChangeReplaceLineCount;
    int lastTextChangeReplaceCharCount;
    int lastLineBottom;
    boolean isMirrored;
    boolean bidiColoring = false;
    Image leftCaretBitmap = null;
    Image rightCaretBitmap = null;
    int caretDirection = 0;
    Caret defaultCaret = null;
    boolean updateCaretDirection = true;
    boolean fixedLineHeight;
    boolean dragDetect = true;
    int alignment;
    boolean justify;
    int indent;
    int lineSpacing;
    static final boolean IS_CARBON;
    static final boolean IS_GTK;
    static final boolean IS_MOTIF;

    static {
        String string = SWT.getPlatform();
        IS_CARBON = "carbon".equals(string);
        IS_GTK = "gtk".equals(string);
        IS_MOTIF = "motif".equals(string);
    }

    public StyledText(Composite composite, int n) {
        super(composite, StyledText.checkStyle(n));
        super.setForeground(this.getForeground());
        super.setDragDetect(false);
        Display display = this.getDisplay();
        this.isMirrored = (super.getStyle() & 0x8000000) != 0;
        this.fixedLineHeight = true;
        if ((n & 8) != 0) {
            this.setEditable(false);
        }
        this.rightMargin = this.isBidiCaret() ? 2 : 0;
        this.leftMargin = this.rightMargin;
        if ((n & 4) != 0 && (n & 0x800) != 0) {
            this.bottomMargin = 2;
            this.rightMargin = 2;
            this.topMargin = 2;
            this.leftMargin = 2;
        }
        this.alignment = n & 0x1024000;
        if (this.alignment == 0) {
            this.alignment = 16384;
        }
        this.clipboard = new Clipboard(display);
        this.installDefaultContent();
        this.renderer = new StyledTextRenderer(this.getDisplay(), this);
        this.renderer.setContent(this.content);
        this.renderer.setFont(this.getFont(), this.tabLength);
        this.defaultCaret = new Caret(this, 0);
        if ((n & 0x40) != 0) {
            this.setWordWrap(true);
        }
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
            Runnable runnable = new Runnable(){

                public void run() {
                    int n;
                    int n2 = n = BidiUtil.getKeyboardLanguage() == 1 ? 131072 : 16384;
                    if (n == StyledText.this.caretDirection) {
                        return;
                    }
                    if (StyledText.this.getCaret() != StyledText.this.defaultCaret) {
                        return;
                    }
                    Point point = StyledText.this.getPointAtOffset(StyledText.this.caretOffset);
                    StyledText.this.setCaretLocation(point, n);
                }
            };
            BidiUtil.addLanguageListener(this.handle, runnable);
        }
        this.setCaret(this.defaultCaret);
        this.calculateScrollBars();
        this.createKeyBindings();
        this.setCursor(display.getSystemCursor(19));
        this.installListeners();
        this.initializeAccessible();
        this.setData("DEFAULT_DROP_TARGET_EFFECT", new StyledTextDropTargetEffect(this));
    }

    public void addExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        StyledTextListener styledTextListener = new StyledTextListener(extendedModifyListener);
        this.addListener(3000, styledTextListener);
    }

    public void addBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        this.addListener(3007, new StyledTextListener(bidiSegmentListener));
    }

    public void addLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        if (!this.isListening(3001)) {
            this.renderer.clearLineBackground(0, this.content.getLineCount());
        }
        this.addListener(3001, new StyledTextListener(lineBackgroundListener));
    }

    public void addLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        if (!this.isListening(3002)) {
            this.setStyleRanges(0, 0, null, null, true);
            this.renderer.clearLineStyle(0, this.content.getLineCount());
        }
        this.addListener(3002, new StyledTextListener(lineStyleListener));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.addListener(24, new TypedListener(modifyListener));
    }

    public void addPaintObjectListener(PaintObjectListener paintObjectListener) {
        this.checkWidget();
        if (paintObjectListener == null) {
            SWT.error(4);
        }
        this.addListener(3008, new StyledTextListener(paintObjectListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.addListener(13, new TypedListener(selectionListener));
    }

    public void addVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.checkWidget();
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        this.addListener(3005, new StyledTextListener(verifyKeyListener));
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.addListener(25, new TypedListener(verifyListener));
    }

    public void addWordMovementListener(MovementListener movementListener) {
        this.checkWidget();
        if (this.listener == null) {
            SWT.error(4);
        }
        this.addListener(3009, new StyledTextListener(movementListener));
        this.addListener(3010, new StyledTextListener(movementListener));
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n = Math.max(this.getCharCount(), 0);
        this.replaceTextRange(n, 0, string);
    }

    void calculateScrollBars() {
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        this.setScrollBars(true);
        if (scrollBar2 != null) {
            scrollBar2.setIncrement(this.getVerticalIncrement());
        }
        if (scrollBar != null) {
            scrollBar.setIncrement(this.getHorizontalIncrement());
        }
    }

    void calculateTopIndex(int n) {
        int n2 = this.topIndex;
        int n3 = this.topIndexY;
        if (this.isFixedLineHeight()) {
            int n4 = this.getVerticalIncrement();
            if (n4 == 0) {
                return;
            }
            this.topIndex = Compatibility.ceil(this.getVerticalScrollOffset(), n4);
            if (this.topIndex > 0) {
                if (this.clientAreaHeight > 0) {
                    int n5;
                    int n6 = this.getVerticalScrollOffset() + this.clientAreaHeight;
                    int n7 = n6 - (n5 = this.topIndex * n4);
                    if (n7 < n4) {
                        --this.topIndex;
                    }
                } else if (this.topIndex >= this.content.getLineCount()) {
                    this.topIndex = this.content.getLineCount() - 1;
                }
            }
        } else if (n >= 0) {
            n -= this.topIndexY;
            int n8 = this.topIndex;
            int n9 = this.content.getLineCount();
            while (n8 < n9) {
                if (n <= 0) break;
                n -= this.renderer.getLineHeight(n8++);
            }
            if (n8 < n9 && -n + this.renderer.getLineHeight(n8) <= this.clientAreaHeight - this.topMargin - this.bottomMargin) {
                this.topIndex = n8;
                this.topIndexY = -n;
            } else {
                this.topIndex = n8 - 1;
                this.topIndexY = -this.renderer.getLineHeight(this.topIndex) - n;
            }
        } else {
            n -= this.topIndexY;
            int n10 = this.topIndex;
            while (n10 > 0) {
                int n11 = this.renderer.getLineHeight(n10 - 1);
                if (n + n11 > 0) break;
                n += n11;
                --n10;
            }
            if (n10 == 0 || -n + this.renderer.getLineHeight(n10) <= this.clientAreaHeight - this.topMargin - this.bottomMargin) {
                this.topIndex = n10;
                this.topIndexY = -n;
            } else {
                this.topIndex = n10 - 1;
                this.topIndexY = -this.renderer.getLineHeight(this.topIndex) - n;
            }
        }
        if (this.topIndex != n2 || n3 != this.topIndexY) {
            this.renderer.calculateClientArea();
            this.setScrollBars(false);
        }
    }

    static int checkStyle(int n) {
        if ((n & 4) != 0) {
            n &= 0xFFFFFCBD;
        } else if (((n |= 2) & 0x40) != 0) {
            n &= 0xFFFFFEFF;
        }
        return n |= 0x20140000;
    }

    void claimBottomFreeSpace() {
        int n = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            int n3 = Math.max(0, this.content.getLineCount() * n2 - n);
            if (n3 < this.getVerticalScrollOffset()) {
                this.scrollVertical(n3 - this.getVerticalScrollOffset(), true);
            }
        } else {
            int n4 = this.getPartialBottomIndex();
            int n5 = this.getLinePixel(n4 + 1);
            if (n > n5) {
                this.scrollVertical(-this.getAvailableHeightAbove(n - n5), true);
            }
        }
    }

    void claimRightFreeSpace() {
        int n = Math.max(0, this.renderer.getWidth() - (this.clientAreaWidth - this.leftMargin - this.rightMargin));
        if (n < this.horizontalScrollOffset) {
            this.scrollHorizontal(n - this.horizontalScrollOffset, true);
        }
    }

    void clearSelection(boolean bl) {
        int n = this.selection.x;
        int n2 = this.selection.y;
        this.resetSelection();
        if (n2 - n > 0) {
            int n3 = this.content.getCharCount();
            int n4 = Math.min(n, n3);
            int n5 = Math.min(n2, n3);
            if (n5 - n4 > 0) {
                this.internalRedrawRange(n4, n5 - n4);
            }
            if (bl) {
                this.sendSelectionEvent();
            }
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        this.checkWidget();
        int n4 = (this.getStyle() & 4) != 0 ? 1 : this.content.getLineCount();
        int n5 = 0;
        int n6 = 0;
        if (n == -1 || n2 == -1) {
            Display display = this.getDisplay();
            n3 = display.getClientArea().height;
            int n7 = 0;
            while (n7 < n4) {
                TextLayout textLayout = this.renderer.getTextLayout(n7);
                if (this.wordWrap) {
                    textLayout.setWidth(n == 0 ? 1 : n);
                }
                Rectangle rectangle = textLayout.getBounds();
                n5 = Math.max(n5, rectangle.width);
                this.renderer.disposeTextLayout(textLayout);
                if (this.isFixedLineHeight() && (n6 += rectangle.height) > n3) break;
                ++n7;
            }
            if (this.isFixedLineHeight()) {
                n6 = n4 * this.renderer.getLineHeight();
            }
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n != -1) {
            n5 = n;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        int n8 = this.leftMargin + this.rightMargin + this.getCaretWidth();
        n3 = this.topMargin + this.bottomMargin;
        Rectangle rectangle = this.computeTrim(0, 0, n5 + n8, n6 + n3);
        return new Point(rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        this.copy(1);
    }

    public void copy(int n) {
        block4: {
            this.checkWidget();
            if (n != 1 && n != 2) {
                return;
            }
            int n2 = this.selection.y - this.selection.x;
            if (n2 > 0) {
                try {
                    this.setClipboardContent(this.selection.x, n2, n);
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 2002) break block4;
                    throw sWTError;
                }
            }
        }
    }

    public int getAlignment() {
        this.checkWidget();
        return this.alignment;
    }

    int getAvailableHeightAbove(int n) {
        int n2 = this.verticalScrollOffset;
        if (n2 == -1) {
            int n3 = this.topIndex - 1;
            n2 = -this.topIndexY;
            if (this.topIndexY > 0) {
                n2 += this.renderer.getLineHeight(n3--);
            }
            while (n > n2 && n3 >= 0) {
                n2 += this.renderer.getLineHeight(n3--);
            }
        }
        return Math.min(n, n2);
    }

    int getAvailableHeightBellow(int n) {
        int n2 = this.getPartialBottomIndex();
        int n3 = this.getLinePixel(n2);
        int n4 = this.renderer.getLineHeight(n2);
        int n5 = 0;
        int n6 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (n3 + n4 > n6) {
            n5 = n4 - (n6 - n3);
        }
        int n7 = n2 + 1;
        int n8 = this.content.getLineCount();
        while (n > n5 && n7 < n8) {
            n5 += this.renderer.getLineHeight(n7++);
        }
        return Math.min(n, n5);
    }

    String getModelDelimitedText(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(n);
        String string2 = this.getLineDelimiter();
        while (n4 < n) {
            if (n2 != -1) {
                n2 = string.indexOf(13, n4);
            }
            if (n3 != -1) {
                n3 = string.indexOf(10, n4);
            }
            if (n3 == -1 && n2 == -1) break;
            if (n2 < n3 && n2 != -1 || n3 == -1) {
                stringBuffer.append(string.substring(n4, n2));
                n4 = n3 == n2 + 1 ? n3 + 1 : n2 + 1;
            } else {
                stringBuffer.append(string.substring(n4, n3));
                n4 = n3 + 1;
            }
            if (this.isSingleLine()) break;
            stringBuffer.append(string2);
        }
        if (!(n4 >= n || this.isSingleLine() && stringBuffer.length() != 0)) {
            stringBuffer.append(string.substring(n4));
        }
        return stringBuffer.toString();
    }

    boolean checkDragDetect(Event event) {
        if (!this.isListening(29)) {
            return false;
        }
        if (IS_MOTIF ? event.button != 2 : event.button != 1) {
            return false;
        }
        if (this.selection.x == this.selection.y) {
            return false;
        }
        int n = this.getOffsetAtPoint(event.x, event.y);
        if (n > this.selection.x && n < this.selection.y) {
            return this.dragDetect(event);
        }
        return false;
    }

    void createKeyBindings() {
        int n = this.isMirrored() ? 0x1000003 : 0x1000004;
        int n2 = this.isMirrored() ? 0x1000004 : 0x1000003;
        this.setKeyBinding(0x1000001, 0x1000001);
        this.setKeyBinding(0x1000002, 0x1000002);
        if (IS_CARBON) {
            this.setKeyBinding(n2 | SWT.MOD1, 0x1000007);
            this.setKeyBinding(n | SWT.MOD1, 0x1000008);
            this.setKeyBinding(0x1000007, 17039367);
            this.setKeyBinding(0x1000008, 17039368);
            this.setKeyBinding(0x1000001 | SWT.MOD1, 17039367);
            this.setKeyBinding(0x1000002 | SWT.MOD1, 17039368);
            this.setKeyBinding(n | SWT.MOD3, 0x1040004);
            this.setKeyBinding(n2 | SWT.MOD3, 17039363);
        } else {
            this.setKeyBinding(0x1000007, 0x1000007);
            this.setKeyBinding(0x1000008, 0x1000008);
            this.setKeyBinding(0x1000007 | SWT.MOD1, 17039367);
            this.setKeyBinding(0x1000008 | SWT.MOD1, 17039368);
            this.setKeyBinding(n | SWT.MOD1, 0x1040004);
            this.setKeyBinding(n2 | SWT.MOD1, 17039363);
        }
        this.setKeyBinding(0x1000005, 0x1000005);
        this.setKeyBinding(0x1000006, 0x1000006);
        this.setKeyBinding(0x1000005 | SWT.MOD1, 17039365);
        this.setKeyBinding(0x1000006 | SWT.MOD1, 17039366);
        this.setKeyBinding(n, 0x1000004);
        this.setKeyBinding(n2, 0x1000003);
        this.setKeyBinding(0x1000001 | SWT.MOD2, 0x1020001);
        this.setKeyBinding(0x1000002 | SWT.MOD2, 0x1020002);
        if (IS_CARBON) {
            this.setKeyBinding(n2 | SWT.MOD1 | SWT.MOD2, 16908295);
            this.setKeyBinding(n | SWT.MOD1 | SWT.MOD2, 16908296);
            this.setKeyBinding(0x1000007 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000008 | SWT.MOD2, 17170440);
            this.setKeyBinding(0x1000001 | SWT.MOD1 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000002 | SWT.MOD1 | SWT.MOD2, 17170440);
            this.setKeyBinding(n | SWT.MOD2 | SWT.MOD3, 17170436);
            this.setKeyBinding(n2 | SWT.MOD2 | SWT.MOD3, 17170435);
        } else {
            this.setKeyBinding(0x1000007 | SWT.MOD2, 16908295);
            this.setKeyBinding(0x1000008 | SWT.MOD2, 16908296);
            this.setKeyBinding(0x1000007 | SWT.MOD1 | SWT.MOD2, 17170439);
            this.setKeyBinding(0x1000008 | SWT.MOD1 | SWT.MOD2, 17170440);
            this.setKeyBinding(n | SWT.MOD1 | SWT.MOD2, 17170436);
            this.setKeyBinding(n2 | SWT.MOD1 | SWT.MOD2, 17170435);
        }
        this.setKeyBinding(0x1000005 | SWT.MOD2, 16908293);
        this.setKeyBinding(0x1000006 | SWT.MOD2, 16908294);
        this.setKeyBinding(0x1000005 | SWT.MOD1 | SWT.MOD2, 17170437);
        this.setKeyBinding(0x1000006 | SWT.MOD1 | SWT.MOD2, 0x1060006);
        this.setKeyBinding(n | SWT.MOD2, 16908292);
        this.setKeyBinding(n2 | SWT.MOD2, 16908291);
        this.setKeyBinding(0x58 | SWT.MOD1, 131199);
        this.setKeyBinding(0x43 | SWT.MOD1, 17039369);
        this.setKeyBinding(0x56 | SWT.MOD1, 16908297);
        if (IS_CARBON) {
            this.setKeyBinding(0x7F | SWT.MOD2, 127);
            this.setKeyBinding(8 | SWT.MOD3, 262152);
            this.setKeyBinding(0x7F | SWT.MOD3, 262271);
        } else {
            this.setKeyBinding(0x7F | SWT.MOD2, 131199);
            this.setKeyBinding(0x1000009 | SWT.MOD1, 17039369);
            this.setKeyBinding(0x1000009 | SWT.MOD2, 16908297);
        }
        this.setKeyBinding(8 | SWT.MOD2, 8);
        this.setKeyBinding(8, 8);
        this.setKeyBinding(127, 127);
        this.setKeyBinding(8 | SWT.MOD1, 262152);
        this.setKeyBinding(0x7F | SWT.MOD1, 262271);
        this.setKeyBinding(0x1000009, 0x1000009);
    }

    void createCaretBitmaps() {
        int n = 3;
        Display display = this.getDisplay();
        if (this.leftCaretBitmap != null) {
            if (this.defaultCaret != null && this.leftCaretBitmap.equals(this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.leftCaretBitmap.dispose();
        }
        int n2 = this.renderer.getLineHeight();
        this.leftCaretBitmap = new Image((Device)display, n, n2);
        GC gC = new GC(this.leftCaretBitmap);
        gC.setBackground(display.getSystemColor(2));
        gC.fillRectangle(0, 0, n, n2);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(0, 0, 0, n2);
        gC.drawLine(0, 0, n - 1, 0);
        gC.drawLine(0, 1, 1, 1);
        gC.dispose();
        if (this.rightCaretBitmap != null) {
            if (this.defaultCaret != null && this.rightCaretBitmap.equals(this.defaultCaret.getImage())) {
                this.defaultCaret.setImage(null);
            }
            this.rightCaretBitmap.dispose();
        }
        this.rightCaretBitmap = new Image((Device)display, n, n2);
        gC = new GC(this.rightCaretBitmap);
        gC.setBackground(display.getSystemColor(2));
        gC.fillRectangle(0, 0, n, n2);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(n - 1, 0, n - 1, n2);
        gC.drawLine(0, 0, n - 1, 0);
        gC.drawLine(n - 1, 1, 1, 1);
        gC.dispose();
    }

    public void cut() {
        this.checkWidget();
        int n = this.selection.y - this.selection.x;
        if (n > 0) {
            try {
                this.setClipboardContent(this.selection.x, n, 1);
            }
            catch (SWTError sWTError) {
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                return;
            }
            this.doDelete();
        }
    }

    void doAutoScroll(Event event) {
        if (event.y > this.clientAreaHeight) {
            this.doAutoScroll(1024, event.y - this.clientAreaHeight);
        } else if (event.y < 0) {
            this.doAutoScroll(128, -event.y);
        } else if (event.x < this.leftMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000003, this.leftMargin - event.x);
        } else if (event.x > this.clientAreaWidth - this.leftMargin - this.rightMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000004, event.x - (this.clientAreaWidth - this.leftMargin - this.rightMargin));
        } else {
            this.endAutoScroll();
        }
    }

    void doAutoScroll(int n, int n2) {
        this.autoScrollDistance = n2;
        if (this.autoScrollDirection == n) {
            return;
        }
        Runnable runnable = null;
        final Display display = this.getDisplay();
        if (n == 128) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 128) {
                        StyledText.this.doSelectionPageUp(StyledText.this.autoScrollDistance);
                        display.timerExec(50, this);
                    }
                }
            };
            this.autoScrollDirection = n;
            display.timerExec(50, runnable);
        } else if (n == 1024) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 1024) {
                        StyledText.this.doSelectionPageDown(StyledText.this.autoScrollDistance);
                        display.timerExec(50, this);
                    }
                }
            };
            this.autoScrollDirection = n;
            display.timerExec(50, runnable);
        } else if (n == 0x1000004) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000004) {
                        StyledText.this.doVisualNext();
                        StyledText.this.setMouseWordSelectionAnchor();
                        StyledText.this.doMouseSelection();
                        display.timerExec(10, this);
                    }
                }
            };
            this.autoScrollDirection = n;
            display.timerExec(10, runnable);
        } else if (n == 0x1000003) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000003) {
                        StyledText.this.doVisualPrevious();
                        StyledText.this.setMouseWordSelectionAnchor();
                        StyledText.this.doMouseSelection();
                        display.timerExec(10, this);
                    }
                }
            };
            this.autoScrollDirection = n;
            display.timerExec(10, runnable);
        }
    }

    void doBackspace() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset > 0) {
            int n = this.content.getLineAtOffset(this.caretOffset);
            int n2 = this.content.getOffsetAtLine(n);
            if (this.caretOffset == n2) {
                n2 = this.content.getOffsetAtLine(n - 1);
                event.start = n2 + this.content.getLine(n - 1).length();
                event.end = this.caretOffset;
            } else {
                TextLayout textLayout = this.renderer.getTextLayout(n);
                int n3 = textLayout.getPreviousOffset(this.caretOffset - n2, 1);
                this.renderer.disposeTextLayout(textLayout);
                event.start = n3 + n2;
                event.end = this.caretOffset;
            }
            this.sendKeyEvent(event);
        }
    }

    void doContent(char c) {
        if (this.textLimit > 0 && this.content.getCharCount() - (this.selection.y - this.selection.x) >= this.textLimit) {
            return;
        }
        Event event = new Event();
        event.start = this.selection.x;
        event.end = this.selection.y;
        if (c == '\r' || c == '\n') {
            if (!this.isSingleLine()) {
                event.text = this.getLineDelimiter();
            }
        } else if (this.selection.x == this.selection.y && this.overwrite && c != '\t') {
            String string;
            int n = this.content.getLineAtOffset(event.end);
            int n2 = this.content.getOffsetAtLine(n);
            if (event.end < n2 + (string = this.content.getLine(n)).length()) {
                ++event.end;
            }
            event.text = new String(new char[]{c});
        } else {
            event.text = new String(new char[]{c});
        }
        if (event.text != null) {
            this.sendKeyEvent(event);
        }
    }

    void doContentEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n = this.content.getCharCount();
            if (this.caretOffset < n) {
                this.caretOffset = n;
                this.showCaret();
            }
        }
    }

    void doContentStart() {
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            this.showCaret();
        }
    }

    void doCursorPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            this.caretAlignment = 1;
            this.showCaret();
        } else {
            this.doSelectionCursorPrevious();
        }
    }

    void doCursorNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            this.caretAlignment = 0;
            this.showCaret();
        } else {
            this.doSelectionCursorNext();
        }
    }

    void doDelete() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset < this.content.getCharCount()) {
            int n;
            int n2 = this.content.getLineAtOffset(this.caretOffset);
            int n3 = this.content.getOffsetAtLine(n2);
            if (this.caretOffset == n3 + (n = this.content.getLine(n2).length())) {
                event.start = this.caretOffset;
                event.end = this.content.getOffsetAtLine(n2 + 1);
            } else {
                event.start = this.caretOffset;
                event.end = this.getClusterNext(this.caretOffset, n2);
            }
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordNext() {
        if (this.selection.x != this.selection.y) {
            this.doDelete();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.caretOffset;
            event.end = this.getWordNext(this.caretOffset, 4);
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordPrevious() {
        if (this.selection.x != this.selection.y) {
            this.doBackspace();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.getWordPrevious(this.caretOffset, 4);
            event.end = this.caretOffset;
            this.sendKeyEvent(event);
        }
    }

    void doLineDown(boolean bl) {
        int n;
        int n2;
        int n3 = this.getCaretLine();
        int n4 = this.content.getLineCount();
        int n5 = 0;
        boolean bl2 = false;
        if (this.wordWrap) {
            int n6;
            n2 = this.content.getOffsetAtLine(n3);
            n = this.caretOffset - n2;
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            int n7 = this.getVisualLineIndex(textLayout, n);
            if (n7 == (n6 = textLayout.getLineCount()) - 1) {
                bl2 = n3 == n4 - 1;
                ++n3;
            } else {
                n5 = textLayout.getLineBounds((int)(n7 + 1)).y;
            }
            this.renderer.disposeTextLayout(textLayout);
        } else {
            bl2 = n3 == n4 - 1;
            ++n3;
        }
        if (bl2) {
            if (bl) {
                this.caretOffset = this.content.getCharCount();
            }
        } else {
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n5, n3);
        }
        n2 = this.columnX;
        n = this.horizontalScrollOffset;
        if (bl) {
            this.setMouseWordSelectionAnchor();
            this.doSelection(0x1000004);
        }
        this.showCaret();
        int n8 = n - this.horizontalScrollOffset;
        this.columnX = n2 + n8;
    }

    void doLineEnd() {
        int n;
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        if (this.wordWrap) {
            TextLayout textLayout = this.renderer.getTextLayout(n2);
            int n4 = this.caretOffset - n3;
            int n5 = this.getVisualLineIndex(textLayout, n4);
            int[] nArray = textLayout.getLineOffsets();
            n = n3 + nArray[n5 + 1];
            this.renderer.disposeTextLayout(textLayout);
        } else {
            int n6 = this.content.getLine(n2).length();
            n = n3 + n6;
        }
        if (this.caretOffset < n) {
            this.caretOffset = n;
            this.caretAlignment = 0;
            this.showCaret();
        }
    }

    void doLineStart() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        if (this.wordWrap) {
            TextLayout textLayout = this.renderer.getTextLayout(n);
            int n3 = this.caretOffset - n2;
            int n4 = this.getVisualLineIndex(textLayout, n3);
            int[] nArray = textLayout.getLineOffsets();
            n2 += nArray[n4];
            this.renderer.disposeTextLayout(textLayout);
        }
        if (this.caretOffset > n2) {
            this.caretOffset = n2;
            this.caretAlignment = 1;
            this.showCaret();
        }
    }

    void doLineUp(boolean bl) {
        int n;
        int n2;
        int n3 = this.getCaretLine();
        int n4 = 0;
        boolean bl2 = false;
        if (this.wordWrap) {
            n2 = this.content.getOffsetAtLine(n3);
            n = this.caretOffset - n2;
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            int n5 = this.getVisualLineIndex(textLayout, n);
            if (n5 == 0) {
                boolean bl3 = bl2 = n3 == 0;
                if (!bl2) {
                    n4 = this.renderer.getLineHeight(--n3) - 1;
                }
            } else {
                n4 = textLayout.getLineBounds((int)(n5 - 1)).y;
            }
            this.renderer.disposeTextLayout(textLayout);
        } else {
            bl2 = n3 == 0;
            --n3;
        }
        if (bl2) {
            if (bl) {
                this.caretOffset = 0;
            }
        } else {
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n4, n3);
        }
        n2 = this.columnX;
        n = this.horizontalScrollOffset;
        if (bl) {
            this.setMouseWordSelectionAnchor();
        }
        this.showCaret();
        if (bl) {
            this.doSelection(0x1000003);
        }
        int n6 = n - this.horizontalScrollOffset;
        this.columnX = n2 + n6;
    }

    void doMouseLocationChange(int n, int n2, boolean bl) {
        int n3 = this.getLineIndex(n2);
        this.updateCaretDirection = true;
        if (n3 < 0 || this.isSingleLine() && n3 > 0) {
            return;
        }
        int n4 = this.caretAlignment;
        int n5 = this.getOffsetAtPoint(n, n2);
        if (this.clickCount > 1) {
            n5 = this.doMouseWordSelect(n, n5, n3);
        }
        int n6 = this.content.getLineAtOffset(n5);
        if (n2 >= 0 && n2 < this.clientAreaHeight && (n >= 0 && n < this.clientAreaWidth || this.wordWrap || n6 != this.content.getLineAtOffset(this.caretOffset)) && (n5 != this.caretOffset || this.caretAlignment != n4)) {
            this.caretOffset = n5;
            if (bl) {
                this.doMouseSelection();
            }
            this.showCaret();
        }
        if (!bl) {
            this.caretOffset = n5;
            this.clearSelection(true);
        }
    }

    void doMouseSelection() {
        if (this.caretOffset <= this.selection.x || this.caretOffset > this.selection.x && this.caretOffset < this.selection.y && this.selectionAnchor == this.selection.x) {
            this.doSelection(0x1000003);
        } else {
            this.doSelection(0x1000004);
        }
    }

    int doMouseWordSelect(int n, int n2, int n3) {
        if (n2 < this.selectionAnchor && this.selectionAnchor == this.selection.x) {
            this.selectionAnchor = this.doubleClickSelection.y;
        } else if (n2 > this.selectionAnchor && this.selectionAnchor == this.selection.y) {
            this.selectionAnchor = this.doubleClickSelection.x;
        }
        if (n >= 0 && n < this.clientAreaWidth) {
            boolean bl;
            boolean bl2 = bl = (this.clickCount & 1) == 0;
            if (this.caretOffset == this.selection.x) {
                n2 = bl ? this.getWordPrevious(n2, 16) : this.content.getOffsetAtLine(n3);
            } else if (bl) {
                n2 = this.getWordNext(n2, 8);
            } else {
                int n4 = this.content.getCharCount();
                if (n3 + 1 < this.content.getLineCount()) {
                    n4 = this.content.getOffsetAtLine(n3 + 1);
                }
                n2 = n4;
            }
        }
        return n2;
    }

    void doPageDown(boolean bl, int n) {
        int n2;
        if (this.isSingleLine()) {
            return;
        }
        int n3 = this.columnX;
        int n4 = this.horizontalScrollOffset;
        if (this.isFixedLineHeight()) {
            n2 = this.content.getLineCount();
            int n5 = this.getCaretLine();
            if (n5 < n2 - 1) {
                int n6 = this.renderer.getLineHeight();
                int n7 = (n == -1 ? this.clientAreaHeight : n) / n6;
                int n8 = Math.min(n2 - n5 - 1, n7);
                n8 = Math.max(1, n8);
                this.caretOffset = this.getOffsetAtPoint(this.columnX, this.getLinePixel(n5 + n8));
                if (bl) {
                    this.doSelection(0x1000004);
                }
                int n9 = n2 * this.getVerticalIncrement();
                int n10 = this.clientAreaHeight;
                int n11 = this.getVerticalScrollOffset();
                int n12 = n11 + n8 * this.getVerticalIncrement();
                if (n12 + n10 > n9) {
                    n12 = n9 - n10;
                }
                if (n12 > n11) {
                    this.scrollVertical(n12 - n11, true);
                }
            }
        } else {
            Rectangle rectangle;
            int n13;
            int n14;
            TextLayout textLayout;
            int n15;
            int n16;
            int n17;
            n2 = this.content.getLineCount();
            int n18 = this.getCaretLine();
            if (n == -1) {
                n17 = this.getPartialBottomIndex();
                n16 = this.getLinePixel(n17);
                n15 = this.renderer.getLineHeight(n17);
                n = n16;
                if (n16 + n15 <= this.clientAreaHeight) {
                    n += n15;
                } else if (this.wordWrap) {
                    textLayout = this.renderer.getTextLayout(n17);
                    n14 = this.clientAreaHeight - n16;
                    n13 = 0;
                    while (n13 < textLayout.getLineCount()) {
                        rectangle = textLayout.getLineBounds(n13);
                        if (rectangle.contains(rectangle.x, n14)) {
                            n += rectangle.y;
                            break;
                        }
                        ++n13;
                    }
                    this.renderer.disposeTextLayout(textLayout);
                }
            } else {
                n17 = this.getLineIndex(n);
                n16 = this.getLinePixel(n17);
                if (this.wordWrap) {
                    textLayout = this.renderer.getTextLayout(n17);
                    n14 = n - n16;
                    n13 = 0;
                    while (n13 < textLayout.getLineCount()) {
                        rectangle = textLayout.getLineBounds(n13);
                        if (rectangle.contains(rectangle.x, n14)) {
                            n = n16 + rectangle.y + rectangle.height;
                            break;
                        }
                        ++n13;
                    }
                    this.renderer.disposeTextLayout(textLayout);
                } else {
                    n = n16 + this.renderer.getLineHeight(n17);
                }
            }
            n16 = n;
            if (this.wordWrap) {
                textLayout = this.renderer.getTextLayout(n18);
                n14 = this.caretOffset - this.content.getOffsetAtLine(n18);
                n17 = this.getVisualLineIndex(textLayout, n14);
                n16 += textLayout.getLineBounds((int)n17).y;
                this.renderer.disposeTextLayout(textLayout);
            }
            n17 = n18;
            n15 = this.renderer.getLineHeight(n17);
            while (n16 - n15 >= 0 && n17 < n2 - 1) {
                n16 -= n15;
                n15 = this.renderer.getLineHeight(++n17);
            }
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n16, n17);
            if (bl) {
                this.doSelection(0x1000004);
            }
            n = this.getAvailableHeightBellow(n);
            this.scrollVertical(n, true);
            if (n == 0) {
                this.setCaretLocation();
            }
        }
        this.showCaret();
        n2 = n4 - this.horizontalScrollOffset;
        this.columnX = n3 + n2;
    }

    void doPageEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n;
            if (this.wordWrap) {
                int n2 = this.getPartialBottomIndex();
                TextLayout textLayout = this.renderer.getTextLayout(n2);
                int n3 = this.clientAreaHeight - this.bottomMargin - this.getLinePixel(n2);
                int n4 = textLayout.getLineCount() - 1;
                while (n4 >= 0) {
                    Rectangle rectangle = textLayout.getLineBounds(n4);
                    if (n3 >= rectangle.y + rectangle.height) break;
                    --n4;
                }
                n = n4 == -1 && n2 > 0 ? this.content.getOffsetAtLine(n2 - 1) + this.content.getLine(n2 - 1).length() : this.content.getOffsetAtLine(n2) + Math.max(0, textLayout.getLineOffsets()[n4 + 1] - 1);
                this.renderer.disposeTextLayout(textLayout);
            } else {
                int n5 = this.getBottomIndex();
                n = this.content.getOffsetAtLine(n5) + this.content.getLine(n5).length();
            }
            if (this.caretOffset < n) {
                this.caretOffset = n;
                this.caretAlignment = 1;
                this.showCaret();
            }
        }
    }

    void doPageStart() {
        int n;
        if (this.wordWrap) {
            int n2;
            int n3;
            if (this.topIndexY > 0) {
                n3 = this.topIndex - 1;
                n2 = this.renderer.getLineHeight(n3) - this.topIndexY;
            } else {
                n3 = this.topIndex;
                n2 = -this.topIndexY;
            }
            TextLayout textLayout = this.renderer.getTextLayout(n3);
            int n4 = 0;
            int n5 = textLayout.getLineCount();
            while (n4 < n5) {
                Rectangle rectangle = textLayout.getLineBounds(n4);
                if (n2 <= rectangle.y) break;
                ++n4;
            }
            n = n4 == n5 ? this.content.getOffsetAtLine(n3 + 1) : this.content.getOffsetAtLine(n3) + textLayout.getLineOffsets()[n4];
            this.renderer.disposeTextLayout(textLayout);
        } else {
            n = this.content.getOffsetAtLine(this.topIndex);
        }
        if (this.caretOffset > n) {
            this.caretOffset = n;
            this.caretAlignment = 1;
            this.showCaret();
        }
    }

    void doPageUp(boolean bl, int n) {
        int n2;
        if (this.isSingleLine()) {
            return;
        }
        int n3 = this.horizontalScrollOffset;
        int n4 = this.columnX;
        if (this.isFixedLineHeight()) {
            n2 = this.getCaretLine();
            if (n2 > 0) {
                int n5;
                int n6;
                int n7 = this.renderer.getLineHeight();
                int n8 = (n == -1 ? this.clientAreaHeight : n) / n7;
                int n9 = Math.max(1, Math.min(n2, n8));
                this.caretOffset = this.getOffsetAtPoint(this.columnX, this.getLinePixel(n2 -= n9));
                if (bl) {
                    this.doSelection(0x1000003);
                }
                if ((n6 = Math.max(0, (n5 = this.getVerticalScrollOffset()) - n9 * this.getVerticalIncrement())) < n5) {
                    this.scrollVertical(n6 - n5, true);
                }
            }
        } else {
            int n10;
            TextLayout textLayout;
            int n11;
            int n12;
            int n13;
            n2 = this.getCaretLine();
            if (n == -1) {
                if (this.topIndexY == 0) {
                    n = this.clientAreaHeight;
                } else {
                    if (this.topIndex > 0) {
                        n13 = this.topIndex - 1;
                        n12 = this.renderer.getLineHeight(n13);
                        n = this.clientAreaHeight - this.topIndexY;
                        n11 = n12 - this.topIndexY;
                    } else {
                        n13 = this.topIndex;
                        n12 = this.renderer.getLineHeight(n13);
                        n = this.clientAreaHeight - (n12 + this.topIndexY);
                        n11 = -this.topIndexY;
                    }
                    if (this.wordWrap) {
                        textLayout = this.renderer.getTextLayout(n13);
                        n10 = 0;
                        while (n10 < textLayout.getLineCount()) {
                            Rectangle rectangle = textLayout.getLineBounds(n10);
                            if (rectangle.contains(rectangle.x, n11)) {
                                n += n12 - (rectangle.y + rectangle.height);
                                break;
                            }
                            ++n10;
                        }
                        this.renderer.disposeTextLayout(textLayout);
                    }
                }
            } else {
                n13 = this.getLineIndex(this.clientAreaHeight - n);
                n11 = this.getLinePixel(n13);
                if (this.wordWrap) {
                    textLayout = this.renderer.getTextLayout(n13);
                    n10 = n11;
                    int n14 = 0;
                    while (n14 < textLayout.getLineCount()) {
                        Rectangle rectangle = textLayout.getLineBounds(n14);
                        if (rectangle.contains(rectangle.x, n10)) {
                            n = this.clientAreaHeight - (n11 + rectangle.y);
                            break;
                        }
                        ++n14;
                    }
                    this.renderer.disposeTextLayout(textLayout);
                } else {
                    n = this.clientAreaHeight - n11;
                }
            }
            n11 = n;
            if (this.wordWrap) {
                textLayout = this.renderer.getTextLayout(n2);
                n10 = this.caretOffset - this.content.getOffsetAtLine(n2);
                n13 = this.getVisualLineIndex(textLayout, n10);
                n11 += textLayout.getBounds().height - textLayout.getLineBounds((int)n13).y;
                this.renderer.disposeTextLayout(textLayout);
            }
            n13 = n2;
            n12 = this.renderer.getLineHeight(n13);
            while (n11 - n12 >= 0 && n13 > 0) {
                n11 -= n12;
                n12 = this.renderer.getLineHeight(--n13);
            }
            n12 = this.renderer.getLineHeight(n13);
            this.caretOffset = this.getOffsetAtPoint(this.columnX, n12 - n11, n13);
            if (bl) {
                this.doSelection(0x1000003);
            }
            n = this.getAvailableHeightAbove(n);
            this.scrollVertical(-n, true);
            if (n == 0) {
                this.setCaretLocation();
            }
        }
        this.showCaret();
        n2 = n3 - this.horizontalScrollOffset;
        this.columnX = n4 + n2;
    }

    void doSelection(int n) {
        int n2 = -1;
        int n3 = -1;
        if (this.selectionAnchor == -1) {
            this.selectionAnchor = this.selection.x;
        }
        if (n == 0x1000003) {
            if (this.caretOffset < this.selection.x) {
                n3 = this.selection.x;
                n2 = this.selection.x = this.caretOffset;
                if (this.selection.y != this.selectionAnchor) {
                    n3 = this.selection.y;
                    this.selection.y = this.selectionAnchor;
                }
            } else if (this.selectionAnchor == this.selection.x && this.caretOffset < this.selection.y) {
                n3 = this.selection.y;
                n2 = this.selection.y = this.caretOffset;
            }
        } else if (this.caretOffset > this.selection.y) {
            n2 = this.selection.y;
            n3 = this.selection.y = this.caretOffset;
            if (this.selection.x != this.selectionAnchor) {
                n2 = this.selection.x;
                this.selection.x = this.selectionAnchor;
            }
        } else if (this.selectionAnchor == this.selection.y && this.caretOffset > this.selection.x) {
            n2 = this.selection.x;
            n3 = this.selection.x = this.caretOffset;
        }
        if (n2 != -1 && n3 != -1) {
            this.internalRedrawRange(n2, n3 - n2);
            this.sendSelectionEvent();
        }
    }

    void doSelectionCursorNext() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.caretOffset - n2;
        if (n3 < this.content.getLine(n).length()) {
            TextLayout textLayout = this.renderer.getTextLayout(n);
            n3 = textLayout.getNextOffset(n3, 2);
            int n4 = textLayout.getLineOffsets()[textLayout.getLineIndex(n3)];
            this.renderer.disposeTextLayout(textLayout);
            this.caretOffset = n3 + n2;
            this.caretAlignment = n3 == n4 ? 1 : 0;
            this.showCaret();
        } else if (n < this.content.getLineCount() - 1 && !this.isSingleLine()) {
            this.caretOffset = this.content.getOffsetAtLine(++n);
            this.caretAlignment = 0;
            this.showCaret();
        }
    }

    void doSelectionCursorPrevious() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.caretOffset - n2;
        this.caretAlignment = 1;
        if (n3 > 0) {
            this.caretOffset = this.getClusterPrevious(this.caretOffset, n);
            this.showCaret();
        } else if (n > 0) {
            n2 = this.content.getOffsetAtLine(--n);
            this.caretOffset = n2 + this.content.getLine(n).length();
            this.showCaret();
        }
    }

    void doSelectionLineDown() {
        int n = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doLineDown(true);
        this.columnX = n;
    }

    void doSelectionLineUp() {
        int n = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doLineUp(true);
        this.columnX = n;
    }

    void doSelectionPageDown(int n) {
        int n2 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doPageDown(true, n);
        this.columnX = n2;
    }

    void doSelectionPageUp(int n) {
        int n2 = this.columnX = this.getPointAtOffset((int)this.caretOffset).x;
        this.doPageUp(true, n);
        this.columnX = n2;
    }

    void doSelectionWordNext() {
        int n = this.getWordNext(this.caretOffset, 4);
        this.caretAlignment = 1;
        if (!this.isSingleLine() || this.content.getLineAtOffset(this.caretOffset) == this.content.getLineAtOffset(n)) {
            this.caretOffset = n;
            this.showCaret();
        }
    }

    void doSelectionWordPrevious() {
        this.caretAlignment = 1;
        this.caretOffset = this.getWordPrevious(this.caretOffset, 4);
        int n = this.content.getLineAtOffset(this.caretOffset);
        if (this.wordWrap && n < this.content.getLineCount() - 1 && this.caretOffset == this.content.getOffsetAtLine(n + 1)) {
            ++n;
        }
        this.showCaret();
    }

    void doVisualPrevious() {
        this.caretOffset = this.getClusterPrevious(this.caretOffset, this.getCaretLine());
        this.showCaret();
    }

    void doVisualNext() {
        this.caretOffset = this.getClusterNext(this.caretOffset, this.getCaretLine());
        this.showCaret();
    }

    void doWordNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            this.showCaret();
        } else {
            this.doSelectionWordNext();
        }
    }

    void doWordPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            this.showCaret();
        } else {
            this.doSelectionWordPrevious();
        }
    }

    void endAutoScroll() {
        this.autoScrollDirection = 0;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.background;
    }

    public int getBaseline() {
        this.checkWidget();
        return this.renderer.getBaseline();
    }

    public int getBaseline(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (this.isFixedLineHeight()) {
            return this.renderer.getBaseline();
        }
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        int n4 = textLayout.getLineIndex(Math.min(n - n3, textLayout.getText().length()));
        FontMetrics fontMetrics = textLayout.getLineMetrics(n4);
        this.renderer.disposeTextLayout(textLayout);
        return fontMetrics.getAscent() + fontMetrics.getLeading();
    }

    public boolean getBidiColoring() {
        this.checkWidget();
        return this.bidiColoring;
    }

    int getBottomIndex() {
        int n;
        if (this.isFixedLineHeight()) {
            int n2 = 1;
            int n3 = this.renderer.getLineHeight();
            if (n3 != 0) {
                int n4 = this.topIndex * n3 - this.getVerticalScrollOffset();
                n2 = (this.clientAreaHeight - n4) / n3;
            }
            n = Math.min(this.content.getLineCount() - 1, this.topIndex + Math.max(0, n2 - 1));
        } else {
            int n5;
            int n6;
            int n7 = this.clientAreaHeight - this.bottomMargin;
            n = this.getLineIndex(n7);
            if (n > 0 && (n6 = this.getLinePixel(n)) + (n5 = this.renderer.getLineHeight(n)) > n7 && this.getLinePixel(n - 1) >= this.topMargin) {
                --n;
            }
        }
        return n;
    }

    Rectangle getBoundsAtOffset(int n) {
        Rectangle rectangle;
        int n2 = this.content.getLineAtOffset(n);
        String string = this.content.getLine(n2);
        if (string.length() != 0) {
            int n3 = n - this.content.getOffsetAtLine(n2);
            TextLayout textLayout = this.renderer.getTextLayout(n2);
            rectangle = textLayout.getBounds(n3, n3);
            this.renderer.disposeTextLayout(textLayout);
        } else {
            rectangle = new Rectangle(0, 0, 0, this.renderer.getLineHeight());
        }
        rectangle.x += this.leftMargin - this.horizontalScrollOffset;
        rectangle.y += this.getLinePixel(n2);
        return rectangle;
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.caretOffset;
    }

    int getCaretWidth() {
        Caret caret = this.getCaret();
        if (caret == null) {
            return 0;
        }
        return caret.getSize().x;
    }

    Object getClipboardContent(int n) {
        TextTransfer textTransfer = TextTransfer.getInstance();
        return this.clipboard.getContents(textTransfer, n);
    }

    int getClusterNext(int n, int n2) {
        int n3 = this.content.getOffsetAtLine(n2);
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        n -= n3;
        n = textLayout.getNextOffset(n, 2);
        this.renderer.disposeTextLayout(textLayout);
        return n += n3;
    }

    int getClusterPrevious(int n, int n2) {
        int n3 = this.content.getOffsetAtLine(n2);
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        n -= n3;
        n = textLayout.getPreviousOffset(n, 2);
        this.renderer.disposeTextLayout(textLayout);
        return n += n3;
    }

    public StyledTextContent getContent() {
        this.checkWidget();
        return this.content;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return this.dragDetect;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClickEnabled;
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.editable;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.foreground;
    }

    int getHorizontalIncrement() {
        return this.renderer.averageCharWidth;
    }

    public int getHorizontalIndex() {
        this.checkWidget();
        return this.horizontalScrollOffset / this.getHorizontalIncrement();
    }

    public int getHorizontalPixel() {
        this.checkWidget();
        return this.horizontalScrollOffset;
    }

    public int getIndent() {
        this.checkWidget();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkWidget();
        return this.justify;
    }

    public int getKeyBinding(int n) {
        this.checkWidget();
        Integer n2 = (Integer)this.keyActionMap.get(new Integer(n));
        return n2 == null ? 0 : n2;
    }

    public int getCharCount() {
        this.checkWidget();
        return this.content.getCharCount();
    }

    public int getLineAlignment(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.renderer.getLineAlignment(n, this.alignment);
    }

    public int getLineAtOffset(int n) {
        this.checkWidget();
        if (n < 0 || n > this.getCharCount()) {
            SWT.error(6);
        }
        return this.content.getLineAtOffset(n);
    }

    public Color getLineBackground(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3001) ? null : this.renderer.getLineBackground(n, null);
    }

    public Bullet getLineBullet(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? null : this.renderer.getLineBullet(n, null);
    }

    StyledTextEvent getLineBackgroundData(int n, String string) {
        return this.sendLineEvent(3001, n, string);
    }

    public int getLineCount() {
        this.checkWidget();
        return this.content.getLineCount();
    }

    int getLineCountWhole() {
        if (this.isFixedLineHeight()) {
            int n = this.renderer.getLineHeight();
            return n != 0 ? this.clientAreaHeight / n : 1;
        }
        return this.getBottomIndex() - this.topIndex + 1;
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return this.content.getLineDelimiter();
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.renderer.getLineHeight();
    }

    public int getLineHeight(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (this.isFixedLineHeight()) {
            return this.renderer.getLineHeight();
        }
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        int n4 = textLayout.getLineIndex(Math.min(n - n3, textLayout.getText().length()));
        int n5 = textLayout.getLineBounds((int)n4).height;
        this.renderer.disposeTextLayout(textLayout);
        return n5;
    }

    public int getLineIndent(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? 0 : this.renderer.getLineIndent(n, this.indent);
    }

    public boolean getLineJustify(int n) {
        this.checkWidget();
        if (n < 0 || n > this.content.getLineCount()) {
            SWT.error(5);
        }
        return this.isListening(3002) ? false : this.renderer.getLineJustify(n, this.justify);
    }

    public int getLineSpacing() {
        this.checkWidget();
        return this.lineSpacing;
    }

    StyledTextEvent getLineStyleData(int n, String string) {
        return this.sendLineEvent(3002, n, string);
    }

    public int getLinePixel(int n) {
        this.checkWidget();
        int n2 = this.content.getLineCount();
        n = Math.max(0, Math.min(n2, n));
        if (this.isFixedLineHeight()) {
            int n3 = this.renderer.getLineHeight();
            return n * n3 - this.getVerticalScrollOffset() + this.topMargin;
        }
        if (n == this.topIndex) {
            return this.topIndexY + this.topMargin;
        }
        int n4 = this.topIndexY;
        if (n > this.topIndex) {
            int n5 = this.topIndex;
            while (n5 < n) {
                n4 += this.renderer.getLineHeight(n5);
                ++n5;
            }
        } else {
            int n6 = this.topIndex - 1;
            while (n6 >= n) {
                n4 -= this.renderer.getLineHeight(n6);
                --n6;
            }
        }
        return n4 + this.topMargin;
    }

    public int getLineIndex(int n) {
        this.checkWidget();
        n -= this.topMargin;
        if (this.isFixedLineHeight()) {
            int n2 = this.renderer.getLineHeight();
            int n3 = (n + this.getVerticalScrollOffset()) / n2;
            int n4 = this.content.getLineCount();
            n3 = Math.max(0, Math.min(n4 - 1, n3));
            return n3;
        }
        if (n == this.topIndexY) {
            return this.topIndex;
        }
        int n5 = this.topIndex;
        if (n < this.topIndexY) {
            while (n < this.topIndexY && n5 > 0) {
                n += this.renderer.getLineHeight(--n5);
            }
        } else {
            int n6 = this.content.getLineCount();
            int n7 = this.renderer.getLineHeight(n5);
            while (n - n7 >= this.topIndexY && n5 < n6 - 1) {
                n -= n7;
                n7 = this.renderer.getLineHeight(++n5);
            }
        }
        return n5;
    }

    public Point getLocationAtOffset(int n) {
        this.checkWidget();
        if (n < 0 || n > this.getCharCount()) {
            SWT.error(6);
        }
        return this.getPointAtOffset(n);
    }

    public int getOffsetAtLine(int n) {
        this.checkWidget();
        if (n < 0 || n > 0 && n >= this.content.getLineCount()) {
            SWT.error(6);
        }
        return this.content.getOffsetAtLine(n);
    }

    public int getOffsetAtLocation(Point point) {
        String string;
        int n;
        int n2;
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        if (point.y + this.getVerticalScrollOffset() < 0 || point.x + this.horizontalScrollOffset < 0) {
            SWT.error(5);
        }
        if (point.y > (n2 = this.getLinePixel(n = this.getLineIndex(this.clientAreaHeight)) + this.renderer.getLineHeight(n))) {
            SWT.error(5);
        }
        int n3 = this.getLineIndex(point.y);
        int n4 = this.content.getOffsetAtLine(n3);
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        int[] nArray = new int[1];
        int n5 = point.x + this.horizontalScrollOffset - this.leftMargin;
        int n6 = point.y - this.getLinePixel(n3);
        int n7 = textLayout.getOffset(n5, n6, nArray);
        if (n7 != (string = this.content.getLine(n3)).length() - 1) {
            n7 = Math.min(string.length(), n7 + nArray[0]);
        }
        Rectangle rectangle = textLayout.getLineBounds(textLayout.getLineIndex(n7));
        this.renderer.disposeTextLayout(textLayout);
        if (n5 > rectangle.x + rectangle.width) {
            SWT.error(5);
        }
        return n4 + n7;
    }

    int getOffsetAtPoint(int n, int n2) {
        int n3 = this.getLineIndex(n2);
        return this.getOffsetAtPoint(n, n2 -= this.getLinePixel(n3), n3);
    }

    int getOffsetAtPoint(int n, int n2, int n3) {
        TextLayout textLayout = this.renderer.getTextLayout(n3);
        int[] nArray = new int[1];
        int n4 = textLayout.getOffset(n += this.horizontalScrollOffset - this.leftMargin, n2, nArray);
        this.caretAlignment = 1;
        if (nArray[0] != 0) {
            int n5 = textLayout.getLineIndex(n4 + nArray[0]);
            int n6 = textLayout.getLineOffsets()[n5];
            if (n4 + nArray[0] == n6) {
                n4 += nArray[0];
                this.caretAlignment = 0;
            } else {
                String string = this.content.getLine(n3);
                int n7 = n4;
                while (n7 > 0 && Character.isDigit(string.charAt(n7))) {
                    --n7;
                }
                int n8 = n7 == 0 && Character.isDigit(string.charAt(n7)) ? (this.isMirrored() ? 1 : 0) : textLayout.getLevel(n7) & 1;
                int n9 = textLayout.getLevel(n4 += nArray[0]) & 1;
                this.caretAlignment = (n8 ^ n9) != 0 ? 0 : 1;
            }
        }
        this.renderer.disposeTextLayout(textLayout);
        return n4 + this.content.getOffsetAtLine(n3);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.isMirrored() ? 0x4000000 : 0x2000000;
    }

    int getPartialBottomIndex() {
        if (this.isFixedLineHeight()) {
            int n = this.renderer.getLineHeight();
            int n2 = Compatibility.ceil(this.clientAreaHeight, n);
            return Math.min(this.content.getLineCount(), this.topIndex + n2) - 1;
        }
        return this.getLineIndex(this.clientAreaHeight - this.bottomMargin);
    }

    int getPartialTopIndex() {
        if (this.isFixedLineHeight()) {
            int n = this.renderer.getLineHeight();
            return this.getVerticalScrollOffset() / n;
        }
        return this.topIndexY <= 0 ? this.topIndex : this.topIndex - 1;
    }

    String getPlatformDelimitedText(TextWriter textWriter) {
        int n = textWriter.getStart() + textWriter.getCharCount();
        int n2 = this.content.getLineAtOffset(textWriter.getStart());
        int n3 = this.content.getLineAtOffset(n);
        String string = this.content.getLine(n3);
        int n4 = this.content.getOffsetAtLine(n3);
        int n5 = n2;
        while (n5 <= n3) {
            textWriter.writeLine(this.content.getLine(n5), this.content.getOffsetAtLine(n5));
            if (n5 < n3) {
                textWriter.writeLineDelimiter(PlatformLineDelimiter);
            }
            ++n5;
        }
        if (n > n4 + string.length()) {
            textWriter.writeLineDelimiter(PlatformLineDelimiter);
        }
        textWriter.close();
        return textWriter.toString();
    }

    public int[] getRanges() {
        int[] nArray;
        this.checkWidget();
        if (!this.isListening(3002) && (nArray = this.renderer.getRanges(0, this.content.getCharCount())) != null) {
            return nArray;
        }
        return new int[0];
    }

    public int[] getRanges(int n, int n2) {
        int[] nArray;
        this.checkWidget();
        int n3 = this.getCharCount();
        int n4 = n + n2;
        if (n > n4 || n < 0 || n4 > n3) {
            SWT.error(6);
        }
        if (!this.isListening(3002) && (nArray = this.renderer.getRanges(n, n2)) != null) {
            return nArray;
        }
        return new int[0];
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public Point getSelectionRange() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y - this.selection.x);
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        if (this.selectionBackground == null) {
            return this.getDisplay().getSystemColor(26);
        }
        return this.selectionBackground;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.getSelectionRange().y;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        if (this.selectionForeground == null) {
            return this.getDisplay().getSystemColor(27);
        }
        return this.selectionForeground;
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.content.getTextRange(this.selection.x, this.selection.y - this.selection.x);
    }

    public int getStyle() {
        int n = super.getStyle();
        n &= 0xF1FFFFFF;
        n = this.isMirrored() ? (n |= 0xC000000) : (n |= 0x2000000);
        return n;
    }

    int[] getBidiSegments(int n, String string) {
        int[] nArray;
        if (!this.isBidi()) {
            return null;
        }
        if (!this.isListening(3007)) {
            return this.getBidiSegmentsCompatibility(string, n);
        }
        StyledTextEvent styledTextEvent = this.sendLineEvent(3007, n, string);
        int n2 = string.length();
        if (styledTextEvent == null || styledTextEvent.segments == null || styledTextEvent.segments.length == 0) {
            int[] nArray2 = new int[2];
            nArray2[1] = n2;
            nArray = nArray2;
        } else {
            int n3 = styledTextEvent.segments.length;
            if (styledTextEvent.segments[0] != 0) {
                SWT.error(5);
            }
            int n4 = 1;
            while (n4 < n3) {
                if (styledTextEvent.segments[n4] <= styledTextEvent.segments[n4 - 1] || styledTextEvent.segments[n4] > n2) {
                    SWT.error(5);
                }
                ++n4;
            }
            if (styledTextEvent.segments[n3 - 1] != n2) {
                nArray = new int[n3 + 1];
                System.arraycopy(styledTextEvent.segments, 0, nArray, 0, n3);
                nArray[n3] = n2;
            } else {
                nArray = styledTextEvent.segments;
            }
        }
        return nArray;
    }

    int[] getBidiSegmentsCompatibility(String string, int n) {
        int n2 = string.length();
        if (!this.bidiColoring) {
            int[] nArray = new int[2];
            nArray[1] = n2;
            return nArray;
        }
        StyleRange[] styleRangeArray = null;
        StyledTextEvent styledTextEvent = this.getLineStyleData(n, string);
        styleRangeArray = styledTextEvent != null ? styledTextEvent.styles : this.renderer.getStyleRanges(n, n2, true);
        if (styleRangeArray == null || styleRangeArray.length == 0) {
            int[] nArray = new int[2];
            nArray[1] = n2;
            return nArray;
        }
        int n3 = 0;
        int n4 = 1;
        while (n3 < styleRangeArray.length && styleRangeArray[n3].start == 0 && styleRangeArray[n3].length == n2) {
            ++n3;
        }
        int[] nArray = new int[(styleRangeArray.length - n3) * 2 + 2];
        int n5 = n3;
        while (n5 < styleRangeArray.length) {
            StyleRange styleRange = styleRangeArray[n5];
            int n6 = Math.max(styleRange.start - n, 0);
            int n7 = Math.max(styleRange.start + styleRange.length - n, n6);
            n7 = Math.min(n7, string.length());
            if (n5 > 0 && n4 > 1 && (n6 >= nArray[n4 - 2] && n6 <= nArray[n4 - 1] || n7 >= nArray[n4 - 2] && n7 <= nArray[n4 - 1]) && styleRange.similarTo(styleRangeArray[n5 - 1])) {
                nArray[n4 - 2] = Math.min(nArray[n4 - 2], n6);
                nArray[n4 - 1] = Math.max(nArray[n4 - 1], n7);
            } else {
                if (n6 > nArray[n4 - 1]) {
                    nArray[n4] = n6;
                    ++n4;
                }
                nArray[n4] = n7;
                ++n4;
            }
            ++n5;
        }
        if (n2 > nArray[n4 - 1]) {
            nArray[n4] = n2;
            ++n4;
        }
        if (n4 == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    public StyleRange getStyleRangeAtOffset(int n) {
        StyleRange[] styleRangeArray;
        this.checkWidget();
        if (n < 0 || n >= this.getCharCount()) {
            SWT.error(5);
        }
        if (!this.isListening(3002) && (styleRangeArray = this.renderer.getStyleRanges(n, 1, true)) != null) {
            return styleRangeArray[0];
        }
        return null;
    }

    public StyleRange[] getStyleRanges() {
        this.checkWidget();
        return this.getStyleRanges(0, this.content.getCharCount(), true);
    }

    public StyleRange[] getStyleRanges(boolean bl) {
        this.checkWidget();
        return this.getStyleRanges(0, this.content.getCharCount(), bl);
    }

    public StyleRange[] getStyleRanges(int n, int n2) {
        this.checkWidget();
        return this.getStyleRanges(n, n2, true);
    }

    public StyleRange[] getStyleRanges(int n, int n2, boolean bl) {
        StyleRange[] styleRangeArray;
        this.checkWidget();
        int n3 = this.getCharCount();
        int n4 = n + n2;
        if (n > n4 || n < 0 || n4 > n3) {
            SWT.error(6);
        }
        if (!this.isListening(3002) && (styleRangeArray = this.renderer.getStyleRanges(n, n2, bl)) != null) {
            return styleRangeArray;
        }
        return new StyleRange[0];
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabLength;
    }

    public String getText() {
        this.checkWidget();
        return this.content.getTextRange(0, this.getCharCount());
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n3 || n > n2) {
            SWT.error(6);
        }
        return this.content.getTextRange(n, n2 - n + 1);
    }

    public Rectangle getTextBounds(int n, int n2) {
        Rectangle rectangle;
        this.checkWidget();
        int n3 = this.getCharCount();
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n3 || n > n2) {
            SWT.error(6);
        }
        int n4 = this.content.getLineAtOffset(n);
        int n5 = this.content.getLineAtOffset(n2);
        int n6 = this.getLinePixel(n4);
        int n7 = 0;
        int n8 = Integer.MAX_VALUE;
        int n9 = 0;
        int n10 = n4;
        while (n10 <= n5) {
            int n11 = this.content.getOffsetAtLine(n10);
            TextLayout textLayout = this.renderer.getTextLayout(n10);
            if (textLayout.getText().length() > 0) {
                if (n10 == n4 && n10 == n5) {
                    rectangle = textLayout.getBounds(n - n11, n2 - n11);
                } else if (n10 == n4) {
                    String string = this.content.getLine(n10);
                    rectangle = textLayout.getBounds(n - n11, string.length());
                } else {
                    rectangle = n10 == n5 ? textLayout.getBounds(0, n2 - n11) : textLayout.getBounds();
                }
                n8 = Math.min(n8, rectangle.x);
                n9 = Math.max(n9, rectangle.x + rectangle.width);
                n7 += rectangle.height;
            } else {
                n7 += this.renderer.getLineHeight();
            }
            this.renderer.disposeTextLayout(textLayout);
            ++n10;
        }
        rectangle = new Rectangle(n8, n6, n9 - n8, n7);
        rectangle.x += this.leftMargin - this.horizontalScrollOffset;
        return rectangle;
    }

    public String getTextRange(int n, int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        int n4 = n + n2;
        if (n > n4 || n < 0 || n4 > n3) {
            SWT.error(6);
        }
        return this.content.getTextRange(n, n2);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        return this.topIndex;
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.getVerticalScrollOffset();
    }

    int getVerticalIncrement() {
        return this.renderer.getLineHeight();
    }

    int getVerticalScrollOffset() {
        if (this.verticalScrollOffset == -1) {
            this.renderer.calculate(0, this.topIndex);
            int n = 0;
            int n2 = 0;
            while (n2 < this.topIndex) {
                n += this.renderer.getLineHeight(n2);
                ++n2;
            }
            this.verticalScrollOffset = n -= this.topIndexY;
        }
        return this.verticalScrollOffset;
    }

    int getVisualLineIndex(TextLayout textLayout, int n) {
        int n2;
        int n3;
        int n4 = textLayout.getLineIndex(n);
        int[] nArray = textLayout.getLineOffsets();
        if (n4 != 0 && n == nArray[n4] && (n3 = textLayout.getLineBounds((int)n4).y) > (n2 = this.getCaret().getLocation().y - this.topMargin - this.getLinePixel(this.getCaretLine()))) {
            --n4;
        }
        return n4;
    }

    int getCaretDirection() {
        if (!this.isBidiCaret()) {
            return -1;
        }
        if (!this.updateCaretDirection && this.caretDirection != 0) {
            return this.caretDirection;
        }
        this.updateCaretDirection = false;
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        String string = this.content.getLine(n);
        int n3 = this.caretOffset - n2;
        int n4 = string.length();
        if (n4 == 0) {
            return this.isMirrored() ? 131072 : 16384;
        }
        if (this.caretAlignment == 0 && n3 > 0) {
            --n3;
        }
        if (n3 == n4 && n3 > 0) {
            --n3;
        }
        while (n3 > 0 && Character.isDigit(string.charAt(n3))) {
            --n3;
        }
        if (n3 == 0 && Character.isDigit(string.charAt(n3))) {
            return this.isMirrored() ? 131072 : 16384;
        }
        TextLayout textLayout = this.renderer.getTextLayout(n);
        int n5 = textLayout.getLevel(n3);
        this.renderer.disposeTextLayout(textLayout);
        return (n5 & 1) != 0 ? 131072 : 16384;
    }

    int getCaretLine() {
        return this.content.getLineAtOffset(this.caretOffset);
    }

    int getWrapWidth() {
        if (this.wordWrap && !this.isSingleLine()) {
            int n = this.clientAreaWidth - this.leftMargin - this.rightMargin;
            return n > 0 ? n : 1;
        }
        return -1;
    }

    int getWordNext(int n, int n2) {
        String string;
        int n3;
        int n4;
        if (n >= this.getCharCount()) {
            n4 = n;
            int n5 = this.content.getLineCount() - 1;
            n3 = this.content.getOffsetAtLine(n5);
            string = this.content.getLine(n5);
        } else {
            int n6;
            int n7 = this.content.getLineAtOffset(n);
            n3 = this.content.getOffsetAtLine(n7);
            if (n == n3 + (n6 = (string = this.content.getLine(n7)).length())) {
                n4 = this.content.getOffsetAtLine(n7 + 1);
            } else {
                TextLayout textLayout = this.renderer.getTextLayout(n7);
                n4 = n3 + textLayout.getNextOffset(n - n3, n2);
                this.renderer.disposeTextLayout(textLayout);
            }
        }
        return this.sendWordBoundaryEvent(3009, n2, n, n4, string, n3);
    }

    int getWordPrevious(int n, int n2) {
        String string;
        int n3;
        int n4;
        if (n <= 0) {
            n4 = 0;
            int n5 = this.content.getLineAtOffset(n4);
            n3 = this.content.getOffsetAtLine(n5);
            string = this.content.getLine(n5);
        } else {
            int n6 = this.content.getLineAtOffset(n);
            n3 = this.content.getOffsetAtLine(n6);
            string = this.content.getLine(n6);
            if (n == n3) {
                String string2 = this.content.getLine(n6 - 1);
                int n7 = this.content.getOffsetAtLine(n6 - 1);
                n4 = n7 + string2.length();
            } else {
                TextLayout textLayout = this.renderer.getTextLayout(n6);
                n4 = n3 + textLayout.getPreviousOffset(n - n3, n2);
                this.renderer.disposeTextLayout(textLayout);
            }
        }
        return this.sendWordBoundaryEvent(3010, n2, n, n4, string, n3);
    }

    public boolean getWordWrap() {
        this.checkWidget();
        return this.wordWrap;
    }

    Point getPointAtOffset(int n) {
        Point point;
        int n2 = this.content.getLineAtOffset(n);
        String string = this.content.getLine(n2);
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = n - n3;
        int n5 = string.length();
        if (n2 < this.content.getLineCount() - 1) {
            int n6 = this.content.getOffsetAtLine(n2 + 1) - 1;
            if (n5 < n4 && n4 <= n6) {
                n4 = n5;
            }
        }
        TextLayout textLayout = this.renderer.getTextLayout(n2);
        if (n5 != 0 && n4 <= n5) {
            if (n4 == n5) {
                point = textLayout.getLocation(n4 - 1, true);
            } else {
                switch (this.caretAlignment) {
                    case 1: {
                        point = textLayout.getLocation(n4, false);
                        break;
                    }
                    default: {
                        if (n4 == 0) {
                            point = textLayout.getLocation(n4, false);
                            break;
                        }
                        point = textLayout.getLocation(n4 - 1, true);
                        break;
                    }
                }
            }
        } else {
            point = new Point(textLayout.getIndent(), 0);
        }
        this.renderer.disposeTextLayout(textLayout);
        point.x += this.leftMargin - this.horizontalScrollOffset;
        point.y += this.getLinePixel(n2);
        return point;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        Point point = this.getSelectionRange();
        this.replaceTextRange(point.x, point.y, string);
    }

    void installDefaultContent() {
        this.textChangeListener = new TextChangeListener(){

            public void textChanging(TextChangingEvent textChangingEvent) {
                StyledText.this.handleTextChanging(textChangingEvent);
            }

            public void textChanged(TextChangedEvent textChangedEvent) {
                StyledText.this.handleTextChanged(textChangedEvent);
            }

            public void textSet(TextChangedEvent textChangedEvent) {
                StyledText.this.handleTextSet(textChangedEvent);
            }
        };
        this.content = new DefaultContent();
        this.content.addTextChangeListener(this.textChangeListener);
    }

    void installListeners() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        StyledText.this.handleDispose(event);
                        break;
                    }
                    case 1: {
                        StyledText.this.handleKeyDown(event);
                        break;
                    }
                    case 2: {
                        StyledText.this.handleKeyUp(event);
                        break;
                    }
                    case 3: {
                        StyledText.this.handleMouseDown(event);
                        break;
                    }
                    case 4: {
                        StyledText.this.handleMouseUp(event);
                        break;
                    }
                    case 5: {
                        StyledText.this.handleMouseMove(event);
                        break;
                    }
                    case 9: {
                        StyledText.this.handlePaint(event);
                        break;
                    }
                    case 11: {
                        StyledText.this.handleResize(event);
                        break;
                    }
                    case 31: {
                        StyledText.this.handleTraverse(event);
                    }
                }
            }
        };
        this.addListener(12, this.listener);
        this.addListener(1, this.listener);
        this.addListener(2, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(5, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(31, this.listener);
        if (scrollBar != null) {
            scrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleVerticalScroll(event);
                }
            });
        }
        if (scrollBar2 != null) {
            scrollBar2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleHorizontalScroll(event);
                }
            });
        }
    }

    void internalRedrawRange(int n, int n2) {
        int n3;
        Rectangle rectangle;
        if (n2 <= 0) {
            return;
        }
        int n4 = n + n2;
        int n5 = this.content.getLineAtOffset(n);
        int n6 = this.content.getLineAtOffset(n4);
        int n7 = this.getPartialBottomIndex();
        int n8 = this.getPartialTopIndex();
        if (n5 > n7 || n6 < n8) {
            return;
        }
        if (n8 > n5) {
            n5 = n8;
            n = 0;
        } else {
            n -= this.content.getOffsetAtLine(n5);
        }
        if (n7 < n6) {
            n6 = n7 + 1;
            n4 = 0;
        } else {
            n4 -= this.content.getOffsetAtLine(n6);
        }
        TextLayout textLayout = this.renderer.getTextLayout(n5);
        int n9 = this.leftMargin - this.horizontalScrollOffset;
        int n10 = this.getLinePixel(n5);
        int[] nArray = textLayout.getLineOffsets();
        int n11 = textLayout.getLineIndex(Math.min(n, textLayout.getText().length()));
        if (this.wordWrap && n11 > 0 && nArray[n11] == n) {
            rectangle = textLayout.getLineBounds(n11 - 1);
            rectangle.x = rectangle.width;
            rectangle.width = this.clientAreaWidth - this.rightMargin - rectangle.x;
            rectangle.x += n9;
            rectangle.y += n10;
            super.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
        if (n5 == n6 && n11 == (n3 = textLayout.getLineIndex(Math.min(n4, textLayout.getText().length())))) {
            Rectangle rectangle2 = textLayout.getBounds(n, n4 - 1);
            rectangle2.x += n9;
            rectangle2.y += n10;
            super.redraw(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, false);
            this.renderer.disposeTextLayout(textLayout);
            return;
        }
        rectangle = textLayout.getBounds(n, nArray[n11 + 1] - 1);
        if (rectangle.height == 0) {
            Rectangle rectangle3 = textLayout.getLineBounds(n11);
            rectangle.x = rectangle3.width;
            rectangle.y = rectangle3.y;
            rectangle.height = rectangle3.height;
        }
        rectangle.x += n9;
        rectangle.y += n10;
        rectangle.width = this.clientAreaWidth - this.rightMargin - rectangle.x;
        super.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        if (n5 != n6) {
            this.renderer.disposeTextLayout(textLayout);
            textLayout = this.renderer.getTextLayout(n6);
            nArray = textLayout.getLineOffsets();
        }
        int n12 = textLayout.getLineIndex(Math.min(n4, textLayout.getText().length()));
        Rectangle rectangle4 = textLayout.getBounds(nArray[n12], n4 - 1);
        if (rectangle4.height == 0) {
            Rectangle rectangle5 = textLayout.getLineBounds(n12);
            rectangle4.y = rectangle5.y;
            rectangle4.height = rectangle5.height;
        }
        rectangle4.x += n9;
        rectangle4.y += this.getLinePixel(n6);
        super.redraw(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, false);
        this.renderer.disposeTextLayout(textLayout);
        int n13 = rectangle.y + rectangle.height;
        if (rectangle4.y > n13) {
            super.redraw(this.leftMargin, n13, this.clientAreaWidth - this.rightMargin - this.leftMargin, rectangle4.y - n13, false);
        }
    }

    void handleDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.clipboard.dispose();
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderer = null;
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
            this.content = null;
        }
        if (this.defaultCaret != null) {
            this.defaultCaret.dispose();
            this.defaultCaret = null;
        }
        if (this.leftCaretBitmap != null) {
            this.leftCaretBitmap.dispose();
            this.leftCaretBitmap = null;
        }
        if (this.rightCaretBitmap != null) {
            this.rightCaretBitmap.dispose();
            this.rightCaretBitmap = null;
        }
        if (this.isBidiCaret()) {
            BidiUtil.removeLanguageListener(this.handle);
        }
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.textChangeListener = null;
        this.selection = null;
        this.doubleClickSelection = null;
        this.keyActionMap = null;
        this.background = null;
        this.foreground = null;
        this.clipboard = null;
    }

    void handleHorizontalScroll(Event event) {
        int n = this.getHorizontalBar().getSelection() - this.horizontalScrollOffset;
        this.scrollHorizontal(n, false);
    }

    void handleKey(Event event) {
        int n;
        int n2;
        this.caretAlignment = 0;
        if (event.keyCode != 0) {
            n2 = this.getKeyBinding(event.keyCode | event.stateMask);
        } else {
            n2 = this.getKeyBinding(event.character | event.stateMask);
            if (n2 == 0 && (event.stateMask & 0x40000) != 0 && event.character >= '\u0000' && event.character <= '\u001f') {
                n = event.character + 64;
                n2 = this.getKeyBinding(n | event.stateMask);
            }
        }
        if (n2 == 0) {
            n = 0;
            if (IS_CARBON) {
                n = (event.stateMask ^ 0x400000) != 0 && (event.stateMask ^ 0x420000) != 0 ? 0 : 1;
            } else if (IS_MOTIF) {
                n = (event.stateMask ^ 0x40000) != 0 && (event.stateMask ^ 0x60000) != 0 ? 0 : 1;
            } else {
                int n3 = n = (event.stateMask ^ 0x10000) != 0 && (event.stateMask ^ 0x40000) != 0 && (event.stateMask ^ 0x30000) != 0 && (event.stateMask ^ 0x60000) != 0 ? 0 : 1;
            }
            if (n == 0 && event.character > '\u001f' && event.character != '\u007f' || event.character == '\r' || event.character == '\n' || event.character == '\t') {
                this.doContent(event.character);
                this.update();
            }
        } else {
            this.invokeAction(n2);
        }
    }

    void handleKeyDown(Event event) {
        if (this.clipboardSelection == null) {
            this.clipboardSelection = new Point(this.selection.x, this.selection.y);
        }
        Event event2 = new Event();
        event2.character = event.character;
        event2.keyCode = event.keyCode;
        event2.stateMask = event.stateMask;
        event2.doit = true;
        this.notifyListeners(3005, event2);
        if (event2.doit) {
            this.handleKey(event);
        }
    }

    void handleKeyUp(Event event) {
        block4: {
            if (this.clipboardSelection != null && (this.clipboardSelection.x != this.selection.x || this.clipboardSelection.y != this.selection.y)) {
                try {
                    if (this.selection.y - this.selection.x > 0) {
                        this.setClipboardContent(this.selection.x, this.selection.y - this.selection.x, 2);
                    }
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 2002) break block4;
                    throw sWTError;
                }
            }
        }
        this.clipboardSelection = null;
    }

    void handleMouseDown(Event event) {
        String string;
        this.forceFocus();
        if (this.dragDetect && this.checkDragDetect(event)) {
            return;
        }
        if (event.button == 2 && (string = (String)this.getClipboardContent(2)) != null && string.length() > 0) {
            this.doMouseLocationChange(event.x, event.y, false);
            Event event2 = new Event();
            event2.start = this.selection.x;
            event2.end = this.selection.y;
            event2.text = this.getModelDelimitedText(string);
            this.sendKeyEvent(event2);
        }
        if (event.button != 1 || IS_CARBON && (event.stateMask & SWT.MOD4) != 0) {
            return;
        }
        this.clickCount = event.count;
        if (this.clickCount == 1) {
            boolean bl = (event.stateMask & SWT.MOD2) != 0;
            this.doMouseLocationChange(event.x, event.y, bl);
        } else if (this.doubleClickEnabled) {
            int n;
            int n2;
            this.clearSelection(false);
            int n3 = this.getOffsetAtPoint(event.x, event.y);
            int n4 = this.content.getLineAtOffset(n3);
            int n5 = this.content.getOffsetAtLine(n4);
            int n6 = this.content.getCharCount();
            if (n4 + 1 < this.content.getLineCount()) {
                n6 = this.content.getOffsetAtLine(n4 + 1);
            }
            if ((this.clickCount & 1) == 0) {
                n2 = Math.max(0, this.getWordPrevious(n3, 16));
                n = Math.min(this.content.getCharCount(), this.getWordNext(n2, 8));
            } else {
                n2 = n5;
                n = n6;
            }
            this.selection.x = this.selection.y = n2;
            this.selectionAnchor = -1;
            this.caretOffset = n;
            this.showCaret();
            this.doMouseSelection();
            this.doubleClickSelection = new Point(this.selection.x, this.selection.y);
        }
    }

    void handleMouseMove(Event event) {
        if (this.clickCount == 0) {
            return;
        }
        this.doMouseLocationChange(event.x, event.y, true);
        this.update();
        this.doAutoScroll(event);
    }

    void handleMouseUp(Event event) {
        block4: {
            this.clickCount = 0;
            this.endAutoScroll();
            if (event.button == 1) {
                try {
                    if (this.selection.y - this.selection.x > 0) {
                        this.setClipboardContent(this.selection.x, this.selection.y - this.selection.x, 2);
                    }
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 2002) break block4;
                    throw sWTError;
                }
            }
        }
    }

    void handlePaint(Event event) {
        if (event.width == 0 || event.height == 0) {
            return;
        }
        if (this.clientAreaWidth == 0 || this.clientAreaHeight == 0) {
            return;
        }
        int n = this.getLineIndex(event.y);
        int n2 = this.getLinePixel(n);
        int n3 = event.y + event.height;
        GC gC = event.gc;
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        if (n3 > 0) {
            int n4 = this.isSingleLine() ? 1 : this.content.getLineCount();
            int n5 = this.leftMargin - this.horizontalScrollOffset;
            int n6 = n;
            while (n2 < n3 && n6 < n4) {
                n2 += this.renderer.drawLine(n6, n5, n2, gC, color, color2);
                ++n6;
            }
            if (n2 < n3) {
                gC.setBackground(color);
                this.drawBackground(gC, 0, n2, this.clientAreaWidth, n3 - n2);
            }
        }
        gC.setBackground(color);
        if (this.topMargin > 0) {
            this.drawBackground(gC, 0, 0, this.clientAreaWidth, this.topMargin);
        }
        if (this.bottomMargin > 0) {
            this.drawBackground(gC, 0, this.clientAreaHeight - this.bottomMargin, this.clientAreaWidth, this.bottomMargin);
        }
        if (this.leftMargin > 0) {
            this.drawBackground(gC, 0, 0, this.leftMargin, this.clientAreaHeight);
        }
        if (this.rightMargin > 0) {
            this.drawBackground(gC, this.clientAreaWidth - this.rightMargin, 0, this.rightMargin, this.clientAreaHeight);
        }
    }

    void handleResize(Event event) {
        int n;
        int n2 = this.clientAreaHeight;
        int n3 = this.clientAreaWidth;
        Rectangle rectangle = this.getClientArea();
        this.clientAreaHeight = rectangle.height;
        this.clientAreaWidth = rectangle.width;
        if (n3 != this.clientAreaWidth && this.rightMargin > 0) {
            n = (n3 < this.clientAreaWidth ? n3 : this.clientAreaWidth) - this.rightMargin;
            super.redraw(n, 0, this.rightMargin, n2, false);
        }
        if (n2 != this.clientAreaHeight && this.bottomMargin > 0) {
            n = (n2 < this.clientAreaHeight ? n2 : this.clientAreaHeight) - this.bottomMargin;
            super.redraw(0, n, n3, this.bottomMargin, false);
        }
        if (this.wordWrap) {
            if (n3 != this.clientAreaWidth) {
                this.renderer.reset(0, this.content.getLineCount());
                this.verticalScrollOffset = -1;
                this.renderer.calculateIdle();
                super.redraw();
            }
            if (n2 != this.clientAreaHeight) {
                if (n2 == 0) {
                    this.topIndexY = 0;
                }
                this.setScrollBars(true);
            }
            this.setCaretLocation();
        } else {
            ScrollBar scrollBar;
            this.renderer.calculateClientArea();
            this.setScrollBars(true);
            this.claimRightFreeSpace();
            if (this.clientAreaWidth != 0 && (scrollBar = this.getHorizontalBar()) != null && scrollBar.getVisible() && this.horizontalScrollOffset != scrollBar.getSelection()) {
                scrollBar.setSelection(this.horizontalScrollOffset);
                this.horizontalScrollOffset = scrollBar.getSelection();
            }
        }
        this.claimBottomFreeSpace();
    }

    void handleTextChanged(TextChangedEvent textChangedEvent) {
        int n = this.content.getLineAtOffset(this.lastTextChangeStart);
        this.resetCache(n, 0);
        if (!this.isFixedLineHeight() && this.topIndex > n) {
            this.topIndex = n;
            this.topIndexY = 0;
            super.redraw();
        } else {
            int n2 = n + this.lastTextChangeNewLineCount;
            int n3 = this.getLinePixel(n);
            int n4 = this.getLinePixel(n2 + 1);
            if (this.lastLineBottom != n4) {
                super.redraw();
                if (this.wordWrap) {
                    this.setCaretLocation();
                }
            } else {
                super.redraw(0, n3, this.clientAreaWidth, n4 - n3, false);
                this.redrawLinesBullet(this.renderer.redrawLines);
            }
        }
        this.renderer.redrawLines = null;
        this.updateSelection(this.lastTextChangeStart, this.lastTextChangeReplaceCharCount, this.lastTextChangeNewCharCount);
        if (this.lastTextChangeReplaceLineCount > 0 || this.wordWrap) {
            this.claimBottomFreeSpace();
        }
        if (this.lastTextChangeReplaceCharCount > 0) {
            this.claimRightFreeSpace();
        }
    }

    void handleTextChanging(TextChangingEvent textChangingEvent) {
        int n;
        if (textChangingEvent.replaceCharCount < 0) {
            textChangingEvent.start += textChangingEvent.replaceCharCount;
            textChangingEvent.replaceCharCount *= -1;
        }
        this.lastTextChangeStart = textChangingEvent.start;
        this.lastTextChangeNewLineCount = textChangingEvent.newLineCount;
        this.lastTextChangeNewCharCount = textChangingEvent.newCharCount;
        this.lastTextChangeReplaceLineCount = textChangingEvent.replaceLineCount;
        this.lastTextChangeReplaceCharCount = textChangingEvent.replaceCharCount;
        int n2 = this.content.getLineAtOffset(textChangingEvent.start);
        int n3 = this.getLinePixel(n2 + textChangingEvent.replaceLineCount + 1);
        this.lastLineBottom = n = this.getLinePixel(n2 + 1) + textChangingEvent.newLineCount * this.renderer.getLineHeight();
        if (n3 < 0 && n < 0) {
            this.lastLineBottom += n3 - n;
            this.verticalScrollOffset += n - n3;
            this.calculateTopIndex(n - n3);
            this.setScrollBars(true);
        } else {
            this.scrollText(n3, n);
        }
        this.renderer.textChanging(textChangingEvent);
        int n4 = this.content.getCharCount() - textChangingEvent.replaceCharCount + textChangingEvent.newCharCount;
        if (this.caretOffset > n4) {
            this.caretOffset = n4;
        }
    }

    void handleTextSet(TextChangedEvent textChangedEvent) {
        this.reset();
    }

    void handleTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 256: 
            case 512: {
                event.doit = true;
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                if ((this.getStyle() & 4) != 0) {
                    event.doit = true;
                    break;
                }
                if (this.editable && (event.stateMask & SWT.MODIFIER_MASK) == 0) break;
                event.doit = true;
            }
        }
    }

    void handleVerticalScroll(Event event) {
        int n = this.getVerticalBar().getSelection() - this.getVerticalScrollOffset();
        this.scrollVertical(n, false);
    }

    void initializeAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                String string = null;
                Label label = StyledText.this.getAssociatedLabel();
                if (label != null) {
                    string = StyledText.this.stripMnemonic(label.getText());
                }
                accessibleEvent.result = string;
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = StyledText.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c;
                String string;
                String string2 = null;
                Label label = StyledText.this.getAssociatedLabel();
                if (label != null && (string = label.getText()) != null && (c = StyledText.this._findMnemonic(string)) != '\u0000') {
                    string2 = "Alt+" + c;
                }
                accessibleEvent.result = string2;
            }
        });
        accessible.addAccessibleTextListener(new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent accessibleTextEvent) {
                accessibleTextEvent.offset = StyledText.this.getCaretOffset();
            }

            public void getSelectionRange(AccessibleTextEvent accessibleTextEvent) {
                Point point = StyledText.this.getSelectionRange();
                accessibleTextEvent.offset = point.x;
                accessibleTextEvent.length = point.y;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 42;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                int n = 0;
                if (StyledText.this.isEnabled()) {
                    n |= 0x100000;
                }
                if (StyledText.this.isFocusControl()) {
                    n |= 4;
                }
                if (!StyledText.this.isVisible()) {
                    n |= 0x8000;
                }
                if (!StyledText.this.getEditable()) {
                    n |= 0x40;
                }
                accessibleControlEvent.detail = n;
            }

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = StyledText.this.getText();
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    Label getAssociatedLabel() {
        Control[] controlArray = this.getParent().getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] == this && n > 0 && controlArray[n - 1] instanceof Label) {
                return (Label)controlArray[n - 1];
            }
            ++n;
        }
        return null;
    }

    String stripMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return string;
            }
            if (string.charAt(n) != '&') {
                return String.valueOf(string.substring(0, n - 1)) + string.substring(n, n2);
            }
            if (++n >= n2) break;
        }
        return string;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return Character.toLowerCase(string.charAt(n));
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    public void invokeAction(int n) {
        this.checkWidget();
        this.updateCaretDirection = true;
        switch (n) {
            case 0x1000001: {
                this.doLineUp(false);
                this.clearSelection(true);
                break;
            }
            case 0x1000002: {
                this.doLineDown(false);
                this.clearSelection(true);
                break;
            }
            case 0x1000007: {
                this.doLineStart();
                this.clearSelection(true);
                break;
            }
            case 0x1000008: {
                this.doLineEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1000003: {
                this.doCursorPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1000004: {
                this.doCursorNext();
                this.clearSelection(true);
                break;
            }
            case 0x1000005: {
                this.doPageUp(false, -1);
                this.clearSelection(true);
                break;
            }
            case 0x1000006: {
                this.doPageDown(false, -1);
                this.clearSelection(true);
                break;
            }
            case 17039363: {
                this.doWordPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1040004: {
                this.doWordNext();
                this.clearSelection(true);
                break;
            }
            case 17039367: {
                this.doContentStart();
                this.clearSelection(true);
                break;
            }
            case 17039368: {
                this.doContentEnd();
                this.clearSelection(true);
                break;
            }
            case 17039365: {
                this.doPageStart();
                this.clearSelection(true);
                break;
            }
            case 17039366: {
                this.doPageEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1020001: {
                this.doSelectionLineUp();
                break;
            }
            case 262209: {
                this.selectAll();
                break;
            }
            case 0x1020002: {
                this.doSelectionLineDown();
                break;
            }
            case 16908295: {
                this.doLineStart();
                this.doSelection(0x1000003);
                break;
            }
            case 16908296: {
                this.doLineEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 16908291: {
                this.doSelectionCursorPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 16908292: {
                this.doSelectionCursorNext();
                this.doSelection(0x1000004);
                break;
            }
            case 16908293: {
                this.doSelectionPageUp(-1);
                break;
            }
            case 16908294: {
                this.doSelectionPageDown(-1);
                break;
            }
            case 17170435: {
                this.doSelectionWordPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 17170436: {
                this.doSelectionWordNext();
                this.doSelection(0x1000004);
                break;
            }
            case 17170439: {
                this.doContentStart();
                this.doSelection(0x1000003);
                break;
            }
            case 17170440: {
                this.doContentEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 17170437: {
                this.doPageStart();
                this.doSelection(0x1000003);
                break;
            }
            case 0x1060006: {
                this.doPageEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 131199: {
                this.cut();
                break;
            }
            case 17039369: {
                this.copy();
                break;
            }
            case 16908297: {
                this.paste();
                break;
            }
            case 8: {
                this.doBackspace();
                break;
            }
            case 127: {
                this.doDelete();
                break;
            }
            case 262152: {
                this.doDeleteWordPrevious();
                break;
            }
            case 262271: {
                this.doDeleteWordNext();
                break;
            }
            case 0x1000009: {
                this.overwrite = !this.overwrite;
            }
        }
    }

    boolean isBidi() {
        return IS_GTK || BidiUtil.isBidiPlatform() || this.isMirrored;
    }

    boolean isBidiCaret() {
        return BidiUtil.isBidiPlatform();
    }

    boolean isFixedLineHeight() {
        return this.fixedLineHeight;
    }

    boolean isLineDelimiter(int n) {
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = n - n3;
        return n4 > this.content.getLine(n2).length();
    }

    boolean isMirrored() {
        return this.isMirrored;
    }

    boolean isSingleLine() {
        return (this.getStyle() & 4) != 0;
    }

    void modifyContent(Event event, boolean bl) {
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            int n = event.end - event.start;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, n);
            }
            if (bl && event.text.length() == 0) {
                int n2 = this.content.getLineAtOffset(event.start);
                int n3 = this.content.getOffsetAtLine(n2);
                TextLayout textLayout = this.renderer.getTextLayout(n2);
                int n4 = textLayout.getLevel(event.start - n3);
                int n5 = this.content.getLineAtOffset(event.end);
                if (n2 != n5) {
                    this.renderer.disposeTextLayout(textLayout);
                    n3 = this.content.getOffsetAtLine(n5);
                    textLayout = this.renderer.getTextLayout(n5);
                }
                int n6 = textLayout.getLevel(event.end - n3);
                this.renderer.disposeTextLayout(textLayout);
                this.caretAlignment = n4 != n6 ? 0 : 1;
            }
            this.content.replaceTextRange(event.start, n, event.text);
            if (bl) {
                this.setSelection(event.start + event.text.length(), 0, true);
                this.showCaret();
            }
            this.sendModifyEvent(event);
            if (this.isListening(3000)) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    void paintObject(GC gC, int n, int n2, int n3, int n4, StyleRange styleRange, Bullet bullet, int n5) {
        if (this.isListening(3008)) {
            StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.gc = gC;
            styledTextEvent.x = n;
            styledTextEvent.y = n2;
            styledTextEvent.ascent = n3;
            styledTextEvent.descent = n4;
            styledTextEvent.style = styleRange;
            styledTextEvent.bullet = bullet;
            styledTextEvent.bulletIndex = n5;
            this.notifyListeners(3008, styledTextEvent);
        }
    }

    public void paste() {
        this.checkWidget();
        String string = (String)this.getClipboardContent(1);
        if (string != null && string.length() > 0) {
            Event event = new Event();
            event.start = this.selection.x;
            event.end = this.selection.y;
            event.text = this.getModelDelimitedText(string);
            this.sendKeyEvent(event);
        }
    }

    public void print() {
        this.checkWidget();
        Printer printer = new Printer();
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        new Printing(this, printer, styledTextPrintOptions).run();
        printer.dispose();
    }

    public Runnable print(Printer printer) {
        this.checkWidget();
        if (printer == null) {
            SWT.error(4);
        }
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        return this.print(printer, styledTextPrintOptions);
    }

    public Runnable print(Printer printer, StyledTextPrintOptions styledTextPrintOptions) {
        this.checkWidget();
        if (printer == null || styledTextPrintOptions == null) {
            SWT.error(4);
        }
        return new Printing(this, printer, styledTextPrintOptions);
    }

    public void redraw() {
        super.redraw();
        int n = this.getPartialBottomIndex() - this.topIndex + 1;
        this.renderer.reset(this.topIndex, n);
        this.renderer.calculate(this.topIndex, n);
        this.setScrollBars(false);
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        super.redraw(n, n2, n3, n4, bl);
        if (n4 > 0) {
            int n5 = this.getLineIndex(n2);
            int n6 = this.getLineIndex(n2 + n4);
            this.resetCache(n5, n6 - n5 + 1);
        }
    }

    void redrawLines(int n, int n2) {
        int n3 = this.getPartialBottomIndex();
        if (n > n3 || n + n2 - 1 < this.topIndex) {
            return;
        }
        if (n < this.topIndex) {
            n2 -= this.topIndex - n;
            n = this.topIndex;
        }
        if (n + n2 - 1 > n3) {
            n2 = n3 - n + 1;
        }
        int n4 = this.getLinePixel(n -= this.topIndex);
        int n5 = this.getLinePixel(n + n2);
        int n6 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        super.redraw(this.leftMargin, n4, n6, n5 - n4, true);
    }

    void redrawLinesBullet(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n = this.getPartialTopIndex();
        int n2 = this.getPartialBottomIndex();
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[n3];
            if (n <= n4 && n4 <= n2) {
                int n5 = -1;
                Bullet bullet = this.renderer.getLineBullet(n4, null);
                if (bullet != null) {
                    StyleRange styleRange = bullet.style;
                    GlyphMetrics glyphMetrics = styleRange.metrics;
                    n5 = glyphMetrics.width;
                }
                if (n5 == -1) {
                    n5 = this.getClientArea().width;
                }
                int n6 = this.renderer.getLineHeight(n4);
                int n7 = this.getLinePixel(n4);
                super.redraw(0, n7, n5, n6, false);
            }
            ++n3;
        }
    }

    public void redrawRange(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = n + n2;
        int n4 = this.content.getCharCount();
        if (n > n3 || n < 0 || n3 > n4) {
            SWT.error(6);
        }
        int n5 = this.content.getLineAtOffset(n);
        int n6 = this.content.getLineAtOffset(n3);
        this.resetCache(n5, n6 - n5 + 1);
        this.internalRedrawRange(n, n2);
    }

    public void removeBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        this.removeListener(3007, bidiSegmentListener);
    }

    public void removeExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3000, extendedModifyListener);
    }

    public void removeLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        this.removeListener(3001, lineBackgroundListener);
    }

    public void removeLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        this.removeListener(3002, lineStyleListener);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(24, modifyListener);
    }

    public void removePaintObjectListener(PaintObjectListener paintObjectListener) {
        this.checkWidget();
        if (paintObjectListener == null) {
            SWT.error(4);
        }
        this.removeListener(3008, paintObjectListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(25, verifyListener);
    }

    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3005, verifyKeyListener);
    }

    public void removeWordMovementListener(MovementListener movementListener) {
        this.checkWidget();
        if (movementListener == null) {
            SWT.error(4);
        }
        this.removeListener(3009, movementListener);
        this.removeListener(3010, movementListener);
    }

    public void replaceStyleRanges(int n, int n2, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        this.setStyleRanges(n, n2, null, styleRangeArray, false);
    }

    public void replaceTextRange(int n, int n2, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n3 = this.getCharCount();
        int n4 = n + n2;
        if (n > n4 || n < 0 || n4 > n3) {
            SWT.error(6);
        }
        Event event = new Event();
        event.start = n;
        event.end = n4;
        event.text = string;
        this.modifyContent(event, false);
    }

    void reset() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.caretOffset = 0;
        this.topIndex = 0;
        this.topIndexY = 0;
        this.verticalScrollOffset = 0;
        this.horizontalScrollOffset = 0;
        this.resetSelection();
        this.renderer.setContent(this.content);
        if (scrollBar != null) {
            scrollBar.setSelection(0);
        }
        if (scrollBar2 != null) {
            scrollBar2.setSelection(0);
        }
        this.resetCache(0, 0);
        this.setCaretLocation();
        super.redraw();
    }

    void resetCache(int n, int n2) {
        int n3 = this.renderer.maxWidthLineIndex;
        this.renderer.reset(n, n2);
        this.renderer.calculateClientArea();
        if (n3 >= 0 && n3 < this.content.getLineCount()) {
            this.renderer.calculate(n3, 1);
        }
        this.setScrollBars(true);
        if (!this.isFixedLineHeight()) {
            if (this.topIndex > n) {
                this.verticalScrollOffset = -1;
            }
            this.renderer.calculateIdle();
        }
    }

    void resetSelection() {
        this.selection.x = this.selection.y = this.caretOffset;
        this.selectionAnchor = -1;
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super.scroll(n, n2, n3, n4, n5, n6, false);
        if (bl) {
            int n7 = n - n3;
            int n8 = n2 - n4;
            Control[] controlArray = this.getChildren();
            int n9 = 0;
            while (n9 < controlArray.length) {
                Control control = controlArray[n9];
                Rectangle rectangle = control.getBounds();
                control.setLocation(rectangle.x + n7, rectangle.y + n8);
                ++n9;
            }
        }
    }

    boolean scrollHorizontal(int n, boolean bl) {
        int n2;
        if (n == 0) {
            return false;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null && bl) {
            scrollBar.setSelection(this.horizontalScrollOffset + n);
        }
        int n3 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        if (n > 0) {
            n2 = this.leftMargin + n;
            int n4 = this.clientAreaWidth - n2 - this.rightMargin;
            if (n4 > 0) {
                this.scroll(this.leftMargin, this.topMargin, n2, this.topMargin, n4, n3, true);
            }
            if (n2 > n4) {
                super.redraw(this.leftMargin + n4, this.topMargin, n - n4, n3, true);
            }
        } else {
            n2 = this.leftMargin - n;
            int n5 = this.clientAreaWidth - n2 - this.rightMargin;
            if (n5 > 0) {
                this.scroll(n2, this.topMargin, this.leftMargin, this.topMargin, n5, n3, true);
            }
            if (n2 > n5) {
                super.redraw(this.leftMargin + n5, this.topMargin, -n - n5, n3, true);
            }
        }
        this.horizontalScrollOffset += n;
        n2 = this.columnX;
        this.setCaretLocation();
        this.columnX = n2;
        return true;
    }

    boolean scrollVertical(int n, boolean bl) {
        if (n == 0) {
            return false;
        }
        if (this.verticalScrollOffset != -1) {
            ScrollBar scrollBar = this.getVerticalBar();
            if (scrollBar != null && bl) {
                scrollBar.setSelection(this.verticalScrollOffset + n);
            }
            int n2 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
            if (n > 0) {
                int n3 = this.topMargin + n;
                int n4 = this.clientAreaHeight - n3 - this.bottomMargin;
                if (n4 > 0) {
                    this.scroll(this.leftMargin, this.topMargin, this.leftMargin, n3, n2, n4, true);
                }
                if (n3 > n4) {
                    int n5 = Math.max(0, this.topMargin + n4);
                    int n6 = Math.min(this.clientAreaHeight, n - n4);
                    super.redraw(this.leftMargin, n5, n2, n6, true);
                }
            } else {
                int n7 = this.topMargin - n;
                int n8 = this.clientAreaHeight - n7 - this.bottomMargin;
                if (n8 > 0) {
                    this.scroll(this.leftMargin, n7, this.leftMargin, this.topMargin, n2, n8, true);
                }
                if (n7 > n8) {
                    int n9 = Math.max(0, this.topMargin + n8);
                    int n10 = Math.min(this.clientAreaHeight, -n - n8);
                    super.redraw(this.leftMargin, n9, n2, n10, true);
                }
            }
            this.verticalScrollOffset += n;
            this.calculateTopIndex(n);
        } else {
            this.calculateTopIndex(n);
            super.redraw();
        }
        int n11 = this.columnX;
        this.setCaretLocation();
        this.columnX = n11;
        return true;
    }

    void scrollText(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = n2 - n;
        int n4 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        int n5 = n3 > 0 ? this.clientAreaHeight - n - this.bottomMargin : this.clientAreaHeight - n2 - this.bottomMargin;
        this.scroll(this.leftMargin, n2, this.leftMargin, n, n4, n5, true);
        if (n + n5 > 0 && this.topMargin > n) {
            super.redraw(this.leftMargin, n3, n4, this.topMargin, false);
        }
        if (n2 + n5 > 0 && this.topMargin > n2) {
            super.redraw(this.leftMargin, 0, n4, this.topMargin, false);
        }
        if (this.clientAreaHeight - this.bottomMargin < n + n5 && this.clientAreaHeight > n) {
            super.redraw(this.leftMargin, this.clientAreaHeight - this.bottomMargin + n3, n4, this.bottomMargin, false);
        }
        if (this.clientAreaHeight - this.bottomMargin < n2 + n5 && this.clientAreaHeight > n2) {
            super.redraw(this.leftMargin, this.clientAreaHeight - this.bottomMargin, n4, this.bottomMargin, false);
        }
    }

    public void selectAll() {
        this.checkWidget();
        this.setSelection(0, Math.max(this.getCharCount(), 0));
    }

    void sendKeyEvent(Event event) {
        if (this.editable) {
            this.modifyContent(event, true);
        }
    }

    StyledTextEvent sendLineEvent(int n, int n2, String string) {
        StyledTextEvent styledTextEvent = null;
        if (this.isListening(n)) {
            styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.detail = n2;
            styledTextEvent.text = string;
            styledTextEvent.alignment = this.alignment;
            styledTextEvent.indent = this.indent;
            styledTextEvent.justify = this.justify;
            this.notifyListeners(n, styledTextEvent);
        }
        return styledTextEvent;
    }

    void sendModifyEvent(Event event) {
        Accessible accessible = this.getAccessible();
        if (event.text.length() == 0) {
            accessible.textChanged(1, event.start, event.end - event.start);
        } else if (event.start == event.end) {
            accessible.textChanged(0, event.start, event.text.length());
        } else {
            accessible.textChanged(1, event.start, event.end - event.start);
            accessible.textChanged(0, event.start, event.text.length());
        }
        this.notifyListeners(24, event);
    }

    void sendSelectionEvent() {
        this.getAccessible().textSelectionChanged();
        Event event = new Event();
        event.x = this.selection.x;
        event.y = this.selection.y;
        this.notifyListeners(13, event);
    }

    int sendWordBoundaryEvent(int n, int n2, int n3, int n4, String string, int n5) {
        if (this.isListening(n)) {
            StyledTextEvent styledTextEvent = new StyledTextEvent(this.content);
            styledTextEvent.detail = n5;
            styledTextEvent.text = string;
            styledTextEvent.count = n2;
            styledTextEvent.start = n3;
            styledTextEvent.end = n4;
            this.notifyListeners(n, styledTextEvent);
            n3 = styledTextEvent.end;
            if (n3 != n4) {
                int n6 = this.getCharCount();
                if (n3 < 0) {
                    n3 = 0;
                } else if (n3 > n6) {
                    n3 = n6;
                } else if (this.isLineDelimiter(n3)) {
                    SWT.error(5);
                }
            }
            return n3;
        }
        return n4;
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n &= 0x1024000) == 0 || this.alignment == n) {
            return;
        }
        this.alignment = n;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.background = color;
        super.redraw();
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        super.setCaret(caret);
        this.caretDirection = 0;
        if (caret != null) {
            this.setCaretLocation();
        }
    }

    public void setBidiColoring(boolean bl) {
        this.checkWidget();
        this.bidiColoring = bl;
    }

    void setCaretLocation() {
        Point point = this.getPointAtOffset(this.caretOffset);
        this.setCaretLocation(point, this.getCaretDirection());
    }

    void setCaretLocation(Point point, int n) {
        Caret caret = this.getCaret();
        if (caret != null) {
            int n2;
            boolean bl = caret == this.defaultCaret;
            int n3 = n2 = this.renderer.getLineHeight();
            if (!this.isFixedLineHeight() && bl && (n3 = this.getBoundsAtOffset((int)this.caretOffset).height) != n2) {
                n = -1;
            }
            int n4 = n;
            if (this.isMirrored()) {
                if (n4 == 16384) {
                    n4 = 131072;
                } else if (n4 == 131072) {
                    n4 = 16384;
                }
            }
            if (bl && n4 == 131072) {
                point.x -= caret.getSize().x - 1;
            }
            if (bl) {
                caret.setBounds(point.x, point.y, 0, n3);
            } else {
                caret.setLocation(point);
            }
            this.getAccessible().textCaretMoved(this.getCaretOffset());
            if (n != this.caretDirection) {
                this.caretDirection = n;
                if (bl) {
                    if (n4 == -1) {
                        this.defaultCaret.setImage(null);
                    } else if (n4 == 16384) {
                        this.defaultCaret.setImage(this.leftCaretBitmap);
                    } else if (n4 == 131072) {
                        this.defaultCaret.setImage(this.rightCaretBitmap);
                    }
                }
                if (this.caretDirection == 16384) {
                    BidiUtil.setKeyboardLanguage(0);
                } else if (this.caretDirection == 131072) {
                    BidiUtil.setKeyboardLanguage(1);
                }
            }
        }
        this.columnX = point.x;
    }

    public void setCaretOffset(int n) {
        this.checkWidget();
        int n2 = this.getCharCount();
        if (n2 > 0 && n != this.caretOffset) {
            if (n < 0) {
                this.caretOffset = 0;
            } else if (n > n2) {
                this.caretOffset = n2;
            } else {
                if (this.isLineDelimiter(n)) {
                    SWT.error(5);
                }
                this.caretOffset = n;
            }
            this.clearSelection(false);
        }
        this.setCaretLocation();
    }

    void setClipboardContent(int n, int n2, int n3) throws SWTError {
        Transfer[] transferArray;
        Object[] objectArray;
        if (n3 == 2 && !IS_MOTIF && !IS_GTK) {
            return;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        TextWriter textWriter = new TextWriter(n, n2);
        String string = this.getPlatformDelimitedText(textWriter);
        if (n3 == 2) {
            objectArray = new Object[]{string};
            transferArray = new Transfer[]{textTransfer};
        } else {
            RTFTransfer rTFTransfer = RTFTransfer.getInstance();
            RTFWriter rTFWriter = new RTFWriter(n, n2);
            String string2 = this.getPlatformDelimitedText(rTFWriter);
            objectArray = new Object[]{string2, string};
            transferArray = new Transfer[]{rTFTransfer, textTransfer};
        }
        this.clipboard.setContents(objectArray, transferArray, n3);
    }

    public void setContent(StyledTextContent styledTextContent) {
        this.checkWidget();
        if (styledTextContent == null) {
            SWT.error(4);
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
        }
        this.content = styledTextContent;
        this.content.addTextChangeListener(this.textChangeListener);
        this.reset();
    }

    public void setCursor(Cursor cursor) {
        if (cursor == null) {
            Display display = this.getDisplay();
            super.setCursor(display.getSystemCursor(19));
        } else {
            super.setCursor(cursor);
        }
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClickEnabled = bl;
    }

    public void setDragDetect(boolean bl) {
        this.checkWidget();
        this.dragDetect = bl;
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.editable = bl;
    }

    public void setFont(Font font) {
        int n;
        this.checkWidget();
        int n2 = this.renderer.getLineHeight();
        super.setFont(font);
        this.renderer.setFont(this.getFont(), this.tabLength);
        if (this.isFixedLineHeight() && (n = this.renderer.getLineHeight()) != n2) {
            int n3 = this.getVerticalScrollOffset() * n / n2 - this.getVerticalScrollOffset();
            this.scrollVertical(n3, true);
        }
        this.resetCache(0, this.content.getLineCount());
        this.claimBottomFreeSpace();
        this.calculateScrollBars();
        if (this.isBidiCaret()) {
            this.createCaretBitmaps();
        }
        this.caretDirection = 0;
        this.setCaretLocation();
        super.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.foreground = color;
        super.setForeground(this.getForeground());
        super.redraw();
    }

    public void setHorizontalIndex(int n) {
        int n2;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (this.clientAreaWidth > 0 && (n *= this.getHorizontalIncrement()) > (n2 = this.renderer.getWidth()) - this.clientAreaWidth) {
            n = Math.max(0, n2 - this.clientAreaWidth);
        }
        this.scrollHorizontal(n - this.horizontalScrollOffset, true);
    }

    public void setHorizontalPixel(int n) {
        int n2;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (this.clientAreaWidth > 0 && n > (n2 = this.renderer.getWidth()) - this.clientAreaWidth) {
            n = Math.max(0, n2 - this.clientAreaWidth);
        }
        this.scrollHorizontal(n - this.horizontalScrollOffset, true);
    }

    public void setIndent(int n) {
        this.checkWidget();
        if (this.indent == n || n < 0) {
            return;
        }
        this.indent = n;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setJustify(boolean bl) {
        this.checkWidget();
        if (this.justify == bl) {
            return;
        }
        this.justify = bl;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    public void setKeyBinding(int n, int n2) {
        this.checkWidget();
        int n3 = n & SWT.MODIFIER_MASK;
        char c = (char)(n & 0x100FFFF);
        if (Compatibility.isLetter(c)) {
            char c2 = Character.toUpperCase(c);
            int n4 = c2 | n3;
            if (n2 == 0) {
                this.keyActionMap.remove(new Integer(n4));
            } else {
                this.keyActionMap.put(new Integer(n4), new Integer(n2));
            }
            c2 = Character.toLowerCase(c);
            n4 = c2 | n3;
            if (n2 == 0) {
                this.keyActionMap.remove(new Integer(n4));
            } else {
                this.keyActionMap.put(new Integer(n4), new Integer(n2));
            }
        } else if (n2 == 0) {
            this.keyActionMap.remove(new Integer(n));
        } else {
            this.keyActionMap.put(new Integer(n), new Integer(n2));
        }
    }

    public void setLineAlignment(int n, int n2, int n3) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineAlignment(n, n2, n3);
        this.resetCache(n, n2);
        this.redrawLines(n, n2);
        int n4 = this.getCaretLine();
        if (n <= n4 && n4 < n + n2) {
            this.setCaretLocation();
        }
    }

    public void setLineBackground(int n, int n2, Color color) {
        this.checkWidget();
        if (this.isListening(3001)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        if (color != null) {
            this.renderer.setLineBackground(n, n2, color);
        } else {
            this.renderer.clearLineBackground(n, n2);
        }
        this.redrawLines(n, n2);
    }

    public void setLineBullet(int n, int n2, Bullet bullet) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineBullet(n, n2, bullet);
        this.resetCache(n, n2);
        this.redrawLines(n, n2);
        int n3 = this.getCaretLine();
        if (n <= n3 && n3 < n + n2) {
            this.setCaretLocation();
        }
    }

    void setVariableLineHeight() {
        if (!this.fixedLineHeight) {
            return;
        }
        this.fixedLineHeight = false;
        this.renderer.calculateIdle();
    }

    public void setLineIndent(int n, int n2, int n3) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineIndent(n, n2, n3);
        this.resetCache(n, n2);
        this.redrawLines(n, n2);
        int n4 = this.getCaretLine();
        if (n <= n4 && n4 < n + n2) {
            this.setCaretLocation();
        }
    }

    public void setLineJustify(int n, int n2, boolean bl) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (n < 0 || n + n2 > this.content.getLineCount()) {
            SWT.error(5);
        }
        this.renderer.setLineJustify(n, n2, bl);
        this.resetCache(n, n2);
        this.redrawLines(n, n2);
        int n3 = this.getCaretLine();
        if (n <= n3 && n3 < n + n2) {
            this.setCaretLocation();
        }
    }

    public void setLineSpacing(int n) {
        this.checkWidget();
        if (this.lineSpacing == n || n < 0) {
            return;
        }
        this.lineSpacing = n;
        this.setVariableLineHeight();
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        super.redraw();
    }

    void setMargins(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.leftMargin = n;
        this.topMargin = n2;
        this.rightMargin = n3;
        this.bottomMargin = n4;
        this.setCaretLocation();
    }

    void setMouseWordSelectionAnchor() {
        if (this.clickCount > 1) {
            if (this.caretOffset < this.doubleClickSelection.x) {
                this.selectionAnchor = this.doubleClickSelection.y;
            } else if (this.caretOffset > this.doubleClickSelection.y) {
                this.selectionAnchor = this.doubleClickSelection.x;
            }
        }
    }

    public void setOrientation(int n) {
        if ((n & 0x6000000) == 0) {
            return;
        }
        if ((n & 0x4000000) != 0 && (n & 0x2000000) != 0) {
            return;
        }
        if ((n & 0x4000000) != 0 && this.isMirrored()) {
            return;
        }
        if ((n & 0x2000000) != 0 && !this.isMirrored()) {
            return;
        }
        if (!BidiUtil.setOrientation(this.handle, n)) {
            return;
        }
        this.isMirrored = (n & 0x4000000) != 0;
        this.caretDirection = 0;
        this.resetCache(0, this.content.getLineCount());
        this.setCaretLocation();
        this.keyActionMap.clear();
        this.createKeyBindings();
        super.redraw();
    }

    void setScrollBars(boolean bl) {
        int n;
        ScrollBar scrollBar;
        int n2 = 1;
        if ((bl || !this.isFixedLineHeight()) && (scrollBar = this.getVerticalBar()) != null) {
            n = this.renderer.getHeight();
            if (this.clientAreaHeight < n) {
                scrollBar.setMaximum(n);
                scrollBar.setThumb(this.clientAreaHeight);
                scrollBar.setPageIncrement(this.clientAreaHeight);
            } else if (scrollBar.getThumb() != n2 || scrollBar.getMaximum() != n2) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n2, n2, scrollBar.getIncrement(), n2);
            }
        }
        if ((scrollBar = this.getHorizontalBar()) != null && scrollBar.getVisible()) {
            n = this.renderer.getWidth();
            if (this.clientAreaWidth < n) {
                scrollBar.setMaximum(n);
                scrollBar.setThumb(this.clientAreaWidth - this.leftMargin - this.rightMargin);
                scrollBar.setPageIncrement(this.clientAreaWidth - this.leftMargin - this.rightMargin);
            } else if (scrollBar.getThumb() != n2 || scrollBar.getMaximum() != n2) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n2, n2, scrollBar.getIncrement(), n2);
            }
        }
    }

    public void setSelection(int n) {
        this.setSelection(n, n);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionBackground = color;
        super.redraw();
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionForeground = color;
        super.redraw();
    }

    public void setSelection(int n, int n2) {
        this.setSelectionRange(n, n2 - n);
        this.showSelection();
    }

    void setSelection(int n, int n2, boolean bl) {
        int n3 = n + n2;
        if (n > n3) {
            int n4 = n3;
            n3 = n;
            n = n4;
        }
        if (this.selection.x != n || this.selection.y != n3 || n2 > 0 && this.selectionAnchor != this.selection.x || n2 < 0 && this.selectionAnchor != this.selection.y) {
            this.clearSelection(bl);
            if (n2 < 0) {
                this.selectionAnchor = this.selection.y = n3;
                this.caretOffset = this.selection.x = n;
            } else {
                this.selectionAnchor = this.selection.x = n;
                this.caretOffset = this.selection.y = n3;
            }
            this.internalRedrawRange(this.selection.x, this.selection.y - this.selection.x);
        }
    }

    public void setSelectionRange(int n, int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        n = Math.max(0, Math.min(n, n3));
        int n4 = n + n2;
        if (n4 < 0) {
            n2 = -n;
        } else if (n4 > n3) {
            n2 = n3 - n;
        }
        if (this.isLineDelimiter(n) || this.isLineDelimiter(n + n2)) {
            SWT.error(5);
        }
        this.setSelection(n, n2, false);
        this.setCaretLocation();
    }

    public void setStyleRange(StyleRange styleRange) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRange != null) {
            if (styleRange.isUnstyled()) {
                this.setStyleRanges(styleRange.start, styleRange.length, null, null, false);
            } else {
                this.setStyleRanges(styleRange.start, 0, null, new StyleRange[]{styleRange}, false);
            }
        } else {
            this.setStyleRanges(0, 0, null, null, true);
        }
    }

    public void setStyleRanges(int n, int n2, int[] nArray, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (nArray == null || styleRangeArray == null) {
            this.setStyleRanges(n, n2, null, null, false);
        } else {
            this.setStyleRanges(n, n2, nArray, styleRangeArray, false);
        }
    }

    public void setStyleRanges(int[] nArray, StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (nArray == null || styleRangeArray == null) {
            this.setStyleRanges(0, 0, null, null, true);
        } else {
            this.setStyleRanges(0, 0, nArray, styleRangeArray, true);
        }
    }

    void setStyleRanges(int n, int n2, int[] nArray, StyleRange[] styleRangeArray, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.content.getCharCount();
        int n10 = n + n2;
        if (n > n10 || n < 0) {
            SWT.error(6);
        }
        if (styleRangeArray != null) {
            if (n10 > n9) {
                SWT.error(6);
            }
            if (nArray != null && nArray.length != styleRangeArray.length << 1) {
                SWT.error(5);
            }
            n8 = 0;
            n7 = 0;
            n6 = 0;
            while (n6 < styleRangeArray.length) {
                if (styleRangeArray[n6] == null) {
                    SWT.error(5);
                }
                if (nArray != null) {
                    n5 = nArray[n6 << 1];
                    n4 = nArray[(n6 << 1) + 1];
                } else {
                    n5 = styleRangeArray[n6].start;
                    n4 = styleRangeArray[n6].length;
                }
                if (n4 < 0) {
                    SWT.error(5);
                }
                if (n5 < 0 || n5 + n4 > n9) {
                    SWT.error(5);
                }
                if (n8 > n5) {
                    SWT.error(5);
                }
                n7 |= styleRangeArray[n6].isVariableHeight();
                n8 = n5 + n4;
                ++n6;
            }
            if (n7 != 0) {
                this.setVariableLineHeight();
            }
        }
        n8 = n;
        n7 = n10;
        if (styleRangeArray != null && styleRangeArray.length > 0) {
            if (nArray != null) {
                n8 = nArray[0];
                n7 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
            } else {
                n8 = styleRangeArray[0].start;
                n7 = styleRangeArray[styleRangeArray.length - 1].start + styleRangeArray[styleRangeArray.length - 1].length;
            }
        }
        n6 = 0;
        if (!this.isFixedLineHeight() && !bl) {
            n5 = this.content.getLineAtOffset(Math.max(n10, n7));
            n4 = this.getPartialTopIndex();
            n3 = this.getPartialBottomIndex();
            if (n4 <= n5 && n5 <= n3) {
                n6 = this.getLinePixel(n5 + 1);
            }
        }
        if (bl) {
            this.renderer.setStyleRanges(null, null);
        } else {
            this.renderer.updateRanges(n, n2, n2);
        }
        if (styleRangeArray != null && styleRangeArray.length > 0) {
            this.renderer.setStyleRanges(nArray, styleRangeArray);
        }
        if (bl) {
            this.resetCache(0, this.content.getLineCount());
            super.redraw();
        } else {
            n5 = this.content.getLineAtOffset(Math.min(n, n8));
            n4 = this.content.getLineAtOffset(Math.max(n10, n7));
            this.resetCache(n5, n4 - n5 + 1);
            n3 = this.getPartialTopIndex();
            int n11 = this.getPartialBottomIndex();
            if (n5 <= n11 && n4 >= n3) {
                int n12;
                int n13 = 0;
                int n14 = this.clientAreaHeight;
                if (n3 <= n5 && n5 <= n11) {
                    n13 = n12 = Math.max(n13, this.getLinePixel(n5));
                    n14 -= n12;
                }
                if (n3 <= n4 && n4 <= n11) {
                    n12 = this.getLinePixel(n4 + 1);
                    if (!this.isFixedLineHeight()) {
                        this.scrollText(n6, n12);
                    }
                    n14 = n12 - n13;
                }
                super.redraw(0, n13, this.clientAreaWidth, n14, false);
            }
        }
        this.setCaretLocation();
    }

    public void setStyleRanges(StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.isListening(3002)) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        this.setStyleRanges(0, 0, null, styleRangeArray, true);
    }

    public void setTabs(int n) {
        this.checkWidget();
        this.tabLength = n;
        this.renderer.setFont(null, n);
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            this.showCaret();
            this.clearSelection(false);
        }
        this.resetCache(0, this.content.getLineCount());
        super.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        Event event = new Event();
        event.start = 0;
        event.end = this.getCharCount();
        event.text = string;
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.content);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, event.end - event.start);
            }
            this.content.setText(event.text);
            this.sendModifyEvent(event);
            if (styledTextEvent != null) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            SWT.error(7);
        }
        this.textLimit = n;
    }

    public void setTopIndex(int n) {
        int n2;
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        int n3 = this.content.getLineCount();
        if (this.isFixedLineHeight()) {
            int n4 = Math.max(1, Math.min(n3, this.getLineCountWhole()));
            if (n < 0) {
                n = 0;
            } else if (n > n3 - n4) {
                n = n3 - n4;
            }
            n2 = this.getLinePixel(n);
        } else {
            n2 = this.getLinePixel(n = Math.max(0, Math.min(n3 - 1, n)));
            n2 = n2 > 0 ? this.getAvailableHeightBellow(n2) : this.getAvailableHeightAbove(n2);
        }
        this.scrollVertical(n2, true);
    }

    public void setTopPixel(int n) {
        this.checkWidget();
        if (this.getCharCount() == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = this.content.getLineCount();
        int n3 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        int n4 = this.getVerticalScrollOffset();
        if (this.isFixedLineHeight()) {
            int n5 = Math.max(0, n2 * this.getVerticalIncrement() - n3);
            if (n > n5) {
                n = n5;
            }
            n -= n4;
        } else if ((n -= n4) > 0) {
            n = this.getAvailableHeightBellow(n);
        }
        this.scrollVertical(n, true);
    }

    public void setWordWrap(boolean bl) {
        this.checkWidget();
        if ((this.getStyle() & 4) != 0) {
            return;
        }
        if (this.wordWrap == bl) {
            return;
        }
        this.wordWrap = bl;
        this.setVariableLineHeight();
        this.resetCache(0, this.content.getLineCount());
        this.horizontalScrollOffset = 0;
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setVisible(!this.wordWrap);
        }
        this.setScrollBars(true);
        this.setCaretLocation();
        super.redraw();
    }

    boolean showLocation(Rectangle rectangle, boolean bl) {
        int n = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        int n2 = this.clientAreaHeight - this.topMargin - this.bottomMargin;
        boolean bl2 = false;
        if (rectangle.y <= this.topMargin) {
            bl2 = this.scrollVertical(rectangle.y - this.topMargin, true);
        } else if (rectangle.y + rectangle.height > n2) {
            bl2 = n2 == 0 ? this.scrollVertical(rectangle.y, true) : this.scrollVertical(rectangle.y + rectangle.height - n2, true);
        }
        if (n > 0) {
            int n3;
            int n4 = n3 = bl ? n / 4 : 0;
            if (rectangle.x < this.leftMargin) {
                int n5 = Math.max(this.leftMargin - rectangle.x, n3);
                int n6 = this.horizontalScrollOffset;
                bl2 = this.scrollHorizontal(-Math.min(n6, n5), true);
            } else if (rectangle.x + rectangle.width > n) {
                int n7 = Math.max(rectangle.x + rectangle.width - n, n3);
                int n8 = this.renderer.getWidth() - this.horizontalScrollOffset - this.clientAreaWidth;
                bl2 = this.scrollHorizontal(Math.min(n8, n7), true);
            }
        }
        return bl2;
    }

    void showCaret() {
        Rectangle rectangle = this.getBoundsAtOffset(this.caretOffset);
        if (!this.showLocation(rectangle, true)) {
            this.setCaretLocation();
        }
    }

    public void showSelection() {
        boolean bl;
        int n;
        int n2;
        boolean bl2;
        this.checkWidget();
        boolean bl3 = bl2 = this.caretOffset == this.selection.x;
        if (bl2) {
            n2 = this.selection.y;
            n = this.selection.x;
        } else {
            n2 = this.selection.x;
            n = this.selection.y;
        }
        Rectangle rectangle = this.getBoundsAtOffset(n2);
        Rectangle rectangle2 = this.getBoundsAtOffset(n);
        int n3 = this.clientAreaWidth - this.leftMargin - this.rightMargin;
        boolean bl4 = bl2 ? rectangle.x - rectangle2.x <= n3 : (bl = rectangle2.x - rectangle.x <= n3);
        if (bl) {
            if (this.showLocation(rectangle, false)) {
                rectangle2 = this.getBoundsAtOffset(n);
            }
            rectangle2.width = 0;
            this.showLocation(rectangle2, false);
        } else {
            this.showLocation(rectangle2, true);
        }
    }

    void updateSelection(int n, int n2, int n3) {
        if (this.selection.y <= n) {
            return;
        }
        if (this.selection.x < n) {
            this.internalRedrawRange(this.selection.x, n - this.selection.x);
        }
        if (this.selection.y > n + n2 && this.selection.x < n + n2) {
            int n4 = n3 - n2;
            int n5 = n + n3;
            this.internalRedrawRange(n5, this.selection.y + n4 - n5);
        }
        if (this.selection.y > n && this.selection.x < n + n2) {
            this.setSelection(n + n3, 0, true);
        } else {
            this.setSelection(this.selection.x + n3 - n2, this.selection.y - this.selection.x, true);
        }
        this.setCaretLocation();
    }

    static class Printing
    implements Runnable {
        static final int LEFT = 0;
        static final int CENTER = 1;
        static final int RIGHT = 2;
        Printer printer;
        StyledTextRenderer printerRenderer;
        StyledTextPrintOptions printOptions;
        Rectangle clientArea;
        FontData fontData;
        Font printerFont;
        Hashtable resources;
        int tabLength;
        GC gc;
        int pageWidth;
        int startPage;
        int endPage;
        int startLine;
        int endLine;
        boolean singleLine;
        Point selection = null;
        boolean mirrored;
        int lineSpacing;
        int printMargin;

        Printing(StyledText styledText, Printer printer, StyledTextPrintOptions styledTextPrintOptions) {
            this.printer = printer;
            this.printOptions = styledTextPrintOptions;
            this.mirrored = (styledText.getStyle() & 0x8000000) != 0;
            this.singleLine = styledText.isSingleLine();
            this.startPage = 1;
            this.endPage = Integer.MAX_VALUE;
            PrinterData printerData = printer.getPrinterData();
            if (printerData.scope == 1) {
                this.startPage = printerData.startPage;
                this.endPage = printerData.endPage;
                if (this.endPage < this.startPage) {
                    int n = this.endPage;
                    this.endPage = this.startPage;
                    this.startPage = n;
                }
            } else if (printerData.scope == 2) {
                this.selection = styledText.getSelectionRange();
            }
            this.printerRenderer = new StyledTextRenderer(printer, null);
            this.printerRenderer.setContent(this.copyContent(styledText.getContent()));
            this.cacheLineData(styledText);
        }

        void cacheLineData(StyledText styledText) {
            Object object;
            int n;
            Object object2;
            StyledTextRenderer styledTextRenderer = styledText.renderer;
            styledTextRenderer.copyInto(this.printerRenderer);
            this.fontData = styledText.getFont().getFontData()[0];
            this.tabLength = styledText.tabLength;
            int n2 = this.printerRenderer.lineCount;
            if (styledText.isListening(3001) || styledText.isBidi() && styledText.isListening(3007) || styledText.isListening(3002)) {
                object2 = this.printerRenderer.content;
                int n3 = 0;
                while (n3 < n2) {
                    String string = object2.getLine(n3);
                    n = object2.getOffsetAtLine(n3);
                    StyledTextEvent styledTextEvent = styledText.getLineBackgroundData(n, string);
                    if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
                        this.printerRenderer.setLineBackground(n3, 1, styledTextEvent.lineBackground);
                    }
                    if (styledText.isBidi()) {
                        object = styledText.getBidiSegments(n, string);
                        this.printerRenderer.setLineSegments(n3, 1, (int[])object);
                    }
                    if ((styledTextEvent = styledText.getLineStyleData(n, string)) != null) {
                        this.printerRenderer.setLineIndent(n3, 1, styledTextEvent.indent);
                        this.printerRenderer.setLineAlignment(n3, 1, styledTextEvent.alignment);
                        this.printerRenderer.setLineJustify(n3, 1, styledTextEvent.justify);
                        this.printerRenderer.setLineBullet(n3, 1, styledTextEvent.bullet);
                        object = styledTextEvent.styles;
                        if (object != null && ((Object)object).length > 0) {
                            this.printerRenderer.setStyleRanges(styledTextEvent.ranges, (StyleRange[])object);
                        }
                    }
                    ++n3;
                }
            }
            object2 = styledText.getDisplay().getDPI();
            Point point = this.printer.getDPI();
            this.resources = new Hashtable();
            int n4 = 0;
            while (n4 < n2) {
                int n5;
                Color color = this.printerRenderer.getLineBackground(n4, null);
                if (color != null) {
                    if (this.printOptions.printLineBackground) {
                        Color color2 = (Color)this.resources.get(color);
                        if (color2 == null) {
                            color2 = new Color(this.printer, color.getRGB());
                            this.resources.put(color, color2);
                        }
                        this.printerRenderer.setLineBackground(n4, 1, color2);
                    } else {
                        this.printerRenderer.setLineBackground(n4, 1, null);
                    }
                }
                if ((n5 = this.printerRenderer.getLineIndent(n4, 0)) != 0) {
                    this.printerRenderer.setLineIndent(n4, 1, n5 * point.x / ((Point)object2).x);
                }
                ++n4;
            }
            StyleRange[] styleRangeArray = this.printerRenderer.styles;
            n = 0;
            while (n < this.printerRenderer.styleCount) {
                Object object3;
                Resource resource;
                StyleRange styleRange = styleRangeArray[n];
                object = styleRange.font;
                if (styleRange.font != null) {
                    resource = (Font)this.resources.get(object);
                    if (resource == null) {
                        resource = new Font((Device)this.printer, ((Font)object).getFontData());
                        this.resources.put(object, resource);
                    }
                    styleRange.font = resource;
                }
                if ((resource = styleRange.foreground) != null) {
                    object3 = (Color)this.resources.get(resource);
                    if (this.printOptions.printTextForeground) {
                        if (object3 == null) {
                            object3 = new Color(this.printer, ((Color)resource).getRGB());
                            this.resources.put(resource, object3);
                        }
                        styleRange.foreground = object3;
                    } else {
                        styleRange.foreground = null;
                    }
                }
                if ((resource = styleRange.background) != null) {
                    object3 = (Color)this.resources.get(resource);
                    if (this.printOptions.printTextBackground) {
                        if (object3 == null) {
                            object3 = new Color(this.printer, ((Color)resource).getRGB());
                            this.resources.put(resource, object3);
                        }
                        styleRange.background = object3;
                    } else {
                        styleRange.background = null;
                    }
                }
                if (!this.printOptions.printTextFontStyle) {
                    styleRange.fontStyle = 0;
                }
                styleRange.rise = styleRange.rise * point.y / ((Point)object2).y;
                object3 = styleRange.metrics;
                if (object3 != null) {
                    ((GlyphMetrics)object3).ascent = ((GlyphMetrics)object3).ascent * point.y / ((Point)object2).y;
                    ((GlyphMetrics)object3).descent = ((GlyphMetrics)object3).descent * point.y / ((Point)object2).y;
                    ((GlyphMetrics)object3).width = ((GlyphMetrics)object3).width * point.x / ((Point)object2).x;
                }
                ++n;
            }
            this.lineSpacing = styledText.lineSpacing * point.y / ((Point)object2).y;
            if (this.printOptions.printLineNumbers) {
                this.printMargin = 3 * point.x / ((Point)object2).x;
            }
        }

        StyledTextContent copyContent(StyledTextContent styledTextContent) {
            DefaultContent defaultContent = new DefaultContent();
            int n = 0;
            int n2 = 0;
            while (n2 < styledTextContent.getLineCount()) {
                int n3 = n2 < styledTextContent.getLineCount() - 1 ? styledTextContent.getOffsetAtLine(n2 + 1) : styledTextContent.getCharCount();
                defaultContent.replaceTextRange(n, 0, styledTextContent.getTextRange(n, n3 - n));
                n = n3;
                ++n2;
            }
            return defaultContent;
        }

        void dispose() {
            if (this.gc != null) {
                this.gc.dispose();
                this.gc = null;
            }
            if (this.resources != null) {
                Enumeration enumeration = this.resources.elements();
                while (enumeration.hasMoreElements()) {
                    Resource resource = (Resource)enumeration.nextElement();
                    resource.dispose();
                }
                this.resources = null;
            }
            if (this.printerFont != null) {
                this.printerFont.dispose();
                this.printerFont = null;
            }
            if (this.printerRenderer != null) {
                this.printerRenderer.dispose();
                this.printerRenderer = null;
            }
        }

        void init() {
            Rectangle rectangle = this.printer.computeTrim(0, 0, 0, 0);
            Point point = this.printer.getDPI();
            this.printerFont = new Font((Device)this.printer, this.fontData.getName(), this.fontData.getHeight(), 0);
            this.clientArea = this.printer.getClientArea();
            this.pageWidth = this.clientArea.width;
            this.clientArea.x = point.x + rectangle.x;
            this.clientArea.y = point.y + rectangle.y;
            this.clientArea.width -= this.clientArea.x + rectangle.width;
            this.clientArea.height -= this.clientArea.y + rectangle.height;
            int n = this.mirrored ? 0x4000000 : 0x2000000;
            this.gc = new GC(this.printer, n);
            this.gc.setFont(this.printerFont);
            this.printerRenderer.setFont(this.printerFont, this.tabLength);
            int n2 = this.printerRenderer.getLineHeight();
            if (this.printOptions.header != null) {
                this.clientArea.y += n2 * 2;
                this.clientArea.height -= n2 * 2;
            }
            if (this.printOptions.footer != null) {
                this.clientArea.height -= n2 * 2;
            }
            StyledTextContent styledTextContent = this.printerRenderer.content;
            this.startLine = 0;
            this.endLine = this.singleLine ? 0 : styledTextContent.getLineCount() - 1;
            PrinterData printerData = this.printer.getPrinterData();
            if (printerData.scope == 1) {
                int n3 = this.clientArea.height / n2;
                this.startLine = (this.startPage - 1) * n3;
            } else if (printerData.scope == 2) {
                this.startLine = styledTextContent.getLineAtOffset(this.selection.x);
                this.endLine = this.selection.y > 0 ? styledTextContent.getLineAtOffset(this.selection.x + this.selection.y - 1) : this.startLine - 1;
            }
        }

        void print() {
            Object object;
            int n;
            Color color = this.gc.getBackground();
            Color color2 = this.gc.getForeground();
            int n2 = this.clientArea.y;
            int n3 = this.clientArea.x;
            int n4 = this.clientArea.width;
            int n5 = this.startPage;
            int n6 = this.clientArea.y + this.clientArea.height;
            int n7 = this.gc.getStyle() & 0x6000000;
            TextLayout textLayout = null;
            if (this.printOptions.printLineNumbers || this.printOptions.header != null || this.printOptions.footer != null) {
                textLayout = new TextLayout(this.printer);
                textLayout.setFont(this.printerFont);
            }
            if (this.printOptions.printLineNumbers) {
                n = this.endLine - this.startLine + 1;
                object = new StringBuffer("0");
                while ((n /= 10) > 0) {
                    ((StringBuffer)object).append("0");
                }
                textLayout.setText(((StringBuffer)object).toString());
                int n8 = textLayout.getBounds().width + this.printMargin;
                if (n8 > n4) {
                    n8 = n4;
                }
                n3 += n8;
                n4 -= n8;
            }
            n = this.startLine;
            while (n <= this.endLine && n5 <= this.endPage) {
                if (n2 == this.clientArea.y) {
                    this.printer.startPage();
                    this.printDecoration(n5, true, textLayout);
                }
                object = this.printerRenderer.getTextLayout(n, n7, n4, this.lineSpacing);
                Color color3 = this.printerRenderer.getLineBackground(n, color);
                int n9 = n2 + ((TextLayout)object).getBounds().height;
                if (n9 <= n6) {
                    this.printLine(n3, n2, this.gc, color2, color3, (TextLayout)object, textLayout, n);
                    n2 = n9;
                } else {
                    int n10 = ((TextLayout)object).getLineCount();
                    while (n9 > n6 && n10 > 0) {
                        n9 -= ((TextLayout)object).getLineBounds((int)(--n10)).height + ((TextLayout)object).getSpacing();
                    }
                    if (n10 == 0) {
                        this.printDecoration(n5, false, textLayout);
                        this.printer.endPage();
                        if (++n5 <= this.endPage) {
                            this.printer.startPage();
                            this.printDecoration(n5, true, textLayout);
                            n2 = this.clientArea.y;
                            this.printLine(n3, n2, this.gc, color2, color3, (TextLayout)object, textLayout, n);
                            n2 += ((TextLayout)object).getBounds().height;
                        }
                    } else {
                        int n11 = n9 - n2;
                        this.gc.setClipping(n3, n2, n4, n11);
                        this.printLine(n3, n2, this.gc, color2, color3, (TextLayout)object, textLayout, n);
                        this.printDecoration(n5, false, textLayout);
                        this.printer.endPage();
                        if (++n5 <= this.endPage) {
                            this.printer.startPage();
                            this.printDecoration(n5, true, textLayout);
                            n2 = this.clientArea.y - n11;
                            int n12 = ((TextLayout)object).getBounds().height;
                            this.gc.setClipping(n3, this.clientArea.y, n4, n12 - n11);
                            this.printLine(n3, n2, this.gc, color2, color3, (TextLayout)object, textLayout, n);
                            n2 += n12;
                        }
                        this.gc.setClipping((Rectangle)null);
                    }
                }
                this.printerRenderer.disposeTextLayout((TextLayout)object);
                ++n;
            }
            if (n2 > this.clientArea.y) {
                this.printDecoration(n5, false, textLayout);
                this.printer.endPage();
            }
            if (textLayout != null) {
                textLayout.dispose();
            }
        }

        void printDecoration(int n, boolean bl, TextLayout textLayout) {
            String string;
            String string2 = string = bl ? this.printOptions.header : this.printOptions.footer;
            if (string == null) {
                return;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < 3) {
                String string3;
                int n4 = string.indexOf("\t", n2);
                if (n4 == -1) {
                    string3 = string.substring(n2);
                    this.printDecorationSegment(string3, n3, n, bl, textLayout);
                    break;
                }
                string3 = string.substring(n2, n4);
                this.printDecorationSegment(string3, n3, n, bl, textLayout);
                n2 = n4 + "\t".length();
                ++n3;
            }
        }

        void printDecorationSegment(String string, int n, int n2, boolean bl, TextLayout textLayout) {
            int n3;
            int n4 = string.indexOf("<page>");
            if (n4 != -1) {
                n3 = "<page>".length();
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, n4));
                stringBuffer.append(n2);
                stringBuffer.append(string.substring(n4 + n3));
                string = stringBuffer.toString();
            }
            if (string.length() > 0) {
                textLayout.setText(string);
                n3 = textLayout.getBounds().width;
                int n5 = this.printerRenderer.getLineHeight();
                int n6 = 0;
                if (n == 0) {
                    n6 = this.clientArea.x;
                } else if (n == 1) {
                    n6 = (this.pageWidth - n3) / 2;
                } else if (n == 2) {
                    n6 = this.clientArea.x + this.clientArea.width - n3;
                }
                int n7 = bl ? this.clientArea.y - n5 * 2 : this.clientArea.y + this.clientArea.height + n5;
                textLayout.draw(this.gc, n6, n7);
            }
        }

        void printLine(int n, int n2, GC gC, Color color, Color color2, TextLayout textLayout, TextLayout textLayout2, int n3) {
            Object object;
            if (color2 != null) {
                object = textLayout.getBounds();
                gC.setBackground(color2);
                gC.fillRectangle(n, n2, ((Rectangle)object).width, ((Rectangle)object).height);
            }
            if (this.printOptions.printLineNumbers) {
                object = textLayout.getLineMetrics(0);
                textLayout2.setAscent(((FontMetrics)object).getAscent() + ((FontMetrics)object).getDescent());
                textLayout2.setDescent(((FontMetrics)object).getDescent());
                textLayout2.setText(String.valueOf(n3));
                int n4 = n - this.printMargin - textLayout2.getBounds().width;
                textLayout2.draw(gC, n4, n2);
                textLayout2.setAscent(-1);
                textLayout2.setDescent(-1);
            }
            gC.setForeground(color);
            textLayout.draw(gC, n, n2);
        }

        public void run() {
            String string = this.printOptions.jobName;
            if (string == null) {
                string = "Printing";
            }
            if (this.printer.startJob(string)) {
                this.init();
                this.print();
                this.dispose();
                this.printer.endJob();
            }
        }
    }

    class RTFWriter
    extends TextWriter {
        static final int DEFAULT_FOREGROUND = 0;
        static final int DEFAULT_BACKGROUND = 1;
        Vector colorTable = new Vector();
        Vector fontTable = new Vector();
        boolean WriteUnicode;

        public RTFWriter(int n, int n2) {
            super(n, n2);
            this.colorTable.addElement(StyledText.this.getForeground());
            this.colorTable.addElement(StyledText.this.getBackground());
            this.fontTable.addElement(StyledText.this.getFont());
            this.setUnicode();
        }

        public void close() {
            if (!this.isClosed()) {
                this.writeHeader();
                this.write("\n}}\u0000");
                super.close();
            }
        }

        int getColorIndex(Color color, int n) {
            if (color == null) {
                return n;
            }
            int n2 = this.colorTable.indexOf(color);
            if (n2 == -1) {
                n2 = this.colorTable.size();
                this.colorTable.addElement(color);
            }
            return n2;
        }

        int getFontIndex(Font font) {
            int n = this.fontTable.indexOf(font);
            if (n == -1) {
                n = this.fontTable.size();
                this.fontTable.addElement(font);
            }
            return n;
        }

        void setUnicode() {
            int n;
            String string = System.getProperty("os.name").toLowerCase();
            String string2 = System.getProperty("os.version");
            int n2 = 0;
            if (string.startsWith("windows nt") && string2 != null && (n = string2.indexOf(46)) != -1) {
                string2 = string2.substring(0, n);
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.WriteUnicode = !string.startsWith("windows 95") && !string.startsWith("windows 98") && !string.startsWith("windows me") && (!string.startsWith("windows nt") || n2 > 4);
        }

        void write(String string, int n, int n2) {
            int n3 = n;
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c > '\u00ff' && this.WriteUnicode) {
                    if (n3 > n) {
                        this.write(string.substring(n, n3));
                    }
                    this.write("\\u");
                    this.write(Integer.toString((short)c));
                    this.write(' ');
                    n = n3 + 1;
                } else if (c == '}' || c == '{' || c == '\\') {
                    if (n3 > n) {
                        this.write(string.substring(n, n3));
                    }
                    this.write('\\');
                    this.write(c);
                    n = n3 + 1;
                }
                ++n3;
            }
            if (n < n2) {
                this.write(string.substring(n, n2));
            }
        }

        void writeHeader() {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            FontData fontData = StyledText.this.getFont().getFontData()[0];
            stringBuffer.append("{\\rtf1\\ansi");
            String string = System.getProperty("file.encoding").toLowerCase();
            if (string.startsWith("cp") || string.startsWith("ms")) {
                string = string.substring(2, string.length());
                stringBuffer.append("\\ansicpg");
                stringBuffer.append(string);
            }
            stringBuffer.append("\\uc0\\deff0{\\fonttbl{\\f0\\fnil ");
            stringBuffer.append(fontData.getName());
            stringBuffer.append(";");
            int n = 1;
            while (n < this.fontTable.size()) {
                stringBuffer.append("\\f");
                stringBuffer.append(n);
                stringBuffer.append(" ");
                object = ((Font)this.fontTable.elementAt(n)).getFontData()[0];
                stringBuffer.append(((FontData)object).getName());
                stringBuffer.append(";");
                ++n;
            }
            stringBuffer.append("}}\n{\\colortbl");
            n = 0;
            while (n < this.colorTable.size()) {
                object = (Color)this.colorTable.elementAt(n);
                stringBuffer.append("\\red");
                stringBuffer.append(((Color)object).getRed());
                stringBuffer.append("\\green");
                stringBuffer.append(((Color)object).getGreen());
                stringBuffer.append("\\blue");
                stringBuffer.append(((Color)object).getBlue());
                stringBuffer.append(";");
                ++n;
            }
            stringBuffer.append("}\n{\\f0\\fs");
            stringBuffer.append(fontData.getHeight() * 2);
            stringBuffer.append(" ");
            this.write(stringBuffer.toString(), 0);
        }

        public void writeLine(String string, int n) {
            StyleRange[] styleRangeArray;
            int[] nArray;
            boolean bl;
            int n2;
            int n3;
            if (this.isClosed()) {
                SWT.error(39);
            }
            int n4 = StyledText.this.content.getLineAtOffset(n);
            StyledTextEvent styledTextEvent = StyledText.this.getLineStyleData(n, string);
            if (styledTextEvent != null) {
                n3 = styledTextEvent.alignment;
                n2 = styledTextEvent.indent;
                bl = styledTextEvent.justify;
                nArray = styledTextEvent.ranges;
                styleRangeArray = styledTextEvent.styles;
            } else {
                n3 = StyledText.this.renderer.getLineAlignment(n4, StyledText.this.alignment);
                n2 = StyledText.this.renderer.getLineIndent(n4, StyledText.this.indent);
                bl = StyledText.this.renderer.getLineJustify(n4, StyledText.this.justify);
                nArray = StyledText.this.renderer.getRanges(n, string.length());
                styleRangeArray = StyledText.this.renderer.getStyleRanges(n, string.length(), false);
            }
            if (styleRangeArray == null) {
                styleRangeArray = new StyleRange[]{};
            }
            Color color = StyledText.this.renderer.getLineBackground(n4, null);
            styledTextEvent = StyledText.this.getLineBackgroundData(n, string);
            if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
                color = styledTextEvent.lineBackground;
            }
            this.writeStyledLine(string, n, nArray, styleRangeArray, color, n2, n3, bl);
        }

        public void writeLineDelimiter(String string) {
            if (this.isClosed()) {
                SWT.error(39);
            }
            this.write(string, 0, string.length());
            this.write("\\par ");
        }

        void writeStyledLine(String string, int n, int[] nArray, StyleRange[] styleRangeArray, Color color, int n2, int n3, boolean bl) {
            int n4 = string.length();
            int n5 = this.getStart();
            int n6 = n5 - n;
            if (n6 >= n4) {
                return;
            }
            int n7 = Math.max(0, n6);
            this.write("\\fi");
            this.write(n2);
            switch (n3) {
                case 16384: {
                    this.write("\\ql");
                    break;
                }
                case 0x1000000: {
                    this.write("\\qc");
                    break;
                }
                case 131072: {
                    this.write("\\qr");
                }
            }
            if (bl) {
                this.write("\\qj");
            }
            this.write(" ");
            if (color != null) {
                this.write("{\\highlight");
                this.write(this.getColorIndex(color, 1));
                this.write(" ");
            }
            int n8 = n5 + super.getCharCount();
            int n9 = Math.min(n4, n8 - n);
            int n10 = 0;
            while (n10 < styleRangeArray.length) {
                int n11;
                int n12;
                StyleRange styleRange = styleRangeArray[n10];
                if (nArray != null) {
                    n12 = nArray[n10 << 1] - n;
                    n11 = n12 + nArray[(n10 << 1) + 1];
                } else {
                    n12 = styleRange.start - n;
                    n11 = n12 + styleRange.length;
                }
                if (n11 >= n6) {
                    int n13;
                    Font font;
                    if (n12 >= n9) break;
                    if (n7 < n12) {
                        this.write(string, n7, n12);
                        n7 = n12;
                    }
                    this.write("{\\cf");
                    this.write(this.getColorIndex(styleRange.foreground, 0));
                    int n14 = this.getColorIndex(styleRange.background, 1);
                    if (n14 != 1) {
                        this.write("\\highlight");
                        this.write(n14);
                    }
                    if ((font = styleRange.font) != null) {
                        n13 = this.getFontIndex(font);
                        this.write("\\f");
                        this.write(n13);
                        FontData fontData = font.getFontData()[0];
                        this.write("\\fs");
                        this.write(fontData.getHeight() * 2);
                    } else {
                        if ((styleRange.fontStyle & 1) != 0) {
                            this.write("\\b");
                        }
                        if ((styleRange.fontStyle & 2) != 0) {
                            this.write("\\i");
                        }
                    }
                    if (styleRange.underline) {
                        this.write("\\ul");
                    }
                    if (styleRange.strikeout) {
                        this.write("\\strike");
                    }
                    this.write(" ");
                    n13 = Math.min(n11, n9);
                    n13 = Math.max(n13, n7);
                    this.write(string, n7, n13);
                    if (font == null) {
                        if ((styleRange.fontStyle & 1) != 0) {
                            this.write("\\b0");
                        }
                        if ((styleRange.fontStyle & 2) != 0) {
                            this.write("\\i0");
                        }
                    }
                    if (styleRange.underline) {
                        this.write("\\ul0");
                    }
                    if (styleRange.strikeout) {
                        this.write("\\strike0");
                    }
                    this.write("}");
                    n7 = n13;
                }
                ++n10;
            }
            if (n7 < n9) {
                this.write(string, n7, n9);
            }
            if (color != null) {
                this.write("}");
            }
        }
    }

    class TextWriter {
        private StringBuffer buffer;
        private int startOffset;
        private int endOffset;
        private boolean isClosed = false;

        public TextWriter(int n, int n2) {
            this.buffer = new StringBuffer(n2);
            this.startOffset = n;
            this.endOffset = n + n2;
        }

        public void close() {
            if (!this.isClosed) {
                this.isClosed = true;
            }
        }

        public int getCharCount() {
            return this.endOffset - this.startOffset;
        }

        public int getStart() {
            return this.startOffset;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public String toString() {
            return this.buffer.toString();
        }

        void write(String string) {
            this.buffer.append(string);
        }

        void write(String string, int n) {
            if (n < 0 || n > this.buffer.length()) {
                return;
            }
            this.buffer.insert(n, string);
        }

        void write(int n) {
            this.buffer.append(n);
        }

        void write(char c) {
            this.buffer.append(c);
        }

        public void writeLine(String string, int n) {
            int n2;
            int n3;
            int n4;
            if (this.isClosed) {
                SWT.error(39);
            }
            if ((n4 = this.startOffset - n) >= (n3 = string.length())) {
                return;
            }
            int n5 = n4 > 0 ? n4 : 0;
            if (n5 < (n2 = Math.min(n3, this.endOffset - n))) {
                this.write(string.substring(n5, n2));
            }
        }

        public void writeLineDelimiter(String string) {
            if (this.isClosed) {
                SWT.error(39);
            }
            this.write(string);
        }
    }
}

