#!/usr/bin/perl

=pod

=head1 NAME

actor2flag2.0 - Calculate "flag" from F<actor.txt>.

=head1 SYNOPSIS

    perl actor2flag.pl [-c cache_size] actor.txt

=head1 DESCRIPTION

1Ԥ˶ڤB<(index, caller, callee, depth)>Ҥ줿եɤ߹ߡ
flag&depthɽǡɸϤؽϤ롥

=head1 OPTIONS

=over 4

=item -c call_size

å奵

=back

=cut

#use strict;
use Getopt::Std;

# ޥɥ饤󥪥ץ
my %options;
getopts('c:', \%options);

# å奵
my @cache = ();           ## åǤϥ֥ID
##  ǿϵꤷʤ

my $cache_size = 1;       ## 桼λꤹ륭å奵ʻʤʤ飱
if ($options{"c"}) {
	$cache_size = $options{"c"};
}


# 
if (@ARGV < 0) {
	exit(1);
}

my   %map = ();           ## åʣѥϥå
keys %map = $cache_size;  ## ϥå奵ϻꥭå奵ʲ

##ϡ
while (<>) {
	chomp;            ## ԤȤ
	# 
	next if (/^\#/);      ## Ƭ#פä̵뤷ƼιԤ
	next if (/^\@thread/);## Ƭ@threadפä̵뤷ƼιԤ

	# ǡ
	split(/\s+/);         ## ȾѥڡǶڤ
	my $line = shift(@_);     ##  index
	my $caller = shift(@_);   ##  ƤӽФID
	my $callee = shift(@_);   ##  ƤӽФID
	my $stackd = shift(@_);   ##  륹åο

	my $flag1 = &add($caller);  ## ƤӽФID򥭥åɲ
	my $flag2 = &add($callee);  ## ƤӽФID򥭥åɲ
	my $flag = 0;
	if ($flag1 or $flag2) {
		$flag = 1;              ## ƤӽФorƤӽФɤ餫ɲäǥå夬줿ե饰ΩƤ
	}
	print "$line $flag $stackd @_\n";      ## indexȥե饰ȥ륹åοʡܤ¾ξˤ
}
exit(0);


#---------------------------------------------------------------------
# @return å夬1Ǥʤ0
#
# ѥեޥUPΤᡤǤ%map˽ʣ򵭲
#---------------------------------------------------------------------

## ˥å奵ξ
## time     Υå  @cache         %map
## 
##  0       (0,1,2) <- 1        (0,1,2)        {0=>1,1=>1,2=>1}
##  1       (0.2.1) <- 1        (0,1,2,1)      {0=>1,1=>2,2=>1}
##  2       (0.2.1) <- 3        (0,1,2,1,1)    {0=>1,1=>3,2=>1}
##  3       (2.1,3) <- 4        (1,2,1,1,3)    {1=>3,2=>1,3=>1}
##  3                           (2,1,1,3)      {1=>2,2=>1,3=>1}
##  3                           (1,1,3)        {1=>2,2=>0,3=>1}
##  4       (1,3,4) <- X        (1,1,3,4)      {1=>2,3=>1,4=>1}


sub add {
	my ($data) = @_;                        ## ɲä륪֥ID
	my $hit_index = -1;                     ## 

	# ˥å󥰤Ƥ뤫å
	if (exists $map{$data}) {
		# ҥå
		push(@cache, $data);                ## IDΰ֤򹹿ʺǸء
		++$map{$data};                      ## ƱIDνʣ򹹿
		return 0;                           ## ǤΰѹΤߤʤΤǹ̵֤
	} else {
		# ҥåȤ
		if (keys(%map) == $cache_size) {      ## åIDμꥭåɤĤ
			##  ˽ʣǤ̵֤ǥå夬줿
			my $removed;
			do {
				$removed = shift(@cache);     ## åΰָŤǤΤƤ
				--$map{$removed};             ## ΤƤǤνʣ1餹
			} while ($map{$removed} != 0);    ## åǤμޤǷ֤
			##   ʣǤϤäȿ֤ưƤΤǡΤƤƤ̵̣
			## ǿΰ֤ǤΡ˸ߤΰ֤ˤǡˤΤƤ줿餽ǻߤޤ롥
			delete $map{$removed};            ## ΤƤǤνʣäƤޤ
		}

		push(@cache, $data);                ## ǤȤƥåIDɲ
		$map{$data} = 1;                    ##ʿʣ̵Τǣ
		return 1;                           ## å夬줿Τ1֤
	}
}

