#!/usr/bin/perl

=pod

=head1 NAME

average - Caluculate average of each continuous N-numbers.

=head1 SYNOPSIS

    perl average.pl [-c num] [-h] [-n num] [-p] [-s] input_file

=head1 DESCRIPTION

ϥեγƹԤФƤβʬʿ(뤤)򻻽Ф롥

ƤΥǡʿ(뤤Ϲ)᤿ꡤ10ΤߤʤǡФ1ˤʤäƤ٤᤿ꡤη㤷դʤ餫ʿѲ뤳Ȥǽ

=head1 OPTIONS

=over 4

=item -c num

оݤȤʤꤹ롥
ǽ1ܤǡǥեͤ1ܤˤʤäƤ롥

=item -h

إס

=item -n num

nʬ(ߤιԤޤ)ʿѤȤ롥
ǽιԤʤnԤʤʬϲûԿʬʿѤȤ롥
Υץ󤬾ά줿ˤϡnum=ϥեιԿȤ롥

=item -s

ʿѤǤϤʤ¤Ϥ롥

=back

=head1 INPUT EXAMPLE

    2
    1
    8
    4
    5
    3
    1

=head1 OUTPUT EXAMPLE

    perl average.pl -n 3 testdata

    2
    1.5
    3.66666666666667
    4.33333333333333
    5.66666666666667
    4
    3

=cut

use strict;
use Getopt::Std;

# ޥɥ饤󥪥ץ
my %options;
getopts('c:hn:s', \%options);

# إ
if ($options{h}) {
    &print_usage();
    exit(0);
}

# ʬоݤˤ뤫
my $n;
if ($options{n}) {
    my $num = $options{n};
    if (&is_numeric($num)) {            ## ɤå
        $n = $num;
    } else {
        &print_usage();
        exit(1);
    }
} else {
    # TODO: not smart.
    split(/\s/, `wc -l $ARGV[0]`);
    $n = $_[0];
}
my @buf;                               ## оϰʬΥǡݻ륭å

# ܤоݤˤ뤫
my $column = 1;
if ($options{"c"}) {
    $column = $options{"c"};
}
$column--;

# ʬ
my $denominator = $n; ## ʿѤϰ
if ($options{s}) {
    $denominator = 1; ## -s ʤ¤ 
}

# 
if (@ARGV >= 2) {
    &print_usage();
    exit(1);
}

my $sum = 0; # 
my @data;    # 1ʬΥǡ
#=====================================================================
# ᥤ
#
# ѥեޥ󥹤Τᡤ1ѹΤäʬø롥
#=====================================================================
while (<>) {
 	chomp;                              ## Խ
    # ǡ
    @data = split(/\s+/);               ## ȾѥڡǶڤ
    if (!exists($data[$column])) {      ## оǤͤå
        die "Input file format error.";
    }

    # ХåեθŤǡ
    my $removed = 0;
 	if (@buf == $n) {
 	    $removed = shift(@buf);         ## Ǹťǡ
 	}
    push(@buf, $data[$column]);         ## ǡɲ

 	#  or ʿѤη׻
    $sum = $sum - $removed + $data[$column];
    $data[$column] = $sum / $denominator;
#    $data[$column] = $sum / @buf; # TODO: which is better ?

    # 
    print join(' ', @data), "\n";       ## оǤѹơʬ
}
exit(0);

#---------------------------------------------------------------------
# Ȥ
#---------------------------------------------------------------------
sub print_usage {
    print "average - Caluculate average of each continuous N-numbers.\n";
    print "Usage: perl $0 [-c num] [-h] [-n num] [-s] input_file\n";
}

#---------------------------------------------------------------------
# ͤɤå
#---------------------------------------------------------------------
sub is_numeric {
	my $text = shift;
	if($text =~ /^[0-9]+$/){
		return 1;
	} else {
		return 0;
	}
}

