#!/usr/bin/perl

=pod

=head1 NAME

ratioPxDep2dev - output block-point from ratio and depth of callstack.

=head1 SYNOPSIS

  perl ratioPxDep2dev.pl [-np] [-s scope] [-t threshold ] ratio.log

=head1 DESCRIPTION

٤ȥ륹åο顤֥åʬϤ롥

=head1 OPTIONS

=over 4

=item -n
  եθĿ򼡤ιԤ˽Ϥ

=item -p
  ƥեλ٥ȤΡ¹եΥեݥ󥿰֤򼡤ιԤ˽Ϥ
  
=item -s
  륹åë򤵤ΤܤϰϤ򥤥٥ȸĿǻꤹ롥

=item -t
  ٤֥åȿȤƸФͤꤹ롥01

=back

=cut


use strict;
use Getopt::Std;

# ޥɥ饤󥪥ץ
my %options;
getopts('s:t:np', \%options);

# 륹å̤ϰ
my $scope = 1;
if ($options{"s"}) {
    $scope = $options{"s"};
}

my $threshold = "";
if( $options{"t"} ) { $threshold = $options{"t"}; }

my $phasecount = 0;
if( $options{'n'} ){ $phasecount = 1; }

my $filepointer = 0;
if( $options{'p'} ){ $filepointer = 1; }

# 
if (@ARGV <= 0 or @ARGV >= 4) {
#    &print_usage();
    exit(1);
}

#-----------------------------------------------#
# main
#-----------------------------------------------#



# 륹åå
my @depthindex = ();           #ϰϤˤindexǼ
my @depthfp = ();              #ϰϤˤindexfilepointerǼ
my @depthstack = ();           #嵭б륳륹åǼ
my $deepest = 0;	       #ʾ嵭Ρ˰ֿëΰ

my $before = "";               #
my $upflag = 0;                #徺ߥե饰

my @devideIndex = ();          #ڤȤƸФindex
my @devideFp = ();              #Υեݥ
while( <> ){
    chomp;
    if( /^#/ ) { next; }

    my @data = split(/\s+/);
    my $num = @data;
    if( $num < 3 ) { die " file format error \n" ; }


    if( $before eq "" ){
      $before = $data[1];
      push(@depthindex, $data[0]);
      push(@depthstack, $data[2]);
      push(@depthfp, $data[3]);
      push(@devideIndex, $data[0]);
      $deepest = 0;
      next;
    }

    my $diff = $data[1]-$before;
    $before = $data[1];

    #徺
    if( $upflag == 1 ){
      if( $diff < 0 ){
	$upflag = 0;
	if((($threshold ne "")and($threshold < $data[1])) or ($threshold eq "")){
	  if( $depthindex[$deepest] > $devideIndex[@devideIndex-1] ){
	    push( @devideIndex, $depthindex[$deepest] );
	    push( @devideFp, $depthfp[$deepest] );
	  }
	}
      }
    } else {
      if( $diff > 0 ){
	  $upflag = 1;
      }
    }

# 󹹿
	my $numS = @depthstack;
	if( $numS >= $options{"s"} ){
		shift( @depthindex );
		shift( @depthfp );
		shift( @depthstack );
		$deepest--;
	}
	push( @depthindex, $data[0] );
	push( @depthstack, $data[2] );
	push( @depthfp, $data[3] );
	# ë򹹿
	if( $deepest == -1 ){	# ëscopeȴȤʻëκõ
	  my $min = $depthstack[0];
	  $deepest = 0;
	  for( my $i = 1; $i < $numS; $i++ ){
	    if( ($min >= $depthstack[$i]) and ($depthstack[$i] != $depthstack[$i-1])){
	      $deepest = $i;
	      $min = $depthstack[$i];
	    }
	  }
	} else {		# ëScopeˤȤʿʬȸëӡ
	  if( ($depthstack[$numS-1] <= $depthstack[$deepest]) and ($depthstack[$numS-1] != $depthstack[$numS-2]) ){
	      $deepest = $numS-1;
	  }
	}
}
print "@devideIndex";
if( $phasecount > 0 ){
	$phasecount = @devideIndex;
	print "\n$phasecount\n";
}
if( $filepointer > 0 ){
	print "\n@devideFp\n";
}
exit(0);
