/*
 * Decompiled with CFR 0.152.
 */
package amida.library;

import amida.library.Pair;
import amida.library.PromptPrinter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class PromptPrinterCanvas
extends JPanel
implements PromptPrinter {
    private JScrollBar scrollBar = null;
    private List texts = new ArrayList();
    private int charHeight = 0;

    public PromptPrinterCanvas() {
        this.setBackground(Color.WHITE);
    }

    public void println(String text, int mode) {
        this.texts.add(new Pair(text, new Integer(mode)));
        int needHeight = (this.texts.size() + 1) * this.charHeight;
        if (this.getSize().getHeight() < (double)needHeight) {
            this.setSize((int)this.getSize().getWidth(), needHeight);
            this.setPreferredSize(new Dimension((int)this.getSize().getWidth(), needHeight));
        }
        this.scrollEnd();
        this.repaint();
    }

    public void clear() {
        this.texts.clear();
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.charHeight = g.getFontMetrics().getHeight();
        int size = this.texts.size();
        int i = 0;
        while (i < size) {
            Pair text = (Pair)this.texts.get(i);
            int mode = (Integer)text.getO2();
            if (mode == -1) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawString((String)text.getO1(), 3, this.charHeight * (i + 1));
            ++i;
        }
    }

    private void scrollEnd() {
        if (this.scrollBar == null) {
            Container comp = this;
            while ((comp = comp.getParent()) != null && !(comp instanceof JScrollPane)) {
            }
            if (comp != null) {
                this.scrollBar = ((JScrollPane)comp).getVerticalScrollBar();
            } else {
                return;
            }
        }
        System.out.println("test");
        BoundedRangeModel model = this.scrollBar.getModel();
        model.setValue(model.getMaximum() - model.getExtent());
    }
}

