/*
 * Decompiled with CFR 0.152.
 */
package amida.node;

import amida.node.CallTree;
import amida.node.Node;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class CallNode
extends Node {
    public static final int NOT_EXIT = 0;
    public static final int EXIT_NORMAL = 1;
    public static final int EXIT_EXCEPTION = 2;
    private static final String INIT = "<init>";
    private List recursivePoints = new LinkedList();
    private boolean isRecursive = false;
    private boolean isBranch = false;
    private boolean isConstructor = false;
    private int exitMode;
    private String methodName = null;
    private String className = null;
    private String packageName = null;
    private String[] fullArgs = null;
    private Set id = new TreeSet();
    private String returnType = null;
    private String exception = null;
    private int callIndex;

    public CallNode(CallTree tree, String className, String name, String returnType, List argList, int id, int callIndex) {
        super(tree);
        this.construct(className, name, returnType, callIndex);
        this.id.add(new Integer(id));
        if (argList != null && argList.size() > 0) {
            this.fullArgs = new String[argList.size()];
            Iterator it = argList.iterator();
            int i = 0;
            while (it.hasNext()) {
                this.fullArgs[i] = ((String)it.next()).intern();
                ++i;
            }
        }
    }

    public CallNode(CallTree tree, String className, String name, String returnType, String[] argList, int id, int callIndex) {
        super(tree);
        this.construct(className, name, returnType, callIndex);
        this.id.add(new Integer(id));
        if (argList != null && argList.length > 0) {
            this.fullArgs = new String[argList.length];
            int i = 0;
            while (i < argList.length) {
                this.fullArgs[i] = argList[i].intern();
                ++i;
            }
        }
    }

    public CallNode(CallTree tree, String className, String name, String returnType, String[] argList, Set id, int callIndex) {
        super(tree);
        this.construct(className, name, returnType, callIndex);
        this.id = id;
        if (argList != null && argList.length > 0) {
            this.fullArgs = new String[argList.length];
            int i = 0;
            while (i < argList.length) {
                this.fullArgs[i] = argList[i].intern();
                ++i;
            }
        }
    }

    private void construct(String className, String name, String returnType, int callIndex) {
        this.callIndex = callIndex;
        int index = className.lastIndexOf("/");
        if (index == -1) {
            index = className.lastIndexOf(".");
        }
        this.packageName = index == -1 ? "" : className.substring(0, index).replace('/', '.').intern();
        this.className = className.substring(index + 1, className.length()).intern();
        this.methodName = name.equals(INIT) ? this.className.intern() : name.intern();
        this.returnType = returnType.replace('/', '.').intern();
        if (this.className.equals(this.methodName)) {
            this.isConstructor = true;
        }
    }

    protected String[] makeArgs() {
        if (this.fullArgs == null) {
            return null;
        }
        String[] args = new String[this.fullArgs.length];
        int i = 0;
        while (i < args.length) {
            int index = this.fullArgs[i].lastIndexOf("/");
            args[i] = this.fullArgs[i].substring(index + 1);
            ++i;
        }
        return args;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getFullClassName() {
        return String.valueOf(this.packageName) + "." + this.className;
    }

    public void setMethodName(String name) {
        this.methodName = name;
    }

    public void setId(Set id) {
        this.id = id;
    }

    public void addId(int id) {
        this.id.add(new Integer(id));
    }

    public void addId(Set id) {
        Iterator it = id.iterator();
        while (it.hasNext()) {
            Integer i = (Integer)it.next();
            this.id.add(i);
        }
    }

    public void setArgs(String[] args) {
        this.fullArgs = args;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Set getId() {
        return this.id;
    }

    public String[] getArgs() {
        return this.makeArgs();
    }

    public String[] getFullArgs() {
        return this.fullArgs;
    }

    public int getArgc() {
        if (this.fullArgs == null) {
            return 0;
        }
        return this.fullArgs.length;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int getCallNodeNum() {
        return 1;
    }

    public CallNode getCallNode(int i) {
        return this;
    }

    public Object clone() throws CloneNotSupportedException {
        CallNode copy = (CallNode)super.clone();
        TreeSet<Integer> newId = new TreeSet<Integer>();
        Iterator it = this.id.iterator();
        while (it.hasNext()) {
            Integer i = (Integer)it.next();
            newId.add(new Integer(i));
        }
        copy.setId(newId);
        return copy;
    }

    public void addRecursivePoint(CallNode node) {
        this.recursivePoints.add(node);
    }

    public List getRecursivePoints() {
        return this.recursivePoints;
    }

    public void setRecursive(boolean bool) {
        this.isRecursive = bool;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public void setBranch(boolean bool) {
        this.isBranch = bool;
    }

    public boolean isBranch() {
        return this.isBranch;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < depth) {
            buffer.append("\t");
            ++i;
        }
        buffer.append(String.valueOf(this.getStartString()) + lineSeparator);
        if (this.hasChildren()) {
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                buffer.append(String.valueOf(((Node)it.next()).toString(depth + 1)) + lineSeparator);
            }
        }
        i = 0;
        while (i < depth) {
            buffer.append("\t");
            ++i;
        }
        buffer.append(this.getEndString());
        return buffer.toString();
    }

    public String getStartString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isBranch) {
            buffer.append("? ");
        }
        if (this.isRecursive) {
            buffer.append("Recursive ");
        }
        buffer.append(String.valueOf(this.getReturnType()) + " ");
        if (!this.getPackageName().equals("")) {
            buffer.append(String.valueOf(this.getPackageName()) + ".");
        }
        Iterator it = this.id.iterator();
        if (this.id.size() == 1) {
            buffer.append(String.valueOf(this.getClassName()) + "(" + it.next() + ")." + this.getMethodName() + "(");
        } else {
            buffer.append(String.valueOf(this.getClassName()) + "( * )." + this.getMethodName() + "(");
        }
        if (this.fullArgs != null) {
            String[] args = this.makeArgs();
            int i = 0;
            while (i < args.length - 1) {
                buffer.append(String.valueOf(args[i]) + ",");
                ++i;
            }
            buffer.append(args[args.length - 1]);
        }
        buffer.append("){");
        return buffer.toString();
    }

    public String getEndString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("}");
        if (this.getException() != null) {
            buffer.append("(");
            buffer.append(this.getException());
            buffer.append(")");
        }
        return buffer.toString();
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public String toStringForCCF() {
        return this.toString();
    }

    public int getDefaultSize() {
        return 2;
    }

    public Node getNewInstance() {
        CallNode node = new CallNode(this.getCallTree(), String.valueOf(this.packageName) + this.className, this.methodName, this.returnType, this.fullArgs, this.id, this.callIndex);
        node.setExitMode(this.getExitMode());
        return node;
    }

    public int getCallIndex() {
        return this.callIndex;
    }

    public boolean isEnded() {
        return this.getExitMode() != 0;
    }

    /*
     * Unable to fully structure code
     */
    public CallNode getCallParent() {
        parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof CallNode)) ** GOTO lbl8
        return (CallNode)parent;
lbl-1000:
        // 1 sources

        {
            if (!(parent instanceof CallNode)) continue;
            return (CallNode)parent;
lbl8:
            // 2 sources

            ** while ((parent = parent.getParent()) != null)
        }
lbl9:
        // 1 sources

        return null;
    }

    public int getExitMode() {
        return this.exitMode;
    }

    public void setExitMode(int exitMode) {
        this.exitMode = exitMode;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public int hashCode() {
        return this.getId().toString().hashCode();
    }
}

