/*
 * Decompiled with CFR 0.152.
 */
package amida.node;

import amida.node.Node;
import amida.node.NodeList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;

public class NodeIterator
implements ListIterator {
    private Node now = null;
    private Node parent = null;
    private ListIterator it = null;
    private NodeList children = null;

    protected NodeIterator(Node parent, NodeList list) {
        this.parent = parent;
        this.children = list;
        this.it = list.listIterator();
    }

    protected NodeIterator(Node parent, NodeList list, int index) {
        this.parent = parent;
        this.children = list;
        this.it = list.listIterator(index);
    }

    public Object next() {
        this.now = (Node)this.it.next();
        return this.now;
    }

    public Node nextNode() {
        this.now = (Node)this.it.next();
        return this.now;
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public Object previous() {
        this.now = (Node)this.it.previous();
        return this.now;
    }

    public Node previousNode() {
        this.now = (Node)this.it.previous();
        return this.now;
    }

    public boolean hasPrevious() {
        return this.it.hasPrevious();
    }

    public boolean hasNow() {
        return this.now != null;
    }

    public Object now() {
        return this.now;
    }

    public void remove() {
        this.it.remove();
        Node parent = this.getParent();
        if (parent == null) {
            return;
        }
    }

    public void set(Object o) {
        this.it.set(o);
        if (this.now.getParent() == this.parent) {
            this.now.setParent(null);
        }
        this.now = (Node)o;
        Node parent = this.getParent();
        if (parent == null) {
            return;
        }
        this.now.setParent(parent);
    }

    public void add(Object o) {
        this.it.add(o);
        Node parent = this.getParent();
        if (parent == null) {
            return;
        }
        Node node = (Node)o;
        node.setParent(parent);
    }

    public Node getParent() {
        return this.parent;
    }

    public int nextIndex() {
        return this.it.nextIndex();
    }

    public int previousIndex() {
        return this.it.previousIndex();
    }

    public NodeIterator nextIterator() {
        return this.now.nodeIterator();
    }

    public boolean hasChildren() {
        return this.now.hasChildren();
    }

    public int size() {
        return this.children.size();
    }

    public void reset() {
        this.it = this.children.listIterator();
        this.now = null;
    }

    public void reset(int index) {
        this.it = this.children.listIterator(index);
        this.now = null;
    }

    public NodeList getChildren() {
        return this.children;
    }

    public int countCallNode() {
        Iterator it = this.children.iterator();
        int num = 0;
        while (it.hasNext()) {
            num += ((Node)it.next()).getCallNodeNum();
        }
        return num;
    }

    public NodeIteratorView getView() {
        return new NodeIteratorView(this);
    }

    private class NodeIteratorView
    extends NodeIterator {
        NodeIterator nit;

        private NodeIteratorView(NodeIterator nit) {
            super(nit.getParent(), nit.getChildren(), nit.nextIndex());
            this.nit = nit;
        }

        public void remove() {
        }

        public void set(Object o) {
        }

        public void add(Object o) {
        }

        public NodeIterator nextIterator() {
            return null;
        }

        public void reset() {
            int target = this.nit.nextIndex();
            int position = this.nextIndex();
            try {
                if (target <= position) {
                    if (target < position - target) {
                        super.reset(target);
                    } else {
                        int gap = position - target;
                        for (int i = 0; i < gap; ++i) {
                            this.previous();
                        }
                    }
                } else {
                    int gap = target - position;
                    for (int i = 0; i < gap; ++i) {
                        this.next();
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                super.reset(target);
            }
        }

        public NodeIteratorView nextIteratorView() {
            return ((Node)this.now()).nodeIterator().getView();
        }

        public NodeIteratorView getView() {
            return this;
        }
    }
}

