/*
 * Decompiled with CFR 0.152.
 */
package amida.sequencefilter;

import amida.library.StringPatternComparator;
import amida.node.CallNode;
import amida.sequencefilter.IPreObjectFilter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class ObjectFilter
implements IPreObjectFilter {
    private final String packageName;
    private final String className;
    private final Set ids;
    private final boolean canIncludeOtherId;

    public ObjectFilter(String packageName, String className, Set ids, boolean otherId) {
        this.packageName = packageName;
        this.className = className;
        if (ids != null) {
            this.ids = new TreeSet();
            this.ids.addAll(ids);
        } else {
            this.ids = null;
        }
        this.canIncludeOtherId = otherId;
    }

    public boolean filter(CallNode node) {
        if (this.packageName != null && !StringPatternComparator.compareStringPattern(this.packageName, node.getPackageName())) {
            return false;
        }
        if (this.className != null && !StringPatternComparator.compareStringPattern(this.className, node.getClassName())) {
            return false;
        }
        return !(this.canIncludeOtherId ? this.ids != null && !this.ids.isEmpty() && !node.getId().containsAll(this.ids) : this.ids == null || this.ids.isEmpty() || !this.ids.equals(node.getId()));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.getPackageName()) + "." + this.getClassName() + "(");
        if (this.getIds() == null || this.getIds().isEmpty()) {
            buffer.append("*");
        } else {
            Iterator it = this.getIds().iterator();
            while (it.hasNext()) {
                buffer.append(it.next());
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public abstract void makeSuitableGroupe(CallNode var1, Map var2);

    public boolean isCanIncludeOtherId() {
        return this.canIncludeOtherId;
    }

    public String getClassName() {
        return this.className;
    }

    public Set getIds() {
        return this.ids;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

