/*
 * Decompiled with CFR 0.152.
 */
package amida.diagram.sequencediagram.gui;

import amida.calltree.BlockNode;
import amida.calltree.CallNode;
import amida.calltree.CallTreeIterator;
import amida.calltree.Node;
import amida.diagram.sequencediagram.Called;
import amida.diagram.sequencediagram.ISequenceElement;
import amida.diagram.sequencediagram.Sequence;
import amida.diagram.sequencediagram.SequenceBlock;
import amida.diagram.sequencediagram.SequenceDiagramDrawer;
import amida.diagram.sequencediagram.SequenceDiagramModel;
import amida.diagram.sequencediagram.SequenceLoop;
import amida.diagram.sequencediagram.gui.DiagramsCanvasAdjuster;
import amida.diagram.sequencediagram.gui.SelectableElement;
import amida.diagram.sequencediagram.gui.SequenceDiagramTabbedPane;
import amida.utility.DataChangeListener;
import amida.utility.SelectionChangeListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoundedRangeModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class SequenceDiagramCanvas
extends JPanel
implements DataChangeListener,
SelectionChangeListener {
    private static final long serialVersionUID = -8598046585018596293L;
    private SequenceDiagramModel model;
    private DiagramsCanvasAdjuster adjuster;
    private JScrollBar verticalBar;
    private JScrollBar horizontalBar;
    private List<Collection<SelectableElement>> selectablePriorityList = new ArrayList<Collection<SelectableElement>>();
    private Point prevMousePressPoint = null;
    private boolean mouseDragged = false;

    public SequenceDiagramCanvas() {
        this.setBackground(Color.white);
        final JPopupMenu sequencePopup = new JPopupMenu();
        JMenu compressMenu = new JMenu("Compress");
        JMenuItem simpleLoop = new JMenuItem("Simple loop");
        compressMenu.add(simpleLoop);
        sequencePopup.add(compressMenu);
        JMenuItem extractMenu = new JMenuItem("Extract to another diagram");
        sequencePopup.add(extractMenu);
        int i = 0;
        while (i < 5) {
            this.selectablePriorityList.add(new TreeSet());
            ++i;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                Iterator listIt = SequenceDiagramCanvas.this.selectablePriorityList.iterator();
                while (listIt.hasNext()) {
                    for (SelectableElement element : (Collection)listIt.next()) {
                        if (!element.isInRange(p)) continue;
                        ISequenceElement sequenceElement = element.getElement();
                        if (e.getButton() == 1) {
                            if (e.getClickCount() >= 2) {
                                if (sequenceElement instanceof SequenceLoop) {
                                    SequenceLoop loop = (SequenceLoop)sequenceElement;
                                    loop.getNode().setFold(!loop.getNode().isFold());
                                    SequenceDiagramCanvas.this.model.renew();
                                    return;
                                }
                                if (sequenceElement instanceof Called) {
                                    Called called = (Called)sequenceElement;
                                    called.getCallSequence().getNode().setBehind(!called.getCallSequence().getNode().isBehind());
                                    SequenceDiagramCanvas.this.model.renew();
                                    return;
                                }
                                if (sequenceElement instanceof SequenceBlock) {
                                    SequenceBlock block = (SequenceBlock)sequenceElement;
                                    block.getBlockNode().setBehind(!block.getBlockNode().isBehind());
                                    SequenceDiagramCanvas.this.model.renew();
                                    return;
                                }
                            }
                        } else if (e.getButton() != 2 && e.getButton() == 3) {
                            if (sequenceElement instanceof Sequence) {
                                sequencePopup.show(e.getComponent(), e.getX(), e.getY());
                            } else if (sequenceElement instanceof Called) {
                                sequencePopup.show(e.getComponent(), e.getX(), e.getY());
                            }
                        }
                        SequenceDiagramCanvas.this.getModel().getSelectionModel().selectElement(element.getElement());
                        return;
                    }
                }
                SequenceDiagramCanvas.this.getModel().getSelectionModel().clearAllSelection();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SequenceDiagramCanvas.this.prevMousePressPoint = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SequenceDiagramCanvas.this.mouseDragged) {
                    SequenceDiagramCanvas.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SequenceDiagramCanvas.this.prevMousePressPoint == null) {
                    return;
                }
                SequenceDiagramCanvas.this.mouseDragged = true;
                SequenceDiagramCanvas.this.setCursor(Cursor.getPredefinedCursor(12));
                double diffX = (double)e.getX() - SequenceDiagramCanvas.this.prevMousePressPoint.getX();
                double diffY = (double)e.getY() - SequenceDiagramCanvas.this.prevMousePressPoint.getY();
                BoundedRangeModel verticalModel = SequenceDiagramCanvas.this.verticalBar.getModel();
                BoundedRangeModel horizontalModel = SequenceDiagramCanvas.this.horizontalBar.getModel();
                double xRate = (double)horizontalModel.getMaximum() / SequenceDiagramCanvas.this.getSize().getWidth();
                double yRate = (double)verticalModel.getMaximum() / SequenceDiagramCanvas.this.getSize().getHeight();
                horizontalModel.setValue((int)((double)horizontalModel.getValue() - diffX * xRate));
                verticalModel.setValue((int)((double)verticalModel.getValue() - diffY * yRate));
            }
        });
        extractMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Set<Integer> selectedSequence = SequenceDiagramCanvas.this.getModel().getSelectionModel().getSelectedSequenceIndex();
                Set<Called> selectedCalled = SequenceDiagramCanvas.this.getModel().getSelectionModel().getSelectedCalled();
                Node block = null;
                if (selectedSequence.size() == 1) {
                    Sequence sequence = SequenceDiagramCanvas.this.getModel().getSequence(selectedSequence.iterator().next());
                    CallNode node = sequence.getNode();
                    Node parent = node.getParent();
                    CallTreeIterator it = parent == null ? node.getCallTree().getTopNodeList().nodeIterator() : parent.nodeIterator();
                    while (it.hasNext() && it.next() != node) {
                    }
                    block = new BlockNode(node.getCallTree());
                    if (node instanceof CallNode) {
                        ((BlockNode)block).setBlockName(node.getMethodName());
                    }
                    it.set(block);
                    block.addChild(node);
                } else if (selectedCalled.size() == 1) {
                    Called called = selectedCalled.iterator().next();
                    CallNode node = called.getCallSequence().getNode();
                    if (node.hasChildren()) {
                        CallTreeIterator it = node.nodeIterator();
                        block = new BlockNode(node.getCallTree());
                        Node first = it.nextNode();
                        it.set(block);
                        block.addChild(first);
                        if (first instanceof CallNode) {
                            ((BlockNode)block).setBlockName(((CallNode)first).getMethodName());
                        }
                        while (it.hasNext()) {
                            block.addChild(it.nextNode());
                        }
                    }
                } else {
                    return;
                }
                SequenceDiagramModel newModel = new SequenceDiagramModel(block.getChildren());
                SequenceDiagramTabbedPane.getInstance().addNewDiagram(newModel, ((BlockNode)block).getBlockName());
                block.setBehind(true);
                SequenceDiagramCanvas.this.getModel().renew();
            }
        });
    }

    public SequenceDiagramCanvas(SequenceDiagramModel model) {
        this.setBackground(Color.white);
        this.setModel(model);
    }

    public void setSequenceDiagramsAdjuster(DiagramsCanvasAdjuster adjuster) {
        this.adjuster = adjuster;
    }

    public SequenceDiagramModel getModel() {
        if (this.adjuster != null) {
            return this.adjuster.getModel();
        }
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize() {
        SequenceDiagramModel model = this.getModel();
        if (model == null) {
            return;
        }
        SequenceDiagramModel sequenceDiagramModel = model;
        synchronized (sequenceDiagramModel) {
            int objectNum = model.getObjectNum();
            int sequenceNum = model.getSequenceNum();
            int objectsSpace = this.adjuster.getObjectSpace();
            int x = (objectNum + 1) * (this.adjuster.getObjectWidth() + objectsSpace) + this.adjuster.getMargin().left + this.adjuster.getMargin().right;
            int y = (sequenceNum + 1) * this.adjuster.getSequenceSpace() + this.adjuster.getMargin().bottom;
            Dimension newSize = new Dimension(x, y);
            this.setPreferredSize(newSize);
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Iterator<Collection<SelectableElement>> listIt = this.selectablePriorityList.iterator();
        while (listIt.hasNext()) {
            listIt.next().clear();
        }
        if (this.adjuster == null) {
            return;
        }
        int objectSpace = this.adjuster.getObjectSpace();
        int objectWidth = this.adjuster.getObjectWidth();
        int sequenceSpace = this.adjuster.getSequenceSpace();
        SequenceDiagramModel model = this.getModel();
        if (model != null) {
            SequenceDiagramModel sequenceDiagramModel = model;
            synchronized (sequenceDiagramModel) {
                Rectangle viewRange = this.getViewRange();
                int xStartIndex = ((int)viewRange.getX() - this.adjuster.getMargin().left - objectSpace) / (objectWidth + objectSpace);
                int xEndIndex = ((int)viewRange.getX() + (int)viewRange.getWidth() - this.adjuster.getMargin().left) / (objectWidth + objectSpace) - 1;
                int yStartIndex = (int)viewRange.getY() / sequenceSpace - 1;
                int yEndIndex = (int)viewRange.getHeight() / sequenceSpace + yStartIndex;
                if (xStartIndex < 0) {
                    xStartIndex = 0;
                }
                if (xEndIndex > model.getObjectList().size() - 1) {
                    xEndIndex = model.getObjectList().size() - 1;
                }
                if (yStartIndex < 0) {
                    yStartIndex = 0;
                }
                if (yEndIndex > model.getSequenceList().size() - 1) {
                    yEndIndex = model.getSequenceList().size() - 1;
                }
                List<SelectableElement> selectables = SequenceDiagramDrawer.drawDiagram(model, this.adjuster, g, viewRange, viewRange);
                Iterator<SelectableElement> it = selectables.iterator();
                while (it.hasNext()) {
                    this.addSelectableElement(it.next());
                }
            }
        }
    }

    protected Rectangle getViewRange() {
        if (this.verticalBar == null) {
            Container comp = this;
            while ((comp = comp.getParent()) != null && !(comp instanceof JScrollPane)) {
            }
            if (comp != null) {
                this.verticalBar = ((JScrollPane)comp).getVerticalScrollBar();
                this.horizontalBar = ((JScrollPane)comp).getHorizontalScrollBar();
            }
        }
        Dimension size = this.getSize();
        if (this.verticalBar == null) {
            return new Rectangle(0, 0, (int)size.getWidth(), (int)size.getHeight());
        }
        BoundedRangeModel model = this.horizontalBar.getModel();
        int x = (int)((double)size.width * ((double)model.getValue() / (double)model.getMaximum()));
        int width = (int)((double)size.width * ((double)model.getExtent() / (double)model.getMaximum()));
        model = this.verticalBar.getModel();
        int y = (int)((double)size.height * ((double)model.getValue() / (double)model.getMaximum()));
        int height = (int)((double)size.height * ((double)model.getExtent() / (double)model.getMaximum()));
        return new Rectangle(x, y, width, height);
    }

    public void scroll(int objectNum, int sequenceNum) {
        int scrollY;
        int scrollX;
        BoundedRangeModel verticalModel = this.verticalBar.getModel();
        BoundedRangeModel horizontalModel = this.horizontalBar.getModel();
        Dimension size = this.getSize();
        int objectSpace = this.adjuster.getObjectSpace();
        if (objectNum >= 0 && objectNum < this.getModel().getObjectNum()) {
            int pointX = this.adjuster.getMargin().left + this.adjuster.getObjectWidth() / 2 + objectNum * (this.adjuster.getObjectWidth() + objectSpace);
            scrollX = (int)((double)pointX / size.getWidth() * (double)horizontalModel.getMaximum() - (double)(horizontalModel.getExtent() / 2));
        } else {
            scrollX = horizontalModel.getValue();
        }
        if (sequenceNum >= 0 && sequenceNum < this.getModel().getSequenceNum()) {
            int pointY = sequenceNum * this.adjuster.getSequenceSpace();
            scrollY = (int)((double)pointY / size.getHeight() * (double)verticalModel.getMaximum() - (double)(verticalModel.getExtent() / 2));
        } else {
            scrollY = verticalModel.getValue();
        }
        horizontalModel.setValue(scrollX);
        verticalModel.setValue(scrollY);
    }

    @Override
    public void dataChanged() {
        this.resize();
        this.repaint();
    }

    protected void setModel(SequenceDiagramModel model) {
        this.model = model;
        model.addDataChangeListener(this);
        model.getSelectionModel().addSelectionListener(this);
        this.resize();
    }

    @Override
    public void selectionChanged() {
        this.repaint();
    }

    public void addSelectableElement(SelectableElement e) {
        this.selectablePriorityList.get(e.getPriority()).add(e);
    }
}

