/*
 * Decompiled with CFR 0.152.
 */
package amida.logloader;

import amida.LanguageType;
import amida.logloader.EntryType;
import amida.logloader.LogEntry;
import amida.logloader.LogParser;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public abstract class LogIterator {
    private final Queue<LogEntry> entries = new LinkedList<LogEntry>();
    private final LogParser parser;
    private final LanguageType language;

    protected LogIterator(LanguageType language, LogParser parser) {
        this.parser = parser;
        this.language = language;
    }

    public LogEntry next() {
        if (this.hasLogSource()) {
            this.getNextEntries();
            return this.entries.poll();
        }
        return this.entries.poll();
    }

    public boolean hasNext() {
        if (this.hasLogSource()) {
            this.getNextEntries();
            return !this.entries.isEmpty();
        }
        return !this.entries.isEmpty();
    }

    private void getNextEntries() {
        Object log;
        while (this.entries.isEmpty() && (log = this.getNextLog()) != null) {
            Iterator it = this.parser.parse(log).iterator();
            while (it.hasNext()) {
                LogEntry entry = (LogEntry)it.next();
                it.remove();
                if (entry.getEntryType() == EntryType.UNKNOWN) continue;
                this.entries.offer(entry);
            }
        }
    }

    public LanguageType getLanguageType() {
        return this.language;
    }

    public void addEntry(LogEntry entry) {
        this.entries.offer(entry);
    }

    public abstract boolean hasLogSource();

    public abstract Object getNextLog();

    public abstract int getMethodCallCount();
}

