/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler;

import amida.gui.FileSaveDialog;
import amida.gui.ProcessMonitorTask;
import amida.profiler.ProfilerConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ProfilerConfigWindow {
    private Shell shell;
    private ProfilerConfig configuration;
    private Text execCommandText;
    private Text execLogText;
    private Text profilerPathText;
    private Text jvmArgsText;
    private Text programArgsText;
    private Text javaCommandText;
    private Text mainClassText;
    private Text classPathText;
    private Text logfileDirectoryText;
    private Text triggerMethodText;
    private Text packageFilterText;
    private Text classFilterText;
    private Text methodFilterText;
    private static final String DEFAULT_FILENAME_LABEL = "(save the configuration to generate a command)";
    private static final String[] PROFILER_FILE_FILTERS_NAME = new String[]{"Profiler Config Files (*.ini)", "All Files (*.*)"};
    private static final String[] PROFILER_FILE_FILTERS_EXTENSION = new String[]{"*.ini", "*"};

    public static void main(String[] args) {
        Display display = new Display();
        ProfilerConfigWindow window = new ProfilerConfigWindow(display);
        window.shell.open();
        while (!window.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static void open(Shell parent) {
        ProfilerConfigWindow window = new ProfilerConfigWindow(parent);
        window.shell.open();
    }

    private ProfilerConfigWindow(Display display) {
        this.shell = new Shell(display);
        this.constructWindow();
    }

    private ProfilerConfigWindow(Shell parent) {
        this.shell = new Shell(parent, 66672);
        this.constructWindow();
    }

    public void constructWindow() {
        this.shell.setText("Amida Profiler Laucnher");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Composite fileComposite = this.constructFileComposite(this.shell);
        GridData fileCompositeLayout = new GridData();
        fileCompositeLayout.grabExcessHorizontalSpace = true;
        fileCompositeLayout.horizontalAlignment = 4;
        fileComposite.setLayoutData((Object)fileCompositeLayout);
        TabFolder tab = this.constructTab(this.shell);
        GridData tabLayout = new GridData();
        tabLayout.grabExcessVerticalSpace = true;
        tabLayout.horizontalAlignment = 4;
        tabLayout.verticalAlignment = 4;
        tab.setLayoutData((Object)tabLayout);
        this.shell.pack();
        this.shell.setSize(640, 480);
        this.initializeConfig();
    }

    private void initializeConfig() {
        this.configuration = new ProfilerConfig();
        this.fireConfigLoaded();
    }

    private Composite constructFileComposite(final Shell shell) {
        Composite fileComposite = new Composite((Composite)shell, 0);
        Button loadButton = new Button(fileComposite, 8);
        loadButton.setText("Load");
        Button saveButton = new Button(fileComposite, 8);
        saveButton.setText("Save");
        final Label configFilenameLabel = new Label(fileComposite, 2060);
        configFilenameLabel.setText(DEFAULT_FILENAME_LABEL);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(shell, 4096);
                String filename = configFilenameLabel.getText();
                if (!filename.equals(ProfilerConfigWindow.DEFAULT_FILENAME_LABEL)) {
                    File f = new File(filename);
                    dialog.setFileName(f.getAbsolutePath());
                }
                dialog.setFilterNames(PROFILER_FILE_FILTERS_NAME);
                dialog.setFilterExtensions(PROFILER_FILE_FILTERS_EXTENSION);
                filename = dialog.open();
                if (filename != null) {
                    try {
                        ProfilerConfigWindow.this.configuration = new ProfilerConfig(new File(filename));
                        configFilenameLabel.setText(filename);
                        ProfilerConfigWindow.this.fireConfigLoaded();
                    }
                    catch (IOException exception) {
                        MessageBox box = new MessageBox(shell, 32);
                        box.setText("File load error");
                        box.setMessage("Could not read the configuration file. " + exception.getMessage());
                        box.open();
                    }
                }
            }
        });
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfilerConfigWindow.this.updateConfig();
                FileDialog dialog = new FileDialog(shell, 8192);
                dialog.setFilterNames(PROFILER_FILE_FILTERS_NAME);
                dialog.setFilterExtensions(PROFILER_FILE_FILTERS_EXTENSION);
                String filename = configFilenameLabel.getText();
                if (filename.equals(ProfilerConfigWindow.DEFAULT_FILENAME_LABEL)) {
                    filename = dialog.open();
                } else {
                    dialog.setFileName(filename);
                }
                while (filename != null) {
                    File f = new File(filename);
                    if (f.exists()) {
                        MessageBox box = new MessageBox(shell, 448);
                        box.setText("File already exists");
                        box.setMessage("Do you overwrite the file?\n'No' shows a dialog to choose a new file.");
                        int ret = box.open();
                        if (ret == 64) {
                            boolean success = ProfilerConfigWindow.this.configuration.saveAs(f);
                            this.notifySaveResult(filename, success);
                            break;
                        }
                        if (ret == 256) {
                            break;
                        }
                    } else {
                        boolean success = ProfilerConfigWindow.this.configuration.saveAs(f);
                        this.notifySaveResult(filename, success);
                        break;
                    }
                    filename = dialog.open();
                }
            }

            private void notifySaveResult(String filename, boolean success) {
                if (success) {
                    configFilenameLabel.setText(filename);
                } else {
                    MessageBox box = new MessageBox(shell, 32);
                    box.setText("Save Failure");
                    box.setMessage("Failed to update the file: " + filename);
                    box.open();
                }
            }
        });
        fileComposite.setLayout((Layout)new GridLayout(3, false));
        GridData loadButtonLayout = new GridData();
        loadButton.setLayoutData((Object)loadButtonLayout);
        GridData saveButtonLayout = new GridData();
        saveButton.setLayoutData((Object)saveButtonLayout);
        GridData labelLayout = new GridData();
        labelLayout.grabExcessHorizontalSpace = true;
        labelLayout.horizontalAlignment = 4;
        configFilenameLabel.setLayoutData((Object)labelLayout);
        return fileComposite;
    }

    private TabFolder constructTab(Shell shell) {
        TabFolder tab = new TabFolder((Composite)shell, 0);
        TabItem programTab = new TabItem(tab, 0);
        TabItem profilerTab = new TabItem(tab, 0);
        TabItem execTab = new TabItem(tab, 0);
        programTab.setText("Program");
        profilerTab.setText("Profiler");
        execTab.setText("Execution");
        tab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfilerConfigWindow.this.updateConfig();
            }
        });
        Composite programComposite = new Composite((Composite)tab, 0);
        programTab.setControl((Control)programComposite);
        this.constructProgramTab(programComposite);
        Composite profilerComposite = new Composite((Composite)tab, 0);
        profilerTab.setControl((Control)profilerComposite);
        this.constructProfilerTab(profilerComposite);
        Composite execComposite = new Composite((Composite)tab, 0);
        execTab.setControl((Control)execComposite);
        this.constructExecTab(execComposite);
        tab.setSize(tab.computeSize(-1, -1));
        return tab;
    }

    private void constructProgramTab(Composite programComposite) {
        programComposite.setLayout((Layout)new GridLayout(3, false));
        this.mainClassText = this.createSinglelineText(programComposite, "Main Class", null);
        this.programArgsText = this.createMultilineText(programComposite, "Program Args", null);
        this.javaCommandText = this.createSinglelineText(programComposite, "Java Command", new FileOpenButton("...", new String[]{"*.exe", "*.*"}));
        this.jvmArgsText = this.createMultilineText(programComposite, "VM Args", null);
        this.classPathText = this.createMultilineText(programComposite, "Classpath \n(1 entry per line)", new MultilineItemAction(new FileOpenButton("JAR", new String[]{"*.jar", "*.*"}), new DirOpenButton("DIR")));
        this.profilerPathText = this.createSinglelineText(programComposite, "Profiler Path", new FileOpenButton("...", new String[]{"*.dll", "*.*"}));
    }

    private void constructProfilerTab(Composite profilerComposite) {
        profilerComposite.setLayout((Layout)new GridLayout(3, false));
        this.logfileDirectoryText = this.createSinglelineText(profilerComposite, "Log Output Directory", new DirOpenButton("..."));
        this.triggerMethodText = this.createSinglelineText(profilerComposite, "Logging Start Trigger", null);
        this.packageFilterText = this.createMultilineText(profilerComposite, "Package Filter\n(1 entry per line)", null);
        this.classFilterText = this.createMultilineText(profilerComposite, "Class Filter\n(1 entry per line)", null);
        this.methodFilterText = this.createMultilineText(profilerComposite, "Method Filter\n(1 entry per line)", null);
    }

    private Text createSinglelineText(Composite parent, String label, AddItemAction action) {
        Label l = new Label(parent, 0);
        Text text = new Text(parent, 2052);
        l.setText(label);
        l.setLayoutData((Object)new GridData());
        GridData textLayout = new GridData();
        textLayout.horizontalSpan = 1;
        textLayout.horizontalAlignment = 4;
        textLayout.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)textLayout);
        if (action != null) {
            action.createItem(parent, text);
        } else {
            new PlaceHolder().createItem(parent, text);
        }
        return text;
    }

    private Text createMultilineText(Composite parent, String label, MultilineItemAction action) {
        Label l = new Label(parent, 0);
        Text text = new Text(parent, 2626);
        l.setText(label);
        l.setLayoutData((Object)new GridData());
        GridData textLayout = new GridData();
        textLayout.horizontalSpan = 1;
        textLayout.verticalSpan = 2;
        textLayout.horizontalAlignment = 4;
        textLayout.verticalAlignment = 4;
        textLayout.grabExcessHorizontalSpace = true;
        textLayout.grabExcessVerticalSpace = true;
        text.setLayoutData((Object)textLayout);
        if (action != null) {
            action.createItem(parent, text);
        } else {
            PlaceHolder h = new PlaceHolder();
            h.createItem(parent, text);
            h.createItem(parent, text);
            h.createItem(parent, text);
        }
        return text;
    }

    private void constructExecTab(Composite execComposite) {
        execComposite.setLayout((Layout)new GridLayout(1, false));
        Label execCommandLabel = new Label(execComposite, 16384);
        execCommandLabel.setText("A generated command to execute a Java program with the Amida Profiler:");
        GridData execCommandLabelLayout = new GridData();
        execCommandLabelLayout.grabExcessHorizontalSpace = true;
        execCommandLabelLayout.horizontalAlignment = 4;
        execCommandLabel.setLayoutData((Object)execCommandLabelLayout);
        this.execCommandText = new Text(execComposite, 2626);
        GridData execCommandTextLayout = new GridData();
        execCommandTextLayout.horizontalAlignment = 4;
        execCommandTextLayout.grabExcessHorizontalSpace = true;
        execCommandTextLayout.verticalAlignment = 4;
        execCommandTextLayout.grabExcessVerticalSpace = true;
        this.execCommandText.setLayoutData((Object)execCommandTextLayout);
        Button execCommandButton = new Button(execComposite, 8);
        execCommandButton.setText("Profile the Java Program");
        GridData execCommandButtonLayout = new GridData();
        execCommandButtonLayout.grabExcessHorizontalSpace = true;
        execCommandButtonLayout.horizontalAlignment = 0x1000000;
        execCommandButton.setLayoutData((Object)execCommandButtonLayout);
        Button saveBatchButton = new Button(execComposite, 8);
        saveBatchButton.setText("Execute the command as a batch file for Windows");
        GridData saveBatchButtonLayout = new GridData();
        saveBatchButtonLayout.grabExcessHorizontalSpace = true;
        saveBatchButtonLayout.horizontalAlignment = 0x1000000;
        saveBatchButton.setLayoutData((Object)saveBatchButtonLayout);
        saveBatchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileSaveDialog dialog = new FileSaveDialog(ProfilerConfigWindow.this.shell);
                dialog.setFilterNames(new String[]{"Batch Files (*.bat)", "All Files (*.*)"});
                dialog.setFilterExtensions(new String[]{"*.bat", "*.*"});
                String filename = dialog.open();
                if (filename != null) {
                    try {
                        File f = new File(filename);
                        String command = ProfilerConfigWindow.this.execCommandText.getText();
                        FileWriter writer = new FileWriter(f);
                        writer.append(command);
                        writer.append('\n');
                        writer.close();
                        ProfilerConfigWindow.this.execLogText.append("Saved: " + filename);
                        ProfilerConfigWindow.this.execLogText.append("Executed: " + filename);
                        Runtime.getRuntime().exec("cmd /k start " + filename);
                    }
                    catch (IOException e) {
                        ProfilerConfigWindow.this.execLogText.append(e.getMessage());
                    }
                }
            }
        });
        this.execLogText = new Text(execComposite, 2626);
        GridData execLogTextLayout = new GridData();
        execLogTextLayout.grabExcessVerticalSpace = true;
        execLogTextLayout.horizontalAlignment = 4;
        execLogTextLayout.verticalAlignment = 4;
        this.execLogText.setLayoutData((Object)execLogTextLayout);
        execCommandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String command = ProfilerConfigWindow.this.execCommandText.getText();
                try {
                    Process p = Runtime.getRuntime().exec(command);
                    ProfilerConfigWindow.this.execLogText.append("Executed: " + command);
                    Thread thread = new Thread(new ProfilerMonitor(ProfilerConfigWindow.this.shell.getDisplay(), ProfilerConfigWindow.this.execLogText, p));
                    thread.start();
                }
                catch (IOException e) {
                    ProfilerConfigWindow.this.execLogText.append(e.getMessage());
                }
            }
        });
    }

    private String joinStrings(String[] strings) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < strings.length) {
            builder.append(strings[i]);
            builder.append("\n");
            ++i;
        }
        return builder.toString();
    }

    private void fireConfigLoaded() {
        this.profilerPathText.setText(this.configuration.getProfilerPath());
        this.jvmArgsText.setText(this.configuration.getJvmArgs());
        this.programArgsText.setText(this.configuration.getProgramArgs());
        this.javaCommandText.setText(this.configuration.getJavaCommand());
        this.mainClassText.setText(this.configuration.getMainClass());
        this.classPathText.setText(this.joinStrings(this.configuration.getClassPath()));
        this.logfileDirectoryText.setText(this.configuration.getLogfileDirectory());
        this.triggerMethodText.setText(this.configuration.getTriggerMethods());
        this.packageFilterText.setText(this.joinStrings(this.configuration.getPackageFilters()));
        this.classFilterText.setText(this.joinStrings(this.configuration.getClassFilters()));
        this.methodFilterText.setText(this.joinStrings(this.configuration.getMethodFilters()));
        this.execCommandText.setText(this.configuration.toCommandLine());
    }

    private String removeNewLine(String s) {
        return s.replaceAll("\n", " ");
    }

    private String[] splitItems(String s) {
        ArrayList<String> strings = new ArrayList<String>();
        String[] lines = s.split("\n");
        int i = 0;
        while (i < lines.length) {
            String l = lines[i].trim();
            if (l.length() > 0) {
                strings.add(l);
            }
            ++i;
        }
        return strings.toArray(new String[0]);
    }

    private void updateConfig() {
        this.configuration.setProfilerPath(this.profilerPathText.getText());
        this.configuration.setJvmArgs(this.removeNewLine(this.jvmArgsText.getText()));
        this.configuration.setProgramArgs(this.removeNewLine(this.programArgsText.getText()));
        this.configuration.setJavaCommand(this.javaCommandText.getText());
        this.configuration.setMainClass(this.mainClassText.getText());
        this.configuration.setClassPath(this.splitItems(this.classPathText.getText()));
        this.configuration.setLogfileDirectory(this.logfileDirectoryText.getText());
        this.configuration.setTriggerMethods(this.triggerMethodText.getText());
        this.configuration.setPackageFilters(this.splitItems(this.packageFilterText.getText()));
        this.configuration.setClassFilters(this.splitItems(this.classFilterText.getText()));
        this.configuration.setMethodFilters(this.splitItems(this.methodFilterText.getText()));
        this.execCommandText.setText(this.configuration.toCommandLine());
    }

    private static abstract class AddItemAction {
        private boolean multiline = false;

        private AddItemAction() {
        }

        public abstract void createItem(Composite var1, Text var2);

        public void setMultiline(boolean value) {
            this.multiline = true;
        }

        public boolean isMultiline() {
            return this.multiline;
        }
    }

    private static class DirOpenButton
    extends AddItemAction {
        private String caption;

        public DirOpenButton(String caption) {
            this.caption = caption;
        }

        @Override
        public void createItem(final Composite parent, final Text text) {
            Button pushButton = new Button(parent, 0);
            pushButton.setText(this.caption);
            pushButton.setLayoutData((Object)new GridData());
            pushButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 4096);
                    String filename = dialog.open();
                    if (filename != null) {
                        if (DirOpenButton.this.isMultiline()) {
                            String s = text.getText();
                            if (s.length() > 0 && !s.endsWith("\n")) {
                                text.append("\n");
                            }
                            text.append(filename);
                            text.append("\n");
                        } else {
                            text.setText(filename);
                        }
                    }
                }
            });
        }
    }

    private static class FileOpenButton
    extends AddItemAction {
        private String caption;
        private String[] extensionFilter;

        public FileOpenButton(String caption, String[] extensionFilter) {
            this.caption = caption;
            this.extensionFilter = extensionFilter;
        }

        @Override
        public void createItem(final Composite parent, final Text text) {
            Button pushButton = new Button(parent, 0);
            pushButton.setText(this.caption);
            pushButton.setLayoutData((Object)new GridData());
            pushButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(parent.getShell(), 4096);
                    dialog.setFilterExtensions(FileOpenButton.this.extensionFilter);
                    String filename = dialog.open();
                    if (filename != null) {
                        if (FileOpenButton.this.isMultiline()) {
                            String s = text.getText();
                            if (s.length() > 0 && !s.endsWith("\n")) {
                                text.append("\n");
                            }
                            text.append(filename);
                            text.append("\n");
                        } else {
                            text.setText(filename);
                        }
                    }
                }
            });
        }
    }

    private static class MultilineItemAction
    extends AddItemAction {
        private AddItemAction item1;
        private AddItemAction item2;

        public MultilineItemAction(AddItemAction item1, AddItemAction item2) {
            this.item1 = item1;
            this.item2 = item2;
            this.setMultiline(true);
            this.item1.setMultiline(true);
            this.item2.setMultiline(true);
        }

        @Override
        public void createItem(Composite parent, Text text) {
            this.item1.createItem(parent, text);
            new PlaceHolder().createItem(parent, text);
            this.item2.createItem(parent, text);
        }
    }

    private static class PlaceHolder
    extends AddItemAction {
        @Override
        public void createItem(Composite parent, Text text) {
            Label l = new Label(parent, 0);
            l.setLayoutData((Object)new GridData());
        }
    }

    private static class ProfilerMonitor
    extends ProcessMonitorTask {
        public ProfilerMonitor(Display display, Text execLog, Process p) {
            super(display, execLog, p);
        }

        @Override
        protected void onReadLine(String line) {
        }

        @Override
        protected void onFinished() {
            this.outputText("\n*** The process is termianted. ***\n");
        }
    }
}

