/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler.gui;

import amida.calltree.CallTreeGroup;
import amida.diagram.sequencediagram.SequenceDiagramModel;
import amida.diagram.sequencediagram.gui.SequenceDiagramTabbedPane;
import amida.logloader.LogFile;
import amida.logloader.LogLoader;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class LogChooser
extends JTable {
    private static final long serialVersionUID = -2552442421042362265L;

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
    }

    public LogChooser(final TableModel model) {
        super(model);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = LogChooser.this.getSelectedRow();
                    LogFile logFile = (LogFile)model.getValueAt(index, 0);
                    CallTreeGroup group = LogLoader.load(logFile);
                    int num = group.getCallTreeNum();
                    SequenceDiagramTabbedPane diagramTab = SequenceDiagramTabbedPane.getInstance();
                    if (num > 1) {
                        int i = 0;
                        while (i < num) {
                            SequenceDiagramModel model2 = new SequenceDiagramModel(group.getCallTree(i));
                            diagramTab.addNewDiagram(model2, group.getCallTree(i).getName());
                            ++i;
                        }
                    } else {
                        SequenceDiagramModel model3 = new SequenceDiagramModel(group.getCallTree(0));
                        diagramTab.addNewDiagram(model3, logFile.getName());
                    }
                }
            }
        });
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

