/*
 * Decompiled with CFR 0.152.
 */
package amida.staticanalyzer;

import amida.calltree.CallNode;
import amida.calltree.CallTree;
import amida.calltree.CallTreeIterator;
import amida.calltree.Node;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class StaticAnalyzer {
    private static StaticAnalyzer singleton = new StaticAnalyzer();
    private Map<String, JavaClass> classMap = new HashMap<String, JavaClass>();
    private Map<String, Method> methodMap = new HashMap<String, Method>();

    private StaticAnalyzer() {
    }

    public static StaticAnalyzer getInstance() {
        return singleton;
    }

    public void analyze(CallTree tree, String[] classpathes) {
        this.addClasspath(classpathes);
        this.analyze(tree);
    }

    public void analyze(CallTree tree) {
        Stack<CallTreeIterator> itStack = new Stack<CallTreeIterator>();
        CallTreeIterator it = tree.getTopNodeList().nodeIterator();
        while (it.hasNext() || !itStack.isEmpty()) {
            if (!it.hasNext()) {
                it = (CallTreeIterator)itStack.pop();
                continue;
            }
            Node node = it.nextNode();
            if (node instanceof CallNode) {
                CallNode call = (CallNode)node;
                Set<String> set = this.classMap.keySet();
                if (!set.contains(call.getFullClassName())) {
                    JavaClass clazz = null;
                    try {
                        clazz = Repository.lookupClass((String)call.getFullClassName());
                        this.classMap.put(call.getFullClassName(), clazz);
                        Method[] methods = clazz.getMethods();
                        int i = 0;
                        while (i < methods.length) {
                            if (methods[i].getArgumentTypes().length > 0) {
                                StringBuffer buffer = new StringBuffer();
                                int j = 0;
                                while (j < methods[i].getArgumentTypes().length) {
                                    buffer.append(methods[i].getArgumentTypes()[j]);
                                    buffer.append(",");
                                    ++j;
                                }
                                this.methodMap.put(String.valueOf(call.getFullClassName()) + "." + methods[i].getName() + "(" + buffer.substring(0, buffer.length() - 1) + ")", methods[i]);
                            } else {
                                this.methodMap.put(String.valueOf(call.getFullClassName()) + "." + methods[i].getName() + "()", methods[i]);
                            }
                            ++i;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println(String.valueOf(call.getFullClassName()) + "is not found.");
                    }
                }
            }
            itStack.push(it);
            it = it.nextIterator();
        }
    }

    public void addClasspath(String[] pathes) {
        if (pathes != null && pathes.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < pathes.length) {
                buffer.append(pathes[i]);
                buffer.append(";");
                ++i;
            }
            String newPath = buffer.substring(0, buffer.length() - 1);
            String currentClasspath = System.getProperty("java.class.path");
            System.setProperty("java.class.path", String.valueOf(currentClasspath) + ";" + newPath);
            System.out.println(System.getProperty("java.class.path"));
        }
    }

    public void addClasspath(File[] files) {
    }

    public void removeClasspath(String[] pathes) {
    }
}

