/*
 * Decompiled with CFR 0.152.
 */
package amida.staticdata.java.data;

import amida.staticdata.java.data.JavaType;
import amida.staticdata.java.data.ReferenceType;
import java.util.HashMap;
import java.util.Map;

public class ArrayType
implements ReferenceType {
    private static final Map<JavaType, ArrayType> arrays = new HashMap<JavaType, ArrayType>();
    private final JavaType type;
    private final String text;

    public static ArrayType getInstance(JavaType type) {
        if (arrays.containsKey(type)) {
            return arrays.get(type);
        }
        ArrayType newArray = new ArrayType(type);
        arrays.put(type, newArray);
        return newArray;
    }

    private ArrayType(JavaType type) {
        this.type = type;
        this.text = (String.valueOf(type.getTypeName()) + "[]").intern();
    }

    @Override
    public String getTypeName() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    @Override
    public String getSimpleTypeName() {
        return this.text;
    }

    @Override
    public String getSimpleJavaTypeName() {
        return "[" + this.type.getSimpleJavaTypeName();
    }
}

