/*
 * Decompiled with CFR 0.152.
 */
package amida.utility;

import amida.utility.ClickableTextField;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;

public class LabeledTextFieldPanel
extends JPanel {
    private static final long serialVersionUID = 6517195592795158066L;
    private final ClickableTextField field;

    public LabeledTextFieldPanel(String preLabel, String afterLabel) {
        this.field = new ClickableTextField();
        this.construct(preLabel, afterLabel);
    }

    public LabeledTextFieldPanel(String text, String preLabel, String afterLabel) {
        this.field = new ClickableTextField(text);
        this.construct(preLabel, afterLabel);
    }

    public LabeledTextFieldPanel(int size, String preLabel, String afterLabel) {
        this.field = new ClickableTextField(size);
        this.construct(preLabel, afterLabel);
    }

    public LabeledTextFieldPanel(String text, int size, String preLabel, String afterLabel) {
        this.field = new ClickableTextField(text, size);
        this.construct(preLabel, afterLabel);
    }

    private void construct(String pre, String after) {
        JLabel preLabel = new JLabel(pre);
        JLabel afterLabel = new JLabel(after);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        this.setLayout(layout);
        cons.fill = 2;
        cons.anchor = 17;
        cons.weighty = 1.0;
        cons.weightx = 0.0;
        cons.gridy = 1;
        layout.setConstraints(preLabel, cons);
        this.add(preLabel);
        cons.weightx = 1.0;
        layout.setConstraints(this.field, cons);
        this.add(this.field);
        cons.weightx = 0.0;
        layout.setConstraints(afterLabel, cons);
        this.add(afterLabel);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.field.getDocument().addDocumentListener(listener);
    }

    public String getText() {
        return this.field.getText();
    }

    public void setText(String text) {
        this.field.setText(text);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.field.setEnabled(b);
    }
}

