/*
 * Decompiled with CFR 0.152.
 */
package amida.utility;

import amida.utility.Pair;
import amida.utility.PromptPrinter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class PromptPrinterCanvas
extends JPanel
implements PromptPrinter {
    private static final long serialVersionUID = -2184967581285310047L;
    private JScrollBar scrollBar = null;
    private List<Pair<String, Integer>> texts = new ArrayList<Pair<String, Integer>>();
    private int charHeight = 0;

    public PromptPrinterCanvas() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public synchronized void println(String text, int mode) {
        this.texts.add(new Pair<String, Integer>(text, new Integer(mode)));
        int needHeight = (this.texts.size() + 2) * this.charHeight;
        if (this.getSize().getHeight() < (double)needHeight) {
            this.setSize((int)this.getSize().getWidth(), needHeight);
            this.setPreferredSize(new Dimension((int)this.getSize().getWidth(), needHeight));
        }
        this.scrollEnd();
        this.repaint();
    }

    @Override
    public void clear() {
        this.texts.clear();
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.charHeight = g.getFontMetrics().getHeight();
        int size = this.texts.size();
        int i = 0;
        while (i < size) {
            Pair<String, Integer> text = this.texts.get(i);
            int mode = text.getSecond();
            if (mode == -1) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawString(text.getFirst(), 3, this.charHeight * (i + 1));
            ++i;
        }
    }

    private void scrollEnd() {
        if (this.scrollBar == null) {
            Container comp = this;
            while ((comp = comp.getParent()) != null && !(comp instanceof JScrollPane)) {
            }
            if (comp != null) {
                this.scrollBar = ((JScrollPane)comp).getVerticalScrollBar();
            } else {
                return;
            }
        }
        BoundedRangeModel model = this.scrollBar.getModel();
        model.setValue(model.getMaximum());
    }
}

