/*
 * Decompiled with CFR 0.152.
 */
package amida.logloader;

import amida.LanguageType;
import amida.logdecoder.Dictionary;
import amida.logdecoder.DictionaryLoader;
import amida.logdecoder.MethodSignature;
import amida.logloader.LogEntry;
import amida.logloader.LogParser;
import amida.logloader.MethodCallEntry;
import amida.logloader.MethodExitEntry;
import amida.logloader.ThreadStartEntry;
import amida.logloader.UnknownEntry;
import amida.staticdata.StaticDataAccessor;
import amida.staticdata.Type;
import amida.staticdata.java.JavaStaticDataAccessor;
import amida.staticdata.java.data.JavaAccessModifier;
import amida.staticdata.java.data.JavaType;
import amida.staticdata.java.data.JavaTypeManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;

public class DefaultBinaryLogParser
implements LogParser {
    private static final int INT_SIZE = 4;
    public static final int BYTES_SIZE = 4;
    private static final int METHOD_OFFSET = 0;
    private static final int OBJECT_OFFSET = 1;
    private static final int METHOD_COUNT_OFFSET = 2;
    private static final int THREAD_OFFSET = 4;
    private final Dictionary dictionary;
    private Queue<LogEntry> entries = new LinkedList<LogEntry>();
    private final Set<Integer> threadIdSet = new TreeSet<Integer>();
    private boolean threadRecorded = false;

    public DefaultBinaryLogParser(File indexFile, LanguageType type) {
        this.dictionary = DictionaryLoader.loadDictionary(indexFile.getAbsolutePath());
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(indexFile));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("Thread")) continue;
                this.threadRecorded = true;
                break;
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Queue<LogEntry> parse(Object o) {
        if (!(o instanceof byte[])) {
            this.entries.offer(UnknownEntry.getInstance());
            return this.entries;
        }
        byte[] data = (byte[])o;
        int methodCount = this.getIntValue(data, 2);
        int methodIndex = this.getIntValue(data, 0);
        int objectId = this.getIntValue(data, 1);
        int threadId = 0;
        if (data.length >= 5) {
            threadId = this.getIntValue(data, 4);
        }
        if (methodIndex == 0) {
            this.entries.offer(new MethodExitEntry(threadId));
            return this.entries;
        }
        if (!this.threadIdSet.contains(threadId)) {
            this.threadIdSet.add(threadId);
            this.entries.offer(new ThreadStartEntry(this.dictionary.getThread(threadId), threadId));
        }
        MethodSignature methodSignature = this.dictionary.decode(methodIndex);
        JavaStaticDataAccessor accessor = JavaStaticDataAccessor.getInstance();
        JavaType returnType = JavaTypeManager.getType(methodSignature.getReturnType());
        String[] args = methodSignature.getArgs();
        Type[] argTypes = new Type[args.length];
        int i = 0;
        while (i < args.length) {
            argTypes[i] = JavaTypeManager.getType(args[i]);
            ++i;
        }
        this.entries.offer(new MethodCallEntry(threadId, methodCount, ((StaticDataAccessor)accessor).makeMethodData(((StaticDataAccessor)accessor).makeClassData(String.valueOf(methodSignature.getPackageName()) + "." + methodSignature.getClassName()), methodSignature.getMethodName(), returnType, argTypes, objectId == 0, JavaAccessModifier.getInstance(JavaAccessModifier.ACCESS_MODIFIER.UNDECIDED)), objectId, -1L));
        return this.entries;
    }

    private int bytesToInt(byte[] data) {
        if (data.length != 4 || data.length <= 0) {
            return 0;
        }
        int result = 0;
        int rate = 1;
        int i = 0;
        while (i < data.length - 1) {
            int b = data[i];
            int j = 0;
            while (j < 8) {
                if ((b & 1) == 1) {
                    result += rate;
                }
                b >>= 1;
                rate *= 2;
                ++j;
            }
            ++i;
        }
        int b = data[data.length - 1];
        int j = 0;
        while (j < 7) {
            if ((b & 1) == 1) {
                result += rate;
            }
            b >>= 1;
            rate *= 2;
            ++j;
        }
        if ((b & 1) == 1) {
            result *= -1;
        }
        return result;
    }

    private int getIntValue(byte[] data, int index) {
        byte[] intData = new byte[4];
        try {
            System.arraycopy(data, index * 4, intData, 0, 4);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
        return this.bytesToInt(intData);
    }

    public int getPrefferedUnitSize() {
        if (this.threadRecorded) {
            return 16;
        }
        return 20;
    }
}

