/*
 * Decompiled with CFR 0.152.
 */
package amida.profiler;

import amida.logmanager.AmidaProperty;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProfilerConfig {
    private static final String COMMNET_PROGRAM_ATTRIBUTE = "; Attributes for Amida Manager to execute a Java program.";
    private static final String COMMNET_PROFILER_ATTRIBUTE = "; Attributes for Amida Profiler.";
    private static final String KEY_VALUE_SEPARATOR = "=";
    public static final String DEFAULT_VMARGS = "-Xdebug -Djava.compiler=NONE";
    private static final String KEY_LOGFILE_DIRECTORY = "LogfileDirectory";
    private static final String KEY_COMPRESS_LOGFILE = "CompressLogfile";
    private static final String KEY_RECORD_FILTERED_METHODS = "GetFilteredMethod";
    private static final String KEY_RECORD_THREAD_ID = "RecordThreadID";
    private static final String KEY_TRIGGER_METHODS = "StartMethod";
    private static final String KEY_RECORD_METHOD_CALL_COUNT = "RecordMethodCallCount";
    private static final String KEY_CREATE_FILE_PER_THREAD = "SeparateLogfilePerThread";
    private static final String KEY_RECORD_CALLER_LOCATION = "RecordCallerLocation";
    private static final String KEY_RECORD_ONLY_MATCHED_METHODS = "FilterMode";
    private static final String KEY_PACKAGE_FILTER = "PackageFilter";
    private static final String KEY_CLASS_FILTER = "ClassFilter";
    private static final String KEY_METHOD_FILTER = "MethodFilter";
    private static final String KEY_IGNORE_BUILTIN_CLASS = "IgnoreBuiltInClas";
    private static final String KEY_VERBOSE = "Verbose";
    private static final String KEY_JAVA_COMMAND = "JavaCommand";
    private static final String KEY_CLASSPATH = "Classpath";
    private static final String KEY_JVM_ARGS = "JvmArgs";
    private static final String KEY_MAIN_CLASS = "MainClass";
    private static final String KEY_PROGRAM_ARGS = "ProgramArgs";
    private static final String KEY_PROFILER_PATH = "ProfilerPath";
    private File configFile;
    private String javaCommand = AmidaProperty.getInstance().getJavaCommand();
    private String[] classPath = new String[0];
    private String jvmArgs = "";
    private String mainClass = "";
    private String programArgs = "";
    private String profilerPath = "amidaprof.dll";
    private String logfileDirectory = new File(".").getAbsoluteFile().getParent();
    private boolean recordCallsToFilteredMethods = false;
    private boolean recordCallerLocation = true;
    private String triggerMethods = "*";
    private String[] packageFilters = new String[0];
    private String[] classFilters = new String[0];
    private String[] methodFilters = new String[0];
    private boolean recordOnlyMatchedMethods = false;
    private boolean compressLogfile = false;
    private boolean recordThreadID = true;
    private boolean recordMethodCallCount = true;
    private boolean createFilePerThread = false;
    private boolean ignoreBuiltinClass = true;
    private boolean verbose = false;

    public ProfilerConfig() {
    }

    public ProfilerConfig(File configFile) throws IOException {
        this();
        String line;
        HashMap data = new HashMap();
        LineNumberReader reader = new LineNumberReader(new FileReader(configFile));
        while ((line = reader.readLine()) != null) {
            int idx;
            if (line.startsWith(";") || (idx = line.indexOf(KEY_VALUE_SEPARATOR)) == -1) continue;
            String key = line.substring(0, idx).trim();
            String value = line.substring(idx + 1).trim();
            if (data.containsKey(key)) {
                ((List)data.get(key)).add(value);
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            data.put(key, values);
        }
        reader.close();
        try {
            if (data.containsKey(KEY_LOGFILE_DIRECTORY)) {
                this.logfileDirectory = this.getValue((List)data.get(KEY_LOGFILE_DIRECTORY));
            }
            if (data.containsKey(KEY_COMPRESS_LOGFILE)) {
                this.compressLogfile = this.parseBool(this.getValue((List)data.get(KEY_COMPRESS_LOGFILE)));
            }
            if (data.containsKey(KEY_RECORD_FILTERED_METHODS)) {
                this.recordCallsToFilteredMethods = this.parseBool(this.getValue((List)data.get(KEY_RECORD_FILTERED_METHODS)));
            }
            if (data.containsKey(KEY_RECORD_THREAD_ID)) {
                this.recordThreadID = this.parseBool(this.getValue((List)data.get(KEY_RECORD_THREAD_ID)));
            }
            if (data.containsKey(KEY_TRIGGER_METHODS)) {
                this.triggerMethods = this.getValue((List)data.get(KEY_TRIGGER_METHODS));
            }
            if (data.containsKey(KEY_RECORD_METHOD_CALL_COUNT)) {
                this.recordMethodCallCount = this.parseBool(this.getValue((List)data.get(KEY_RECORD_METHOD_CALL_COUNT)));
            }
            if (data.containsKey(KEY_CREATE_FILE_PER_THREAD)) {
                this.createFilePerThread = this.parseBool(this.getValue((List)data.get(KEY_CREATE_FILE_PER_THREAD)));
            }
            if (data.containsKey(KEY_RECORD_CALLER_LOCATION)) {
                this.recordCallerLocation = this.parseBool(this.getValue((List)data.get(KEY_RECORD_CALLER_LOCATION)));
            }
            if (data.containsKey(KEY_RECORD_ONLY_MATCHED_METHODS)) {
                this.recordOnlyMatchedMethods = this.parseBool(this.getValue((List)data.get(KEY_RECORD_ONLY_MATCHED_METHODS)));
            }
            if (data.containsKey(KEY_PACKAGE_FILTER)) {
                this.packageFilters = this.getValues((List)data.get(KEY_PACKAGE_FILTER));
            }
            if (data.containsKey(KEY_CLASS_FILTER)) {
                this.classFilters = this.getValues((List)data.get(KEY_CLASS_FILTER));
            }
            if (data.containsKey(KEY_METHOD_FILTER)) {
                this.methodFilters = this.getValues((List)data.get(KEY_METHOD_FILTER));
            }
            if (data.containsKey(KEY_JAVA_COMMAND)) {
                this.javaCommand = this.getValue((List)data.get(KEY_JAVA_COMMAND));
            }
            if (data.containsKey(KEY_CLASSPATH)) {
                this.classPath = this.getValues((List)data.get(KEY_CLASSPATH));
            }
            if (data.containsKey(KEY_JVM_ARGS)) {
                this.jvmArgs = this.getValue((List)data.get(KEY_JVM_ARGS));
            }
            if (data.containsKey(KEY_MAIN_CLASS)) {
                this.mainClass = this.getValue((List)data.get(KEY_MAIN_CLASS));
            }
            if (data.containsKey(KEY_PROGRAM_ARGS)) {
                this.programArgs = this.getValue((List)data.get(KEY_PROGRAM_ARGS));
            }
            if (data.containsKey(KEY_PROFILER_PATH)) {
                this.profilerPath = this.getValue((List)data.get(KEY_PROFILER_PATH));
            }
            this.configFile = configFile;
        }
        catch (NullPointerException e) {
            throw new IOException("Invalid File Format", e);
        }
    }

    private String getValue(List<String> values) {
        return values.get(0);
    }

    private String[] getValues(List<String> values) {
        return values.toArray(new String[0]);
    }

    public String toCommandLine() {
        if (this.configFile == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.javaCommand);
        builder.append(" ");
        if (this.classPath.length > 0) {
            builder.append("-classpath \"");
            int i = 0;
            while (i < this.classPath.length) {
                if (i > 0) {
                    builder.append(File.pathSeparator);
                }
                builder.append(this.classPath[i]);
                ++i;
            }
            builder.append("\" ");
        }
        builder.append(this.jvmArgs);
        builder.append(" ");
        builder.append("-agentpath:");
        builder.append(this.profilerPath);
        builder.append(KEY_VALUE_SEPARATOR);
        builder.append(this.configFile.getAbsolutePath());
        builder.append(" ");
        builder.append(DEFAULT_VMARGS);
        builder.append(" ");
        builder.append(this.mainClass);
        builder.append(" ");
        builder.append(this.programArgs);
        return builder.toString();
    }

    public boolean saveAs(File file) {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            writer.println(COMMNET_PROFILER_ATTRIBUTE);
            this.write(writer, KEY_LOGFILE_DIRECTORY, this.logfileDirectory);
            this.write(writer, KEY_COMPRESS_LOGFILE, this.compressLogfile);
            this.write(writer, KEY_RECORD_FILTERED_METHODS, this.recordCallsToFilteredMethods);
            this.write(writer, KEY_RECORD_THREAD_ID, this.recordThreadID);
            this.write(writer, KEY_TRIGGER_METHODS, this.triggerMethods);
            this.write(writer, KEY_RECORD_METHOD_CALL_COUNT, this.recordMethodCallCount);
            this.write(writer, KEY_CREATE_FILE_PER_THREAD, this.createFilePerThread);
            this.write(writer, KEY_RECORD_CALLER_LOCATION, this.recordCallerLocation);
            this.write(writer, KEY_RECORD_ONLY_MATCHED_METHODS, this.recordOnlyMatchedMethods);
            this.write(writer, KEY_PACKAGE_FILTER, this.packageFilters);
            this.write(writer, KEY_CLASS_FILTER, this.classFilters);
            this.write(writer, KEY_METHOD_FILTER, this.methodFilters);
            this.write(writer, KEY_VERBOSE, this.verbose);
            this.write(writer, KEY_IGNORE_BUILTIN_CLASS, this.ignoreBuiltinClass);
            writer.println(COMMNET_PROGRAM_ATTRIBUTE);
            this.write(writer, KEY_JAVA_COMMAND, this.javaCommand);
            this.write(writer, KEY_CLASSPATH, this.classPath);
            this.write(writer, KEY_JVM_ARGS, this.jvmArgs);
            this.write(writer, KEY_MAIN_CLASS, this.mainClass);
            this.write(writer, KEY_PROGRAM_ARGS, this.programArgs);
            this.write(writer, KEY_PROFILER_PATH, this.profilerPath);
            writer.close();
            this.configFile = file;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void write(PrintWriter w, String key, String value) {
        w.print(key);
        w.print(KEY_VALUE_SEPARATOR);
        w.print(value);
        w.println();
    }

    private void write(PrintWriter w, String key, boolean value) {
        w.print(key);
        w.print(KEY_VALUE_SEPARATOR);
        w.print(this.boolToStr(value));
        w.println();
    }

    private void write(PrintWriter w, String key, String[] values) {
        int i = 0;
        while (i < values.length) {
            this.write(w, key, values[i]);
            ++i;
        }
    }

    private String boolToStr(boolean b) {
        if (b) {
            return "1";
        }
        return "0";
    }

    private boolean parseBool(String s) {
        return !s.equals("0");
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public void setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
    }

    public String[] getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String[] classPath) {
        this.classPath = classPath;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public void setJvmArgs(String jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getProgramArgs() {
        return this.programArgs;
    }

    public void setProgramArgs(String programArgs) {
        this.programArgs = programArgs;
    }

    public String getProfilerPath() {
        return this.profilerPath;
    }

    public void setProfilerPath(String profilerPath) {
        this.profilerPath = profilerPath;
    }

    public String getLogfileDirectory() {
        return this.logfileDirectory;
    }

    public void setLogfileDirectory(String logfileDirectory) {
        this.logfileDirectory = logfileDirectory;
    }

    public boolean getRecordCallsToFilteredMethods() {
        return this.recordCallsToFilteredMethods;
    }

    public void setRecordCallsToFilteredMethods(boolean recordCallsToFilteredMethods) {
        this.recordCallsToFilteredMethods = recordCallsToFilteredMethods;
    }

    public boolean getRecordCallerLocation() {
        return this.recordCallerLocation;
    }

    public void setRecordCallerLocation(boolean recordCallerLocation) {
        this.recordCallerLocation = recordCallerLocation;
    }

    public String getTriggerMethods() {
        return this.triggerMethods;
    }

    public void setTriggerMethods(String triggerMethods) {
        this.triggerMethods = triggerMethods;
    }

    public String[] getPackageFilters() {
        return this.packageFilters;
    }

    public void setPackageFilters(String[] packageFilters) {
        this.packageFilters = packageFilters;
    }

    public String[] getClassFilters() {
        return this.classFilters;
    }

    public void setClassFilters(String[] classFilters) {
        this.classFilters = classFilters;
    }

    public String[] getMethodFilters() {
        return this.methodFilters;
    }

    public void setMethodFilters(String[] methodFilters) {
        this.methodFilters = methodFilters;
    }

    public boolean getRecordOnlyMatchedMethods() {
        return this.recordOnlyMatchedMethods;
    }

    public void setRecordOnlyMatchedMethods(boolean recordOnlyMatchedMethods) {
        this.recordOnlyMatchedMethods = recordOnlyMatchedMethods;
    }

    public boolean getCompressLogfile() {
        return this.compressLogfile;
    }

    public void setCompressLogfile(boolean compressLogfile) {
        this.compressLogfile = compressLogfile;
    }

    public boolean getRecordThreadID() {
        return this.recordThreadID;
    }

    public void setRecordThreadID(boolean recordThreadID) {
        this.recordThreadID = recordThreadID;
    }

    public boolean getRecordMethodCallCount() {
        return this.recordMethodCallCount;
    }

    public void setRecordMethodCallCount(boolean recordMethodCallCount) {
        this.recordMethodCallCount = recordMethodCallCount;
    }

    public boolean getCreateFilePerThread() {
        return this.createFilePerThread;
    }

    public void setCreateFilePerThread(boolean createFilePerThread) {
        this.createFilePerThread = createFilePerThread;
    }
}

