/*
 * Decompiled with CFR 0.152.
 */
package amida.staticdata;

import amida.staticdata.ClassData;
import amida.staticdata.MethodData;

public class StaticDataBuildFilter {
    private final String pattern;
    private final String nullTerminatedPattern;
    private final boolean containsAsterisk;

    public StaticDataBuildFilter(String pattern) {
        this.pattern = pattern;
        this.nullTerminatedPattern = String.valueOf(pattern) + '\u0000';
        this.containsAsterisk = pattern.contains("*");
    }

    public boolean filterOutClass(ClassData cl) {
        boolean result = false;
        if (cl != null) {
            String text = cl.getFullName();
            result = !this.containsAsterisk ? text.equals(this.pattern) : this.matches(text);
        }
        return result;
    }

    public boolean filterOutMethod(MethodData method) {
        boolean result = false;
        if (method != null) {
            String text = String.valueOf(method.getBelongClass().getFullName()) + method.getName();
            result = !this.containsAsterisk ? text.equals(this.pattern) : this.matches(text);
        }
        return result;
    }

    private boolean matches(String text) {
        text = String.valueOf(text) + '\u0000';
        int n = this.nullTerminatedPattern.length();
        boolean[] states = null;
        boolean[] old = new boolean[n + 1];
        old[0] = true;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            states = new boolean[n + 1];
            int j = 0;
            while (j < n) {
                char p = this.nullTerminatedPattern.charAt(j);
                if (old[j]) {
                    if (p == '*') {
                        old[j + 1] = true;
                        states[j] = true;
                        states[j + 1] = true;
                    } else if (p == c) {
                        states[j + 1] = true;
                    }
                }
                ++j;
            }
            old = states;
            ++i;
        }
        return states[n];
    }
}

