/*
 * Decompiled with CFR 0.152.
 */
package amida.viewer;

import amida.calltree.BlockNode;
import amida.calltree.CallNode;
import amida.calltree.CallTree;
import amida.calltree.CallTreeIterator;
import amida.calltree.LoopNode;
import amida.calltree.Node;
import amida.calltree.NodeList;
import amida.diagram.sequencediagram.RecursiveCallBlock;
import amida.diagram.sequencediagram.SeparateBlock;
import amida.diagram.sequencediagram.Sequence;
import amida.diagram.sequencediagram.SequenceBlock;
import amida.diagram.sequencediagram.SequenceLoop;
import amida.diagram.sequencediagram.SequenceObject;
import amida.utility.DataChangeListener;
import amida.viewer.ModelChangeListener;
import amida.viewer.ObjectManager;
import amida.viewer.filter.FilterSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public class SequenceDiagramModel
implements DataChangeListener {
    private String filename;
    private List<ModelChangeListener> modelChangeListeners = new LinkedList<ModelChangeListener>();
    private CallTree callTree;
    private Node targetNode;
    private NodeList targetNodeList;
    private List<SequenceObject> objectList;
    private List<Sequence> sequenceList;
    private List<SequenceLoop> loopList;
    private List<SequenceBlock> blockList;
    private int maxLoopDepth = 0;
    private ObjectManager objectManager = null;
    private FilterSet filters = null;
    private List<SequenceObject> tmpObjectList;
    private List<Sequence> tmpSequenceList;
    private List<SequenceLoop> tmpLoopList;
    private List<SequenceBlock> tmpBlockList;
    private int tmpMaxLoopDepth;
    private Comparator<SequenceObject> sorter;
    private Stack<SequenceObject> loopStack = new Stack();
    private int sequenceCount = 0;

    public SequenceDiagramModel(String filename, CallTree tree, FilterSet filters) {
        this.filename = filename;
        this.callTree = tree;
        this.callTree.addDataChangeListener(this);
        this.filters = filters;
        this.renew();
    }

    public SequenceDiagramModel(String filename, Node node, FilterSet filters) {
        this.filename = filename;
        this.targetNode = node;
        this.callTree = node.getCallTree();
        this.callTree.addDataChangeListener(this);
        this.filters = filters;
        this.renew();
    }

    public SequenceDiagramModel(String filename, NodeList list, FilterSet filters) {
        this.filename = filename;
        this.targetNodeList = list;
        this.callTree = list.getCallTree();
        this.callTree.addDataChangeListener(this);
        this.filters = filters;
        this.renew();
    }

    public void dispose() {
        this.callTree.removeDataChangeListener(this);
    }

    public void setSorter(Comparator<SequenceObject> sorter) {
        this.sorter = sorter;
        this.renew();
    }

    public void renew() {
        if (this.targetNodeList == null && this.targetNode == null && (this.callTree == null || this.callTree.getTopNodeList() == null)) {
            return;
        }
        this.fireModelChanging();
        this.tmpLoopList = new ArrayList<SequenceLoop>();
        this.tmpObjectList = new ArrayList<SequenceObject>();
        this.tmpSequenceList = new ArrayList<Sequence>();
        this.tmpBlockList = new ArrayList<SequenceBlock>();
        this.tmpMaxLoopDepth = 0;
        this.loopStack.clear();
        this.sequenceCount = 0;
        NodeList nodes = null;
        Node node = null;
        if (this.targetNode != null) {
            node = this.targetNode;
            this.objectManager = new ObjectManager(node, this.filters);
            this.makeSequenceModel(node, null, this.loopStack, 0, null);
        } else if (this.targetNodeList != null || this.callTree != null) {
            nodes = this.targetNodeList != null ? this.targetNodeList : this.callTree.getTopNodeList();
            this.objectManager = new ObjectManager(nodes, this.filters);
            this.makeSequenceModel(nodes, null, this.loopStack, 0, null);
        }
        if (this.sorter != null) {
            Collections.sort(this.tmpObjectList, this.sorter);
            ListIterator<SequenceObject> it = this.tmpObjectList.listIterator();
            while (it.hasNext()) {
                it.next().setIndex(it.nextIndex());
            }
        }
        this.reflectNewData();
        this.fireModelChanged();
    }

    private void makeSequenceModel(NodeList list, SequenceObject callParent, Stack<SequenceObject> loopStack, int blockDepth, Stack<Sequence> passThroughParent) {
        CallTreeIterator it = list.nodeIterator();
        while (it.hasNext()) {
            Node node = it.next();
            this.makeSequenceModel(node, callParent, loopStack, blockDepth, passThroughParent);
        }
    }

    private void makeSequenceModel(Node node, SequenceObject callParent, Stack<SequenceObject> loopStack, int blockDepth, Stack<Sequence> passThroughParent) {
        if (node instanceof CallNode) {
            Sequence newSequence;
            int filtered;
            CallNode call = (CallNode)node;
            SequenceObject object = this.objectManager.getObject(call);
            if (object.isDeleted()) {
                return;
            }
            if (call.isConstructor() && object.getMadeIndex() == 0) {
                object.renewClassName(call);
            }
            if ((filtered = this.filters.applyMethodFilters(newSequence = call.isRecursive() && !call.hasChildren() ? new Sequence(call, callParent, object, 3, this.sequenceCount) : new Sequence(call, callParent, object, 0, this.sequenceCount))) == 3) {
                return;
            }
            if (object.isHidden() || filtered == 2) {
                if (passThroughParent == null) {
                    passThroughParent = new Stack();
                }
                passThroughParent.push(newSequence);
                this.makeSequenceModel(node.getChildren(), callParent, loopStack, blockDepth, passThroughParent);
                passThroughParent.pop();
            } else {
                if (object.getIndex() <= 0) {
                    object.setAppearanceIndex(this.tmpObjectList.size() + 1);
                    this.tmpObjectList.add(object);
                }
                ++this.sequenceCount;
                this.tmpSequenceList.add(newSequence);
                if (callParent != null) {
                    callParent.addCallSequence(newSequence);
                }
                if (!call.isRecursive() || call.hasChildren()) {
                    object.call(newSequence, this.tmpSequenceList.size());
                }
                if (call.isBranch()) {
                    newSequence.setBranch(true);
                }
                if (passThroughParent != null) {
                    ArrayList<Sequence> clone = new ArrayList<Sequence>(passThroughParent.size());
                    clone.addAll(passThroughParent);
                    newSequence.setIndirectSequence(clone);
                }
                if (!object.getIds().contains(new Integer(0)) && object.getMadeIndex() == 0) {
                    object.make(this.tmpSequenceList.size());
                }
                int tmpBlockDepth = 0;
                if (call.isRecursive() && call.hasChildren()) {
                    tmpBlockDepth = blockDepth++;
                }
                if (filtered == 0) {
                    this.makeSequenceModel(node.getChildren(), object, loopStack, blockDepth, null);
                }
                object.used(this.sequenceCount);
                Sequence newSequence2 = null;
                newSequence2 = call.getExitMode() == 2 ? (!call.isRecursive() || call.hasChildren() ? new Sequence(call, object, callParent, 5, this.sequenceCount++) : new Sequence(call, object, callParent, 6, this.sequenceCount++)) : (call.getReturnTypeName().equals("void") || !call.isEnded() ? new Sequence(call, object, callParent, 2, this.sequenceCount++) : (call.isRecursive() && !call.hasChildren() ? new Sequence(call, object, callParent, 4, this.sequenceCount++) : new Sequence(call, object, callParent, 1, this.sequenceCount++)));
                this.tmpSequenceList.add(newSequence2);
                if (callParent != null) {
                    callParent.addCallSequence(newSequence2);
                }
                newSequence.setPareSequence(newSequence2);
                if (!call.isRecursive() || call.hasChildren()) {
                    object.ret(newSequence2, this.tmpSequenceList.size() - 1);
                }
                if (call.isRecursive() && call.hasChildren()) {
                    RecursiveCallBlock recursiveBlock = new RecursiveCallBlock(tmpBlockDepth, callParent);
                    recursiveBlock.setStartIndex(newSequence.getIndex());
                    recursiveBlock.setEndIndex(newSequence2.getIndex());
                    recursiveBlock.setSequenceList(new ArrayList<Sequence>((Collection)this.tmpSequenceList.subList(newSequence.getIndex(), newSequence2.getIndex() + 1)));
                    this.tmpBlockList.add(recursiveBlock);
                }
            }
        } else if (node instanceof LoopNode) {
            int loopStart = this.tmpSequenceList.size();
            loopStack.push(callParent);
            this.makeSequenceModel(node.getChildren(), callParent, loopStack, blockDepth, null);
            loopStack.pop();
            int loopEnd = this.tmpSequenceList.size();
            if (loopStart != loopEnd) {
                Iterator stackEntry = loopStack.iterator();
                int count = 1;
                while (stackEntry.hasNext()) {
                    if (callParent != stackEntry.next()) continue;
                    ++count;
                }
                if (count > this.tmpMaxLoopDepth) {
                    this.tmpMaxLoopDepth = count;
                }
                this.tmpLoopList.add(new SequenceLoop((LoopNode)node, loopStart, loopEnd - 1, callParent, count));
            }
        } else if (node instanceof BlockNode) {
            BlockNode block = (BlockNode)node;
            if (block.hasChildren()) {
                int start = this.sequenceCount;
                this.makeSequenceModel(node.getChildren(), callParent, loopStack, ++blockDepth, null);
                int end = this.sequenceCount - 1;
                if (end - start > 0) {
                    SeparateBlock separateBlock = new SeparateBlock(block, blockDepth, callParent);
                    separateBlock.setStartIndex(start);
                    separateBlock.setEndIndex(end);
                    separateBlock.setSequenceList(new ArrayList<Sequence>((Collection)this.tmpSequenceList.subList(start, end)));
                    this.tmpBlockList.add(separateBlock);
                }
            } else {
                SeparateBlock separateBlock = new SeparateBlock(block, blockDepth, callParent);
                separateBlock.setStartIndex(this.sequenceCount);
                separateBlock.setEndIndex(this.sequenceCount);
                separateBlock.setSequenceList(new ArrayList<Sequence>());
                this.tmpBlockList.add(separateBlock);
                Sequence one = new Sequence(null, callParent, callParent, 2, this.sequenceCount++);
                Sequence two = new Sequence(null, callParent, callParent, 2, this.sequenceCount++);
                one.setPareSequence(two);
                this.tmpSequenceList.add(one);
                this.tmpSequenceList.add(two);
            }
        } else {
            this.makeSequenceModel(node.getChildren(), callParent, loopStack, blockDepth, null);
        }
    }

    private synchronized void reflectNewData() {
        this.loopList = this.tmpLoopList;
        this.objectList = this.tmpObjectList;
        this.sequenceList = this.tmpSequenceList;
        this.blockList = this.tmpBlockList;
        this.maxLoopDepth = this.tmpMaxLoopDepth;
    }

    public synchronized Sequence getSequence(int i) {
        return this.sequenceList.get(i);
    }

    public synchronized int getSequenceNum() {
        return this.sequenceList.size();
    }

    public synchronized List<SequenceObject> getObjectList() {
        return Collections.unmodifiableList(this.objectList);
    }

    public synchronized SequenceObject getObject(int i) {
        return this.objectList.get(i);
    }

    public synchronized int getObjectNum() {
        return this.objectList.size();
    }

    public synchronized SequenceLoop getLoop(int i) {
        return this.loopList.get(i);
    }

    public synchronized int getLoopNum() {
        return this.loopList.size();
    }

    public synchronized SequenceBlock getBlock(int i) {
        return this.blockList.get(i);
    }

    public synchronized int getBlockNum() {
        return this.blockList.size();
    }

    public synchronized int getMaxLoopDepth() {
        return this.maxLoopDepth;
    }

    @Override
    public void dataChanged() {
        this.renew();
    }

    public void addModelChangeListener(ModelChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public void removeModelChangeListener(ModelChangeListener listener) {
        this.modelChangeListeners.remove(listener);
    }

    private void fireModelChanging() {
        for (ModelChangeListener listener : this.modelChangeListeners) {
            listener.changing(this);
        }
    }

    private void fireModelChanged() {
        for (ModelChangeListener listener : this.modelChangeListeners) {
            listener.changed(this);
        }
    }

    public CallTree getCallTree() {
        return this.callTree;
    }

    public Node getTargetNode() {
        return this.targetNode;
    }

    public NodeList getTargetNodeList() {
        return this.targetNodeList;
    }

    public FilterSet getFilters() {
        return this.filters;
    }

    public String getFileName() {
        return this.filename;
    }
}

