unit frmMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OleServer, PowerPointXP, ComCtrls,
  BrwsFldr;

type
  TForm1 = class(TForm)
    PptApp: TPowerPointApplication;
    ActivatePptBtn: TButton;
    Button2: TButton;
    DirNameBox: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    FileNameBox: TEdit;
    FilterBox: TComboBox;
    Label3: TLabel;
    DirBrowseBtn: TButton;
    OutputProgress: TProgressBar;
    ProgressLabel: TLabel;
    DirAutoCreate: TCheckBox;
    procedure ActivatePptBtnClick(Sender: TObject);
    procedure PptAppSlideShowBegin(ASender: TObject;
      const Wn: SlideShowWindow);
    procedure Button2Click(Sender: TObject);
    procedure DirBrowseBtnClick(Sender: TObject);
  private
    { Private 錾 }
    procedure execConversion;
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

uses
  Math;

{$R *.dfm}

procedure TForm1.ActivatePptBtnClick(Sender: TObject);
begin
    PptApp.Activate;
    PptApp.Connect;
end;

procedure TForm1.PptAppSlideShowBegin(ASender: TObject;
  const Wn: SlideShowWindow);
var
  //slides: Slides;
  slide : _Slide;
begin
  Button2.Caption := WN.Presentation.Name;
      slide :=  Wn.View.Slide;
    slide.Export('C:\test.png', 'png', 800, 600);
end;

procedure TForm1.execConversion;
var
  slide: _Slide;
  i: integer;
  count: integer;

  columns: integer;
  filenameFormat: string;
begin
  count := PptApp.ActiveWindow.Presentation.Slides.Count;
  outputProgress.Max := count;
  outputProgress.Position := 0;
  columns := Floor(log10(Count)) + 1;
  filenameFormat := '%' + IntToStr(columns) + '.' + IntToStr(columns) + 'd';
  for i:=1 to count do begin
    slide := PptApp.ActiveWindow.Presentation.Slides.Item(i);
    slide.Export(DirNameBox.Text + '\' + FileNameBox.Text + Format(filenameFormat, [i]) + '.' + FilterBox.Text, FilterBox.Text , 800, 600);
    outputProgress.Position := i;
  end;

end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if PptApp.Presentations.Count = 0 then begin
    MessageDlg('t@CJĂ܂D', mtInformation, [mbok], 0);
    exit;
  end;

  if not DirectoryExists(DirNameBox.Text) then begin
    if DirAutoCreate.Checked then begin
      if not CreateDir(DirNameBox.Text) then begin
        MessageDlg('o͐fBNg' + DirNameBox.Text + '쐬ł܂D', mtError, [mbOK], 0);
        exit;
      end;
    end else begin
      MessageDlg('o͐fBNg' + DirNameBox.Text + '܂D', mtError, [mbOK], 0);
      exit;
    end;
  end;

  try
    ProgressLabel.Caption := 'ݏł ...';
    ProgressLabel.Repaint;
    execConversion;
    ProgressLabel.Caption := 'I܂D';
  except
    on E: Exception do begin
      MessageDlg('ɃG[܂: ' + E.Message, mtError, [mbOK], 0);
      ProgressLabel.Caption := 'f܂D';
    end;
  end;
end;

procedure TForm1.DirBrowseBtnClick(Sender: TObject);
var
  BF : TBrowseFolderBox;
begin
  BF := TBrowseFolderBox.Create;
  try
    BF.InitFolder := DirNameBox.Text;;         //ItH_ C:\ 
    BF.Title := 'tH_I';   //_CAO{bNX̃^Cg
    BF.Flags := BF.Flags or bifStatusText;
                                    //Xe[^XeLXgɃJ[\
                                    //ʒutH_̃tpX\
    BF.SizeX := 0; BF.SizeY := 0;
                                    //TCYύXiIWi
                                    //-50Ac+100̑傫j
    BF.PosX := self.Left + self.Width div 4;
    BF.PosY := self.Top + self.Height div 4;  //_CAÖʒuw
    if BF.Execute then begin
      DirNameBox.Text := BF.SelectFolder;
    end;
  finally
    BF.Free;
  end;
end;

end.
