/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.CallNode;
import amida.calltree.CallTree;
import amida.calltree.CallTreeGroup;
import amida.calltree.Node;
import amida.log.MethodCallEntry;
import amida.log.MethodData;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public class CallTreeBuilder {
    private CallTreeGroup group;
    private CallTree tree;
    private Stack<CallNode> callStack = new Stack();
    private int methodCallNum = 0;
    private Map<CallNode, MethodCallEntry> returnToMap = new HashMap<CallNode, MethodCallEntry>();
    private MethodCallEntry theLastReturnTo;

    public CallTreeBuilder(CallTreeGroup group) {
        this.group = group;
        this.tree = new CallTree();
    }

    public CallTree getTree() {
        return this.tree;
    }

    public CallNode getCurrentCallNode() {
        if (this.callStack.isEmpty()) {
            return null;
        }
        return this.callStack.peek();
    }

    public Stack<CallNode> getCurrentCallStack() {
        return this.callStack;
    }

    private void processCall(int callerID, int calleeID) {
        this.group.registerCall(callerID, calleeID);
    }

    public void pushNewCaller() {
        CallNode newNode = new CallNode(this.tree, this.theLastReturnTo.getMethod(), this.theLastReturnTo.getObjectId(), this.theLastReturnTo.getMethodCallCount());
        ListIterator<Node> it = this.tree.getTopNodeList().listIterator();
        while (it.hasNext()) {
            CallNode n = (CallNode)it.next();
            MethodCallEntry returnTo = this.returnToMap.get(n);
            if (!returnTo.getMethod().equals(this.theLastReturnTo.getMethod()) || returnTo.getObjectId() != this.theLastReturnTo.getObjectId()) continue;
            it.remove();
            newNode.addChild(n);
        }
        this.tree.getTopNodeList().add(newNode);
        this.getCurrentCallStack().push(newNode);
        ++this.methodCallNum;
    }

    public CallNode methodExit(MethodCallEntry returnTo, String exception) {
        CallNode current;
        if (this.callStack.isEmpty()) {
            this.pushNewCaller();
        }
        if ((current = this.getCurrentCallNode()) != null) {
            if (returnTo != null) {
                this.processCall(returnTo.getObjectId(), current.getFirstID());
            }
            if (exception == null) {
                current.setExitMode(1);
            } else {
                current.setExitMode(2);
                current.setException(exception);
            }
            if (this.getCurrentCallStack().size() == 1) {
                this.returnToMap.put(current, returnTo);
            }
        }
        this.theLastReturnTo = returnTo;
        return this.getCurrentCallStack().pop();
    }

    public CallNode methodCall(MethodData method, int id, int methodCallCount) {
        CallNode current;
        if (methodCallCount == -1) {
            methodCallCount = this.group.getNextCallIndex();
        }
        CallNode newNode = new CallNode(this.tree, method, id, methodCallCount);
        if (id == 0) {
            int calleeID = this.group.getObjectGraph().getNewStaticCallID();
            newNode.setStaticCallID(calleeID);
        }
        if ((current = this.getCurrentCallNode()) != null) {
            int callerID;
            current.addChild(newNode);
            int calleeID = id;
            if (calleeID == 0) {
                calleeID = newNode.getStaticCallID();
            }
            if ((callerID = current.getFirstID()) == 0) {
                callerID = current.getStaticCallID();
            }
            this.processCall(callerID, calleeID);
        } else {
            this.tree.getTopNodeList().add(newNode);
        }
        this.getCurrentCallStack().push(newNode);
        ++this.methodCallNum;
        return newNode;
    }
}

