/*
 * Decompiled with CFR 0.152.
 */
package amida.calltree;

import amida.calltree.CallTree;
import amida.calltree.CallTreeBuilder;
import amida.calltree.DominanceTree;
import amida.calltree.ObjectGraph;
import gnu.trove.TIntObjectHashMap;

public class CallTreeGroup {
    private TIntObjectHashMap<CallTreeBuilder> trees = new TIntObjectHashMap();
    private ObjectGraph objectCallGraph = new ObjectGraph();
    private DominanceTree domtree = null;
    private int callCount = 0;

    public ObjectGraph getObjectGraph() {
        return this.objectCallGraph;
    }

    public DominanceTree getDominanceTree() {
        if (this.domtree == null) {
            this.domtree = new DominanceTree(this.objectCallGraph);
        }
        return this.domtree;
    }

    public int[] treeKeys() {
        return this.trees.keys();
    }

    public CallTreeBuilder getCallTreeBuilder(int threadIndex) {
        CallTreeBuilder tree = (CallTreeBuilder)this.trees.get(threadIndex);
        if (tree == null) {
            tree = new CallTreeBuilder(this);
            this.trees.put(threadIndex, (Object)tree);
        }
        return tree;
    }

    public CallTree getCallTree(int threadIndex) {
        CallTreeBuilder tree = (CallTreeBuilder)this.trees.get(threadIndex);
        return tree.getTree();
    }

    public boolean hasCallTree(int thraedIndex) {
        return this.trees.get(thraedIndex) != null;
    }

    public int getCallTreeNum() {
        return this.trees.size();
    }

    public int getNextCallIndex() {
        return ++this.callCount;
    }

    public void registerCall(int callerID, int calleeID) {
        this.objectCallGraph.addEdge(callerID, calleeID);
    }
}

