/*
 * Decompiled with CFR 0.152.
 */
package amida.log;

import amida.calltree.CallTreeBuilder;
import amida.calltree.CallTreeGroup;
import amida.log.EntryType;
import amida.log.LogEntry;
import amida.log.LogFile;
import amida.log.LogFileName;
import amida.log.MethodCallEntry;
import amida.log.MethodData;
import amida.log.MethodExitByThrowExceptionEntry;
import amida.log.MethodExitEntry;
import amida.log.ThreadStartEntry;
import java.util.HashSet;
import java.util.Iterator;

public class AmidaLog {
    private LogFile logfile;
    private CallTreeGroup trees;

    public AmidaLog(LogFile logfile) {
        this.logfile = logfile;
        this.constructCallTrees(logfile.getEntries());
    }

    public LogFileName getFileInfo() {
        return this.logfile.getFilename();
    }

    public String getFileName() {
        return this.logfile.getFilename().getFileObject().getAbsolutePath();
    }

    private void constructCallTrees(Iterator<LogEntry> entries) {
        CallTreeGroup trees = new CallTreeGroup();
        HashSet<ThreadStartEntry> threadNames = new HashSet<ThreadStartEntry>();
        while (entries.hasNext()) {
            CallTreeBuilder tree;
            int threadIndex;
            LogEntry entry = entries.next();
            EntryType type = entry.getEntryType();
            if (type == EntryType.METHOD_CALL) {
                MethodCallEntry call = (MethodCallEntry)entry;
                threadIndex = call.getThreadIndex();
                MethodData method = call.getMethod();
                CallTreeBuilder tree2 = trees.getCallTreeBuilder(threadIndex);
                tree2.methodCall(method, call.getObjectId(), call.getMethodCallCount());
                continue;
            }
            if (type == EntryType.METHOD_EXIT) {
                MethodExitEntry exit = (MethodExitEntry)entry;
                threadIndex = exit.getThreadIndex();
                tree = trees.getCallTreeBuilder(threadIndex);
                tree.methodExit(exit.getCaller(), null);
                continue;
            }
            if (type == EntryType.METHOD_EXIT_BY_EXCEPTION) {
                MethodExitByThrowExceptionEntry exception = (MethodExitByThrowExceptionEntry)entry;
                threadIndex = exception.getThreadIndex();
                tree = trees.getCallTreeBuilder(threadIndex);
                tree.methodExit(exception.getCaller(), exception.getExceptionName());
                continue;
            }
            if (type != EntryType.THREAD_START) continue;
            ThreadStartEntry start = (ThreadStartEntry)entry;
            threadNames.add(start);
        }
        for (ThreadStartEntry th : threadNames) {
            if (!trees.hasCallTree(th.getIndex())) continue;
            trees.getCallTree(th.getIndex()).setName(th.getName());
        }
        this.trees = trees;
    }

    public CallTreeGroup getCallTrees() {
        return this.trees;
    }
}

