/*
 * Decompiled with CFR 0.152.
 */
package amida.log;

import amida.log.EntryType;
import amida.log.LogEntry;
import amida.log.MethodData;
import amida.log.Type;

public class MethodCallEntry
implements LogEntry {
    private final int threadIndex;
    private final MethodData method;
    private final int objectId;
    private final int methodCallCount;
    private final long callerLocation;

    public MethodCallEntry(int threadIndex, int methodCallCount, MethodData method, int id, long callerLocation) {
        this.threadIndex = threadIndex;
        this.methodCallCount = methodCallCount;
        this.objectId = id;
        this.callerLocation = callerLocation;
        this.method = method;
    }

    public MethodCallEntry(int threadIndex, MethodData method, int id) {
        this(threadIndex, -1, method, id, -1L);
    }

    @Override
    public EntryType getEntryType() {
        return EntryType.METHOD_CALL;
    }

    public int getThreadIndex() {
        return this.threadIndex;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public Type[] getArgs() {
        return this.method.getArgmentTypes();
    }

    public String getFullClassName() {
        return this.method.getBelongClass().getFullName();
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public String getSignature() {
        return this.method.toString();
    }

    public Type getReturnType() {
        return this.method.getReturnType();
    }

    public int getMethodCallCount() {
        return this.methodCallCount;
    }

    public MethodData getMethod() {
        return this.method;
    }

    public long getCallerLocation() {
        return this.callerLocation;
    }

    public String toString() {
        Type[] parameters;
        StringBuilder builder = new StringBuilder();
        if (this.threadIndex >= 0) {
            builder.append("@" + this.threadIndex + " ");
        }
        if (this.methodCallCount >= 0) {
            builder.append(String.valueOf(this.methodCallCount) + " ");
        }
        if (this.callerLocation >= 0L) {
            builder.append("From:" + this.callerLocation + " ");
        }
        builder.append(String.valueOf(this.method.getReturnType().toString()) + " ");
        builder.append(this.method.getBelongClass() + "(");
        builder.append(String.valueOf(this.objectId) + ")");
        builder.append(String.valueOf(this.method.getName()) + "(");
        Type[] typeArray = parameters = this.method.getArgmentTypes();
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type para = typeArray[n2];
            builder.append(String.valueOf(para.getTypeName()) + ",");
            ++n2;
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("){");
        return builder.toString();
    }
}

