/*
 * Decompiled with CFR 0.152.
 */
package amida.log;

import amida.log.LogEntry;
import amida.log.MethodCallEntry;
import amida.log.MethodExitByThrowExceptionEntry;
import amida.log.MethodExitEntry;
import amida.log.ThreadStartEntry;
import amida.log.java.JavaMethod;
import amida.log.java.JavaType;
import amida.log.java.JavaTypeManager;
import java.util.StringTokenizer;

public class TextLogLineParser {
    private static final long CALLER_NONE = -1L;
    private static final String THREAD_START = "@thread";
    private final int DEFAULT_THREAD_INDEX = 0;
    private JavaTypeManager typeManager;

    public TextLogLineParser(JavaTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public LogEntry parseLine(String line) {
        if (line.startsWith(THREAD_START)) {
            return this.parseThreadEvent(line);
        }
        if (line.indexOf("}") >= 0) {
            return this.parseExitEvent(line);
        }
        assert (line.endsWith("{"));
        return this.parseEnterEvent(line);
    }

    private int parseInt(String s, int defaultValue) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private long parseLong(String s, long defaultValue) {
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private MethodCallEntry parseEnterEvent(String line) {
        JavaType[] argsType;
        int idx;
        String[] tokens = line.split(" ");
        int threadID = tokens[idx = 0].startsWith("@") ? this.parseInt(tokens[idx].substring(1), 0) : 0;
        int n = ++idx;
        int timestamp = this.parseInt(tokens[n], 0);
        long callerLocation = tokens[++idx].startsWith("From:") ? this.parseLong(tokens[idx].substring("From:".length()), -1L) : -1L;
        int n2 = ++idx;
        String returnType = tokens[n2];
        String signature = tokens[++idx];
        int i = signature.indexOf("(");
        String className = signature.substring(0, i);
        signature = signature.substring(i + 1);
        i = signature.indexOf(")");
        int objectID = this.parseInt(signature.substring(0, i), 0);
        signature = signature.substring(i + 1);
        i = signature.indexOf("(");
        String methodName = signature.substring(1, i);
        String parameters = (signature = signature.substring(i + 1)).substring(0, i = signature.indexOf(")"));
        if (parameters.equals("")) {
            argsType = new JavaType[]{};
        } else {
            String[] params = parameters.split(",");
            argsType = new JavaType[params.length];
            int paramIdx = 0;
            while (paramIdx < params.length) {
                argsType[paramIdx] = this.typeManager.getType(params[paramIdx]);
                ++paramIdx;
            }
        }
        JavaMethod m = new JavaMethod(this.typeManager.getType(className), methodName, this.typeManager.getType(returnType), argsType, objectID == 0);
        return new MethodCallEntry(threadID, timestamp, m, objectID, callerLocation);
    }

    private LogEntry parseThreadEvent(String line) {
        String s = line.trim().substring(THREAD_START.length());
        int idx = s.indexOf("=");
        if (idx == -1) {
            return null;
        }
        String key = s.substring(0, idx).trim();
        String value = s.substring(idx + 1, s.length()).trim();
        try {
            int threadId = Integer.parseInt(key);
            String threadName = value;
            if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                threadName = value.substring(1, value.length() - 1);
            }
            return new ThreadStartEntry(threadName, threadId);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private LogEntry parseExitEvent(String line) {
        StringTokenizer st = new StringTokenizer(line, " \t");
        if (!st.hasMoreTokens()) {
            return null;
        }
        String token = st.nextToken();
        int threadId = 0;
        if (token.startsWith("@") && token.length() > 1) {
            try {
                String tmp = token;
                token = st.nextToken();
                threadId = Integer.parseInt(tmp.substring(1));
            }
            catch (NumberFormatException tmp) {
                // empty catch block
            }
        }
        if (token.equals("}")) {
            if (st.hasMoreTokens()) {
                token = st.nextToken();
                if (token.equals("returnTo:")) {
                    MethodExitEntry exit = new MethodExitEntry(threadId);
                    exit.setCallerInfo(this.parseCallerInfo(line));
                    return exit;
                }
                String exception = token;
                MethodExitByThrowExceptionEntry exit = new MethodExitByThrowExceptionEntry(threadId, exception);
                if (st.hasMoreTokens() && (token = st.nextToken()).equals("returnTo:")) {
                    exit.setCallerInfo(this.parseCallerInfo(line));
                }
                return exit;
            }
            return new MethodExitEntry(threadId);
        }
        return null;
    }

    private MethodCallEntry parseCallerInfo(String line) {
        assert (line.contains("returnTo:"));
        int idx = line.indexOf("returnTo:");
        String sub = line.substring(idx + "returnTo:".length()).trim();
        if (sub.equals("-1")) {
            return null;
        }
        return this.parseEnterEvent(sub);
    }
}

