/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import amida.gui.ProcessMonitorTask;
import amida.logmanager.AmidaProperty;
import amida.logmanager.CommandBuilder;
import amida.logmanager.PhaseDetectionListener;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PhaseDetectionLauncherWindow {
    private static final String CAPTION_EXECUTE = "Execute!";
    private static final String CAPTION_CANCEL = "CANCEL";
    private String filename = String.valueOf(AmidaProperty.getInstance().getLogDir()) + File.separator + AmidaProperty.getInstance().getDefaultLogFilename();
    private String[][] parameters = new String[4][];
    private static PhaseDetectionTask currentTask = null;
    private static final String[][] options = new String[][]{{"Cache Size", "-c", "-C", "-d"}, {"Window Size", "-w", "-W", "-v"}, {"Threshold", "-t", "-T", "-u"}, {"Scope Size", "-s", "-S", "-r"}};

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        PhaseDetectionLauncherWindow window = new PhaseDetectionLauncherWindow(display);
        window.constructWindow(shell, null);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public PhaseDetectionLauncherWindow(Display display) {
        this();
    }

    public PhaseDetectionLauncherWindow() {
        int i = 0;
        while (i < options.length) {
            this.parameters[i] = AmidaProperty.getInstance().getPhaseDetectionParam(i);
            ++i;
        }
    }

    public void open(Shell parent, PhaseDetectionListener listener) {
        Shell window = new Shell(parent, 68656);
        this.constructWindow(window, listener);
        Point p = window.computeSize(-1, -1);
        window.setSize(parent.getSize().x, p.y + 100);
        window.open();
    }

    private void constructWindow(final Shell shell, final PhaseDetectionListener listener) {
        shell.setText("Phase Detection");
        shell.setLayout((Layout)new GridLayout(1, false));
        Composite composite1 = new Composite((Composite)shell, 0);
        GridData dataComposite = new GridData();
        dataComposite.grabExcessHorizontalSpace = true;
        dataComposite.horizontalAlignment = 4;
        composite1.setLayoutData((Object)dataComposite);
        final Text logFileText = new Text(composite1, 2052);
        logFileText.setText(this.filename);
        Button browseBtn = new Button(composite1, 8);
        browseBtn.setText("...");
        browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(shell, 4096);
                File f = new File(logFileText.getText());
                dialog.setFileName(f.getAbsolutePath());
                dialog.setFilterExtensions(new String[]{"*.log", "*"});
                String filename = dialog.open();
                if (filename != null) {
                    logFileText.setText(filename);
                }
            }
        });
        final Button execButton = new Button(composite1, 8);
        execButton.setText(CAPTION_EXECUTE);
        composite1.setLayout((Layout)new FormLayout());
        FormData formForText = new FormData();
        formForText.top = new FormAttachment(0, 0);
        formForText.left = new FormAttachment(0, 0);
        formForText.right = new FormAttachment((Control)browseBtn, 0);
        logFileText.setLayoutData((Object)formForText);
        FormData formForBrowse = new FormData();
        formForBrowse.top = new FormAttachment(0, 0);
        formForBrowse.right = new FormAttachment((Control)execButton, 0);
        browseBtn.setLayoutData((Object)formForBrowse);
        FormData formForExec = new FormData();
        formForExec.top = new FormAttachment(0, 0);
        formForExec.right = new FormAttachment(100, 0);
        execButton.setLayoutData((Object)formForExec);
        ParameterTable table = new ParameterTable(shell, execButton);
        final Table parameterTable = table.getTableWidget();
        GridData tableData = new GridData();
        tableData.horizontalAlignment = 4;
        tableData.verticalAlignment = 4;
        parameterTable.setLayoutData((Object)tableData);
        final Text execLogText = new Text((Composite)shell, 2626);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        execLogText.setLayoutData((Object)data);
        execButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (currentTask == null || currentTask.isFinished()) {
                    currentTask = PhaseDetectionLauncherWindow.executePhaseDetection(shell, listener, logFileText.getText(), parameterTable, execLogText, execButton);
                } else {
                    PhaseDetectionLauncherWindow.askTerminate(shell);
                }
            }
        });
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (currentTask != null && !currentTask.isFinished()) {
                    e.doit = PhaseDetectionLauncherWindow.askTerminate(shell);
                } else {
                    PhaseDetectionLauncherWindow.this.filename = logFileText.getText();
                    PhaseDetectionLauncherWindow.this.parameters = new String[options.length][];
                    int row = 0;
                    while (row < options.length) {
                        ((PhaseDetectionLauncherWindow)PhaseDetectionLauncherWindow.this).parameters[row] = new String[parameterTable.getColumnCount()];
                        int col = 0;
                        while (col < parameterTable.getColumnCount()) {
                            ((PhaseDetectionLauncherWindow)PhaseDetectionLauncherWindow.this).parameters[row][col] = parameterTable.getItem(row).getText(col);
                            ++col;
                        }
                        ++row;
                    }
                    e.doit = true;
                }
            }
        });
        shell.pack();
        shell.setSize(640, 400);
    }

    private static boolean askTerminate(Shell shell) {
        MessageBox box = new MessageBox(shell, 288);
        box.setText("Phase detection process is still running");
        box.setMessage("Are you sure to terminate the phase detection process?");
        if (box.open() == 32) {
            currentTask.terminate();
            return true;
        }
        return false;
    }

    private static void deleteDirRecursive(File dir) {
        File[] entries = dir.listFiles();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].isDirectory()) {
                PhaseDetectionLauncherWindow.deleteDirRecursive(entries[i]);
            } else {
                entries[i].delete();
            }
            ++i;
        }
        dir.delete();
    }

    private static PhaseDetectionTask executePhaseDetection(Shell shell, PhaseDetectionListener listener, String logfile, Table parameters, Text execLog, Button execButton) {
        File dir = new File(String.valueOf(logfile) + ".tmp");
        if (dir.exists()) {
            MessageBox box = new MessageBox(shell, 288);
            box.setText("A temporary directory already exists");
            box.setMessage("Phase detection process is using a directory '" + dir.getAbsolutePath() + "' to store intermediate data.  Are you sure to delete the contents of the directory?");
            if (box.open() == 32) {
                PhaseDetectionLauncherWindow.deleteDirRecursive(dir);
            } else {
                return null;
            }
        }
        try {
            File f = new File(logfile);
            if (f.canRead()) {
                File scriptDir = new File(AmidaProperty.getInstance().getScriptDir());
                File script = new File(scriptDir, AmidaProperty.getInstance().getPhaseDetectionScriptName());
                CommandBuilder cmd = new CommandBuilder();
                cmd.append(AmidaProperty.getInstance().getScriptCommand());
                cmd.append(script.getAbsolutePath());
                int row = 0;
                while (row < parameters.getItemCount()) {
                    TableItem item = parameters.getItem(row);
                    int col = 1;
                    while (col < parameters.getColumnCount()) {
                        cmd.append(options[row][col]);
                        cmd.append(item.getText(col));
                        ++col;
                    }
                    ++row;
                }
                cmd.append("-b");
                cmd.append(scriptDir.getAbsolutePath());
                cmd.append(f.getAbsolutePath());
                String command = cmd.toString();
                execLog.append("Execute: ");
                execLog.append(command);
                execLog.append("\n");
                execButton.setText(CAPTION_CANCEL);
                Process process = Runtime.getRuntime().exec(command);
                PhaseDetectionTask task = new PhaseDetectionTask(shell, process, f, execLog, execButton);
                if (listener != null) {
                    task.setPhaseDetectionListener(listener);
                }
                Thread thread = new Thread(task);
                thread.start();
                return task;
            }
            execLog.append("File is not readable: " + f.getAbsolutePath() + "\n");
            return null;
        }
        catch (IOException e) {
            execLog.append("Failed.");
            execButton.setText(CAPTION_EXECUTE);
            return null;
        }
    }

    private class ParameterTable {
        private Shell shell;
        private Button execButton;
        private Table table;
        private TableCursor cursor;
        private ControlEditor editor;

        public ParameterTable(Shell shell, Button execButton) {
            this.shell = shell;
            this.execButton = execButton;
            this.createTableWidget();
        }

        public Table getTableWidget() {
            return this.table;
        }

        private void createTableWidget() {
            this.table = new Table((Composite)this.shell, 34816);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.table.addListener(41, new Listener(){

                public void handleEvent(Event event) {
                    event.height = event.gc.getFontMetrics().getHeight() * 2;
                    int height = ((ParameterTable)ParameterTable.this).table.computeSize((int)-1, (int)-1).y;
                    Point currentSize = ParameterTable.this.table.getSize();
                    if (height != currentSize.y) {
                        ParameterTable.this.table.setSize(currentSize.x, height);
                        ParameterTable.this.shell.layout();
                        ParameterTable.this.cursor.setSelection(0, 1);
                    }
                }
            });
            this.cursor = new TableCursor(this.table, 0);
            this.editor = new ControlEditor((Composite)this.cursor);
            this.editor.grabHorizontal = true;
            this.editor.grabVertical = true;
            this.cursor.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (ParameterTable.this.cursor.getColumn() != 0) {
                        ParameterTable.this.openTextForTableEdit();
                    }
                }
            });
            this.cursor.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.keyCode == 9) {
                        e.doit = false;
                        ParameterTable.this.execButton.setFocus();
                    }
                }
            });
            this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ParameterTable.this.table.setSelection(new TableItem[]{ParameterTable.this.cursor.getRow()});
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    if (ParameterTable.this.cursor.getColumn() != 0) {
                        ParameterTable.this.openTextForTableEdit();
                    }
                }
            });
            TableColumn col1 = new TableColumn(this.table, 16384);
            col1.setText("Parameter");
            col1.setWidth(100);
            TableColumn col2 = new TableColumn(this.table, 131072);
            col2.setText("from");
            col2.setWidth(60);
            TableColumn col3 = new TableColumn(this.table, 131072);
            col3.setText("to");
            col3.setWidth(60);
            TableColumn col4 = new TableColumn(this.table, 131072);
            col4.setText("step");
            col4.setWidth(60);
            int i = 0;
            while (i < options.length) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(PhaseDetectionLauncherWindow.this.parameters[i]);
                ++i;
            }
        }

        private void openTextForTableEdit() {
            final Text text = new Text((Composite)this.cursor, 0);
            text.setText(this.cursor.getRow().getText(this.cursor.getColumn()));
            text.setFocus();
            text.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.keyCode == 9) {
                        ParameterTable.this.cursor.getRow().setText(ParameterTable.this.cursor.getColumn(), text.getText());
                        text.dispose();
                        e.doit = false;
                        int col = ParameterTable.this.cursor.getColumn();
                        int row = ParameterTable.this.table.indexOf(ParameterTable.this.cursor.getRow());
                        if ((e.stateMask & 0x20000) == 0) {
                            if (col < ParameterTable.this.table.getColumnCount() - 1) {
                                ParameterTable.this.cursor.setSelection(row, ParameterTable.this.cursor.getColumn() + 1);
                                ParameterTable.this.openTextForTableEdit();
                            } else if (row < ParameterTable.this.table.getItemCount() - 1) {
                                ParameterTable.this.cursor.setSelection(row + 1, 1);
                                ParameterTable.this.openTextForTableEdit();
                            } else {
                                ParameterTable.this.execButton.setFocus();
                            }
                        } else if (col > 1) {
                            ParameterTable.this.cursor.setSelection(row, ParameterTable.this.cursor.getColumn() - 1);
                            ParameterTable.this.openTextForTableEdit();
                        } else if (row > 0) {
                            ParameterTable.this.cursor.setSelection(row - 1, ParameterTable.this.table.getColumnCount() - 1);
                            ParameterTable.this.openTextForTableEdit();
                        } else {
                            ParameterTable.this.execButton.setFocus();
                        }
                    }
                }
            });
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    switch (event.keyCode) {
                        case 13: {
                            ParameterTable.this.cursor.getRow().setText(ParameterTable.this.cursor.getColumn(), text.getText());
                        }
                        case 27: {
                            text.dispose();
                        }
                    }
                }
            });
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    ParameterTable.this.cursor.getRow().setText(ParameterTable.this.cursor.getColumn(), text.getText());
                    text.dispose();
                }
            });
            this.editor.setEditor((Control)text);
        }
    }

    private static class PhaseDetectionTask
    extends ProcessMonitorTask {
        private Shell shell;
        private PhaseDetectionListener listener;
        private File targetFile;
        private Button execButton;
        private boolean success;

        public PhaseDetectionTask(Shell shell, Process process, File targetFile, Text execLog, Button execButton) {
            super(shell.getDisplay(), execLog, process);
            this.shell = shell;
            this.targetFile = targetFile;
            this.execButton = execButton;
            this.listener = null;
            this.success = false;
        }

        public void setPhaseDetectionListener(PhaseDetectionListener listener) {
            this.listener = listener;
        }

        @Override
        protected void onReadLine(String line) {
            if (line.startsWith("finished.")) {
                this.success = true;
            }
        }

        @Override
        protected void onFinished() {
            this.checkAsyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!PhaseDetectionTask.this.execButton.isDisposed()) {
                        PhaseDetectionTask.this.execButton.setText(PhaseDetectionLauncherWindow.CAPTION_EXECUTE);
                    }
                    if (PhaseDetectionTask.this.listener != null) {
                        PhaseDetectionTask.this.listener.onFinished(PhaseDetectionTask.this.shell, PhaseDetectionTask.this.success, PhaseDetectionTask.this.targetFile.getAbsolutePath());
                    }
                }
            });
        }
    }
}

