/*
 * Decompiled with CFR 0.152.
 */
package amida.logmanager;

import java.util.Arrays;

public class PhaseScale {
    private int maxTraceSize;
    private int[] phaseTransitionPoints;
    private double[] sqrt;
    private double[] logscale;

    public PhaseScale(int maxTraceSize, int[] phaseTransitionPoints) {
        this.maxTraceSize = maxTraceSize;
        this.phaseTransitionPoints = phaseTransitionPoints;
        if (phaseTransitionPoints.length > 0) {
            this.sqrt = this.computeRatio(new SqrtFunc());
            this.logscale = this.computeRatio(new LogscaleFunc());
        }
    }

    private double[] computeRatio(Func f) {
        double[] result = new double[this.phaseTransitionPoints.length];
        double[] scaledDistance = new double[this.phaseTransitionPoints.length];
        double sum = 0.0;
        scaledDistance[0] = 0.0;
        int i = 1;
        while (i < this.phaseTransitionPoints.length) {
            scaledDistance[i] = f.apply(this.phaseTransitionPoints[i] - this.phaseTransitionPoints[i - 1]);
            sum += scaledDistance[i];
            ++i;
        }
        double d = 0.0;
        int i2 = 1;
        while (i2 < this.phaseTransitionPoints.length) {
            result[i2] = (d += scaledDistance[i2]) / sum;
            ++i2;
        }
        result[0] = 0.0;
        result[result.length - 1] = 1.0;
        return result;
    }

    public double getScale(int timestamp, PHASE_SCALE_OPTION option) {
        if (option == PHASE_SCALE_OPTION.NORMAL) {
            return (double)timestamp * 1.0 / (double)this.maxTraceSize;
        }
        int idx = Arrays.binarySearch(this.phaseTransitionPoints, timestamp);
        assert (idx >= 0) : "Programming Error in getScaledPosition";
        if (idx >= 0) {
            if (option == PHASE_SCALE_OPTION.SQRT) {
                return this.sqrt[idx];
            }
            if (option == PHASE_SCALE_OPTION.LOGSCALE) {
                return this.logscale[idx];
            }
            assert (false) : "Invalid scaling arguments for getScale.";
            return 0.0;
        }
        return 0.0;
    }

    private static interface Func {
        public double apply(int var1);
    }

    private static class LogscaleFunc
    implements Func {
        private LogscaleFunc() {
        }

        @Override
        public double apply(int t) {
            return Math.log(t);
        }
    }

    public static enum PHASE_SCALE_OPTION {
        NORMAL,
        SQRT,
        LOGSCALE;

    }

    private static class SqrtFunc
    implements Func {
        private SqrtFunc() {
        }

        @Override
        public double apply(int t) {
            return Math.sqrt(t);
        }
    }
}

