/*
 * Decompiled with CFR 0.152.
 */
package amida.util;

import java.io.IOException;
import java.io.InputStream;

public class FileRangeInputStream
extends InputStream {
    private InputStream r;
    private long size;
    private long offset;

    public FileRangeInputStream(InputStream reader, long pBegin, long pEnd) throws IOException {
        this.r = reader;
        this.r.skip(pBegin);
        this.size = pEnd - pBegin;
        this.offset = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.size == this.offset) {
            return -1;
        }
        if (this.size < 0L) {
            return this.r.read();
        }
        ++this.offset;
        return this.r.read();
    }

    @Override
    public void close() throws IOException {
        this.r.close();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.size == this.offset) {
            return -1;
        }
        if (this.size < 0L) {
            return this.r.read(buf, off, len);
        }
        int bytes = this.r.read(buf, off, len);
        if (this.offset > this.size - (long)bytes) {
            bytes = (int)(this.size - this.offset);
        }
        this.offset += (long)bytes;
        return bytes;
    }
}

